/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.ProjectUserAccountMap;
import fr.proline.core.orm.uds.UserAccount;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AddProjectDialog
extends DefaultDialog {
    private static AddProjectDialog m_singletonDialog = null;
    private JTextField m_nameTextField;
    private JTextArea m_descriptionTextArea;
    private JList<UserAccount> m_userAccountList;
    private JScrollPane m_userListScrollPane;
    private JButton m_addUserAccountButton;
    private JButton m_removeFileButton;
    private JPanel m_userAccountPanel;
    private boolean m_canModifyValues;

    public static AddProjectDialog getAddProjectDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new AddProjectDialog(parent);
        }
        m_singletonDialog.initialize(null);
        return m_singletonDialog;
    }

    public static AddProjectDialog getModifyProjectDialog(Window parent, Project p) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new AddProjectDialog(parent);
        }
        m_singletonDialog.initialize(p);
        return m_singletonDialog;
    }

    public void initialize(Project p) {
        DefaultListModel userAccountListModel = (DefaultListModel)this.m_userAccountList.getModel();
        userAccountListModel.clear();
        this.m_canModifyValues = true;
        if (p == null) {
            this.m_nameTextField.setText("");
            this.m_descriptionTextArea.setText("");
            this.setTitle("Add Project");
            this.setButtonVisible(5, true);
            this.setDocumentationSuffix("id.49x2ik5");
        } else {
            this.m_nameTextField.setText(p.getName());
            this.m_descriptionTextArea.setText(p.getDescription());
            this.setTitle("Modify Project Parameters");
            this.setButtonVisible(5, false);
            UserAccount loggedUserAccount = DatabaseDataManager.getDatabaseDataManager().getLoggedUser();
            UserAccount mainUserAccount = p.getOwner();
            boolean isCreatorOfTheProject = loggedUserAccount.getId() == mainUserAccount.getId();
            Set members = p.getProjectUserAccountMap();
            for (ProjectUserAccountMap userAccount : members) {
                if (isCreatorOfTheProject && userAccount.getId().getUserAccountId() == mainUserAccount.getId()) continue;
                userAccountListModel.addElement(userAccount.getUserAccount());
            }
            this.m_userListScrollPane.setEnabled(isCreatorOfTheProject);
            this.m_addUserAccountButton.setEnabled(isCreatorOfTheProject);
            this.m_removeFileButton.setEnabled(isCreatorOfTheProject);
            this.m_canModifyValues = DatabaseDataManager.getDatabaseDataManager().ownProject(p);
        }
        this.updateEnabled(this.m_canModifyValues);
    }

    private AddProjectDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(true);
        this.initInternalPanel();
    }

    private void initInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        JPanel projectParametersPanel = this.createProjectParametersPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        internalPanel.add((Component)projectParametersPanel, c);
        this.m_userAccountPanel = this.createUserAccountPanel();
        ++c.gridy;
        c.weighty = 1.0;
        internalPanel.add((Component)this.m_userAccountPanel, c);
        this.setInternalComponent(internalPanel);
    }

    private JPanel createProjectParametersPanel() {
        JPanel projectParametersPanel = new JPanel(new GridBagLayout());
        projectParametersPanel.setBorder(BorderFactory.createTitledBorder(" Project Parameters "));
        JLabel projectNameLabel = new JLabel("Name :");
        this.m_nameTextField = new JTextField(30);
        JLabel projectDescriptionLabel = new JLabel("Description :");
        this.m_descriptionTextArea = new JTextArea();
        JScrollPane desciptionScrollPane = new JScrollPane(this.m_descriptionTextArea){
            private Dimension preferredSize;
            {
                this.preferredSize = new Dimension(360, 200);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }
        };
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        projectParametersPanel.add((Component)projectNameLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        projectParametersPanel.add((Component)this.m_nameTextField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        projectParametersPanel.add((Component)projectDescriptionLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        projectParametersPanel.add((Component)desciptionScrollPane, c);
        c.gridx = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        projectParametersPanel.add(Box.createHorizontalStrut(26), c);
        c.gridx = 0;
        ++c.gridy;
        projectParametersPanel.add(Box.createHorizontalStrut(60), c);
        return projectParametersPanel;
    }

    private JPanel createUserAccountPanel() {
        JPanel userAccountPanel = new JPanel(new GridBagLayout());
        userAccountPanel.setBorder(BorderFactory.createTitledBorder(" Project Users "));
        this.m_userAccountList = new JList(new DefaultListModel());
        this.m_userAccountList.setCellRenderer(UserAccountListRenderer.getRenderer());
        this.m_userListScrollPane = new JScrollPane(this.m_userAccountList){
            private final Dimension preferredSize;
            {
                this.preferredSize = new Dimension(360, 200);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }
        };
        this.m_addUserAccountButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.USERS));
        this.m_addUserAccountButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_removeFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        this.m_removeFileButton.setMargin(new Insets(2, 2, 2, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        userAccountPanel.add((Component)this.m_userListScrollPane, c);
        ++c.gridx;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        userAccountPanel.add((Component)this.m_addUserAccountButton, c);
        ++c.gridy;
        userAccountPanel.add((Component)this.m_removeFileButton, c);
        ++c.gridy;
        userAccountPanel.add(Box.createVerticalStrut(30), c);
        ++c.gridy;
        c.gridx = 0;
        userAccountPanel.add(Box.createHorizontalStrut(60), c);
        c.gridx = 2;
        userAccountPanel.add(Box.createHorizontalStrut(26), c);
        this.m_userAccountList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean sometingSelected = AddProjectDialog.this.m_userAccountList.getSelectedIndex() != -1;
                AddProjectDialog.this.m_removeFileButton.setEnabled(sometingSelected);
            }
        });
        this.m_addUserAccountButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultListModel userAccountListModel = (DefaultListModel)AddProjectDialog.this.m_userAccountList.getModel();
                HashSet<Long> userAccountOfProjectSet = new HashSet<Long>();
                int nb = userAccountListModel.getSize();
                for (int i = 0; i < nb; ++i) {
                    userAccountOfProjectSet.add(((UserAccount)userAccountListModel.getElementAt(i)).getId());
                }
                userAccountOfProjectSet.add(DatabaseDataManager.getDatabaseDataManager().getLoggedUser().getId());
                SelectUserAccountDialog dialog = new SelectUserAccountDialog((Window)((Object)m_singletonDialog), userAccountOfProjectSet);
                dialog.setLocationRelativeTo(AddProjectDialog.this.m_addUserAccountButton);
                dialog.setVisible(true);
                if (dialog.getButtonClicked() == 0) {
                    List<UserAccount> userAccounts = dialog.getSelectedUserAccounts();
                    for (UserAccount userAccount : userAccounts) {
                        userAccountListModel.addElement(userAccount);
                    }
                }
            }
        });
        this.m_removeFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedValues = AddProjectDialog.this.m_userAccountList.getSelectedValuesList();
                Iterator it = selectedValues.iterator();
                while (it.hasNext()) {
                    ((DefaultListModel)AddProjectDialog.this.m_userAccountList.getModel()).removeElement(it.next());
                }
                AddProjectDialog.this.m_removeFileButton.setEnabled(false);
            }
        });
        return userAccountPanel;
    }

    private void updateEnabled(boolean canModifyValues) {
        this.m_nameTextField.setEnabled(canModifyValues);
        this.m_descriptionTextArea.setEnabled(canModifyValues);
        this.m_userAccountList.setEnabled(canModifyValues);
        this.m_addUserAccountButton.setEnabled(canModifyValues);
        this.m_removeFileButton.setEnabled(canModifyValues);
    }

    protected boolean okCalled() {
        if (!this.m_canModifyValues) {
            return true;
        }
        return this.checkParameters();
    }

    protected boolean cancelCalled() {
        return true;
    }

    private boolean checkParameters() {
        String name = this.m_nameTextField.getText();
        if (name.isEmpty()) {
            this.setStatus(true, "You must fill the Project Name.");
            this.highlight(this.m_nameTextField);
            return false;
        }
        if (name.length() > 250) {
            this.setStatus(true, "Project Name must not exceed 250 characters.");
            this.highlight(this.m_nameTextField);
            return false;
        }
        String description = this.m_descriptionTextArea.getText();
        if (description.isEmpty()) {
            this.setStatus(true, "You must fill the Project Description.");
            this.highlight(this.m_descriptionTextArea);
            return false;
        }
        if (description.length() > 1000) {
            this.setStatus(true, "Description must not exceed 1000 characters.");
            this.highlight(this.m_nameTextField);
            return false;
        }
        return true;
    }

    public boolean canModifyValues() {
        return this.m_canModifyValues;
    }

    public String getProjectName() {
        return this.m_nameTextField.getText();
    }

    public String getProjectDescription() {
        return this.m_descriptionTextArea.getText();
    }

    public ArrayList<UserAccount> getUserAccountList() {
        DefaultListModel userAccountListModel = (DefaultListModel)this.m_userAccountList.getModel();
        int nb = userAccountListModel.getSize();
        ArrayList<UserAccount> userAccountList = new ArrayList<UserAccount>(nb);
        userAccountList.add(DatabaseDataManager.getDatabaseDataManager().getLoggedUser());
        for (int i = 0; i < nb; ++i) {
            userAccountList.add((UserAccount)userAccountListModel.getElementAt(i));
        }
        return userAccountList;
    }

    private static class UserAccountListRenderer
    extends DefaultListCellRenderer {
        private static UserAccountListRenderer m_singleton = null;

        public static UserAccountListRenderer getRenderer() {
            if (m_singleton == null) {
                m_singleton = new UserAccountListRenderer();
            }
            return m_singleton;
        }

        private UserAccountListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent(list, ((UserAccount)value).getLogin(), index, isSelected, cellHasFocus);
        }
    }

    public class SelectUserAccountDialog
    extends DefaultDialog {
        private JList<UserAccount> m_userList;

        public SelectUserAccountDialog(Window parent, HashSet<Long> userAccountOfProjectSet) {
            super(parent, Dialog.ModalityType.APPLICATION_MODAL);
            this.setTitle("User Accounts");
            this.setButtonVisible(5, false);
            UserAccount[] users = DatabaseDataManager.getDatabaseDataManager().getProjectUsersArray();
            this.setInternalComponent(this.createInternalPanel(userAccountOfProjectSet, users));
        }

        private JPanel createInternalPanel(HashSet<Long> userAccountOfProjectSet, UserAccount[] users) {
            JPanel internalPanel = new JPanel(new GridBagLayout());
            internalPanel.setBorder(BorderFactory.createTitledBorder(" Select User Accounts "));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(5, 5, 5, 5);
            DefaultListModel<UserAccount> listModel = new DefaultListModel<UserAccount>();
            for (int i = 0; i < users.length; ++i) {
                UserAccount userAccount = users[i];
                if (userAccountOfProjectSet.contains(userAccount.getId())) continue;
                listModel.addElement(users[i]);
            }
            this.m_userList = new JList(listModel);
            this.m_userList.setCellRenderer(UserAccountListRenderer.getRenderer());
            JScrollPane filesListScrollPane = new JScrollPane(this.m_userList){
                private final Dimension preferredSize;
                {
                    this.preferredSize = new Dimension(280, 140);
                }

                @Override
                public Dimension getPreferredSize() {
                    return this.preferredSize;
                }
            };
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            internalPanel.add((Component)filesListScrollPane, c);
            return internalPanel;
        }

        protected boolean okCalled() {
            return true;
        }

        protected boolean cancelCalled() {
            return true;
        }

        public List<UserAccount> getSelectedUserAccounts() {
            return this.m_userList.getSelectedValuesList();
        }
    }
}

