/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.id.ProjectId;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.python.data.Col;
import fr.proline.studio.python.data.ColDoubleData;
import fr.proline.studio.python.data.PythonImage;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.interpreter.CalcCallback;
import fr.proline.studio.python.interpreter.CalcError;
import fr.proline.studio.python.interpreter.CalcInterpreterTask;
import fr.proline.studio.python.interpreter.CalcInterpreterThread;
import fr.proline.studio.python.interpreter.ResultVariable;
import fr.proline.studio.rserver.dialog.ImageViewerTopComponent;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import fr.proline.studio.rsmexplorer.gui.calc.DataTree;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultRightAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.Utilities;
import org.jdesktop.swingx.JXTable;
import org.openide.util.NbPreferences;
import org.python.core.PyObject;

public class CalcDialog
extends JDialog {
    private JTextPane m_codeArea = null;
    private DefaultHighlighter m_errorHighlighter = null;
    private Highlighter.HighlightPainter m_errorHighlighterPainter = null;
    private boolean m_isHighlighting = false;
    private JTextField m_statusTextField = null;
    private JButton m_executeButton = null;
    private JButton m_loadButton = null;
    private JButton m_saveButton = null;
    private JButton m_clearButton = null;
    private DefaultListModel m_resultsListModel = null;
    private DefaultListModel m_functionsListModel = null;
    private JTabbedPane m_tabbedPane = null;
    private DataCalcTree m_dataTree = null;
    private JFileChooser m_fileChooser;
    private static CalcDialog m_calcDialog = null;
    private static final Color ERROR_COLOR = new Color(196, 0, 0);
    private static final Color OK_COLOR = new Color(0, 196, 0);

    public static CalcDialog getCalcDialog(Window parent, JXTable t) {
        if (m_calcDialog == null) {
            m_calcDialog = new CalcDialog(parent);
        }
        CalcDialog.m_calcDialog.m_dataTree.updataDataNodes();
        return m_calcDialog;
    }

    private CalcDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Python Calculator");
        this.add(this.createInternalPanel());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                CalcDialog.this.cleanupOnClose();
            }
        });
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        AbstractAction actionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalcDialog.this.cleanupOnClose();
                CalcDialog.this.setVisible(false);
            }
        };
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", actionListener);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    private JComponent createInternalPanel() {
        JPanel rightPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_statusTextField = new JTextField();
        this.m_statusTextField.setForeground(ERROR_COLOR);
        this.m_statusTextField.setEditable(false);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        rightPanel.add((Component)this.createCodeArea(), c);
        ++c.gridy;
        c.weighty = 0.0;
        rightPanel.add((Component)this.m_statusTextField, c);
        ++c.gridx;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridheight = 2;
        rightPanel.add((Component)this.createCodeToolBar(), c);
        JSplitPane splitPane = new JSplitPane(1, this.createTabbedPane(), rightPanel);
        return splitPane;
    }

    private JTabbedPane createTabbedPane() {
        final Dimension d = new Dimension(180, 400);
        this.m_tabbedPane = new JTabbedPane(){

            @Override
            public Dimension getMinimumSize() {
                return d;
            }

            @Override
            public Dimension getPreferredSize() {
                return d;
            }
        };
        this.m_tabbedPane.add("Data", this.createDataPanel());
        this.m_functionsListModel = new DefaultListModel();
        this.fillFunctions();
        final JList functions = new JList(this.m_functionsListModel);
        JScrollPane functionsScrollPane = new JScrollPane();
        functionsScrollPane.setViewportView(functions);
        this.m_tabbedPane.add("Functions", functionsScrollPane);
        this.m_resultsListModel = new DefaultListModel();
        final JList results = new JList(this.m_resultsListModel);
        results.setSelectionMode(0);
        JScrollPane resultsScrollPane = new JScrollPane();
        resultsScrollPane.setViewportView(results);
        this.m_tabbedPane.add("Results", resultsScrollPane);
        results.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ResultVariable resultVariable = (ResultVariable)results.getSelectedValue();
                    if (resultVariable == null) {
                        return;
                    }
                    PyObject o = resultVariable.getValue();
                    if (o instanceof ColDoubleData) {
                        ColDoubleData col = (ColDoubleData)o;
                        Table t = col.getTable();
                        t.addColumn((Col)col, null, (TableCellRenderer)new DoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 4, true, true));
                    } else if (o instanceof Table) {
                        WindowBox windowBox = WindowBoxFactory.getGenericWindowBox(null, resultVariable.getName(), IconManager.IconType.CHALKBOARD, false);
                        GlobalTableModelInterface model = ((Table)o).getModel();
                        ProjectId projectId = (ProjectId)model.getSingleValue(ProjectId.class);
                        long id = projectId != null ? projectId.getId() : -1L;
                        windowBox.setEntryData(id, model);
                        DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(windowBox);
                        win.open();
                        win.requestActive();
                    } else if (o instanceof PythonImage) {
                        BufferedImage image = ((PythonImage)o).getImage();
                        ImageViewerTopComponent win = new ImageViewerTopComponent(resultVariable.getName(), (Image)image);
                        win.open();
                        win.requestActive();
                    }
                    results.clearSelection();
                }
            }
        });
        functions.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Function function = (Function)functions.getSelectedValue();
                    if (function == null) {
                        return;
                    }
                    function.action();
                    functions.clearSelection();
                }
            }
        });
        functions.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                ListModel m = functions.getModel();
                int index = functions.locationToIndex(e.getPoint());
                if (index > -1) {
                    functions.setToolTipText(((Function)m.getElementAt(index)).getDescription());
                } else {
                    functions.setToolTipText(null);
                }
            }
        });
        return this.m_tabbedPane;
    }

    private JPanel createDataPanel() {
        JPanel dataPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JPanel tablePanel = new JPanel(new GridBagLayout());
        tablePanel.setBorder(BorderFactory.createTitledBorder("Tables"));
        JScrollPane treeScrollPane = new JScrollPane();
        this.m_dataTree = new DataCalcTree();
        treeScrollPane.setViewportView(this.m_dataTree);
        GridBagConstraints c1 = new GridBagConstraints();
        c1.anchor = 18;
        c1.fill = 1;
        c1.insets = new Insets(5, 5, 5, 5);
        c1.gridx = 0;
        c1.gridy = 0;
        c1.weightx = 1.0;
        c1.weighty = 1.0;
        tablePanel.add((Component)treeScrollPane, c1);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        dataPanel.add((Component)tablePanel, c);
        return dataPanel;
    }

    private JComponent createCodeArea() {
        Dimension d = new Dimension(420, 400);
        this.m_codeArea = new JTextPane();
        this.m_errorHighlighter = new DefaultHighlighter();
        this.m_errorHighlighterPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 90, 90));
        this.m_codeArea.setHighlighter(this.m_errorHighlighter);
        this.m_codeArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CalcDialog.this.removeHighlighting();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CalcDialog.this.removeHighlighting();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CalcDialog.this.removeHighlighting();
            }
        });
        JScrollPane codeScrollPane = new JScrollPane();
        codeScrollPane.setMinimumSize(d);
        codeScrollPane.setPreferredSize(d);
        codeScrollPane.setViewportView(this.m_codeArea);
        return codeScrollPane;
    }

    private JToolBar createCodeToolBar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_executeButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.EXECUTE));
        toolbar.add(this.m_executeButton);
        this.m_saveButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SAVE_WND));
        toolbar.add(this.m_saveButton);
        this.m_loadButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.LOAD_SETTINGS));
        toolbar.add(this.m_loadButton);
        this.m_clearButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        toolbar.add(this.m_clearButton);
        this.m_saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = CalcDialog.this.getPyhtonScriptChooser();
                int result = chooser.showSaveDialog(CalcDialog.this.m_saveButton);
                if (result == 0) {
                    File file = chooser.getSelectedFile();
                    try {
                        if (file.exists()) {
                            String message = "The file already exists. Do you want to overwrite it ?";
                            String title = "Overwrite ?";
                            Object[] options = new String[]{"Yes", "No"};
                            int reply = JOptionPane.showOptionDialog(CalcDialog.this.m_saveButton, message, title, 0, 1, null, options, "Yes");
                            if (reply != 0) {
                                return;
                            }
                        }
                        FileWriter fw = new FileWriter(file.getAbsoluteFile(), true);
                        BufferedWriter bw = new BufferedWriter(fw);
                        bw.write(CalcDialog.this.m_codeArea.getText());
                        bw.close();
                        fw.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.m_loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = CalcDialog.this.getPyhtonScriptChooser();
                int result = chooser.showOpenDialog(CalcDialog.this.m_loadButton);
                if (result == 0) {
                    File file = chooser.getSelectedFile();
                    try {
                        if (file.exists() && file.canRead()) {
                            String line;
                            FileReader reader = new FileReader(file);
                            BufferedReader br = new BufferedReader(reader);
                            StringBuilder sb = new StringBuilder();
                            while ((line = br.readLine()) != null) {
                                sb.append(line).append('\n');
                                if (sb.length() <= 40000) continue;
                            }
                            br.close();
                            reader.close();
                            CalcDialog.this.m_codeArea.setText(sb.toString());
                            CalcDialog.this.m_codeArea.requestFocus();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.m_executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalcDialog.this.m_executeButton.setEnabled(false);
                CalcDialog.this.m_codeArea.setEnabled(false);
                CalcDialog.this.execute();
            }
        });
        this.m_clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalcDialog.this.m_codeArea.setText("");
            }
        });
        return toolbar;
    }

    public void cleanupOnClose() {
    }

    private JFileChooser getPyhtonScriptChooser() {
        if (this.m_fileChooser == null) {
            Preferences preferences = NbPreferences.root();
            String scriptPath = preferences.get("DefaultPythonScriptPath", null);
            this.m_fileChooser = scriptPath != null ? new JFileChooser(new File(scriptPath)) : new JFileChooser();
            this.m_fileChooser.setMultiSelectionEnabled(false);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Python Script File (*.py)", "py");
            this.m_fileChooser.setFileFilter(filter);
        }
        return this.m_fileChooser;
    }

    private void fillFunctions() {
        this.m_functionsListModel.addElement(new Function("adjustP", "adjustp = Stats.adjustP(,,,,)", "adjustp = Stats.adjustP(Table.get(1)[14], \"abh\")"));
        this.m_functionsListModel.addElement(new Function("bbinomial", "bbinomial = Stats.bbinomial( (,) , (,) )", "bbinomial = Stats.bbinomial( (Table.get(1)[5],Table.get(1)[7]), (Table.get(1)[9],Table.get(1)[11]) )"));
        this.m_functionsListModel.addElement(new Function("calibrationPlot", "calibrationplot = Stats.calibrationPlot(,,,)", "calibrationplot = Stats.calibrationPlot(Table.get(1)[14], \"ALL\")"));
        this.m_functionsListModel.addElement(new Function("diff", "diffTable = Table.diff(,)", "diffTable = Table.diff(Table.get(1),Table.get(2))"));
        this.m_functionsListModel.addElement(new Function("join", "joinTable = Table.join(,)", "joinTable = Table.join(Table.get(1),Table.get(2))"));
        this.m_functionsListModel.addElement(new Function("pvalue", "pvalue = Stats.pvalue( (,) , (,) )", "pvalue = Stats.pvalue( (Table.get(1)[5],Table.get(1)[7]), (Table.get(1)[9],Table.get(1)[11]) )"));
        this.m_functionsListModel.addElement(new Function("ttd", "ttd = Stats.ttd( (,) , (,) )", "ttd = Stats.ttd( (Table.get(1)[5],Table.get(1)[7]), (Table.get(1)[9],Table.get(1)[11]) )"));
    }

    private void execute() {
        this.m_statusTextField.setText("");
        this.m_resultsListModel.clear();
        this.removeHighlighting();
        final long timeStart = System.currentTimeMillis();
        CalcInterpreterThread interpreterThread = CalcInterpreterThread.getCalcInterpreterThread();
        CalcCallback callback = new CalcCallback(){

            public void run(ArrayList<ResultVariable> variables, CalcError error) {
                if (variables != null) {
                    long milliseconds = System.currentTimeMillis() - timeStart;
                    int seconds = (int)(milliseconds / 1000L) % 60;
                    int minutes = (int)(milliseconds / 60000L);
                    String timeDisplay = String.format("Execution Time: %d:%d.%d", minutes, seconds, milliseconds %= 100L);
                    CalcDialog.this.m_statusTextField.setForeground(OK_COLOR);
                    CalcDialog.this.m_statusTextField.setText(timeDisplay);
                    int nb = variables.size();
                    for (int i = 0; i < nb; ++i) {
                        CalcDialog.this.m_resultsListModel.addElement(variables.get(i));
                    }
                    CalcDialog.this.m_tabbedPane.setSelectedIndex(2);
                } else if (error != null) {
                    int lineError = error.getLineError();
                    if (lineError != -1) {
                        try {
                            int[] offset = CalcDialog.this.getLineOffsets(CalcDialog.this.m_codeArea.getText(), lineError);
                            if (offset != null) {
                                CalcDialog.this.m_errorHighlighter.addHighlight(offset[0], offset[1], CalcDialog.this.m_errorHighlighterPainter);
                                CalcDialog.this.m_isHighlighting = true;
                            } else {
                                lineError = -1;
                            }
                        }
                        catch (Exception e2) {
                            lineError = -1;
                        }
                    }
                    CalcDialog.this.m_statusTextField.setForeground(ERROR_COLOR);
                    if (lineError != -1) {
                        CalcDialog.this.m_statusTextField.setText("At line " + lineError + ": " + error);
                    } else {
                        CalcDialog.this.m_statusTextField.setText(error.getErrorMessage());
                    }
                }
                CalcDialog.this.m_executeButton.setEnabled(true);
                CalcDialog.this.m_codeArea.setEnabled(true);
            }
        };
        interpreterThread.addTask(new CalcInterpreterTask(this.m_codeArea.getText(), callback));
    }

    private int[] getLineOffsets(String text, int lineNumber) throws BadLocationException {
        int endOffset;
        int offset = 0;
        int lineIndex = 1;
        do {
            int startOffset = Utilities.getRowStart(this.m_codeArea, offset);
            endOffset = Utilities.getRowEnd(this.m_codeArea, offset);
            if (lineIndex == lineNumber) {
                return new int[]{startOffset, endOffset};
            }
            ++lineIndex;
        } while ((offset = endOffset + 1) < text.length());
        return null;
    }

    private void removeHighlighting() {
        if (!this.m_isHighlighting) {
            return;
        }
        this.m_errorHighlighter.removeAllHighlights();
        this.m_isHighlighting = false;
    }

    public void centerToWindow(Window w) {
        int width = this.getWidth();
        int height = this.getHeight();
        int frameX = w.getX();
        int frameY = w.getY();
        int frameWidth = w.getWidth();
        int frameHeight = w.getHeight();
        int x = frameX + (frameWidth - width) / 2;
        int y = frameY + (frameHeight - height) / 2;
        this.setLocation(x, y);
    }

    public class DataCalcTree
    extends DataTree {
        public DataCalcTree() {
            super(new DataTree.ParentDataNode(), true, null);
        }

        @Override
        public void action(DataTree.DataNode node) {
            switch (node.getType()) {
                case COLUMN_DATA: {
                    int pos = CalcDialog.this.m_codeArea.getCaretPosition();
                    int index = ((DataTree.ColumnDataNode)node).getColumnIndex();
                    try {
                        DataTree.ViewDataNode viewNode = (DataTree.ViewDataNode)node.getParent();
                        String textToAdd = "Table.get(" + viewNode.getTableIndex() + ")[" + index + "]";
                        CalcDialog.this.m_codeArea.getDocument().insertString(pos, textToAdd, null);
                        CalcDialog.this.m_codeArea.setCaretPosition(pos + textToAdd.length());
                        CalcDialog.this.m_codeArea.getCaret().setVisible(true);
                        CalcDialog.this.m_codeArea.requestFocusInWindow();
                    }
                    catch (BadLocationException viewNode) {}
                    break;
                }
                case VIEW_DATA: {
                    int pos = CalcDialog.this.m_codeArea.getCaretPosition();
                    int index = ((DataTree.ViewDataNode)node).getTableIndex();
                    try {
                        String textToAdd = "Table.get(" + index + ")";
                        CalcDialog.this.m_codeArea.getDocument().insertString(pos, textToAdd, null);
                        CalcDialog.this.m_codeArea.setCaretPosition(pos + textToAdd.length());
                        CalcDialog.this.m_codeArea.getCaret().setVisible(true);
                        CalcDialog.this.m_codeArea.requestFocusInWindow();
                        break;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class Function {
        private final String m_name;
        private final String m_insertText;
        private final String m_description;

        public Function(String name, String insertText, String description) {
            this.m_name = name;
            this.m_insertText = insertText;
            this.m_description = description;
        }

        public void action() {
            int pos = CalcDialog.this.m_codeArea.getCaretPosition();
            try {
                CalcDialog.this.m_codeArea.getDocument().insertString(pos, this.m_insertText, null);
                CalcDialog.this.m_codeArea.setCaretPosition(pos + this.m_insertText.length());
                CalcDialog.this.m_codeArea.getCaret().setVisible(true);
                CalcDialog.this.m_codeArea.requestFocusInWindow();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public String toString() {
            return this.m_name;
        }

        public String getDescription() {
            return this.m_description;
        }
    }
}

