/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.core.orm.uds.Project;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.ClearProjectData;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.rsmexplorer.gui.dialog.ClearProjectPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.List;
import javax.swing.JOptionPane;

public class ClearProjectDialog
extends DefaultDialog {
    private boolean m_canModifyValues;
    private Project m_project;
    private ClearProjectPanel m_clearProjectPanel = null;
    private List<ClearProjectData> m_listDataToClear = null;
    private DefaultDialog.ProgressTask m_task = null;

    public ClearProjectDialog(Window parent, Project p, List<ClearProjectData> listDataToClear) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.m_project = p;
        this.m_listDataToClear = listDataToClear;
        this.setResizable(true);
        this.setTitle("Clean up Project " + this.m_project.getName());
        this.setButtonVisible(2, false);
        this.m_clearProjectPanel = new ClearProjectPanel();
        this.setInternalComponent(this.m_clearProjectPanel);
        this.initialize();
    }

    private void initialize() {
        this.m_canModifyValues = true;
        if (this.m_project != null) {
            this.m_canModifyValues = DatabaseDataManager.getDatabaseDataManager().ownProject(this.m_project);
            this.m_clearProjectPanel.setData(this.m_listDataToClear);
        }
        this.updateEnabled(this.m_canModifyValues);
    }

    public boolean canModifyValues() {
        return this.m_canModifyValues;
    }

    private void updateEnabled(boolean canModifyValues) {
    }

    public List<ClearProjectData> getSelectedData() {
        return this.m_clearProjectPanel.getSelectedData();
    }

    public void setTask(DefaultDialog.ProgressTask task) {
        this.m_task = task;
    }

    protected boolean okCalled() {
        List<ClearProjectData> list = this.getSelectedData();
        if (!list.isEmpty()) {
            Object[] options = new Object[]{"Yes, delete", "No, cancel"};
            int n = JOptionPane.showOptionDialog((Component)((Object)this), "Are you sure you want to delete the selected data? (can not be undone)", "Delete Data", 0, 3, null, options, options[1]);
            if (n == 0) {
                this.startTask(this.m_task);
                return false;
            }
            return true;
        }
        return true;
    }

    protected boolean cancelCalled() {
        return true;
    }
}

