/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.ParametersComboPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.FilterProteinSetPanel;
import fr.proline.studio.settings.FilePreferences;
import fr.proline.studio.settings.SettingsDialog;
import fr.proline.studio.settings.SettingsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.openide.util.NbPreferences;
import org.slf4j.LoggerFactory;

public class FilterProtSetDialog
extends DefaultDialog
implements ComponentListener {
    private static FilterProtSetDialog m_singletonDialog = null;
    private ParameterList m_parameterList;
    private AbstractParameter[] m_proteinFilterParameters;
    private ParametersComboPanel m_proteinPrefiltersPanel;
    private static final String SETTINGS_KEY = "ProtSetFiltering";

    public static FilterProtSetDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new FilterProtSetDialog(parent);
        }
        return m_singletonDialog;
    }

    public FilterProtSetDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("ProteinSet Filtering");
        this.setDocumentationSuffix("id.2lwamvv");
        this.setButtonVisible(3, true);
        this.setButtonVisible(4, true);
        this.m_parameterList = new ParameterList("ProtSet Filtering");
        this.m_proteinFilterParameters = FilterProteinSetPanel.createProteinSetFilterParameters("", this.m_parameterList);
        this.m_parameterList.updateValues(NbPreferences.root());
        this.setInternalComponent(this.createInternalPanel());
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        this.m_proteinPrefiltersPanel = new ParametersComboPanel(" Filter(s) ", this.m_proteinFilterParameters);
        this.m_proteinPrefiltersPanel.addComponentListener((ComponentListener)this);
        internalPanel.add((Component)this.m_proteinPrefiltersPanel, c);
        return internalPanel;
    }

    public HashMap<String, String> getArguments() {
        return this.m_parameterList.getValues();
    }

    protected boolean okCalled() {
        if (!this.checkParameters()) {
            return false;
        }
        Preferences preferences = NbPreferences.root();
        this.saveParameters(preferences);
        return true;
    }

    private void saveParameters(Preferences preferences) {
        this.m_parameterList.saveParameters(preferences);
    }

    private boolean checkParameters() {
        ParameterError error = this.m_parameterList.checkParameters();
        if (error != null) {
            this.setStatus(true, error.getErrorMessage());
            this.highlight(error.getParameterComponent());
            return false;
        }
        return true;
    }

    protected boolean saveCalled() {
        if (!this.checkParameters()) {
            return false;
        }
        JFileChooser fileChooser = SettingsUtils.getFileChooser((String)SETTINGS_KEY);
        int result = fileChooser.showSaveDialog((Component)((Object)this));
        if (result == 0) {
            File f = fileChooser.getSelectedFile();
            FilePreferences filePreferences = new FilePreferences(f, null, "");
            this.saveParameters((Preferences)filePreferences);
            SettingsUtils.addSettingsPath((String)SETTINGS_KEY, (String)f.getAbsolutePath());
            SettingsUtils.writeDefaultDirectory((String)SETTINGS_KEY, (String)f.getParent());
        }
        return false;
    }

    protected boolean loadCalled() {
        SettingsDialog settingsDialog = new SettingsDialog((Window)((Object)this), SETTINGS_KEY);
        settingsDialog.setLocationRelativeTo((Component)((Object)this));
        settingsDialog.setVisible(true);
        if (settingsDialog.getButtonClicked() == 0) {
            if (settingsDialog.isDefaultSettingsSelected()) {
                this.m_parameterList.initDefaults();
            } else {
                try {
                    String[] keys;
                    File settingsFile = settingsDialog.getSelectedFile();
                    FilePreferences filePreferences = new FilePreferences(settingsFile, null, "");
                    Preferences preferences = NbPreferences.root();
                    for (String key : keys = filePreferences.keys()) {
                        String value = filePreferences.get(key, null);
                        preferences.put(key, value);
                    }
                    this.m_parameterList.loadParameters((Preferences)filePreferences);
                    this.m_proteinPrefiltersPanel.updatePanel();
                }
                catch (Exception e) {
                    LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer").error("Parsing of User Settings File Failed", (Throwable)e);
                    this.setStatus(true, "Parsing of your Settings File failed");
                }
            }
        }
        return false;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.repack();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

