/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.core.orm.msi.Ptm;
import fr.proline.studio.gui.DefaultDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class IdentifyPtmSitesDialog
extends DefaultDialog {
    private List<Ptm> m_ptms;
    private List<Ptm> m_selectedPtms;
    private JLabel m_clusteringMethod;
    private JRadioButton m_clusterizePartiallyIsomorph;
    private JRadioButton m_clusterizeIsomorphOnly;

    public IdentifyPtmSitesDialog(Window parent, List<Ptm> ptms) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        ptms.sort(Comparator.comparing(Ptm::getShortName));
        this.m_ptms = ptms;
        this.m_selectedPtms = new ArrayList<Ptm>(this.m_ptms);
        this.setDocumentationSuffix("h.2wwbldi");
        this.setTitle("Identify Ptm sites");
        this.setHelpHeaderText("Select the list of modifications of interest <br>(other modifications will be ignored during clustering) and set <br>the method's parameters that will be used to clusterize modification sites.</li></ul>");
        this.initInternalPanel();
        this.pack();
    }

    private void initInternalPanel() {
        JPanel parametersPanel = new JPanel();
        parametersPanel.setLayout(new GridBagLayout());
        JPanel clusteringMethodPanel = new JPanel(new GridBagLayout());
        clusteringMethodPanel.setBorder(BorderFactory.createTitledBorder("Clustering method"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_clusteringMethod = new JLabel("<html><b>Rely on localizations inferred from PSMs</b>: this clustering method <br/>use the site localization inferred from the validated PSMs, regardless <br/>of the reported localization probabilities.</html>");
        clusteringMethodPanel.add((Component)this.m_clusteringMethod, c);
        this.m_clusterizePartiallyIsomorph = new JRadioButton("Group fully cleaved with missed cleaved peptides in same cluster");
        ++c.gridy;
        c.insets = new Insets(5, 15, 5, 5);
        clusteringMethodPanel.add((Component)this.m_clusterizePartiallyIsomorph, c);
        this.m_clusterizeIsomorphOnly = new JRadioButton("Separate fully cleaved and missed cleaved peptides in different clusters");
        ++c.gridy;
        c.insets = new Insets(5, 15, 5, 5);
        clusteringMethodPanel.add((Component)this.m_clusterizeIsomorphOnly, c);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_clusterizePartiallyIsomorph);
        group.add(this.m_clusterizeIsomorphOnly);
        this.m_clusterizePartiallyIsomorph.setSelected(true);
        JPanel ptmOIPanel = new JPanel(new GridBagLayout());
        ptmOIPanel.setBorder(BorderFactory.createTitledBorder("PTMs of interest"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(5, 15, 5, 5);
        for (Ptm ptm : this.m_ptms) {
            JCheckBox checkbox = new JCheckBox(ptm.getFullName(), true);
            checkbox.addActionListener(evt -> {
                if (((JCheckBox)evt.getSource()).isSelected()) {
                    this.m_selectedPtms.add(ptm);
                } else {
                    this.m_selectedPtms.remove(ptm);
                }
            });
            ptmOIPanel.add((Component)checkbox, c);
            ++c.gridy;
        }
        c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        parametersPanel.add((Component)clusteringMethodPanel, c);
        ++c.gridy;
        parametersPanel.add((Component)ptmOIPanel, c);
        JPanel internalPanel = new JPanel(new BorderLayout());
        internalPanel.add((Component)parametersPanel, "Center");
        this.setInternalComponent(internalPanel);
    }

    public List<Long> getPtms() {
        return this.m_selectedPtms.stream().map(p -> p.getId()).collect(Collectors.toList());
    }

    public String getClusteringMethodName() {
        return this.m_clusterizeIsomorphOnly.isSelected() ? "ISOMORPHIC_MATCHING" : "EXACT_POSITION_MATCHING";
    }
}

