/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.pattern.WindowSavedManager;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ManageSaveWindowsDialog
extends DefaultDialog {
    private static ManageSaveWindowsDialog m_singletonDialog = null;
    private JList<String> m_windowList;
    private JButton m_removeWndButton;

    public static ManageSaveWindowsDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new ManageSaveWindowsDialog(parent);
        }
        m_singletonDialog.init();
        return m_singletonDialog;
    }

    private ManageSaveWindowsDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Manage User Windows");
        this.setDocumentationSuffix(null);
        this.setResizable(true);
        this.setMinimumSize(new Dimension(200, 240));
        JPanel p = this.createWindowsPanel();
        this.setInternalComponent(p);
    }

    private JPanel createWindowsPanel() {
        JPanel windowsPanel = new JPanel(new GridBagLayout());
        windowsPanel.setBorder(BorderFactory.createTitledBorder(" User Windows "));
        this.m_windowList = new JList(new DefaultListModel());
        this.m_windowList.setCellRenderer(new WindowListRenderer());
        JScrollPane windowListScrollPane = new JScrollPane(this.m_windowList){
            private final Dimension preferredSize;
            {
                this.preferredSize = new Dimension(360, 200);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }
        };
        this.m_removeWndButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        this.m_removeWndButton.setMargin(new Insets(2, 2, 2, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        windowsPanel.add((Component)windowListScrollPane, c);
        ++c.gridx;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        windowsPanel.add((Component)this.m_removeWndButton, c);
        ++c.gridy;
        windowsPanel.add(Box.createVerticalStrut(30), c);
        this.m_windowList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean sometingSelected = ManageSaveWindowsDialog.this.m_windowList.getSelectedIndex() != -1;
                ManageSaveWindowsDialog.this.m_removeWndButton.setEnabled(sometingSelected);
            }
        });
        this.m_removeWndButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedValues = ManageSaveWindowsDialog.this.m_windowList.getSelectedValuesList();
                Iterator it = selectedValues.iterator();
                while (it.hasNext()) {
                    ((DefaultListModel)ManageSaveWindowsDialog.this.m_windowList.getModel()).removeElement(it.next());
                }
                ManageSaveWindowsDialog.this.m_removeWndButton.setEnabled(false);
            }
        });
        return windowsPanel;
    }

    private void init() {
        ArrayList<String> m_windowSavedList = WindowSavedManager.readSavedWindows();
        DefaultListModel listModel = (DefaultListModel)this.m_windowList.getModel();
        listModel.clear();
        int nb = m_windowSavedList.size();
        for (int i = 0; i < nb; ++i) {
            listModel.addElement(m_windowSavedList.get(i));
        }
        this.m_removeWndButton.setEnabled(false);
    }

    protected boolean okCalled() {
        DefaultListModel listModel = (DefaultListModel)this.m_windowList.getModel();
        int size = listModel.getSize();
        ArrayList<String> savedWindowsList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            savedWindowsList.add((String)listModel.get(i));
        }
        WindowSavedManager.setSavedWindows(savedWindowsList);
        return true;
    }

    private static class WindowListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent(list, WindowSavedManager.getWindowName((String)value), index, isSelected, cellHasFocus);
        }
    }
}

