/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.exporter;

import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.StringParameter;
import fr.proline.studio.settings.FilePreferences;
import fr.proline.studio.settings.SettingsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.util.NbPreferences;
import org.slf4j.LoggerFactory;

public class Export2MzIdentMLParamPanel
extends JPanel {
    private DefaultDialog m_parent = null;
    private final String m_contact_FN_key = "contact_first_name";
    private JTextField m_contactFirstName;
    private final String m_contact_LN_key = "contact_last_name";
    private JTextField m_contactLastName;
    private final String m_contact_Mail_key = "contact_email";
    private JTextField m_contactEmail;
    private final String m_contact_URL_key = "contact_url";
    private JTextField m_contactURL;
    private final String m_org_name_key = "organization_name";
    private JTextField m_orgName;
    private final String m_org_url_key = "organization_url";
    private JTextField m_orgURL;
    private ParameterList m_parameterList;

    public Export2MzIdentMLParamPanel(DefaultDialog parent) {
        this.m_parent = parent;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createMainPanel(), "Center");
    }

    private JPanel createMainPanel() {
        JPanel paramPanel = new JPanel();
        paramPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.createParameters();
        this.m_parameterList.updateValues(NbPreferences.root());
        JLabel cFNameLabel = new JLabel("First Name*:");
        c.gridx = 0;
        c.gridy = 0;
        paramPanel.add((Component)cFNameLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        paramPanel.add((Component)this.m_contactFirstName, c);
        JLabel cLNameLabel = new JLabel("Last Name*:");
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        paramPanel.add((Component)cLNameLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        paramPanel.add((Component)this.m_contactLastName, c);
        JLabel eMailLabel = new JLabel("Email:");
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        paramPanel.add((Component)eMailLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        paramPanel.add((Component)this.m_contactEmail, c);
        JLabel cURLLabel = new JLabel("URL:");
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        paramPanel.add((Component)cURLLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        paramPanel.add((Component)this.m_contactURL, c);
        JLabel orgNameLabel = new JLabel("Organization Name*:");
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        paramPanel.add((Component)orgNameLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        paramPanel.add((Component)this.m_orgName, c);
        JLabel orgURLLabel = new JLabel("URL:");
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        paramPanel.add((Component)orgURLLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        paramPanel.add((Component)this.m_orgURL, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weighty = 1.0;
        paramPanel.add(Box.createVerticalGlue(), c);
        return paramPanel;
    }

    private void createParameters() {
        this.m_parameterList = new ParameterList("Export2MzIdentML");
        this.m_contactFirstName = new JTextField(20);
        StringParameter contactFirstNameParameter = new StringParameter("contact_first_name", "Contact First Name", (JComponent)this.m_contactFirstName, "", new Integer(2), null);
        contactFirstNameParameter.setUsed(false);
        contactFirstNameParameter.setCompulsory(true);
        this.m_parameterList.add((Object)contactFirstNameParameter);
        this.m_contactLastName = new JTextField(20);
        StringParameter contactLastNameParameter = new StringParameter("contact_last_name", "Contact Last Name", (JComponent)this.m_contactLastName, "", new Integer(2), null);
        contactLastNameParameter.setUsed(false);
        contactLastNameParameter.setCompulsory(true);
        this.m_parameterList.add((Object)contactLastNameParameter);
        this.m_contactURL = new JTextField(20);
        StringParameter contactURLParameter = new StringParameter("contact_url", "Contact URL", (JComponent)this.m_contactURL, "", new Integer(5), null);
        contactURLParameter.setUsed(false);
        contactURLParameter.setCompulsory(false);
        this.m_parameterList.add((Object)contactURLParameter);
        this.m_contactEmail = new JTextField(20);
        StringParameter contactEmailParameter = new StringParameter("contact_email", "Contact eMail", (JComponent)this.m_contactEmail, "", new Integer(5), null);
        contactEmailParameter.setUsed(false);
        contactEmailParameter.setCompulsory(false);
        this.m_parameterList.add((Object)contactEmailParameter);
        this.m_orgName = new JTextField(20);
        StringParameter orgNameParameter = new StringParameter("organization_name", "Organization Name", (JComponent)this.m_orgName, "", new Integer(2), null);
        orgNameParameter.setUsed(false);
        orgNameParameter.setCompulsory(true);
        this.m_parameterList.add((Object)orgNameParameter);
        this.m_orgURL = new JTextField(20);
        StringParameter orgURLParameter = new StringParameter("organization_url", "Organization URL", (JComponent)this.m_orgURL, "", new Integer(5), null);
        orgURLParameter.setUsed(false);
        orgURLParameter.setCompulsory(false);
        this.m_parameterList.add((Object)orgURLParameter);
    }

    protected void saveParameters(Preferences preferences) {
        if (preferences == null) {
            preferences = NbPreferences.root();
        }
        this.m_parameterList.saveParameters(preferences);
    }

    protected boolean checkParameters() {
        ParameterError error = this.m_parameterList.checkParameters();
        if (error == null) {
            this.setUsedParams();
            return true;
        }
        this.m_parent.setStatus(true, error.getErrorMessage());
        this.m_parent.highlight((Component)error.getParameterComponent());
        return false;
    }

    protected void loadParameters() {
        SettingsDialog settingsDialog = new SettingsDialog((Window)this.m_parent, "Export2MzIdentML");
        settingsDialog.setLocationRelativeTo((Component)this);
        settingsDialog.setVisible(true);
        if (settingsDialog.getButtonClicked() == 0) {
            if (settingsDialog.isDefaultSettingsSelected()) {
                this.m_parameterList.initDefaults();
            } else {
                try {
                    String[] keys;
                    File settingsFile = settingsDialog.getSelectedFile();
                    FilePreferences filePreferences = new FilePreferences(settingsFile, null, "");
                    Preferences preferences = NbPreferences.root();
                    for (String key : keys = filePreferences.keys()) {
                        String value = filePreferences.get(key, null);
                        preferences.put(key, value);
                    }
                    this.m_parameterList.loadParameters((Preferences)filePreferences);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer").error("Parsing of User Settings File Failed", (Throwable)e);
                    this.m_parent.setStatus(true, "Parsing of your Settings File failed");
                }
            }
        }
    }

    private void setUsedParams() {
        Iterator iterator = this.m_parameterList.iterator();
        while (iterator.hasNext()) {
            AbstractParameter param;
            param.setUsed(!((JTextField)(param = (AbstractParameter)iterator.next()).getComponent()).getText().isEmpty());
        }
    }

    public HashMap<String, Object> getExportParams() {
        HashMap<String, Object> exportParams = new HashMap<String, Object>();
        HashMap contactMap = new HashMap();
        HashMap orgMap = new HashMap();
        this.m_parameterList.getValues().forEach((key, value) -> {
            if (key.startsWith("contact_")) {
                contactMap.put(key.substring("contact_".length()), value);
            } else if (key.startsWith("organization_")) {
                orgMap.put(key.substring("organization_".length()), value);
            }
            exportParams.put("contact", contactMap);
            exportParams.put("organization", orgMap);
        });
        return exportParams;
    }
}

