/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.spectralcount;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

public class TreeSelectionPanel
extends JPanel {
    private IdentificationTree m_tree = null;
    private static TreeSelectionPanel m_treeSelectionPanel = null;

    public static TreeSelectionPanel getTreeSelectionPanel() {
        return m_treeSelectionPanel;
    }

    public static TreeSelectionPanel getTreeSelectionPanel(IdentificationTree tree) {
        m_treeSelectionPanel = new TreeSelectionPanel(tree);
        return m_treeSelectionPanel;
    }

    private TreeSelectionPanel(IdentificationTree tree) {
        this.m_tree = tree;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createMainPanel(), "Center");
    }

    private JComponent createMainPanel() {
        JScrollPane scrollPane = new JScrollPane(this.m_tree);
        return scrollPane;
    }

    public void setSelection(ArrayList<ResultSummary> rsmArray) {
        this.m_tree.setSelection(rsmArray);
    }

    public ArrayList<DDataset> getSelectedDatasetList() {
        ArrayList<DDataset> returnedList = new ArrayList<DDataset>();
        this.getSelectedData(returnedList, null);
        return returnedList;
    }

    public ArrayList<DataSetNode> getSelectedRSMDSNodeList() {
        ArrayList<DataSetNode> returnedList = new ArrayList<DataSetNode>();
        this.getSelectedData(null, returnedList);
        return returnedList;
    }

    public TreePath[] getSelectionPaths() {
        return this.m_tree.getSelectionPaths();
    }

    public IdentificationTree getTree() {
        return this.m_tree;
    }

    public void getSelectedData(ArrayList<DDataset> selectedDatasetList, ArrayList<DataSetNode> selectedRSMDSNodeList) {
        TreePath[] paths = this.m_tree.getSelectionPaths();
        int size = paths.length;
        for (int i = 0; i < size; ++i) {
            AbstractNode node = (AbstractNode)paths[i].getLastPathComponent();
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET) continue;
            DataSetNode dataSetNode = (DataSetNode)node;
            if (selectedDatasetList != null) {
                selectedDatasetList.add(dataSetNode.getDataset());
            }
            if (selectedRSMDSNodeList == null) continue;
            selectedRSMDSNodeList.add(dataSetNode);
        }
    }
}

