/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.core.orm.uds.QuantitationChannel;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.aggregation.DQuantitationChannelMapping;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.aggregation.QCMappingTransferHandler;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.aggregation.QCMappingTreeTable;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.aggregation.QCMappingTreeTableModel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import fr.proline.studio.rsmexplorer.tree.xic.QuantExperimentalDesignTree;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationQuantChannelsPanel
extends JPanel {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static AggregationQuantChannelsPanel m_singleton;
    private QCMappingTreeTable m_treeTable;
    private QCMappingTreeTableModel m_treeTableModel;
    private JScrollPane m_tableScrollPane;
    private JTabbedPane m_tabbedPane;

    public static AggregationQuantChannelsPanel getPanel(AbstractNode rootNode, List<DDataset> datasets) {
        if (m_singleton == null) {
            m_singleton = new AggregationQuantChannelsPanel();
        }
        m_singleton.setMapping(rootNode, datasets);
        return m_singleton;
    }

    private AggregationQuantChannelsPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createMainPanel(), "Center");
    }

    public final JPanel createMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createTitledBorder(" Sample Analyses mapping "));
        JSplitPane sp = new JSplitPane();
        sp.setLeftComponent(this.createQCMappingPanel());
        sp.setRightComponent(this.createDatasetsPanel());
        sp.setDividerLocation(0.7);
        sp.setResizeWeight(0.5);
        QCMappingToolbar mappingToolBar = new QCMappingToolbar();
        mappingToolBar.setFloatable(false);
        mappingToolBar.setRollover(true);
        mainPanel.add((Component)mappingToolBar, "North");
        mainPanel.add((Component)sp, "Center");
        return mainPanel;
    }

    private JComponent createQCMappingPanel() {
        this.m_tableScrollPane = new JScrollPane();
        this.m_tableScrollPane.getViewport().setBackground(Color.white);
        return this.m_tableScrollPane;
    }

    private JComponent createDatasetsPanel() {
        this.m_tabbedPane = new JTabbedPane();
        return this.m_tabbedPane;
    }

    public void setMapping(AbstractNode rootNode, List<DDataset> datasets) {
        this.m_treeTableModel = new QCMappingTreeTableModel(rootNode, datasets);
        this.m_treeTable = this.createTreeTable(this.m_treeTableModel);
        this.m_tableScrollPane.setViewportView((Component)((Object)this.m_treeTable));
        this.m_tabbedPane.removeAll();
        for (DDataset ds : datasets) {
            DataSetData datasetData = DataSetData.createTemporaryQuantitation((String)ds.getName());
            datasetData.setDataset(ds);
            DataSetNode dsNode = new DataSetNode((AbstractData)datasetData);
            QuantExperimentalDesignTree dsDesignTree = new QuantExperimentalDesignTree(dsNode, false, false);
            QuantExperimentalDesignTree.displayExperimentalDesign(ds, dsNode, dsDesignTree, false, true);
            JScrollPane sPane = new JScrollPane(dsDesignTree);
            this.m_tabbedPane.add(ds.getName(), sPane);
        }
        this.validate();
        this.repaint();
    }

    private QCMappingTreeTable createTreeTable(QCMappingTreeTableModel model) {
        QCMappingTreeTable treeTable = new QCMappingTreeTable(model);
        treeTable.putClientProperty("JTree.lineStyle", "Horizontal");
        treeTable.setRowHeight(18);
        IdentificationTree.RSMTreeRenderer renderer = new IdentificationTree.RSMTreeRenderer();
        treeTable.setTreeCellRenderer(renderer);
        treeTable.expandAll();
        QCMappingTransferHandler handler = new QCMappingTransferHandler(treeTable);
        treeTable.setTransferHandler(handler);
        treeTable.setDropMode(DropMode.ON);
        treeTable.setRootVisible(true);
        treeTable.setShowGrid(true, true);
        treeTable.getColumnModel().getColumn(0).setPreferredWidth(160);
        if (treeTable.getColumnCount(false) > 3) {
            treeTable.setAutoResizeMode(0);
        }
        return treeTable;
    }

    public List<Map<String, Object>> getQuantChannelsMatching() {
        ArrayList<Map<String, Object>> mappingList = new ArrayList<Map<String, Object>>();
        for (DQuantitationChannelMapping entry : this.m_treeTableModel.getMapping().values()) {
            HashMap<String, Object> mapping = new HashMap<String, Object>();
            mapping.put("quant_channel_number", entry.getParentQCNumber());
            Map<Long, Long> map = entry.getMappedQuantChannels().entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> ((DMasterQuantitationChannel)((DDataset)e.getKey()).getMasterQuantitationChannels().get(0)).getId(), e -> ((QuantitationChannel)e.getValue()).getId()));
            mapping.put("quant_channels_matching", map);
            mappingList.add(mapping);
        }
        return mappingList;
    }

    public boolean verifyRedundantChannel() {
        String r = this.m_treeTableModel.verifyRedundantChannel();
        if (!r.isEmpty()) {
            JOptionPane.showMessageDialog(this, r);
            return false;
        }
        return true;
    }

    class QCMappingToolbar
    extends JToolBar {
        JButton m_removeBt;
        JButton m_upBt;
        JButton m_downBt;
        JButton m_insertUpBt;
        JButton m_insertDownBt;

        public QCMappingToolbar() {
            this.createRemoveButton();
            this.createUpButton();
            this.createDownButton();
            this.createInsertUpButton();
            this.createInsertDownButton();
            this.add(this.m_removeBt);
            this.addSeparator();
            this.add(this.m_upBt);
            this.add(this.m_downBt);
            this.addSeparator();
            this.add(this.m_insertUpBt);
            this.add(this.m_insertDownBt);
        }

        private void createRemoveButton() {
            this.m_removeBt = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
            this.m_removeBt.setToolTipText("Remove");
            this.m_removeBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AggregationQuantChannelsPanel.this.m_treeTable.removeAssociateChannel();
                }
            });
        }

        private void createUpButton() {
            this.m_upBt = new JButton();
            this.m_upBt.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW_MOVE_UP));
            this.m_upBt.setToolTipText("Move Up");
            this.m_upBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AggregationQuantChannelsPanel.this.m_treeTable.moveUp();
                }
            });
        }

        private void createDownButton() {
            this.m_downBt = new JButton();
            this.m_downBt.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW_MOVE_DOWN));
            this.m_downBt.setToolTipText("Move Down");
            this.m_downBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AggregationQuantChannelsPanel.this.m_treeTable.moveDown();
                }
            });
        }

        void createInsertUpButton() {
            this.m_insertUpBt = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW_INSERT_UP));
            this.m_insertUpBt.setToolTipText("Insert Up");
            this.m_insertUpBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AggregationQuantChannelsPanel.this.m_treeTable.moveInsertUp();
                }
            });
        }

        void createInsertDownButton() {
            this.m_insertDownBt = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW_INSERT_DOWN));
            this.m_insertDownBt.setToolTipText("Insert Down");
            this.m_insertDownBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AggregationQuantChannelsPanel.this.m_treeTable.moveInsertDown();
                }
            });
        }
    }
}

