/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.xic.QuantExperimentalDesignTree;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckDesignTreeDialog
extends DefaultDialog {
    private String groupName4checkDesignStructure;

    public CheckDesignTreeDialog(Window parent, Dialog.ModalityType modalityType) {
        super(parent, modalityType);
    }

    public boolean checkDesignStructure(QuantExperimentalDesignTree experimentalDesignTree, AbstractNode parentNode, Set<String> duplicates) {
        String nodeName = parentNode.toString();
        if (nodeName.length() > 100) {
            this.showErrorOnNode(experimentalDesignTree, parentNode, "Name Length should less than 100.");
            return false;
        }
        AbstractNode.NodeTypes type = parentNode.getType();
        switch (type) {
            case DATA_SET: {
                this.groupName4checkDesignStructure = "";
                if (!parentNode.isLeaf() && (parentNode.getChildCount() != 1 || ((AbstractNode)parentNode.getChildAt(0)).getType() != AbstractNode.NodeTypes.DATASET_REFERENCE)) break;
                this.showErrorOnNode(experimentalDesignTree, parentNode, "Your Experimental Design is empty.");
                return false;
            }
            case BIOLOGICAL_GROUP: {
                this.groupName4checkDesignStructure = nodeName;
                if (!parentNode.isLeaf()) break;
                this.showErrorOnNode(experimentalDesignTree, parentNode, "You must add at least one Biological Sample for each Biological Group.");
                return false;
            }
            case BIOLOGICAL_SAMPLE: {
                if (this.groupName4checkDesignStructure.length() + nodeName.length() > 100) {
                    this.showErrorOnNode(experimentalDesignTree, parentNode, "Group name + sample name, the length should less than 100.");
                    return false;
                }
                if (!parentNode.isLeaf()) break;
                this.showErrorOnNode(experimentalDesignTree, parentNode, "You must add at least one Identification for each Biological Sample.");
                return false;
            }
            case BIOLOGICAL_SAMPLE_ANALYSIS: {
                if (!parentNode.isLeaf()) break;
                if (duplicates.contains(parentNode.toString())) {
                    this.showErrorOnNode(experimentalDesignTree, parentNode, "Biological Sample Analysis is a duplicate. Please rename using right click!");
                    return false;
                }
                duplicates.add(parentNode.toString());
                return true;
            }
        }
        Enumeration<TreeNode> children = parentNode.children();
        while (children.hasMoreElements()) {
            AbstractNode rsmNode = (AbstractNode)children.nextElement();
            if (this.checkDesignStructure(experimentalDesignTree, rsmNode, duplicates)) continue;
            return false;
        }
        return true;
    }

    public boolean checkBiologicalGroupName(QuantExperimentalDesignTree experimentalDesignTree, AbstractNode parentNode) {
        ArrayList<String> listBiologicalGroupName = new ArrayList<String>();
        Enumeration<TreeNode> children = parentNode.children();
        while (children.hasMoreElements()) {
            AbstractNode rsmNode = (AbstractNode)children.nextElement();
            AbstractNode.NodeTypes type = rsmNode.getType();
            switch (type) {
                case BIOLOGICAL_GROUP: {
                    String gName = rsmNode.getData().getName();
                    if (listBiologicalGroupName.contains(gName)) {
                        this.showErrorOnNode(experimentalDesignTree, rsmNode, "The Biological Group name must be unique.");
                        return false;
                    }
                    listBiologicalGroupName.add(rsmNode.getData().getName());
                    ArrayList<String> listBiologicalSampleName = new ArrayList<String>();
                    Enumeration<TreeNode> childrenS = rsmNode.children();
                    while (childrenS.hasMoreElements()) {
                        AbstractNode sampleNode = (AbstractNode)childrenS.nextElement();
                        AbstractNode.NodeTypes typeS = sampleNode.getType();
                        switch (typeS) {
                            case BIOLOGICAL_SAMPLE: {
                                if (listBiologicalSampleName.contains(sampleNode.getData().getName())) {
                                    this.showErrorOnNode(experimentalDesignTree, sampleNode, "The Biological Sample name must be unique.");
                                    return false;
                                }
                                listBiologicalSampleName.add(sampleNode.getData().getName());
                            }
                        }
                    }
                    break;
                }
            }
        }
        return true;
    }

    protected void showErrorOnNode(QuantExperimentalDesignTree experimentalDesignTree, AbstractNode node, String error) {
        TreePath pathToExpand;
        AbstractNode parentNode = (AbstractNode)node.getParent();
        if (parentNode != null && !experimentalDesignTree.isExpanded(pathToExpand = new TreePath(parentNode.getPath()))) {
            experimentalDesignTree.expandPath(pathToExpand);
        }
        TreePath path = new TreePath(node.getPath());
        experimentalDesignTree.scrollPathToVisible(path);
        this.setStatus(true, error);
        this.highlight(experimentalDesignTree, experimentalDesignTree.getPathBounds(path));
    }
}

