/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.AbstractLabelFreeMSParamsPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.LabelFreeMSParamsCompletePanel;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.LabelFreeMSParamsSimplifiedPanel;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public class LabelFreeMSParamsPanel
extends JPanel {
    private static LabelFreeMSParamsPanel m_singleton = null;
    private AbstractLabelFreeMSParamsPanel m_internalQuantPanel = null;
    private JButton m_toggleButton = null;
    private JPanel m_mainPanel;
    private boolean m_completePanel;
    private GridBagConstraints m_internalPanelGBC = null;

    private LabelFreeMSParamsPanel() {
        this.setLayout(new BorderLayout());
        this.m_mainPanel = this.createMainPanel();
        this.add((Component)this.m_mainPanel, "Center");
    }

    public String getParamsVersion() {
        return "2.0";
    }

    public AbstractLabelFreeMSParamsPanel getParamsPanel() {
        return this.m_internalQuantPanel;
    }

    public static LabelFreeMSParamsPanel getLabelFreeMSQuantParamsPanel() {
        if (m_singleton == null) {
            m_singleton = new LabelFreeMSParamsPanel();
        }
        return m_singleton;
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_toggleButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPTIONS_MORE));
        this.m_toggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String infoText = LabelFreeMSParamsPanel.this.m_completePanel ? "Switching to short XIC Parameters panel will reset the filled values." : "Switching to complete XIC Parameters panel will reset the filled values.";
                InfoDialog exitDialog = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "XIC Parameters Reset", infoText);
                exitDialog.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
                exitDialog.setVisible(true);
                if (exitDialog.getButtonClicked() == 0) {
                    LabelFreeMSParamsPanel.this.setIsSimplifiedPanel(LabelFreeMSParamsPanel.this.m_completePanel);
                }
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        mainPanel.add((Component)this.m_toggleButton, c);
        ++c.gridx;
        c.weightx = 1.0;
        mainPanel.add(Box.createHorizontalGlue(), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weighty = 1.0;
        Preferences preferences = NbPreferences.root();
        boolean completePanel = !preferences.getBoolean("XicParameters.isSimplifiedParameters", true);
        this.m_internalQuantPanel = this.getParamsPanel(completePanel, true);
        mainPanel.add((Component)this.m_internalQuantPanel, c);
        this.m_internalPanelGBC = c;
        return mainPanel;
    }

    protected void setIsSimplifiedPanel(boolean isSimplified) {
        if (this.m_completePanel == isSimplified) {
            this.m_completePanel = !this.m_completePanel;
            this.m_toggleButton.setIcon(this.m_completePanel ? IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPTIONS_LESS) : IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPTIONS_MORE));
            this.m_mainPanel.remove(this.m_internalQuantPanel);
            this.m_internalQuantPanel = this.getParamsPanel(this.m_completePanel, true);
            this.m_mainPanel.add((Component)this.m_internalQuantPanel, this.m_internalPanelGBC);
            this.m_mainPanel.revalidate();
            this.m_mainPanel.repaint();
        }
    }

    private AbstractLabelFreeMSParamsPanel getParamsPanel(boolean completePanel, boolean readValues) {
        this.m_completePanel = completePanel;
        this.updateButton(this.m_completePanel);
        if (this.m_completePanel) {
            return new LabelFreeMSParamsCompletePanel(false, readValues);
        }
        return new LabelFreeMSParamsSimplifiedPanel();
    }

    private void updateButton(boolean completePanel) {
        if (completePanel) {
            this.m_toggleButton.setText("Simplified Parameters");
        } else {
            this.m_toggleButton.setText("Advanced Parameters");
        }
    }
}

