/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import fr.proline.studio.rsmexplorer.tree.xic.DatasetReferenceNode;
import fr.proline.studio.rsmexplorer.tree.xic.IdentificationSelectionTree;
import fr.proline.studio.rsmexplorer.tree.xic.QuantExperimentalDesignTree;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.tree.TreeNode;
import org.hibernate.Hibernate;

public class QuantExperimentalDesignPanel
extends JPanel {
    private final AbstractNode m_rootNode;
    private final IdentificationTree m_selectionTree;
    private final QuantExperimentalDesignTree m_experimentalDesignTree;
    private final QuantitationMethod.Type m_quantitationType;
    private JComboBox<QuantitationMethod> m_methodsCbx;
    private QuantitationMethod m_selectedMethod;

    public QuantExperimentalDesignPanel(AbstractNode rootNode, IdentificationTree selectionTree, QuantitationMethod.Type quantitationType) {
        this.m_rootNode = rootNode;
        this.m_selectionTree = selectionTree;
        this.m_experimentalDesignTree = new QuantExperimentalDesignTree(this.m_rootNode, true, true);
        this.m_quantitationType = quantitationType;
        JPanel mainPanel = this.createMainPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
    }

    public final JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        JPanel designTreePanel = this.createDesignTreePanel();
        JPanel selectionTreePanel = this.createSelectionTreePanel();
        JPanel framePanel = new JPanel(new GridBagLayout());
        framePanel.setBorder(BorderFactory.createTitledBorder(" Experimental Design "));
        JSplitPane sp = new JSplitPane();
        sp.setLeftComponent(designTreePanel);
        sp.setRightComponent(selectionTreePanel);
        sp.setResizeWeight(0.5);
        GridBagConstraints cFrame = new GridBagConstraints();
        cFrame.insets = new Insets(5, 5, 5, 5);
        cFrame.gridx = 0;
        cFrame.gridy = 0;
        cFrame.weightx = 1.0;
        cFrame.weighty = 1.0;
        cFrame.anchor = 18;
        cFrame.fill = 1;
        cFrame.gridwidth = 1;
        framePanel.add((Component)sp, cFrame);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 18;
        this.m_methodsCbx = new JComboBox<QuantitationMethod>(this.retrieveQuantMethods(this.m_quantitationType));
        this.m_selectedMethod = (QuantitationMethod)this.m_methodsCbx.getSelectedItem();
        this.m_methodsCbx.addItemListener(e -> {
            this.m_selectedMethod = (QuantitationMethod)this.m_methodsCbx.getSelectedItem();
        });
        switch (this.m_quantitationType) {
            case ISOBARIC_TAGGING: 
            case RESIDUE_LABELING: {
                c.fill = 2;
                c.weighty = 0.0;
                mainPanel.add((Component)this.createMethodPanel(this.m_quantitationType), c);
                c.gridx = 0;
                ++c.gridy;
            }
        }
        c.weighty = 1.0;
        c.fill = 1;
        mainPanel.add((Component)framePanel, c);
        return mainPanel;
    }

    private JPanel createMethodPanel(QuantitationMethod.Type quantitationType) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(" Quantitation Method "));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.anchor = 18;
        c.fill = 0;
        JLabel label = new JLabel("Name:");
        panel.add((Component)label, c);
        ++c.gridx;
        c.weightx = 0.2;
        panel.add(this.m_methodsCbx, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)new JPanel(), c);
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuantitationMethod[] retrieveQuantMethods(QuantitationMethod.Type quantitationType) {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            TypedQuery query = entityManagerUDS.createNamedQuery("findQuantMethodForType", QuantitationMethod.class);
            query.setParameter("searchType", (Object)quantitationType.toString());
            List results = query.getResultList();
            results.forEach(method -> Hibernate.initialize((Object)method.getLabels()));
            QuantitationMethod[] quantitationMethodArray = results.toArray(new QuantitationMethod[0]);
            return quantitationMethodArray;
        }
        return null;
    }

    private JPanel createDesignTreePanel() {
        JPanel designTreePanel = new JPanel();
        designTreePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JScrollPane treeScrollPane = new JScrollPane();
        treeScrollPane.setViewportView(this.m_experimentalDesignTree);
        designTreePanel.add((Component)treeScrollPane, c);
        return designTreePanel;
    }

    private JPanel createSelectionTreePanel() {
        JPanel selectionTreePanel = new JPanel();
        boolean isCorrect = true;
        Enumeration<TreeNode> childEnum = this.m_rootNode.children();
        while (childEnum.hasMoreElements()) {
            AbstractNode childNode = (AbstractNode)childEnum.nextElement();
            if (!DatasetReferenceNode.class.isInstance(childNode)) continue;
            isCorrect = !((DatasetReferenceNode)childNode).isInvalidReference();
        }
        selectionTreePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        if (isCorrect) {
            AbstractNode rootSelectionNode = this.m_selectionTree == null ? IdentificationTree.getCurrentTree().copyRootNodeForSelection() : this.m_selectionTree.copyRootNodeForSelection();
            IdentificationSelectionTree tree = new IdentificationSelectionTree(rootSelectionNode, true);
            JScrollPane treeScrollPane = new JScrollPane();
            treeScrollPane.setViewportView(tree);
            ++c.gridy;
            selectionTreePanel.add((Component)treeScrollPane, c);
        } else {
            selectionTreePanel = new JPanel(new BorderLayout());
            JLabel errMsgLabel = new JLabel("<html>Invalid Reference Dataset Specified in XIC (may have been revalidated).<br> Same data will be used, no change in experimental design is allowed.</html>", IconManager.getIcon((IconManager.IconType)IconManager.IconType.EXCLAMATION), 0);
            errMsgLabel.setForeground(Color.red);
            selectionTreePanel.add((Component)errMsgLabel, "Center");
        }
        return selectionTreePanel;
    }

    public QuantExperimentalDesignTree getExperimentalDesignTree() {
        return this.m_experimentalDesignTree;
    }

    public List<Long> getQuantifiedRsmIds() {
        return QuantExperimentalDesignTree.getQuantifiedRsmIds(this.m_rootNode);
    }

    public QuantitationMethod getQuantitationMethod() {
        return this.m_selectedMethod;
    }
}

