/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.core.orm.msi.PtmSpecificity;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.corewrapper.data.QuantPostProcessingParams;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.QuantPostProcessingPanel;
import fr.proline.studio.settings.FilePreferences;
import fr.proline.studio.settings.SettingsDialog;
import fr.proline.studio.settings.SettingsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openide.util.NbPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantPostProcessingDialog
extends DefaultDialog {
    private static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private QuantPostProcessingPanel m_quantPostProcessingPanel;

    public QuantPostProcessingDialog(Window parent, ArrayList<PtmSpecificity> ptms, boolean isAggregation, DDataset paramsFromdataset) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Compute Post-Processing on Proteins Sets Abundances");
        this.setDocumentationSuffix("id.thw4kt");
        this.setButtonVisible(3, true);
        this.setButtonVisible(4, true);
        this.setResizable(true);
        this.init(ptms, isAggregation, paramsFromdataset);
    }

    protected boolean saveCalled() {
        if (!this.checkParameters()) {
            return false;
        }
        JFileChooser fileChooser = SettingsUtils.getFileChooser((String)"QuantPostProcessing");
        int result = fileChooser.showSaveDialog((Component)((Object)this));
        if (result == 0) {
            File f = fileChooser.getSelectedFile();
            FilePreferences filePreferences = new FilePreferences(f, null, "");
            ParameterList parameterList = this.m_quantPostProcessingPanel.getParameterList();
            parameterList.saveParameters((Preferences)filePreferences);
            filePreferences.put("QuantPostProcessing.parametersVersion", "3.0");
            SettingsUtils.addSettingsPath((String)"QuantPostProcessing", (String)f.getAbsolutePath());
            SettingsUtils.writeDefaultDirectory((String)"QuantPostProcessing", (String)f.getParent());
        }
        return false;
    }

    protected boolean loadCalled() {
        SettingsDialog settingsDialog = new SettingsDialog((Window)((Object)this), "QuantPostProcessing");
        settingsDialog.setLocationRelativeTo((Component)((Object)this));
        settingsDialog.setVisible(true);
        if (settingsDialog.getButtonClicked() == 0) {
            if (settingsDialog.isDefaultSettingsSelected()) {
                ParameterList parameterList = this.m_quantPostProcessingPanel.getParameterList();
                parameterList.initDefaults();
            } else {
                try {
                    boolean modifiedPepParamExist;
                    File settingsFile = settingsDialog.getSelectedFile();
                    FilePreferences filePreferences = new FilePreferences(settingsFile, null, "");
                    String version = filePreferences.get("QuantPostProcessing.parametersVersion", null);
                    boolean bl = modifiedPepParamExist = filePreferences.get("QuantPostProcessing." + QuantPostProcessingParams.getSettingKey((String)"discard_modified_peptides"), null) != null;
                    if (version == null) {
                        version = modifiedPepParamExist ? "2.0" : "1.0";
                    }
                    if (!version.equals("3.0")) {
                        String msg = "Try loading Post Processing parameters (3.0) from file with version " + version + ". All parameters may not have been taken into account !";
                        JOptionPane.showMessageDialog((Component)((Object)this), msg, "Load Post Processing parameters error", 0);
                    }
                    this.m_quantPostProcessingPanel.loadParameters(filePreferences, version);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer").error("Parsing of User Settings File Failed", (Throwable)e);
                    this.setStatus(true, "Parsing of your Settings File failed");
                }
            }
        }
        return false;
    }

    protected boolean okCalled() {
        if (!this.checkParameters()) {
            return false;
        }
        Preferences preferences = NbPreferences.root();
        this.m_quantPostProcessingPanel.getParameterList().saveParameters(preferences);
        return true;
    }

    private boolean checkParameters() {
        ParameterError error = this.m_quantPostProcessingPanel.getParameterList().checkParameters();
        if (error != null) {
            this.setStatus(true, error.getErrorMessage());
            this.highlight(error.getParameterComponent());
            return false;
        }
        return true;
    }

    public Map<String, Object> getQuantParams() {
        return this.m_quantPostProcessingPanel.getQuantParams();
    }

    private void init(ArrayList<PtmSpecificity> ptms, boolean isAggregation, DDataset dataset) {
        Map<Long, String> ptmSpecificityNameById = ptms.stream().collect(Collectors.toMap(ptmS -> ptmS.getId(), ptmS -> ptmS.toString()));
        this.m_quantPostProcessingPanel = new QuantPostProcessingPanel(false, ptmSpecificityNameById);
        try {
            if (dataset != null && dataset.getQuantProcessingConfigAsMap() != null) {
                this.m_quantPostProcessingPanel.setRefinedParams(dataset.getPostQuantProcessingConfigAsMap());
            } else {
                Preferences preferences = NbPreferences.root();
                this.m_quantPostProcessingPanel.getParameterList().loadParameters(preferences);
            }
        }
        catch (Exception ex) {
            m_logger.error("error while settings quanti params " + ex);
        }
        this.m_quantPostProcessingPanel.setDiscardPeptidesSharingPeakelsChB(isAggregation);
        this.setInternalComponent(this.m_quantPostProcessingPanel);
    }
}

