/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.model;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideInstance;
import fr.proline.core.orm.msi.PeptideReadablePtmString;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.studio.corewrapper.util.PeptideClassesUtils;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.FloatRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.MsQueryRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.PeptideRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.ScoreRenderer;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import fr.proline.studio.table.TableColumn;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultLeftAlignRenderer;
import fr.proline.studio.table.renderer.DefaultRightAlignRenderer;
import fr.proline.studio.utils.StudioExceptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class PeptideInstanceTableModel
extends LazyTableModel
implements GlobalTableModelInterface {
    public static final int COLTYPE_PEPTIDE_ID = 0;
    public static final int COLTYPE_PEPTIDE_NAME = 1;
    public static final int COLTYPE_PEPTIDE_LENGTH = 2;
    public static final int COLTYPE_PEPTIDE_PTM = 3;
    public static final int COLTYPE_PEPTIDE_PSM_SCORE = 4;
    public static final int COLTYPE_PEPTIDE_CALCULATED_MASS = 5;
    public static final int COLTYPE_PEPTIDE_EXPERIMENTAL_MOZ = 6;
    public static final int COLTYPE_PEPTIDE_PPM = 7;
    public static final int COLTYPE_PEPTIDE_CHARGE = 8;
    public static final int COLTYPE_PEPTIDE_MISSED_CLEAVAGE = 9;
    public static final int COLTYPE_PEPTIDE_RANK = 10;
    public static final int COLTYPE_PEPTIDE_RETENTION_TIME = 11;
    public static final int COLTYPE_PEPTIDE_PROTEIN_SET_COUNT = 12;
    public static final int COLTYPE_PEPTIDE_PROTEIN_SET_NAMES = 13;
    public static final int COLTYPE_PEPTIDE_MSQUERY = 14;
    public static final int COLTYPE_SPECTRUM_TITLE = 15;
    public static final int COLTYPE_PEPTIDE_MATCH_COUNT = 16;
    public static final int COLTYPE_PEPTIDE_SCORE = 17;
    private static final TableColumn[] COLUMNS = new TableColumn.Builder().add(0, "Id", "Peptide Id", Long.class).add(1, "Peptide", "Peptide", DPeptideMatch.class).add(2, "Length", "Length", Integer.class).add(3, "PTMs", "Post Translational Modifications", String.class).add(4, "PSM Score", "Best PSM Score", Float.class).add(5, "Calc. Mass", "Calculated Mass", Double.class).add(6, "Exp. MoZ", "Experimental Mass to Charge Ratio", Double.class).add(7, "Ppm", "parts-per-million", Float.class).add(8, "Charge", "Charge", Integer.class).add(9, "Missed Cl.", "Missed Cleavages", Integer.class).add(10, "Rank", "Pretty Rank", Integer.class).add(11, "RT", "Retention Time (min)", Float.class).add(12, "Protein Set Count", "Protein Sets Count", Integer.class).add(13, "Protein Sets", "List of matching Protein Sets", String.class, true).add(14, "MsQuery", "MsQuery", DMsQuery.class, true).add(15, "Spectrum Title", "Spectrum Title", String.class, true).add(16, "PSM Count", "Number of Peptide Spectrum Matches matching this Peptide", Integer.class).add(17, "Score", "Peptide Score", Float.class).build();
    private PeptideInstance[] m_peptideInstances = null;
    private String m_modelName;
    private ScoreRenderer m_scoreRenderer = new ScoreRenderer();
    private final StringBuilder m_sb = new StringBuilder();
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

    public PeptideInstanceTableModel(LazyTable table) {
        super(table);
    }

    public PeptideInstance getPeptideInstance(int row) {
        return this.m_peptideInstances[row];
    }

    public int getColumnCount() {
        return COLUMNS.length;
    }

    public String getColumnName(int col) {
        return COLUMNS[col].getName();
    }

    public String getToolTipForHeader(int col) {
        return COLUMNS[col].getTooltip();
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public Class getColumnClass(int col) {
        return COLUMNS[col].getType();
    }

    @Override
    public int getSubTaskId(int col) {
        switch (col) {
            case 13: {
                return 1;
            }
            case 14: 
            case 15: {
                return 2;
            }
        }
        return -1;
    }

    public int getRowCount() {
        if (this.m_peptideInstances == null) {
            return 0;
        }
        return this.m_peptideInstances.length;
    }

    public Object getValueAt(int row, int col) {
        PeptideInstance peptideInstance = this.m_peptideInstances[row];
        DPeptideMatch peptideMatch = peptideInstance.getTransientData().getBestPeptideMatch();
        switch (col) {
            case 0: {
                return peptideInstance.getPeptide().getId();
            }
            case 1: {
                return peptideMatch;
            }
            case 4: {
                Float score = Float.valueOf(peptideMatch.getScore().floatValue());
                return score;
            }
            case 10: {
                return peptideMatch.getCDPrettyRank() == null ? "" : peptideMatch.getCDPrettyRank();
            }
            case 8: {
                return peptideMatch.getCharge();
            }
            case 2: {
                return peptideMatch == null ? null : Integer.valueOf(peptideMatch.getPeptide().getSequence().length());
            }
            case 6: {
                return Float.valueOf((float)peptideMatch.getExperimentalMoz());
            }
            case 7: {
                float ppm = PeptideClassesUtils.getPPMFor((DPeptideMatch)peptideMatch, (Peptide)peptideMatch.getPeptide()).floatValue();
                return Float.valueOf(ppm);
            }
            case 5: {
                Peptide peptide = peptideMatch.getPeptide();
                Float calculatedMass = Float.valueOf((float)peptide.getCalculatedMass());
                return calculatedMass;
            }
            case 9: {
                return peptideMatch.getMissedCleavage();
            }
            case 12: {
                return peptideInstance.getValidatedProteinSetCount();
            }
            case 16: {
                return peptideInstance.getPeptideMatchCount();
            }
            case 13: {
                LazyData lazyData = this.getLazyData(row, col);
                String[] proteinSetNames = peptideMatch.getProteinSetStringArray();
                if (proteinSetNames == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    for (int i = 0; i < proteinSetNames.length; ++i) {
                        String name = proteinSetNames[i];
                        if (i < proteinSetNames.length - 1) {
                            this.m_sb.append(name).append(", ");
                            continue;
                        }
                        this.m_sb.append(name);
                    }
                    lazyData.setData((Comparable)((Object)this.m_sb.toString()));
                    this.m_sb.setLength(0);
                }
                return lazyData;
            }
            case 11: {
                return peptideMatch.getRetentionTime();
            }
            case 3: {
                Peptide peptide = peptideMatch.getPeptide();
                if (peptide == null) {
                    return null;
                }
                boolean ptmStringLoadeed = peptide.getTransientData().isPeptideReadablePtmStringLoaded();
                if (!ptmStringLoadeed) {
                    return null;
                }
                String ptm = "";
                PeptideReadablePtmString ptmString = peptide.getTransientData().getPeptideReadablePtmString();
                if (ptmString != null) {
                    ptm = ptmString.getReadablePtmString();
                }
                return ptm;
            }
            case 14: {
                LazyData lazyData = this.getLazyData(row, col);
                if (!peptideMatch.isMsQuerySet()) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    DMsQuery msQuery = peptideMatch.getMsQuery();
                    lazyData.setData((Comparable)msQuery);
                }
                return lazyData;
            }
            case 15: {
                LazyData lazyData = this.getLazyData(row, col);
                if (!peptideMatch.isMsQuerySet()) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    String spectrumTitle = peptideMatch.getMsQuery().getDSpectrum().getTitle();
                    lazyData.setData((Comparable)((Object)spectrumTitle));
                }
                return lazyData;
            }
            case 17: {
                try {
                    Map properties = peptideInstance.getProperties();
                    if (properties == null || !properties.containsKey("score")) {
                        return null;
                    }
                    Double score = (Double)((Map)properties.get("score")).get("score");
                    return Float.valueOf(score.floatValue());
                }
                catch (Exception e) {
                    StudioExceptions.notify((String)"Peptide instance property cannot be read", (Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }

    public void setData(Long taskId, PeptideInstance[] peptideInstances) {
        this.m_peptideInstances = peptideInstances;
        this.m_taskId = taskId;
        this.updateMinMax();
        this.fireTableDataChanged();
    }

    private void updateMinMax() {
        if (this.m_peptideInstances == null) {
            return;
        }
        if (this.m_scoreRenderer == null) {
            return;
        }
        float maxScore = 0.0f;
        for (PeptideInstance peptideInstance : this.m_peptideInstances) {
            float score = peptideInstance.getTransientData().getBestPeptideMatch().getScore().floatValue();
            if (!(score > maxScore)) continue;
            maxScore = score;
        }
        this.m_scoreRenderer.setMaxValue(maxScore);
    }

    public PeptideInstance[] getPeptideInstances() {
        return this.m_peptideInstances;
    }

    public ResultSummary getResultSummary() {
        if (this.m_peptideInstances == null || this.m_peptideInstances.length == 0) {
            return null;
        }
        return this.m_peptideInstances[0].getResultSummary();
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    public int findRow(long peptideInstanceId) {
        int nb = this.m_peptideInstances.length;
        for (int i = 0; i < nb; ++i) {
            if (peptideInstanceId != this.m_peptideInstances[i].getId()) continue;
            return i;
        }
        return -1;
    }

    public void sortAccordingToModel(ArrayList<Long> peptideMatchIds, CompoundTableModel compoundTableModel) {
        if (this.m_peptideInstances == null) {
            return;
        }
        HashSet<Long> peptideMatchIdMap = new HashSet<Long>(peptideMatchIds.size());
        peptideMatchIdMap.addAll(peptideMatchIds);
        int nb = this.m_table.getRowCount();
        int iCur = 0;
        for (int iView = 0; iView < nb; ++iView) {
            PeptideInstance ps;
            int iModel = this.m_table.convertRowIndexToModel(iView);
            if (compoundTableModel != null) {
                iModel = compoundTableModel.convertCompoundRowToBaseModelRow(iModel);
            }
            if (!peptideMatchIdMap.contains((ps = this.getPeptideInstance(iModel)).getId())) continue;
            peptideMatchIds.set(iCur++, ps.getId());
        }
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        ConvertValueInterface peptideConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return ((DPeptideMatch)o).getPeptide().getSequence();
            }
        };
        filtersMap.put(1, (Filter)new StringDiffFilter(this.getColumnName(1), peptideConverter, 1));
        filtersMap.put(4, (Filter)new DoubleFilter(this.getColumnName(4), null, 4));
        filtersMap.put(10, (Filter)new IntegerFilter(this.getColumnName(10), null, 10));
        filtersMap.put(5, (Filter)new DoubleFilter(this.getColumnName(5), null, 5));
        filtersMap.put(3, (Filter)new StringDiffFilter(this.getColumnName(3), null, 3));
        filtersMap.put(6, (Filter)new DoubleFilter(this.getColumnName(6), null, 6));
        filtersMap.put(7, (Filter)new DoubleFilter(this.getColumnName(7), null, 7));
        filtersMap.put(11, (Filter)new DoubleFilter(this.getColumnName(11), null, 11));
        filtersMap.put(8, (Filter)new IntegerFilter(this.getColumnName(8), null, 8));
        filtersMap.put(2, (Filter)new IntegerFilter(this.getColumnName(2), null, 2));
        filtersMap.put(9, (Filter)new IntegerFilter(this.getColumnName(9), null, 9));
        filtersMap.put(12, (Filter)new IntegerFilter(this.getColumnName(12), null, 12));
        filtersMap.put(16, (Filter)new IntegerFilter(this.getColumnName(16), null, 16));
        filtersMap.put(13, (Filter)new StringDiffFilter(this.getColumnName(13), null, 13));
        ConvertValueInterface msQueryConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return ((DMsQuery)o).getInitialId();
            }
        };
        filtersMap.put(14, (Filter)new IntegerFilter(this.getColumnName(14), msQueryConverter, 14));
        filtersMap.put(15, (Filter)new StringDiffFilter(this.getColumnName(15), null, 15));
    }

    public boolean isLoaded() {
        return this.m_table.isSortable();
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 5: {
                return Float.class;
            }
            case 1: 
            case 15: {
                return String.class;
            }
        }
        return this.getColumnClass(columnIndex);
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        Object data = this.getValueAt(rowIndex, columnIndex);
        if (data instanceof LazyData) {
            data = ((LazyData)data).getData();
        }
        if (data instanceof DPeptideMatch) {
            data = ((DPeptideMatch)data).getPeptide().getSequence();
        }
        return data;
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{0, 1};
        return keys;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public int getInfoColumn() {
        return 1;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public PlotType getBestPlotType() {
        return null;
    }

    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    public String getExportRowCell(int row, int col) {
        return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public String getExportColumnName(int col) {
        return this.getColumnName(col);
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        TableCellRenderer renderer = null;
        switch (col) {
            case 1: {
                renderer = new PeptideRenderer();
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                renderer = new FloatRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 4);
                break;
            }
            case 4: 
            case 17: {
                renderer = this.m_scoreRenderer;
                break;
            }
            case 7: {
                renderer = new FloatRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)));
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 16: {
                renderer = new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class));
                break;
            }
            case 3: {
                renderer = new DefaultLeftAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class));
                break;
            }
            case 14: {
                renderer = new MsQueryRenderer();
            }
        }
        this.m_rendererMap.put(col, renderer);
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(PeptideInstance.class, true));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(PeptideInstance.class)) {
            return this.m_peptideInstances[row];
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }
}

