/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.model;

import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.ProteinCountRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.ScoreRenderer;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultLeftAlignRenderer;
import fr.proline.studio.utils.IconManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ProteinSetTableModel
extends LazyTableModel
implements GlobalTableModelInterface {
    public static final int COLTYPE_PROTEIN_SET_ID = 0;
    public static final int COLTYPE_PROTEIN_SET_NAME = 1;
    public static final int COLTYPE_PROTEIN_SET_DESCRIPTION = 2;
    public static final int COLTYPE_PROTEIN_SCORE = 3;
    public static final int COLTYPE_PROTEINS_COUNT = 4;
    public static final int COLTYPE_PEPTIDES_COUNT = 5;
    public static final int COLTYPE_OBSERVABLE_PEPTIDES = 6;
    public static final int COLTYPE_SPECTRAL_COUNT = 7;
    public static final int COLTYPE_SPECIFIC_SPECTRAL_COUNT = 8;
    public static final int COLTYPE_UNIQUE_SEQUENCES_COUNT = 9;
    public static final int COLTYPE_PROTEIN_MASS = 10;
    public static final int COLTYPE_PROTEIN_SET_GENE_NAME = 11;
    private static final String[] m_columnNames = new String[]{"Id", "Protein Set", "Description", "Score", "Proteins", "Peptides", "Observable Peptides", "Spectral Count", "Specific Spectral Count", "Sequence Count", "Mass", "Gene Name"};
    private DProteinSet[] m_proteinSets = null;
    private int[] m_colUsed = null;
    private String m_modelName;
    private boolean m_mergedData = false;
    private ScoreRenderer m_scoreRenderer = new ScoreRenderer();
    private static final StringBuilder m_sb = new StringBuilder(20);
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

    public ProteinSetTableModel(LazyTable table) {
        super(table);
        this.setColUsed(this.m_mergedData);
    }

    private void setColUsed(boolean mergedRsm) {
        if (mergedRsm) {
            int[] colUsed = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
            this.m_colUsed = colUsed;
        } else {
            int[] colUsed = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
            this.m_colUsed = colUsed;
        }
    }

    public List<Integer> getDefaultColumnsToHide() {
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        listIds.add(11);
        return listIds;
    }

    public int convertColToColUsed(int col) {
        for (int i = 0; i < this.m_colUsed.length; ++i) {
            if (col != this.m_colUsed[i]) continue;
            return i;
        }
        return -1;
    }

    public int getColumnCount() {
        return this.m_colUsed.length;
    }

    public String getColumnName(int col) {
        return m_columnNames[this.m_colUsed[col]];
    }

    public String getToolTipForHeader(int col) {
        int colUsed = this.m_colUsed[col];
        if (colUsed == 4) {
            String urlSameset = IconManager.getURLForIcon((IconManager.IconType)IconManager.IconType.SAME_SET);
            String urlSubset = IconManager.getURLForIcon((IconManager.IconType)IconManager.IconType.SUB_SET);
            return "<html>Number of Proteins ( Sameset <img src=\"" + urlSameset + "\">&nbsp;,&nbsp; Subset <img src=\"" + urlSubset + "\">)</html>";
        }
        if (colUsed == 7 && this.m_mergedData) {
            return "Number of PSM for all the merged Identification Summaries";
        }
        if (colUsed == 11) {
            return "Correcponding Gene Name. This information is fill in during 'Retrieve Sequence' task.";
        }
        if (colUsed == 6) {
            return "Theorical observable peptides count. This information is fill in during 'Retrieve Sequence' task.";
        }
        return this.getColumnName(col);
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public Class getColumnClass(int col) {
        int colUsed = this.m_colUsed[col];
        if (colUsed == 0) {
            return Long.class;
        }
        return LazyData.class;
    }

    @Override
    public int getSubTaskId(int col) {
        switch (col) {
            case 1: 
            case 2: {
                return 0;
            }
            case 3: 
            case 4: {
                return 3;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                return 0;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 2;
            }
        }
        return -1;
    }

    public int getRowCount() {
        if (this.m_proteinSets == null) {
            return 0;
        }
        return this.m_proteinSets.length;
    }

    public Object getValueAt(int row, int col) {
        DProteinSet proteinSet = this.m_proteinSets[row];
        long rsmId = proteinSet.getResultSummaryId();
        col = this.m_colUsed[col];
        switch (col) {
            case 0: {
                return proteinSet.getId();
            }
            case 1: {
                LazyData lazyData = this.getLazyData(row, col);
                DProteinMatch proteinMatch = proteinSet.getTypicalProteinMatch();
                if (proteinMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)((Object)proteinMatch.getAccession()));
                }
                return lazyData;
            }
            case 2: {
                LazyData lazyData = this.getLazyData(row, col);
                DProteinMatch proteinMatch = proteinSet.getTypicalProteinMatch();
                if (proteinMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)((Object)proteinMatch.getDescription()));
                }
                return lazyData;
            }
            case 11: {
                LazyData lazyData = this.getLazyData(row, col);
                DProteinMatch proteinMatch = proteinSet.getTypicalProteinMatch();
                if (proteinMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    String geneName = proteinMatch.getGeneName();
                    if (geneName == null) {
                        geneName = "";
                    }
                    lazyData.setData((Comparable)((Object)geneName));
                }
                return lazyData;
            }
            case 3: {
                LazyData lazyData = this.getLazyData(row, col);
                DProteinMatch proteinMatch = proteinSet.getTypicalProteinMatch();
                if (proteinMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Float.valueOf(proteinMatch.getPeptideSet(Long.valueOf(rsmId)).getScore()));
                }
                return lazyData;
            }
            case 4: {
                LazyData lazyData = this.getLazyData(row, col);
                Integer sameSetCount = proteinSet.getSameSetCount();
                Integer subSetCount = proteinSet.getSubSetCount();
                if (sameSetCount == null || subSetCount == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)new ProteinCount(sameSetCount, subSetCount));
                }
                return lazyData;
            }
            case 5: {
                LazyData lazyData = this.getLazyData(row, col);
                DProteinMatch proteinMatch = proteinSet.getTypicalProteinMatch();
                if (proteinMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Integer.valueOf(proteinMatch.getPeptideSet(Long.valueOf(rsmId)).getPeptideCount()));
                }
                return lazyData;
            }
            case 6: {
                LazyData lazyData = this.getLazyData(row, col);
                DProteinMatch proteinMatch = proteinSet.getTypicalProteinMatch();
                if (proteinMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    Integer observablePeptides = proteinMatch.getObservablePeptidesCount();
                    if (observablePeptides == null) {
                        return null;
                    }
                    lazyData.setData((Comparable)observablePeptides);
                }
                return lazyData;
            }
            case 9: {
                LazyData lazyData = this.getLazyData(row, col);
                DProteinMatch proteinMatch = proteinSet.getTypicalProteinMatch();
                if (proteinMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    Integer value = -1;
                    try {
                        value = proteinMatch.getPeptideSet(Long.valueOf(rsmId)).getSequenceCount();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    lazyData.setData((Comparable)value);
                }
                return lazyData;
            }
            case 7: {
                LazyData lazyData = this.getLazyData(row, col);
                Integer spectralCount = proteinSet.getSpectralCount();
                lazyData.setData((Comparable)spectralCount);
                if (spectralCount == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                } else if (this.m_mergedData && spectralCount < 0) {
                    lazyData.setData((Comparable)((Object)"Not Available"));
                }
                return lazyData;
            }
            case 8: {
                LazyData lazyData = this.getLazyData(row, col);
                Integer specificSpectralCount = proteinSet.getSpecificSpectralCount();
                lazyData.setData((Comparable)specificSpectralCount);
                if (specificSpectralCount == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                } else if (this.m_mergedData && specificSpectralCount < 0) {
                    lazyData.setData((Comparable)((Object)"Not Available"));
                }
                return lazyData;
            }
            case 10: {
                LazyData lazyData = this.getLazyData(row, col);
                DProteinMatch proteinMatch = proteinSet.getTypicalProteinMatch();
                if (proteinMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else if (proteinMatch.getDBioSequence() == null) {
                    lazyData.setData((Comparable)((Object)""));
                } else {
                    lazyData.setData((Comparable)Double.valueOf(proteinMatch.getDBioSequence().getMass()));
                }
                return lazyData;
            }
        }
        return null;
    }

    public void setData(Long taskId, DProteinSet[] proteinSets, boolean mergedData) {
        this.m_proteinSets = proteinSets;
        this.m_taskId = taskId;
        this.updateMinMax();
        if (this.m_mergedData != mergedData) {
            this.m_mergedData = mergedData;
            this.setColUsed(mergedData);
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    private void updateMinMax() {
        if (this.m_proteinSets == null) {
            return;
        }
        if (this.m_scoreRenderer == null) {
            return;
        }
        float maxScore = 0.0f;
        for (DProteinSet proteinSet : this.m_proteinSets) {
            long rsmId;
            float score;
            DProteinMatch proteinMatch = proteinSet.getTypicalProteinMatch();
            if (proteinMatch == null || !((score = proteinMatch.getPeptideSet(Long.valueOf(rsmId = proteinSet.getResultSummaryId())).getScore()) > maxScore)) continue;
            maxScore = score;
        }
        this.m_scoreRenderer.setMaxValue(maxScore);
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    public DProteinSet getProteinSet(int i) {
        return this.m_proteinSets[i];
    }

    public Long getResultSummaryId() {
        if (this.m_proteinSets == null || this.m_proteinSets.length == 0) {
            return null;
        }
        return this.m_proteinSets[0].getResultSummaryId();
    }

    public int findRow(long proteinSetId) {
        int nb = this.m_proteinSets.length;
        for (int i = 0; i < nb; ++i) {
            if (proteinSetId != this.m_proteinSets[i].getId()) continue;
            return i;
        }
        return -1;
    }

    public void sortAccordingToModel(ArrayList<Long> proteinSetIds, CompoundTableModel compoundTableModel) {
        if (this.m_proteinSets == null) {
            return;
        }
        HashSet<Long> proteinSetIdMap = new HashSet<Long>(proteinSetIds.size());
        proteinSetIdMap.addAll(proteinSetIds);
        int nb = this.m_table.getRowCount();
        int iCur = 0;
        for (int iView = 0; iView < nb; ++iView) {
            DProteinSet ps;
            int iModel = this.m_table.convertRowIndexToModel(iView);
            if (compoundTableModel != null) {
                iModel = compoundTableModel.convertCompoundRowToBaseModelRow(iModel);
            }
            if (!proteinSetIdMap.contains((ps = this.getProteinSet(iModel)).getId())) continue;
            proteinSetIds.set(iCur++, ps.getId());
        }
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public boolean isLoaded() {
        return this.m_table.isLoaded();
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        columnIndex = this.m_colUsed[columnIndex];
        switch (columnIndex) {
            case 0: {
                return Long.class;
            }
            case 1: 
            case 2: 
            case 11: {
                return String.class;
            }
            case 3: 
            case 10: {
                return Float.class;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return Integer.class;
            }
        }
        return null;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        Object data = this.getValueAt(rowIndex, columnIndex);
        if (data instanceof LazyData) {
            data = ((LazyData)data).getData();
        }
        if (data instanceof ProteinCount) {
            return ((ProteinCount)data).getNbProteins();
        }
        return data;
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{this.convertColToColUsed(1), this.convertColToColUsed(0)};
        return keys;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public int getInfoColumn() {
        return 1;
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        int colIdx = 0;
        filtersMap.put(++colIdx, (Filter)new StringDiffFilter(this.getColumnName(colIdx), null, colIdx));
        filtersMap.put(++colIdx, (Filter)new StringDiffFilter(this.getColumnName(colIdx), null, colIdx));
        filtersMap.put(++colIdx, (Filter)new DoubleFilter(this.getColumnName(colIdx), null, colIdx));
        ++colIdx;
        filtersMap.put(++colIdx, (Filter)new IntegerFilter(this.getColumnName(colIdx), null, colIdx));
        filtersMap.put(++colIdx, (Filter)new IntegerFilter(this.getColumnName(colIdx), null, colIdx));
        filtersMap.put(++colIdx, (Filter)new IntegerFilter(this.getColumnName(colIdx), null, colIdx));
        filtersMap.put(++colIdx, (Filter)new IntegerFilter(this.getColumnName(colIdx), null, colIdx));
        filtersMap.put(++colIdx, (Filter)new IntegerFilter(this.getColumnName(colIdx), null, colIdx));
        filtersMap.put(++colIdx, (Filter)new DoubleFilter(this.getColumnName(colIdx), null, colIdx));
        filtersMap.put(++colIdx, (Filter)new StringDiffFilter(this.getColumnName(colIdx), null, colIdx));
    }

    public PlotType getBestPlotType() {
        return PlotType.HISTOGRAM_PLOT;
    }

    public int[] getBestColIndex(PlotType plotType) {
        switch (plotType) {
            case HISTOGRAM_PLOT: {
                int[] cols = new int[]{5, 3};
                return cols;
            }
            case SCATTER_PLOT: {
                int[] cols = new int[]{5, 3};
                return cols;
            }
        }
        return null;
    }

    public String getExportRowCell(int row, int col) {
        if (col == 4) {
            DProteinSet proteinSet = this.m_proteinSets[row];
            Integer sameSetCount = proteinSet.getSameSetCount();
            Integer subSetCount = proteinSet.getSubSetCount();
            ProteinCount proteinCount = new ProteinCount(sameSetCount, subSetCount);
            return proteinCount.toString();
        }
        return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public String getExportColumnName(int col) {
        return this.getColumnName(col);
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col = this.m_colUsed[col])) {
            return this.m_rendererMap.get(col);
        }
        DefaultTableCellRenderer renderer = null;
        switch (col) {
            case 1: 
            case 2: {
                renderer = new DefaultLeftAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class));
                break;
            }
            case 3: {
                renderer = this.m_scoreRenderer;
                break;
            }
            case 4: {
                renderer = new ProteinCountRenderer();
            }
        }
        this.m_rendererMap.put(col, renderer);
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(DProteinSet.class, true));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(DProteinSet.class)) {
            return this.m_proteinSets[row];
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public class ProteinCount
    implements Comparable {
        private final int m_sameSetCount;
        private final int m_subSetCount;

        public ProteinCount(int sameSetCount, int subSetCount) {
            this.m_sameSetCount = sameSetCount;
            this.m_subSetCount = subSetCount;
        }

        public int getNbProteins() {
            return this.m_sameSetCount + this.m_subSetCount;
        }

        public String toHtml() {
            String urlSameset = IconManager.getURLForIcon((IconManager.IconType)IconManager.IconType.SAME_SET);
            String urlSubset = IconManager.getURLForIcon((IconManager.IconType)IconManager.IconType.SUB_SET);
            m_sb.setLength(0);
            m_sb.append("<html>");
            m_sb.append(this.m_sameSetCount + this.m_subSetCount);
            m_sb.append("&nbsp;&nbsp;(").append(this.m_sameSetCount).append("&nbsp;<img src=\"").append(urlSameset).append("\">");
            m_sb.append("&nbsp;,&nbsp;").append(this.m_subSetCount).append("&nbsp;<img src=\"").append(urlSubset).append("\">&nbsp;");
            m_sb.append(')');
            m_sb.append("</html>");
            return m_sb.toString();
        }

        public String toString() {
            m_sb.setLength(0);
            m_sb.append(this.m_sameSetCount + this.m_subSetCount);
            m_sb.append(" (").append(this.m_sameSetCount);
            m_sb.append(",").append(this.m_subSetCount);
            m_sb.append(')');
            return m_sb.toString();
        }

        public int compareTo(Object o) {
            int diffProteins = this.m_sameSetCount + this.m_subSetCount - ((ProteinCount)o).m_sameSetCount - ((ProteinCount)o).m_subSetCount;
            if (diffProteins != 0) {
                return diffProteins;
            }
            return this.m_sameSetCount - ((ProteinCount)o).m_sameSetCount;
        }
    }
}

