/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm;

import fr.proline.core.orm.msi.dto.DBioSequence;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptidePTM;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import fr.proline.studio.dam.tasks.data.ptm.PTMSitePeptideInstance;
import fr.proline.studio.rsmexplorer.gui.ptm.PTMMark;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTMSitePeptidesGraphicDataMgr {
    private static Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.rsmexplorer.ptm");
    private PTMSite m_currentPtmSite;
    private List<PTMSitePeptideInstance> m_peptidesInstances = new ArrayList<PTMSitePeptideInstance>();
    private Map<Integer, PTMMark> m_allPtmMarks;
    private String m_proteinSequence;
    private int m_beginBestFit = Integer.MAX_VALUE;

    public String getProteinSequence() {
        return this.m_proteinSequence;
    }

    public int getRowCount() {
        if (this.m_peptidesInstances == null) {
            return -1;
        }
        return this.m_peptidesInstances.size();
    }

    public Map<Integer, PTMMark> getAllPtmMarks() {
        return this.m_allPtmMarks;
    }

    public void setData(PTMSite selectedPTMSite) {
        if (this.m_currentPtmSite != null && this.m_currentPtmSite.equals(selectedPTMSite)) {
            return;
        }
        this.m_beginBestFit = Integer.MAX_VALUE;
        this.m_currentPtmSite = selectedPTMSite;
        this.m_peptidesInstances = new ArrayList<PTMSitePeptideInstance>();
        this.m_allPtmMarks = new HashMap<Integer, PTMMark>();
        if (this.m_currentPtmSite == null) {
            m_logger.debug(this.getClass().getName() + "setData data is null");
            this.m_proteinSequence = "";
            this.m_beginBestFit = 0;
            return;
        }
        HashSet<Long> peptidesIds = new HashSet<Long>();
        for (DPeptideInstance parentPeptideInstance : this.m_currentPtmSite.getParentPeptideInstances()) {
            long peptideId = parentPeptideInstance.getPeptideId();
            peptidesIds.add(peptideId);
            PTMSitePeptideInstance ptmPepInstance = this.m_currentPtmSite.getPTMSitePeptideInstance(Long.valueOf(peptideId));
            this.m_peptidesInstances.add(ptmPepInstance);
            if (this.m_currentPtmSite.isProteinNTermWithOutM()) {
                this.m_beginBestFit = 0;
            } else if (ptmPepInstance != null && this.m_beginBestFit > ptmPepInstance.getParentPTMPeptideInstance().getStartPosition()) {
                this.m_beginBestFit = ptmPepInstance.getParentPTMPeptideInstance().getStartPosition();
            }
            for (DPeptidePTM ptm : parentPeptideInstance.getPeptide().getTransientData().getDPeptidePtmMap().values()) {
                int protLocation = 0;
                if (this.m_currentPtmSite.isProteinNTermWithOutM()) {
                    protLocation = (int)ptm.getSeqPosition();
                    if (protLocation == 0) {
                        protLocation = 1;
                    }
                } else if (ptmPepInstance != null) {
                    protLocation = ptmPepInstance.getParentPTMPeptideInstance().getStartPosition() + (int)ptm.getSeqPosition();
                }
                PTMMark mark = new PTMMark(ptm, protLocation);
                PTMMark exist = this.m_allPtmMarks.get(protLocation);
                if (exist == null || !exist.equals(mark)) {
                    this.m_allPtmMarks.put(protLocation, mark);
                }
                m_logger.debug("all PTM Marker {}", this.m_allPtmMarks);
            }
        }
        DProteinMatch pm = this.m_currentPtmSite.getProteinMatch();
        DBioSequence bs = pm.getDBioSequence();
        this.m_proteinSequence = bs != null ? bs.getSequence() : this.createSequence();
    }

    int getBeginBestFit() {
        return this.m_beginBestFit;
    }

    private String createSequence() {
        StringBuilder sb = new StringBuilder();
        if (this.m_beginBestFit > 1) {
            for (int i = 1; i < this.m_beginBestFit - 1; ++i) {
                sb.append("-");
            }
        }
        for (PTMSitePeptideInstance item : this.m_peptidesInstances) {
            int l;
            PTMPeptideInstance pp = item.getParentPTMPeptideInstance();
            PTMSite site = item.getSite();
            String content = pp.getSequence();
            int cLength = content.length();
            int pIndex = pp.getStartPosition();
            if (pIndex == 1 && site.isProteinNTermWithOutM()) {
                pIndex = 0;
            }
            if ((l = sb.length()) < pIndex) {
                for (int i = l; i < pIndex; ++i) {
                    sb.append("-");
                }
                sb.append(content);
                continue;
            }
            if (sb.length() > cLength + pIndex) {
                sb.replace(pIndex, pIndex + cLength, content);
                continue;
            }
            sb.delete(pIndex, sb.length());
            sb.append(content);
        }
        return sb.toString();
    }

    protected PTMSitePeptideInstance getSelectedPTMSitePeptideInstance(int row) {
        if (this.getRowCount() == 0) {
            return null;
        }
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        if (this.m_peptidesInstances.get(row) == null) {
            return null;
        }
        return this.m_peptidesInstances.get(row);
    }

    protected DPeptideInstance getSelectedDPeptideInstance(int row) {
        PTMSitePeptideInstance selected = this.getSelectedPTMSitePeptideInstance(row);
        if (selected != null) {
            return selected.getParentPTMPeptideInstance().getPeptideInstance();
        }
        return null;
    }

    public int getPeptideIndex(DPeptideInstance pep) {
        for (int row = 0; row < this.m_peptidesInstances.size(); ++row) {
            DPeptideInstance comparePep = this.m_peptidesInstances.get(row).getParentPTMPeptideInstance().getPeptideInstance();
            if (!comparePep.equals(pep)) continue;
            return row;
        }
        return -1;
    }

    public List<PTMSitePeptideInstance> getPTMSitePeptideInstances() {
        return this.m_peptidesInstances;
    }

    protected int getPTMSiteSeqPos() {
        return this.m_currentPtmSite.getPositionOnProtein();
    }
}

