/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.renderer;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptidePTM;
import fr.proline.studio.table.renderer.GrayableTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class PeptideRenderer
extends DefaultTableCellRenderer
implements GrayableTableCellRenderer {
    private boolean m_grayed = false;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String displayString = value == null || !DPeptideMatch.class.isAssignableFrom(value.getClass()) && !Peptide.class.isAssignableFrom(value.getClass()) ? "" : (DPeptideMatch.class.isAssignableFrom(value.getClass()) ? PeptideRenderer.constructPeptideDisplay(((DPeptideMatch)value).getPeptide()) : PeptideRenderer.constructPeptideDisplay((Peptide)value));
        JLabel l = (JLabel)super.getTableCellRendererComponent(table, displayString, isSelected, hasFocus, row, column);
        if (this.m_grayed) {
            l.setFont(l.getFont().deriveFont(2));
            l.setForeground(Color.lightGray);
        }
        return l;
    }

    public static String constructPeptideDisplay(Peptide peptide) {
        StringBuilder m_displaySB = new StringBuilder();
        StringBuilder m_exportSB = new StringBuilder();
        if (peptide != null && peptide.getTransientData() != null) {
            HashMap ptmMap = peptide.getTransientData().getDPeptidePtmMap();
            if (ptmMap != null) {
                m_displaySB.append("<html>");
            }
            String sequence = peptide.getSequence();
            if (ptmMap == null) {
                m_displaySB.append(sequence);
                m_exportSB.append(sequence);
            } else {
                int nb = sequence.length();
                for (int i = 0; i < nb; ++i) {
                    boolean aminoAcidModification;
                    DPeptidePTM cterPtm;
                    boolean nTerOrCterModification = false;
                    if (i == 0) {
                        DPeptidePTM nterPtm = (DPeptidePTM)ptmMap.get(0);
                        if (nterPtm != null) {
                            nTerOrCterModification = true;
                        }
                    } else if (i == nb - 1 && (cterPtm = (DPeptidePTM)ptmMap.get(-1)) != null) {
                        nTerOrCterModification = true;
                    }
                    DPeptidePTM ptm = (DPeptidePTM)ptmMap.get(i + 1);
                    boolean bl = aminoAcidModification = ptm != null;
                    if (nTerOrCterModification || aminoAcidModification) {
                        if (nTerOrCterModification && aminoAcidModification) {
                            m_displaySB.append("<span style='color:").append("#ce85fd;").append("'>");
                        } else if (nTerOrCterModification) {
                            m_displaySB.append("<span style='color:").append("#6eb86a;").append("'>");
                        } else if (aminoAcidModification) {
                            m_displaySB.append("<span style='color:").append("#fdb800;").append("'>");
                        }
                        m_displaySB.append(sequence.charAt(i));
                        m_displaySB.append("</span>");
                    } else {
                        m_displaySB.append(sequence.charAt(i));
                    }
                    m_exportSB.append(sequence.charAt(i));
                }
            }
            if (ptmMap != null) {
                m_displaySB.append("</html>");
            }
            String textToExport = m_exportSB.toString();
            m_exportSB.setLength(0);
            String res = m_displaySB.toString();
            m_displaySB.setLength(0);
            return res;
        }
        String textToExport = peptide == null ? "" : peptide.getSequence();
        return textToExport;
    }

    public void setGrayed(boolean v) {
        this.m_grayed = v;
    }
}

