/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.spectrum;

import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.rsmexplorer.gui.spectrum.HideFragmentsTableIntensityButton;
import fr.proline.studio.rsmexplorer.gui.spectrum.PeptideFragmentationData;
import fr.proline.studio.rsmexplorer.gui.spectrum.RsetPeptideFragmentationTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import org.jdesktop.swingx.JXTable;

public class RsetPeptideFragmentationTablePanel
extends HourglassPanel
implements DataBoxPanelInterface,
SplittedPanelContainer.ReactiveTabbedComponent {
    private boolean m_isDisplayed = true;
    private AbstractDataBox m_dataBox;
    private RsetPeptideFragmentationTable m_fragmentationTable = null;
    private HideFragmentsTableIntensityButton m_hideFragIntensityButton = null;
    private final JTextArea m_descriptionTA;

    public RsetPeptideFragmentationTablePanel() {
        this.setLayout(new BorderLayout());
        this.m_fragmentationTable = new RsetPeptideFragmentationTable();
        this.m_descriptionTA = new JTextArea();
        this.m_descriptionTA.setEditable(false);
        this.m_descriptionTA.setOpaque(false);
        JToolBar toolbar = this.createToolbar();
        JPanel internalPanel = this.createInternalPanel();
        this.add(this.m_descriptionTA, "North");
        this.add(internalPanel, "Center");
        this.add(toolbar, "West");
    }

    private JToolBar createToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        ExportButton m_exportButton = new ExportButton(null, "Fragmentation Table", (JXTable)this.m_fragmentationTable);
        toolbar.add((Component)m_exportButton);
        this.m_hideFragIntensityButton = new HideFragmentsTableIntensityButton(this.m_fragmentationTable, false);
        this.m_hideFragIntensityButton.setEnabled(false);
        toolbar.add(this.m_hideFragIntensityButton);
        return toolbar;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView((Component)((Object)this.m_fragmentationTable));
        this.m_fragmentationTable.setFillsViewportHeight(true);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        internalPanel.add((Component)scrollPane, c);
        return internalPanel;
    }

    public void setData(DPeptideMatch peptideMatch, PeptideFragmentationData peptideFragmentationData) {
        boolean enable;
        this.m_fragmentationTable.setData(peptideMatch, peptideFragmentationData);
        boolean isEnable = this.m_hideFragIntensityButton.isEnabled();
        boolean bl = enable = peptideFragmentationData != null;
        if (isEnable ^ enable) {
            this.m_hideFragIntensityButton.setEnabled(enable);
        }
        if (peptideFragmentationData != null && peptideFragmentationData.getNeutralLossStatus() != null) {
            this.m_descriptionTA.setText("Sum of Neutral Losses : " + peptideFragmentationData.getNeutralLossStatus());
        } else {
            this.m_descriptionTA.setText("");
        }
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public void setShowed(boolean showed) {
        if (showed == this.m_isDisplayed) {
            return;
        }
        this.m_isDisplayed = showed;
    }

    public boolean isShowed() {
        return this.m_isDisplayed;
    }
}

