/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.tasklog;

import fr.profi.util.StringUtils;
import fr.proline.studio.dpm.data.JMSNotificationMessage;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.util.JMSConnectionManager;
import fr.proline.studio.dpm.task.util.JMSMessageUtil;
import fr.proline.studio.rsmexplorer.gui.dialog.GetSystemInfoButtonAction;
import fr.proline.studio.rsmexplorer.gui.tasklog.AbstractTasksPanel;
import fr.proline.studio.rsmexplorer.gui.tasklog.ServerLogFileNameDialog;
import fr.proline.studio.table.DecoratedTable;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.table.renderer.DefaultLeftAlignRenderer;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.jms.Message;
import javax.jms.QueueBrowser;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openide.windows.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTasksPanel
extends AbstractTasksPanel {
    private SystemMessageTable m_messageTable;
    private QueueBrowser m_qBrowser = null;
    private static final int UPDATE_DELAY = 1000;
    private Timer m_updateTimer = null;
    private static int m_connectionErrCount = 0;
    protected static final Logger m_loggerProline = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private JButton m_reconnectButton;
    private JButton m_logParserButton;
    private ServerLogFileNameDialog m_logParserDialog;

    public SystemTasksPanel() {
        this.setLayout(new GridBagLayout());
        this.m_logParserDialog = new ServerLogFileNameDialog();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add(this.createToolbarPanel(), c);
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        JButton clearButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        clearButton.setToolTipText("Clear system tasks list");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemTasksPanel.this.clearData();
            }
        });
        toolbar.add(clearButton);
        GetSystemInfoButtonAction systemInfoButton = new GetSystemInfoButtonAction();
        toolbar.add(systemInfoButton);
        this.m_reconnectButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.REFRESH));
        this.m_reconnectButton.setToolTipText("Reconnect to server tasks logs");
        this.m_reconnectButton.setEnabled(false);
        this.m_reconnectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SystemTasksPanel.this.isMonitoringConnected()) {
                    m_connectionErrCount = 0;
                    SystemTasksPanel.this.reInitConnection();
                }
            }
        });
        toolbar.add(this.m_reconnectButton);
        this.m_logParserButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.DOCUMENT_LIST));
        this.m_logParserButton.setToolTipText("View server tasks log history");
        this.m_logParserButton.setEnabled(true);
        this.m_logParserButton.addActionListener(this.createLogParserButtonAction());
        toolbar.add(this.m_logParserButton);
        return toolbar;
    }

    private ActionListener createLogParserButtonAction() {
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemTasksPanel.this.m_logParserDialog.setLocationRelativeTo(SystemTasksPanel.this.m_logParserButton);
                SystemTasksPanel.this.m_logParserDialog.setVisible(true);
            }
        };
        return action;
    }

    private JPanel createToolbarPanel() {
        JPanel toolbarPanel = new JPanel();
        toolbarPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        toolbarPanel.add((Component)internalPanel, "Center");
        JToolBar toolbar = this.initToolbar();
        toolbarPanel.add((Component)toolbar, "West");
        return toolbarPanel;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_messageTable = new SystemMessageTable();
        this.m_messageTable.setModel((TableModel)((Object)new SystemMessageTableModel()));
        TableColumnModel columnModel = this.m_messageTable.getColumnModel();
        columnModel.getColumn(3).setCellRenderer(new DateAndTimeRenderer());
        columnModel.getColumn(0).setCellRenderer(new EventTypeRenderer());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView((Component)((Object)this.m_messageTable));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)scrollPane, c);
        return internalPanel;
    }

    public void clearData() {
        ((SystemMessageTableModel)((Object)this.m_messageTable.getModel())).resetData();
    }

    @Override
    protected boolean checkJMSVariables() {
        if (this.m_qBrowser == null) {
            this.m_qBrowser = JMSConnectionManager.getJMSConnectionManager().getQueueBrowser();
            if (this.m_qBrowser == null) {
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Unable to get JMS Queue Browser !! No server tasks monitoring will be done.", "Server Tasks Logs error", 0);
                return false;
            }
        }
        return super.checkJMSVariables();
    }

    @Override
    protected AbstractJMSCallback getServiceNotificationCallback(final JMSNotificationMessage[] sysInfoResult) {
        AbstractJMSCallback notifierCallback = new AbstractJMSCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success) {
                int selectedRow = SystemTasksPanel.this.m_messageTable.getSelectedRow();
                if (selectedRow >= 0) {
                    selectedRow = SystemTasksPanel.this.m_messageTable.convertRowIndexToModel(selectedRow);
                }
                ((SystemMessageTableModel)((Object)SystemTasksPanel.this.m_messageTable.getModel())).addMessage(sysInfoResult[0]);
                if (selectedRow >= 0) {
                    int modelIndex = SystemTasksPanel.this.m_messageTable.convertRowIndexToView(selectedRow);
                    SystemTasksPanel.this.m_messageTable.setRowSelectionInterval(modelIndex, modelIndex);
                }
            }
        };
        return notifierCallback;
    }

    @Override
    protected AbstractJMSCallback getPurgeConsumerCallback(final JMSNotificationMessage[] purgerResult) {
        AbstractJMSCallback purgerCallback = new AbstractJMSCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success) {
                int selectedRow = SystemTasksPanel.this.m_messageTable.getSelectedRow();
                if (selectedRow >= 0) {
                    selectedRow = SystemTasksPanel.this.m_messageTable.convertRowIndexToModel(selectedRow);
                }
                ((SystemMessageTableModel)((Object)SystemTasksPanel.this.m_messageTable.getModel())).addMessage(purgerResult[0]);
                if (selectedRow >= 0) {
                    int modelIndex = SystemTasksPanel.this.m_messageTable.convertRowIndexToView(selectedRow);
                    SystemTasksPanel.this.m_messageTable.setRowSelectionInterval(modelIndex, modelIndex);
                }
            }
        };
        return purgerCallback;
    }

    @Override
    protected void startOtherDataCollecting() {
        if (this.m_updateTimer == null) {
            ActionListener taskPerformer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SystemTasksPanel.this.browsePendingMessages();
                }
            };
            this.m_updateTimer = new Timer(1000, taskPerformer);
        }
        this.m_updateTimer.start();
    }

    private void browsePendingMessages() {
        try {
            Enumeration messageEnum = this.m_qBrowser.getEnumeration();
            ArrayList<JMSNotificationMessage> pendingMsg = new ArrayList<JMSNotificationMessage>();
            while (messageEnum.hasMoreElements()) {
                Message msg = (Message)messageEnum.nextElement();
                JMSNotificationMessage notifMsg = JMSMessageUtil.buildJMSNotificationMessage((Message)msg, (JMSNotificationMessage.MessageStatus)JMSNotificationMessage.MessageStatus.PENDING);
                if (notifMsg != null) {
                    pendingMsg.add(notifMsg);
                    continue;
                }
                m_logger.debug("Invalid message in Queue ! " + msg);
            }
            int selectedRow = this.m_messageTable.getSelectedRow();
            if (selectedRow >= 0) {
                selectedRow = this.m_messageTable.convertRowIndexToModel(selectedRow);
            }
            ((SystemMessageTableModel)((Object)this.m_messageTable.getModel())).addMessages(pendingMsg);
            if (selectedRow >= 0) {
                int modelIndex = this.m_messageTable.convertRowIndexToView(selectedRow);
                this.m_messageTable.setRowSelectionInterval(modelIndex, modelIndex);
            }
        }
        catch (Exception jmsE) {
            if (++m_connectionErrCount < 2) {
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Unable to browse pending messages (JMS Connection problem ?! : " + jmsE.getMessage() + ")", "Server Tasks Logs error", 0);
            }
            JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Unable to browse pending messages. Stop browsing server tasks ", "Server Tasks Logs error", 0);
            this.stopOtherDataCollecting();
            this.m_reconnectButton.setEnabled(true);
            m_connectionErrCount = 0;
        }
    }

    private void reInitConnection() {
        this.m_qBrowser = null;
        String jmsHost = JMSConnectionManager.getJMSConnectionManager().m_jmsServerHost;
        JMSConnectionManager.getJMSConnectionManager().closeConnection();
        JMSConnectionManager.getJMSConnectionManager().setJMSServerHost(jmsHost);
        if (!this.checkJMSVariables()) {
            this.stopOtherDataCollecting();
            this.m_reconnectButton.setEnabled(true);
        } else {
            this.m_reconnectButton.setEnabled(false);
        }
    }

    @Override
    protected void stopOtherDataCollecting() {
        this.m_qBrowser = null;
        this.m_updateTimer.stop();
    }

    public class EventTypeRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            JMSNotificationMessage msg = (JMSNotificationMessage)value;
            this.setIcon(AbstractTasksPanel.PUBLIC_STATE_ICONS[msg.getPublicState()]);
            this.setText("");
            return this;
        }
    }

    public class DateAndTimeRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            SimpleDateFormat sf = new SimpleDateFormat("h:mm:ss a - d MMM yyyy ");
            this.setText(sf.format((Date)value));
            return this;
        }
    }

    class SystemMessageTableModel
    extends DecoratedTableModel {
        public static final int COLTYPE_MESSAGE_EVENT_TYPE = 0;
        public static final int COLTYPE_MESSAGE_JSON_RPC_ID = 1;
        public static final int COLTYPE_MESSAGE_SERVICE_NAME = 2;
        public static final int COLTYPE_MESSAGE_EVENT_DATE = 3;
        public static final int COLTYPE_MESSAGE_SERVICE_SOURCE = 4;
        public static final int COLTYPE_MESSAGE_REQ_ID = 5;
        public static final int COLTYPE_MESSAGE_COMPLEMENTARY_DATA = 6;
        private final String[] m_columnNames = new String[]{"", "Id", "Service", "Date", "Source", "Message ID", "Supplementary Data"};
        private final String[] m_columnTooltips = new String[]{"Current Service State (START, FAIL, SUCCESS, PENDING)", "Identifier of JSON RPC message", "Proline Service Description", "Date of the event on the service", "The source (user/computer) of the service call", "Message Server Unique ID", "All complementary data we can get: service name/version ..."};
        private ArrayList<JMSNotificationMessage> m_notificationMsgs = new ArrayList();
        private HashMap<String, Integer> indexByMsgId = new HashMap();

        SystemMessageTableModel() {
        }

        public void resetData() {
            this.m_notificationMsgs.clear();
            this.indexByMsgId.clear();
            this.fireTableDataChanged();
        }

        public JMSNotificationMessage getMessage(int row) {
            if (this.m_notificationMsgs.size() <= row) {
                return null;
            }
            return this.m_notificationMsgs.get(row);
        }

        public void addMessage(JMSNotificationMessage msg) {
            this.addSingleMessage(msg);
            this.sortMessageById();
            this.fireTableDataChanged();
        }

        private synchronized void addSingleMessage(JMSNotificationMessage msg) {
            String msgId = msg.getServerUniqueMsgId();
            if (this.indexByMsgId.containsKey(msgId)) {
                int index = this.indexByMsgId.get(msgId);
                JMSNotificationMessage prevMsg = this.m_notificationMsgs.get(index);
                if (!msg.getJsonRPCMsgId().equals(prevMsg.getJsonRPCMsgId()) && msgId.equals(msg.getJsonRPCMsgId())) {
                    msg = new JMSNotificationMessage(msg.getServiceName(), msg.getServiceVersion(), msg.getServiceSource(), msg.getServiceDescription(), msg.getServiceInfo(), Long.valueOf(msg.getEventDate().getTime()), msgId, prevMsg.getJsonRPCMsgId(), msg.getEventType());
                }
                this.m_notificationMsgs.set(index, msg);
            } else {
                this.m_notificationMsgs.add(msg);
                this.indexByMsgId.put(msgId, this.m_notificationMsgs.size() - 1);
            }
        }

        public void addMessages(List<JMSNotificationMessage> msgs) {
            for (JMSNotificationMessage msg : msgs) {
                this.addSingleMessage(msg);
            }
            this.sortMessageById();
            this.fireTableDataChanged();
        }

        private synchronized void sortMessageById() {
            Collections.sort(this.m_notificationMsgs, new SortById());
            this.indexByMsgId.clear();
            for (int i = 0; i < this.m_notificationMsgs.size(); ++i) {
                this.indexByMsgId.put(this.m_notificationMsgs.get(i).getServerUniqueMsgId(), i);
            }
        }

        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        public String getColumnName(int col) {
            return this.m_columnNames[col];
        }

        public int getRowCount() {
            if (this.m_notificationMsgs == null) {
                return 0;
            }
            return this.m_notificationMsgs.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            JMSNotificationMessage msg = this.m_notificationMsgs.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return msg;
                }
                case 1: {
                    try {
                        return Integer.valueOf(msg.getJsonRPCMsgId());
                    }
                    catch (NumberFormatException nfe) {
                        return -1;
                    }
                }
                case 2: {
                    if (StringUtils.isNotEmpty((String)msg.getServiceDescription())) {
                        return msg.getServiceDescription();
                    }
                    StringBuilder sb = new StringBuilder(msg.getServiceName());
                    if (StringUtils.isNotEmpty((String)msg.getServiceVersion())) {
                        sb.append(" [").append(msg.getServiceVersion()).append("]");
                    }
                    return sb.toString();
                }
                case 3: {
                    return msg.getEventDate();
                }
                case 4: {
                    return msg.getServiceSource();
                }
                case 5: {
                    return msg.getServerUniqueMsgId();
                }
                case 6: {
                    StringBuilder sb = new StringBuilder();
                    if (StringUtils.isNotEmpty((String)msg.getServiceDescription())) {
                        sb.append(msg.getServiceName());
                        if (StringUtils.isNotEmpty((String)msg.getServiceVersion())) {
                            sb.append(" [").append(msg.getServiceVersion()).append("]");
                        }
                    }
                    if (StringUtils.isNotEmpty((String)msg.getServiceInfo())) {
                        sb.append(" ").append(msg.getServiceInfo());
                    } else if (sb.length() < 0) {
                        sb.append("-");
                    }
                    return sb.toString();
                }
            }
            return null;
        }

        public String getToolTipForHeader(int col) {
            return this.m_columnTooltips[col];
        }

        public String getTootlTipValue(int row, int col) {
            return null;
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 1: {
                    return Integer.class;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    return String.class;
                }
                case 3: {
                    return Date.class;
                }
                case 0: {
                    return JMSNotificationMessage.class;
                }
            }
            return null;
        }

        public TableCellRenderer getRenderer(int row, int col) {
            return new DefaultLeftAlignRenderer(TableDefaultRendererManager.getDefaultRenderer((Class)this.getColumnClass(col)));
        }

        class SortById
        implements Comparator<JMSNotificationMessage> {
            SortById() {
            }

            @Override
            public int compare(JMSNotificationMessage a, JMSNotificationMessage b) {
                try {
                    Integer bIntId = Integer.valueOf(b.getJsonRPCMsgId());
                    Integer aIntId = Integer.valueOf(a.getJsonRPCMsgId());
                    return bIntId - aIntId;
                }
                catch (NumberFormatException nfe) {
                    return a.getJsonRPCMsgId().compareTo(b.getJsonRPCMsgId());
                }
            }
        }
    }

    class SystemMessageTable
    extends DecoratedTable {
        public SystemMessageTable() {
            this.setSelectionMode(0);
            this.setAutoResizeMode(3);
        }

        public TablePopupMenu initPopupMenu() {
            return null;
        }

        public void prepostPopupMenu() {
        }
    }
}

