/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.lcms.MapAlignment;
import fr.proline.core.orm.lcms.ProcessedMap;
import fr.proline.studio.dam.tasks.xic.MapAlignmentConverter;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.PlotPanel;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.xic.DataboxMapAlignment;
import fr.proline.studio.rsmexplorer.gui.xic.LoessParametersDialog;
import fr.proline.studio.rsmexplorer.gui.xic.MapTimePanel;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.rsmexplorer.gui.xic.alignment.IonsRTScatterPlot;
import fr.proline.studio.rsmexplorer.gui.xic.alignment.IonsRTTableModel;
import fr.proline.studio.table.BeanTableModel;
import fr.proline.studio.utils.CyclicColorPalette;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.analysis.interpolation.LoessInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapAlignmentPanel
extends HourglassPanel
implements DataBoxPanelInterface {
    private static final Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static final String CLOUD_VIEW_BEST_FIT_TEXT = "Zoom to fit RT tolerance range";
    private static final String CLOUD_VIEW_All_TEXT = "Zoom to fit all ions";
    private static final String CLOUD_VIEW_NOT_ENABLED_TEXT = "Zoom disabled";
    private static final int CLOUD_VIEW_ALL = 1;
    private static final int CLOUD_VIEW_BEST_FIT = 0;
    private static final String CLOUD_LOAD_TEXT = "Load matched peptide ions";
    private static final String CLOUD_REMOVE_TEXT = "Remove peptide ions plot";
    private static final String CLOUD_IS_LOADING = "Loading ions ...";
    private static final NumberFormat format2 = new DecimalFormat("#0.0000");
    private AbstractDataBox m_dataBox;
    private QuantChannelInfo m_quantChannelInfo;
    private List<MapAlignment> m_allMapAlignments;
    private Map<Integer, ProcessedMap> m_mapName;
    private long m_referenceMapId = 0L;
    private JLabel m_labelTitle;
    private JTextField m_SourceTimeTF;
    private JTextField m_DestTimeTF;
    private JComboBox m_sourceMapsCB;
    private JComboBox m_destMapsCB;
    private JToggleButton m_loadIonsBtn;
    private boolean m_isIonsCloudLoaded;
    private JToggleButton m_zoomModeBtn;
    private int m_zoomMode;
    private JButton m_addLoessCurveBtn;
    private JButton m_removeLoessCurveBtn;
    private JButton m_showHideCrossAssigned;
    private JSplitPane m_splitPane;
    private BasePlotPanel m_alignmentGraphicPanel;
    private BasePlotPanel m_alignmentGraphicPanel_2;
    private PlotPanel m_plotPanel2;
    private boolean m_isInitialized = false;
    private IonsRTScatterPlot m_ionsScatterPlot;

    public MapAlignmentPanel(DataboxMapAlignment dataBox) {
        this.m_dataBox = dataBox;
        this.m_isIonsCloudLoaded = false;
        this.initComponents();
    }

    private void initComponents() {
        JPanel pane = new JPanel();
        JPanel mapAlignmentPanel = this.initMapAlignmentPanel();
        PlotPanel plotPanel1 = new PlotPanel(false);
        this.m_alignmentGraphicPanel = plotPanel1.getBasePlotPanel();
        this.m_plotPanel2 = new PlotPanel(false);
        this.m_alignmentGraphicPanel_2 = this.m_plotPanel2.getBasePlotPanel();
        this.m_plotPanel2.setVisible(false);
        pane.setLayout(new BorderLayout());
        TitledBorder titleB = new TitledBorder(null, " LC-MS Map Alignments", 2, 2);
        pane.setBorder(titleB);
        pane.add((Component)mapAlignmentPanel, "First");
        this.m_splitPane = new JSplitPane(1, (Component)plotPanel1, (Component)this.m_plotPanel2);
        this.m_splitPane.setResizeWeight(0.5);
        this.m_splitPane.setBorder(BorderFactory.createRaisedBevelBorder());
        pane.add((Component)this.m_splitPane, "Center");
        this.setLayout(new BorderLayout());
        this.add(pane, "Center");
    }

    private JPanel initMapAlignmentPanel() {
        ExportButton exportImageButton = new ExportButton("Graphic", (JPanel)((Object)this));
        exportImageButton.setMargin(new Insets(2, 2, 2, 2));
        this.createLoadIonsButton();
        this.createZoomButton();
        this.m_labelTitle = new JLabel("<html>Reference Map: <font color='RED'>&#x25A0;&nbsp;</font>   map   &nbsp;, Alignment Mode : I/H) </html>");
        this.m_SourceTimeTF = new JTextField(10);
        this.m_SourceTimeTF.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                MapAlignmentPanel.this.convertTime();
            }
        });
        this.m_SourceTimeTF.addActionListener(e -> this.convertTime());
        this.m_SourceTimeTF.setName("tfSourceTime");
        this.m_SourceTimeTF.setToolTipText("Enter retention time (in minutes)");
        this.m_sourceMapsCB = new JComboBox();
        this.m_sourceMapsCB.addActionListener(e -> {
            this.convertTime();
            this.setDataGraphic();
        });
        this.m_destMapsCB = new JComboBox();
        this.m_destMapsCB.addActionListener(e -> {
            this.convertTime();
            this.setDataGraphic();
        });
        this.m_destMapsCB.setName("cbDestMaps");
        JPanel cloudOptionPane = new JPanel();
        JSeparator separator = new JSeparator(1);
        cloudOptionPane.setLayout(new BoxLayout(cloudOptionPane, 2));
        this.m_showHideCrossAssigned = new JButton();
        this.m_showHideCrossAssigned.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.HIDE_CROSS_ASSIGNED));
        this.m_showHideCrossAssigned.setActionCommand("HIDE");
        this.m_showHideCrossAssigned.setMargin(new Insets(2, 2, 2, 2));
        this.m_showHideCrossAssigned.setToolTipText("Show/Hide cross assigned ions");
        this.m_showHideCrossAssigned.addActionListener(e -> {
            if (this.m_ionsScatterPlot != null) {
                if (e.getActionCommand().equals("HIDE")) {
                    this.m_ionsScatterPlot.showCrossAssignedIons(false);
                    this.m_showHideCrossAssigned.setActionCommand("SHOW");
                    this.m_showHideCrossAssigned.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SHOW_CROSS_ASSIGNED));
                } else {
                    this.m_ionsScatterPlot.showCrossAssignedIons(true);
                    this.m_showHideCrossAssigned.setActionCommand("HIDE");
                    this.m_showHideCrossAssigned.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.HIDE_CROSS_ASSIGNED));
                }
                this.m_alignmentGraphicPanel.repaintUpdateDoubleBuffer();
            }
        });
        this.m_addLoessCurveBtn = new JButton();
        this.m_addLoessCurveBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ADD_LOESS_CURVE));
        this.m_addLoessCurveBtn.setMargin(new Insets(2, 2, 2, 2));
        this.m_addLoessCurveBtn.setToolTipText("Fit a Loess smooth curve to ions scatter plot");
        this.m_addLoessCurveBtn.addActionListener(e -> this.computeLoess());
        this.m_removeLoessCurveBtn = new JButton();
        this.m_removeLoessCurveBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.REMOVE_LOESS_CURVE));
        this.m_removeLoessCurveBtn.setMargin(new Insets(2, 2, 2, 2));
        this.m_removeLoessCurveBtn.setToolTipText("Clear Loess fit curve ");
        this.m_removeLoessCurveBtn.addActionListener(e -> {
            ((DataboxMapAlignment)this.m_dataBox).loadCloud();
            this.m_removeLoessCurveBtn.setEnabled(false);
        });
        cloudOptionPane.add((Component)exportImageButton);
        cloudOptionPane.add(this.m_loadIonsBtn);
        cloudOptionPane.add(this.m_zoomModeBtn);
        cloudOptionPane.add(this.m_showHideCrossAssigned);
        cloudOptionPane.add(this.m_addLoessCurveBtn);
        cloudOptionPane.add(this.m_removeLoessCurveBtn);
        cloudOptionPane.add(Box.createRigidArea(new Dimension(10, 0)));
        this.setEnabledCloudButtons(false);
        cloudOptionPane.add(separator);
        JPanel timePanel = new JPanel();
        timePanel.setLayout(new FlowLayout(0));
        timePanel.add(this.m_SourceTimeTF);
        JLabel label0 = new JLabel("(min) in ");
        timePanel.add(label0);
        this.m_sourceMapsCB.setName("cbSourceMaps");
        timePanel.add(this.m_sourceMapsCB);
        JLabel label = new JLabel("predicted to");
        timePanel.add(label);
        this.m_DestTimeTF = new JTextField(10);
        this.m_DestTimeTF.setName("tfDestTime");
        this.m_DestTimeTF.setEditable(false);
        timePanel.add(this.m_DestTimeTF);
        JLabel label2 = new JLabel("(min) in");
        timePanel.add(label2);
        timePanel.add(this.m_destMapsCB);
        JPanel beginPane = new JPanel(new FlowLayout());
        beginPane.add(cloudOptionPane);
        beginPane.add(timePanel);
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        pane.add((Component)beginPane, "Before");
        pane.add((Component)this.m_labelTitle, "After");
        pane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        return pane;
    }

    private void setEnabledCloudButtons(boolean enable) {
        this.m_addLoessCurveBtn.setEnabled(enable);
        this.m_removeLoessCurveBtn.setEnabled(false);
        this.m_showHideCrossAssigned.setEnabled(enable);
        this.m_zoomModeBtn.setEnabled(enable);
    }

    private void computeLoess() {
        if (this.m_isIonsCloudLoaded) {
            long mapIdSrc = this.getSelectedMapId(this.m_sourceMapsCB);
            long mapIdDst = this.getSelectedMapId(this.m_destMapsCB);
            MapAlignment map = MapAlignmentConverter.getMapAlgn((Long)mapIdSrc, (Long)mapIdDst, this.m_allMapAlignments);
            IonsRTTableModel cloudData = this.getCloudData(mapIdSrc);
            if (cloudData != null) {
                double bandwidth = 0.1;
                LoessParametersDialog dialog = new LoessParametersDialog();
                dialog.getValueTF().setText(Double.toString(bandwidth));
                Point panelLocation = this.getLocationOnScreen();
                dialog.setLocation(panelLocation.x + this.getWidth() / 2, panelLocation.y + this.getHeight() / 2);
                dialog.setVisible(true);
                if (dialog.getButtonClicked() == 0) {
                    bandwidth = Double.parseDouble(dialog.getValueTF().getText());
                    int axisX = cloudData.getColumnIndex(mapIdSrc);
                    int axisY = cloudData.getColumnIndex(mapIdDst);
                    int size = cloudData.getRowCount();
                    List<Object> data = new ArrayList(size);
                    for (int i = 0; i < size; ++i) {
                        if (cloudData.isCrossAssigned(i, axisY)) continue;
                        Object value = cloudData.getDataValueAt(i, axisX);
                        Double v1 = value == null || !Number.class.isAssignableFrom(value.getClass()) ? Double.NaN : ((Number)value).doubleValue();
                        value = cloudData.getDataValueAt(i, axisY);
                        Double v2 = value == null || !Number.class.isAssignableFrom(value.getClass()) ? Double.NaN : ((Number)value).doubleValue();
                        if (!(Math.abs(v2) < 600.0)) continue;
                        data.add(Pair.of((Object)v1, (Object)v2));
                    }
                    Map<Double, Double> landmarks = data.stream().distinct().collect(Collectors.groupingBy(p -> (Double)p.getKey(), Collectors.averagingDouble(p -> (Double)p.getValue())));
                    data = landmarks.entrySet().stream().map(e -> Pair.of(e.getKey(), e.getValue())).sorted().collect(Collectors.toList());
                    double[] x = new double[data.size()];
                    double[] y = new double[data.size()];
                    for (int i = 0; i < data.size(); ++i) {
                        x[i] = (Double)((Pair)data.get(i)).getKey();
                        y[i] = (Double)((Pair)data.get(i)).getValue();
                    }
                    try {
                        LoessInterpolator interpolator = new LoessInterpolator(bandwidth, 2, 1.0E-12);
                        double[] yfit = interpolator.smooth(x, y);
                        this.createRegressionPlot(x, yfit);
                        PrintWriter writer = new PrintWriter("squared_residuals.csv");
                        double[] residuals = new double[yfit.length];
                        for (int k = 0; k < yfit.length; ++k) {
                            residuals[k] = (y[k] - yfit[k]) * (y[k] - yfit[k]);
                            writer.println(residuals[k] + "," + x[k]);
                        }
                        writer.close();
                        interpolator = new LoessInterpolator(Math.max(0.15, bandwidth), 2, 1.0E-12);
                        double[] sd = interpolator.smooth(x, residuals);
                        double[] upper = new double[yfit.length];
                        double[] lower = new double[yfit.length];
                        for (int k = 0; k < yfit.length; ++k) {
                            double s = Math.sqrt(Math.max(0.0, sd[k]));
                            upper[k] = yfit[k] + 2.0 * s;
                            lower[k] = yfit[k] - 2.0 * s;
                        }
                        this.createRegressionPlot(x, upper);
                        this.createRegressionPlot(x, lower);
                        this.m_removeLoessCurveBtn.setEnabled(true);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
    }

    private void createRegressionPlot(double[] x, double[] newDeltas) {
        ArrayList<Pair> data = new ArrayList<Pair>(x.length);
        for (int i = 0; i < x.length; ++i) {
            data.add(Pair.of((Object)x[i], (Object)newDeltas[i]));
        }
        BeanTableModel model = new BeanTableModel(Pair.class);
        model.setData(data);
        String xAxisTitle = this.m_alignmentGraphicPanel.getXAxis().getTitle();
        String yAxisTitle = this.m_alignmentGraphicPanel.getYAxis().getTitle();
        PlotLinear regressionCurve = new PlotLinear(this.m_alignmentGraphicPanel, (ExtendedTableModelInterface)model, null, 0, 3);
        PlotInformation plotInfo = new PlotInformation();
        plotInfo.setPlotColor(CyclicColorPalette.GRAY_DARK);
        regressionCurve.setPlotInformation(plotInfo);
        regressionCurve.setStroke(1.0f);
        this.m_alignmentGraphicPanel.addPlot((PlotXYAbstract)regressionCurve, true);
        this.m_alignmentGraphicPanel.getXAxis().setTitle(xAxisTitle);
        this.m_alignmentGraphicPanel.getYAxis().setTitle(yAxisTitle);
        this.m_alignmentGraphicPanel.repaint();
    }

    private void createLoadIonsButton() {
        this.m_loadIonsBtn = new JToggleButton();
        this.m_loadIonsBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.LOAD_ALIGNMENT_CLOUD));
        this.m_loadIonsBtn.setMargin(new Insets(2, 2, 2, 2));
        this.m_loadIonsBtn.setToolTipText(CLOUD_LOAD_TEXT);
        this.m_loadIonsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!MapAlignmentPanel.this.m_isIonsCloudLoaded) {
                    MapAlignmentPanel.this.m_isIonsCloudLoaded = true;
                    MapAlignmentPanel.this.m_loadIonsBtn.setIcon(IconManager.getIconWithHourGlass((IconManager.IconType)IconManager.IconType.LOAD_ALIGNMENT_CLOUD));
                    MapAlignmentPanel.this.m_loadIonsBtn.setToolTipText(MapAlignmentPanel.CLOUD_IS_LOADING);
                    ((DataboxMapAlignment)MapAlignmentPanel.this.m_dataBox).loadCloud();
                } else if (MapAlignmentPanel.this.m_dataBox.isLoaded()) {
                    MapAlignmentPanel.this.m_isIonsCloudLoaded = false;
                    MapAlignmentPanel.this.m_loadIonsBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.LOAD_ALIGNMENT_CLOUD));
                    MapAlignmentPanel.this.m_loadIonsBtn.setToolTipText(MapAlignmentPanel.CLOUD_LOAD_TEXT);
                    MapAlignmentPanel.this.setEnabledCloudButtons(false);
                    MapAlignmentPanel.this.setDataGraphic();
                }
            }
        });
    }

    private void createZoomButton() {
        this.m_zoomModeBtn = new JToggleButton();
        this.m_zoomModeBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ZOOM_ALL));
        this.m_zoomModeBtn.setMargin(new Insets(2, 2, 2, 2));
        this.m_zoomModeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MapAlignmentPanel.this.m_zoomMode == 0) {
                    MapAlignmentPanel.this.m_zoomMode = 1;
                    MapAlignmentPanel.this.m_zoomModeBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ZOOM_FIT));
                    MapAlignmentPanel.this.m_zoomModeBtn.setToolTipText(MapAlignmentPanel.CLOUD_VIEW_BEST_FIT_TEXT);
                    MapAlignmentPanel.this.setDataGraphic();
                } else {
                    MapAlignmentPanel.this.m_zoomMode = 0;
                    MapAlignmentPanel.this.m_zoomModeBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ZOOM_ALL));
                    MapAlignmentPanel.this.m_zoomModeBtn.setToolTipText(MapAlignmentPanel.CLOUD_VIEW_All_TEXT);
                    MapAlignmentPanel.this.setDataGraphic();
                }
            }
        });
        this.m_zoomModeBtn.setToolTipText(CLOUD_VIEW_NOT_ENABLED_TEXT);
    }

    public void setAlignmentCloud() {
        this.m_loadIonsBtn.setToolTipText(CLOUD_REMOVE_TEXT);
        this.m_loadIonsBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.REMOVE_ALIGNMENT_CLOUD));
        this.m_zoomModeBtn.setToolTipText(CLOUD_VIEW_All_TEXT);
        this.setEnabledCloudButtons(true);
        this.setDataGraphic();
    }

    public void setData(QuantChannelInfo quantChannelInfo, List<ExtendedTableModelInterface> compareDataInterfaceList, List<CrossSelectionInterface> crossSelectionInterfaceList) {
        if (!this.m_isInitialized) {
            this.m_quantChannelInfo = quantChannelInfo;
            this.m_allMapAlignments = new ArrayList<MapAlignment>();
            this.m_allMapAlignments.addAll(this.m_quantChannelInfo.getDataset().getMapAlignments());
            this.m_allMapAlignments.addAll(this.m_quantChannelInfo.getDataset().getMapReversedAlignments());
            this.m_referenceMapId = this.m_quantChannelInfo.getDataset().getAlnReferenceMapId();
            String referenceMapTitle = this.m_quantChannelInfo.getMapTitle(this.m_referenceMapId);
            String referenceMapColor = this.m_quantChannelInfo.getMapHtmlColor(this.m_quantChannelInfo.getDataset().getAlnReferenceMapId());
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("Reference Map: ");
            sb.append("<font color='").append(referenceMapColor).append("'>&#x25A0;&nbsp;</font>");
            sb.append(referenceMapTitle);
            sb.append(", Alignment Mode : ");
            sb.append(this.getAlignmentMethod());
            sb.append("</html>");
            this.m_labelTitle.setText(sb.toString());
            this.m_mapName = new HashMap<Integer, ProcessedMap>();
            String[] mapItems = new String[this.m_quantChannelInfo.getDataset().getMaps().size()];
            int i = 0;
            for (ProcessedMap map : this.m_quantChannelInfo.getDataset().getMaps()) {
                String mapTitle = this.m_quantChannelInfo.getMapTitle(map.getId());
                sb = new StringBuilder();
                String mapColor = this.m_quantChannelInfo.getMapHtmlColor(map.getId());
                sb.append("<html><font color='").append(mapColor).append("'>&#x25A0;&nbsp;</font>");
                sb.append(mapTitle);
                sb.append("</html>");
                mapItems[i] = sb.toString();
                this.m_mapName.put(i, map);
                ++i;
            }
            DefaultComboBoxModel<String> sourceMapsModel = new DefaultComboBoxModel<String>(mapItems);
            DefaultComboBoxModel<String> destMapsModel = new DefaultComboBoxModel<String>(mapItems);
            this.m_sourceMapsCB.setModel(sourceMapsModel);
            this.m_destMapsCB.setModel(destMapsModel);
            if (mapItems.length > 0) {
                sourceMapsModel.setSelectedItem(mapItems[0]);
            }
            if (mapItems.length > 1) {
                destMapsModel.setSelectedItem(mapItems[1]);
            }
            this.setDataGraphic();
            this.m_isInitialized = true;
            this.repaint();
        }
    }

    private String getAlignmentMethod() {
        String method = "unknown";
        try {
            Map quantParams = this.m_quantChannelInfo.getDataset().getQuantProcessingConfigAsMap();
            if (quantParams.containsKey("alignment_config")) {
                Map alignmentConfig = (Map)quantParams.get("alignment_config");
                method = alignmentConfig.getOrDefault("method_name", "unknown");
            }
            return method;
        }
        catch (Exception e) {
            return "unknown alignment method exception ";
        }
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    private void convertTime() {
        try {
            Double time = Double.parseDouble(this.m_SourceTimeTF.getText());
            Double calcTime = this.calcTimeInMapAlign(time, this.getSelectedMapId(this.m_sourceMapsCB), this.getSelectedMapId(this.m_destMapsCB));
            if (calcTime.isNaN()) {
                this.m_DestTimeTF.setText("");
            } else {
                this.m_DestTimeTF.setText(format2.format(calcTime / 60.0));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void setDataGraphic() {
        long mapIdDst;
        long mapIdSrc = this.getSelectedMapId(this.m_sourceMapsCB);
        if (mapIdSrc == (mapIdDst = this.getSelectedMapId(this.m_destMapsCB).longValue())) {
            this.m_alignmentGraphicPanel.clearPlotsWithRepaint();
            if (this.m_plotPanel2.isVisible()) {
                this.m_plotPanel2.setVisible(false);
                this.m_alignmentGraphicPanel_2.clearPlotsWithRepaint();
            }
            this.repaint();
        } else {
            MapAlignment map = MapAlignmentConverter.getMapAlgn((Long)mapIdSrc, (Long)mapIdDst, this.m_allMapAlignments);
            if (map != null) {
                this.m_plotPanel2.setVisible(false);
                this.setDataGraphicTableModel(map, this.m_alignmentGraphicPanel);
            } else {
                map = MapAlignmentConverter.getMapAlgn((Long)mapIdSrc, (Long)this.m_referenceMapId, this.m_allMapAlignments);
                if (map != null) {
                    this.setDataGraphicTableModel(map, this.m_alignmentGraphicPanel);
                    map = MapAlignmentConverter.getMapAlgn((Long)this.m_referenceMapId, (Long)mapIdDst, this.m_allMapAlignments);
                    this.setDataGraphicTableModel(map, this.m_alignmentGraphicPanel_2);
                    this.m_plotPanel2.setVisible(true);
                    this.m_splitPane.resetToPreferredSizes();
                }
            }
        }
    }

    private void setDataGraphicTableModel(MapAlignment map, BasePlotPanel graphicPanel) {
        IonsRTTableModel cloudData;
        Long mapIdSrc = map.getSourceMap().getId();
        Long mapIdDst = map.getDestinationMap().getId();
        List listMapTime = map.getMapTimeList();
        MapTimePanel mapTimePanel = new MapTimePanel();
        String mapTitleFrom = this.m_quantChannelInfo.getMapTitle(mapIdSrc);
        String mapTitleTo = this.m_quantChannelInfo.getMapTitle(mapIdDst);
        String title = "Map Alignment from " + mapTitleFrom + " (to. " + mapTitleTo + ")";
        Color color = this.m_quantChannelInfo.getMapColor(mapIdDst);
        mapTimePanel.setData(-1L, map, listMapTime, color, title, true, mapTitleFrom, mapTitleTo);
        CrossSelectionInterface crossSelectionTableModel = mapTimePanel.getCrossSelectionInterface();
        GlobalTableModelInterface extendedTableModel = mapTimePanel.getGlobalTableModelInterface();
        double tolerance = ((DataboxMapAlignment)this.m_dataBox).getRT_Tolerance();
        PlotLinear alignmentCurve = new PlotLinear(graphicPanel, (ExtendedTableModelInterface)extendedTableModel, crossSelectionTableModel, 0, 1);
        alignmentCurve.setPlotInformation(extendedTableModel.getPlotInformation());
        alignmentCurve.setStroke(3.0f);
        alignmentCurve.setTolerance(tolerance);
        graphicPanel.setPlot((PlotBaseAbstract)alignmentCurve);
        if (this.m_isIonsCloudLoaded && (cloudData = this.getCloudData(mapIdSrc)) != null) {
            int axisX = cloudData.getColumnIndex(mapIdSrc);
            int axisY = cloudData.getColumnIndex(mapIdDst);
            this.m_removeLoessCurveBtn.setEnabled(false);
            this.m_ionsScatterPlot = new IonsRTScatterPlot(graphicPanel, cloudData, null, axisX, axisY);
            this.m_ionsScatterPlot.showCrossAssignedIons(this.m_showHideCrossAssigned.getActionCommand().equals("HIDE"));
            this.m_ionsScatterPlot.setColor(color);
            if (this.m_zoomMode == 0) {
                double yMax = alignmentCurve.getYMax();
                double yMin = alignmentCurve.getYMin();
                this.m_ionsScatterPlot.setYMax(yMax + 2.0 * tolerance);
                this.m_ionsScatterPlot.setYMin(yMin - 2.0 * tolerance);
            }
            graphicPanel.setPlot((PlotBaseAbstract)this.m_ionsScatterPlot);
            graphicPanel.addPlot((PlotXYAbstract)alignmentCurve, true);
        }
        graphicPanel.repaint();
    }

    private IonsRTTableModel getCloudData(long mapIdSrc) {
        if (this.m_dataBox.isLoaded()) {
            return ((DataboxMapAlignment)this.m_dataBox).getPeptideCloud(mapIdSrc);
        }
        return null;
    }

    private Long getSelectedMapId(JComboBox cb) {
        if (cb == null) {
            return -1L;
        }
        int selId = cb.getSelectedIndex();
        if (this.m_mapName.containsKey(selId)) {
            return this.m_mapName.get(selId).getId();
        }
        return -1L;
    }

    private Double calcTimeInMapAlign(Double time, Long sourceMapId, Long targetMapId) {
        logger.debug("calculate time for " + time + " from source mapId=" + sourceMapId + " to target MapId=" + targetMapId);
        Double calcTime = Double.NaN;
        try {
            calcTime = MapAlignmentConverter.convertElutionTime((Double)(time * 60.0), (Long)sourceMapId, (Long)targetMapId, this.m_allMapAlignments, (Long)this.m_quantChannelInfo.getDataset().getAlnReferenceMapId());
            logger.debug("...result= " + calcTime);
        }
        catch (Exception e) {
            logger.error("Error while retrieving time in map alignment: " + e);
        }
        return calcTime;
    }
}

