/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class MapTableModel
extends LazyTableModel
implements GlobalTableModelInterface {
    public static final int COLTYPE_MAP_ID = 0;
    public static final int COLTYPE_MAP_NAME = 1;
    public static final int COLTYPE_MAP_DESCRIPTION = 2;
    public static final int COLTYPE_MAP_CREATION_DATE = 3;
    private static final String[] m_columnNames = new String[]{"Id", "Name", "Description", "Creation Date"};
    private static final String[] m_toolTipColumns = new String[]{"Map Id", "Name", "Description", "Creation Date"};
    private List<fr.proline.core.orm.lcms.Map> m_maps = null;

    public MapTableModel(LazyTable table) {
        super(table);
    }

    public int getColumnCount() {
        return m_columnNames.length;
    }

    public String getColumnName(int col) {
        return m_columnNames[col];
    }

    public String getExportColumnName(int col) {
        return m_columnNames[col];
    }

    public String getToolTipForHeader(int col) {
        return m_toolTipColumns[col];
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return Long.class;
        }
        return LazyData.class;
    }

    @Override
    public int getSubTaskId(int col) {
        return -1;
    }

    public int getRowCount() {
        if (this.m_maps == null) {
            return 0;
        }
        return this.m_maps.size();
    }

    public Object getValueAt(int row, int col) {
        fr.proline.core.orm.lcms.Map amap = this.m_maps.get(row);
        switch (col) {
            case 0: {
                return amap.getId();
            }
            case 1: {
                LazyData lazyData = this.getLazyData(row, col);
                lazyData.setData((Comparable)((Object)amap.getName()));
                return lazyData;
            }
            case 2: {
                LazyData lazyData = this.getLazyData(row, col);
                lazyData.setData((Comparable)((Object)amap.getDescription()));
                return lazyData;
            }
            case 3: {
                LazyData lazyData = this.getLazyData(row, col);
                lazyData.setData((Comparable)amap.getCreationTimestamp());
                return lazyData;
            }
        }
        return null;
    }

    public void setData(Long taskId, List<fr.proline.core.orm.lcms.Map> maps) {
        this.m_maps = maps;
        this.m_taskId = taskId;
        this.fireTableDataChanged();
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    public fr.proline.core.orm.lcms.Map getMap(int i) {
        return this.m_maps.get(i);
    }

    public int findRow(long mapId) {
        int nb = this.m_maps.size();
        for (int i = 0; i < nb; ++i) {
            if (mapId != this.m_maps.get(i).getId()) continue;
            return i;
        }
        return -1;
    }

    public void sortAccordingToModel(ArrayList<Long> mapIds, CompoundTableModel compoundTableModel) {
        if (this.m_maps == null) {
            return;
        }
        HashSet<Long> mapIdMap = new HashSet<Long>(mapIds.size());
        mapIdMap.addAll(mapIds);
        int nb = this.m_table.getRowCount();
        int iCur = 0;
        for (int iView = 0; iView < nb; ++iView) {
            fr.proline.core.orm.lcms.Map m;
            int iModel = this.m_table.convertRowIndexToModel(iView);
            if (compoundTableModel != null) {
                iModel = compoundTableModel.convertCompoundRowToBaseModelRow(iModel);
            }
            if (!mapIdMap.contains((m = this.getMap(iModel)).getId())) continue;
            mapIds.set(iCur++, m.getId());
        }
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        filtersMap.put(1, (Filter)new StringDiffFilter(this.getColumnName(1), null, 1));
        filtersMap.put(2, (Filter)new StringDiffFilter(this.getColumnName(2), null, 2));
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return null;
    }

    public Class getDataColumnClass(int columnIndex) {
        return null;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return null;
    }

    public int[] getKeysColumn() {
        return null;
    }

    public int getInfoColumn() {
        return -1;
    }

    public void setName(String name) {
    }

    public String getName() {
        return null;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public PlotType getBestPlotType() {
        return null;
    }

    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public boolean isLoaded() {
        return this.m_table.isLoaded();
    }

    public String getExportRowCell(int row, int col) {
        return null;
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        return null;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(fr.proline.core.orm.lcms.Map.class, true));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(fr.proline.core.orm.lcms.Map.class)) {
            return this.m_maps.get(row);
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }
}

