/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.msi.PeptideReadablePtmString;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DCluster;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DQuantPeptide;
import fr.proline.core.orm.msi.dto.MasterQuantProteinSetProperties;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseModifyPeptideTask;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.rsmexplorer.DataBoxViewerManager;
import fr.proline.studio.rsmexplorer.gui.renderer.CompareValueRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.FloatRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.PeptideRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.RendererMouseCallback;
import fr.proline.studio.rsmexplorer.gui.renderer.ScoreRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.TimeRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.XicStatusRenderer;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.rsmexplorer.gui.xic.XicPeptidePanel;
import fr.proline.studio.table.ExportFontModelUtilities;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.BigFloatOrDoubleRenderer;
import fr.proline.studio.table.renderer.DefaultLeftAlignRenderer;
import fr.proline.studio.table.renderer.DefaultRightAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import fr.proline.studio.table.renderer.GrayedRenderer;
import fr.proline.studio.types.QuantitationType;
import fr.proline.studio.types.XicGroup;
import fr.proline.studio.types.XicMode;
import fr.proline.studio.utils.CyclicColorPalette;
import fr.proline.studio.utils.StringUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantPeptideTableModel
extends LazyTableModel
implements GlobalTableModelInterface {
    public static final int COLTYPE_PEPTIDE_ID = 0;
    public static final int COLTYPE_MQPEPTIDE_SELECTION_LEVEL = 1;
    public static final int COLTYPE_PEPTIDE_NAME = 2;
    public static final int COLTYPE_PEPTIDE_PTM = 3;
    public static final int COLTYPE_PEPTIDE_SCORE = 4;
    public static final int COLTYPE_PEPTIDE_CHARGE = 5;
    public static final int COLTYPE_PEPTIDE_MOZ = 6;
    public static final int COLTYPE_PEPTIDE_RETENTION_TIME = 7;
    public static final int COLTYPE_PEPTIDE_PROTEIN_SET_COUNT = 8;
    public static final int COLTYPE_PEPTIDE_PROTEIN_SET_NAMES = 9;
    public static final int COLTYPE_OVERVIEW = 10;
    public static final int COLTYPE_PEPTIDE_CLUSTER = 11;
    public static final int LAST_STATIC_COLUMN = 11;
    private static final String[] m_columnNames = new String[]{"Id", "Status", "Peptide Sequence", "PTMs", "Score", "Charge", "m/z", "RT", "Protein Set Count", "Protein Sets", "Overview", "Cluster"};
    private static final String[] m_toolTipColumns = new String[]{"MasterQuantPeptide Id", "Peptide Status: Validated or Invalidated (manually or automatically)", "Identified Peptide Sequence", "Post Translational Modifications", "Score", "Charge", "Mass to Charge Ratio", "Retention Time (min)", "Number of Protein Set identified by this Peptide", "List of Protein Sets identified by this Peptide", "Overview", "Cluster Number"};
    public static final int COLTYPE_SELECTION_LEVEL = 0;
    public static final int COLTYPE_IDENT_PSM = 1;
    public static final int COLTYPE_PSM = 2;
    public static final int COLTYPE_RAW_ABUNDANCE = 3;
    public static final int COLTYPE_ABUNDANCE = 4;
    public static final int COLTYPE_RETENTION_TIME = 5;
    private int m_overviewType;
    private static final String[] m_columnNamesQC = new String[]{"Sel. level", "Ident. PSMs count", "Quant. PSMs count", "Raw abundance", "Abundance", "Retention time"};
    private static final String[] m_toolTipQC = new String[]{"Selection level (manual or automatique [in]validation)", "Identification Peptides Matches count", "Quantification Peptides Matches count", "Raw abundance", "Abundance", "Retention time"};
    private static final String[] m_columnNamesQC_SC = new String[]{"Sel. level", "Ident. Pep. match count", "Basic SC", "Specific SC"};
    private static final String[] m_toolTipQC_SC = new String[]{"Selection level (manual or automatique [in]validation)", "Identification Peptides Matches count", "Basic Spectral Count", "Specific Spectral Count"};
    private List<DMasterQuantPeptide> m_quantPeptides = null;
    private DMasterQuantProteinSet m_mqProtSetContext = null;
    private Map<Long, Integer> m_selectionLevelInContext = null;
    private Map<Long, Integer> m_globalLevel = null;
    private DQuantitationChannel[] m_quantChannels = null;
    private int m_quantChannelNumber;
    private String m_modelName;
    private AbstractDataBox m_databox;
    private boolean m_isXICMode;
    private long m_projectId;
    private final ScoreRenderer m_scoreRenderer = new ScoreRenderer();
    protected static final Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer.XIC");
    private RendererMouseCallback m_callback;
    private final StringBuilder m_sb = new StringBuilder();
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();
    private final HashMap<Integer, TableCellRenderer> m_rendererMapGrayed = new HashMap();

    public QuantPeptideTableModel(LazyTable table, RendererMouseCallback callback, boolean xicMode) {
        super(table);
        this.m_callback = callback;
        this.m_isXICMode = xicMode;
        this.m_overviewType = xicMode ? 4 : 3;
    }

    public void setDatabox(AbstractDataBox databox) {
        this.m_databox = databox;
    }

    public int getColumnCount() {
        if (this.m_quantChannels == null) {
            return m_columnNames.length;
        }
        if (this.m_isXICMode) {
            return m_columnNames.length + this.m_quantChannelNumber * m_columnNamesQC.length;
        }
        return m_columnNames.length + this.m_quantChannelNumber * m_columnNamesQC_SC.length;
    }

    public String getColumnName(int col) {
        if (col <= 11) {
            return m_columnNames[col];
        }
        if (this.m_quantChannels != null) {
            int id;
            int nbQc;
            if (this.m_isXICMode) {
                nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
                id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            } else {
                nbQc = (col - m_columnNames.length) / m_columnNamesQC_SC.length;
                id = col - m_columnNames.length - nbQc * m_columnNamesQC_SC.length;
            }
            StringBuilder sb = new StringBuilder();
            String rsmHtmlColor = CyclicColorPalette.getHTMLColor((int)nbQc);
            sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
            if (this.m_isXICMode) {
                sb.append(m_columnNamesQC[id]);
            } else {
                sb.append(m_columnNamesQC_SC[id]);
            }
            sb.append("<br/>");
            sb.append(this.m_quantChannels[nbQc].getName());
            sb.append("</html>");
            return sb.toString();
        }
        return "";
    }

    public String getExportColumnName(int col) {
        if (col <= 11) {
            return m_columnNames[col];
        }
        if (this.m_quantChannels != null) {
            int id;
            int nbQc;
            if (this.m_isXICMode) {
                nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
                id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            } else {
                nbQc = (col - m_columnNames.length) / m_columnNamesQC_SC.length;
                id = col - m_columnNames.length - nbQc * m_columnNamesQC_SC.length;
            }
            StringBuilder sb = new StringBuilder();
            if (this.m_isXICMode) {
                sb.append(m_columnNamesQC[id]);
            } else {
                sb.append(m_columnNamesQC_SC[id]);
            }
            sb.append(" ");
            sb.append(this.m_quantChannels[nbQc].getName());
            return sb.toString();
        }
        return "";
    }

    public String getExportRowCell(int row, int col) {
        int id;
        int nbQc;
        DMasterQuantPeptide peptide = this.m_quantPeptides.get(row);
        DPeptideInstance peptideInstance = peptide.getPeptideInstance();
        DPeptideMatch representPepMatch = peptideInstance != null ? peptide.getRepresentativePepMatch() : null;
        switch (col) {
            case 0: {
                return peptide.getId() == -1L ? "" : Long.toString(peptide.getId());
            }
            case 1: {
                if (this.m_isXICMode) {
                    XicStatusRenderer.SelectLevel level = this.getSelectionLevelFor(peptide);
                    return level.getDescription();
                }
                return "";
            }
            case 2: {
                if (peptideInstance == null) {
                    return "";
                }
                if (peptideInstance.getPeptide() != null) {
                    return peptideInstance.getPeptide().getSequence();
                }
                return "";
            }
            case 3: {
                if (peptideInstance == null) {
                    return "";
                }
                if (peptideInstance.getPeptide() != null) {
                    boolean ptmStringLoadeed = peptideInstance.getPeptide().getTransientData().isPeptideReadablePtmStringLoaded();
                    if (!ptmStringLoadeed) {
                        return null;
                    }
                    String ptm = "";
                    PeptideReadablePtmString ptmString = peptideInstance.getPeptide().getTransientData().getPeptideReadablePtmString();
                    if (ptmString != null) {
                        ptm = ptmString.getReadablePtmString();
                    }
                    return ptm;
                }
                return "";
            }
            case 4: {
                if (peptideInstance == null) {
                    return "";
                }
                if (representPepMatch != null) {
                    Float score = Float.valueOf(representPepMatch.getScore().floatValue());
                    return String.valueOf(score);
                }
                return "";
            }
            case 8: {
                if (peptideInstance == null) {
                    return "";
                }
                return Integer.toString(peptideInstance.getValidatedProteinSetCount());
            }
            case 9: {
                if (peptideInstance == null) {
                    return "";
                }
                DPeptideMatch peptideMatch = peptideInstance.getBestPeptideMatch();
                String[] proteinSetNames = peptideMatch.getProteinSetStringArray();
                if (proteinSetNames == null) {
                    return "";
                }
                for (int i = 0; i < proteinSetNames.length; ++i) {
                    String name = proteinSetNames[i];
                    if (i < proteinSetNames.length - 1) {
                        this.m_sb.append(name).append(", ");
                        continue;
                    }
                    this.m_sb.append(name);
                }
                String t = this.m_sb.toString();
                this.m_sb.setLength(0);
                return t;
            }
            case 5: {
                if (representPepMatch == null) {
                    return "";
                }
                return String.valueOf(representPepMatch.getCharge());
            }
            case 6: {
                if (representPepMatch == null) {
                    return "";
                }
                return String.valueOf(representPepMatch.getExperimentalMoz());
            }
            case 7: {
                if (peptideInstance == null) {
                    return "";
                }
                Float f = peptideInstance.getElutionTime();
                if (f != null) {
                    return StringUtils.getTimeInMinutes((float)peptideInstance.getElutionTime().floatValue(), (int)2);
                }
                return "";
            }
            case 10: {
                return "";
            }
            case 11: {
                if (peptideInstance == null) {
                    return "";
                }
                DCluster cluster = peptide.getCluster();
                if (cluster == null) {
                    return "";
                }
                return Integer.toString(cluster.getClusterId());
            }
        }
        if (this.m_isXICMode) {
            nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
            id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
        } else {
            nbQc = (col - m_columnNames.length) / m_columnNamesQC_SC.length;
            id = col - m_columnNames.length - nbQc * m_columnNamesQC_SC.length;
        }
        if (peptideInstance == null) {
            switch (id) {
                case 0: {
                    return Integer.toString(0);
                }
                case 4: {
                    return Float.toString(0.0f);
                }
                case 3: {
                    Float.toString(0.0f);
                }
                case 2: {
                    return Integer.toString(0);
                }
                case 1: {
                    return Integer.toString(0);
                }
                case 5: {
                    return Float.toString(0.0f);
                }
            }
        } else {
            Map quantPeptideByQchIds = peptide.getQuantPeptideByQchIds();
            if (quantPeptideByQchIds == null) {
                switch (id) {
                    case 0: {
                        return Integer.toString(0);
                    }
                    case 4: {
                        return Float.toString(0.0f);
                    }
                    case 3: {
                        Float.toString(0.0f);
                    }
                    case 2: {
                        return Integer.toString(0);
                    }
                    case 1: {
                        return Integer.toString(0);
                    }
                    case 5: {
                        return Float.toString(0.0f);
                    }
                }
            } else {
                DQuantPeptide quantPeptide = (DQuantPeptide)quantPeptideByQchIds.get(this.m_quantChannels[nbQc].getId());
                if (quantPeptide == null) {
                    switch (id) {
                        case 0: {
                            return Integer.toString(0);
                        }
                        case 4: {
                            return Float.toString(0.0f);
                        }
                        case 3: {
                            Float.toString(0.0f);
                        }
                        case 2: {
                            return Integer.toString(0);
                        }
                        case 1: {
                            return Integer.toString(0);
                        }
                        case 5: {
                            return Float.toString(0.0f);
                        }
                    }
                } else {
                    switch (id) {
                        case 0: {
                            return quantPeptide.getSelectionLevel() == null ? Integer.toString(0) : Integer.toString(quantPeptide.getSelectionLevel());
                        }
                        case 4: {
                            return quantPeptide.getAbundance() == null || quantPeptide.getAbundance().isNaN() ? Float.toString(0.0f) : Float.toString(quantPeptide.getAbundance().floatValue());
                        }
                        case 3: {
                            return quantPeptide.getRawAbundance() == null || quantPeptide.getRawAbundance().isNaN() ? Float.toString(0.0f) : Float.toString(quantPeptide.getRawAbundance().floatValue());
                        }
                        case 2: {
                            return quantPeptide.getPeptideMatchesCount() == null ? Integer.toString(0) : Integer.toString(quantPeptide.getPeptideMatchesCount());
                        }
                        case 1: {
                            return quantPeptide.getIdentPeptideMatchCount() == null ? Integer.toString(0) : Integer.toString(quantPeptide.getIdentPeptideMatchCount());
                        }
                        case 5: {
                            return quantPeptide.getElutionTime() == null ? Float.toString(0.0f) : Float.toString(quantPeptide.getElutionTime().floatValue() / 60.0f);
                        }
                    }
                }
            }
        }
        return "";
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        if (col == 2) {
            DMasterQuantPeptide quantPeptide = this.m_quantPeptides.get(row);
            return ExportFontModelUtilities.getExportFonts(quantPeptide.getPeptideInstance());
        }
        return null;
    }

    public String getToolTipForHeader(int col) {
        if (col == 10) {
            return m_toolTipColumns[col] + " on " + (this.m_isXICMode ? m_toolTipQC[this.m_overviewType] : m_toolTipQC_SC[this.m_overviewType]);
        }
        if (col <= 11) {
            return m_toolTipColumns[col];
        }
        if (this.m_quantChannels != null) {
            int id;
            int nbQc;
            if (this.m_isXICMode) {
                nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
                id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            } else {
                nbQc = (col - m_columnNames.length) / m_columnNamesQC_SC.length;
                id = col - m_columnNames.length - nbQc * m_columnNamesQC_SC.length;
            }
            String rawFilePath = StringUtils.truncate((String)this.m_quantChannels[nbQc].getRawFilePath(), (int)50);
            StringBuilder sb = new StringBuilder();
            String rsmHtmlColor = CyclicColorPalette.getHTMLColor((int)nbQc);
            sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
            if (this.m_isXICMode) {
                sb.append(m_toolTipQC[id]);
            } else {
                sb.append(m_toolTipQC_SC[id]);
            }
            sb.append("<br/>");
            sb.append(this.m_quantChannels[nbQc].getFullName());
            sb.append("<br/>");
            sb.append(rawFilePath);
            sb.append("</html>");
            return sb.toString();
        }
        return "";
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return String.class;
        }
        if (col == 1) {
            if (this.m_isXICMode) {
                return XicStatusRenderer.SelectLevel.class;
            }
            return String.class;
        }
        if (col == 10) {
            return CompareValueRenderer.CompareValue.class;
        }
        return LazyData.class;
    }

    @Override
    public int getSubTaskId(int col) {
        return 4;
    }

    public int getRowCount() {
        if (this.m_quantPeptides == null) {
            return 0;
        }
        return this.m_quantPeptides.size();
    }

    public String getTootlTipValue(int row, int col) {
        int a;
        if (this.m_quantPeptides == null || row < 0) {
            return "";
        }
        DMasterQuantPeptide peptide = this.m_quantPeptides.get(row);
        DCluster cluster = peptide.getCluster();
        if (col == 11 && cluster != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("Cluster ");
            sb.append(cluster.getClusterId());
            sb.append("<br/>");
            if (cluster.getAbundances() != null) {
                sb.append("<table><tr> ");
                List abundances = cluster.getAbundances();
                for (int a2 = 0; a2 < this.m_quantChannels.length; ++a2) {
                    sb.append("<td>");
                    String rsmHtmlColor = CyclicColorPalette.getHTMLColor((int)a2);
                    sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
                    sb.append("Abundance");
                    sb.append("<br/>");
                    sb.append(this.m_quantChannels[a2].getFullName());
                    sb.append("</td>");
                }
                sb.append("</tr><tr> ");
                for (Float abundance : abundances) {
                    sb.append("<td>");
                    sb.append(abundance.isNaN() ? "" : abundance);
                    sb.append("</td>");
                }
                sb.append("</tr></table>");
            }
            sb.append("</html>");
            return sb.toString();
        }
        if (cluster != null && (a = this.getAbundanceCol(col)) >= 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("Cluster ");
            sb.append(cluster.getClusterId());
            sb.append("<br/>");
            if (cluster.getAbundances() != null) {
                sb.append("<table><tr> ");
                List abundances = cluster.getAbundances();
                sb.append("<td>");
                String rsmHtmlColor = CyclicColorPalette.getHTMLColor((int)a);
                sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
                sb.append("Abundance");
                sb.append("<br/>");
                sb.append(this.m_quantChannels[a].getFullName());
                sb.append("</td>");
                sb.append("</tr><tr> ");
                sb.append("<td>");
                sb.append((Object)(((Float)abundances.get(a)).isNaN() ? "" : abundances.get(a)));
                sb.append("</td>");
                sb.append("</tr></table>");
            }
            sb.append("</html>");
            return sb.toString();
        }
        return "";
    }

    private int getAbundanceCol(int col) {
        if (this.m_quantChannels != null) {
            int id;
            int nbQc;
            if (this.m_isXICMode) {
                nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
                id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            } else {
                nbQc = (col - m_columnNames.length) / m_columnNamesQC_SC.length;
                id = col - m_columnNames.length - nbQc * m_columnNamesQC_SC.length;
            }
            if (id == 4) {
                return nbQc;
            }
            return -1;
        }
        return -1;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.m_isXICMode) {
            return false;
        }
        if (columnIndex != 1) {
            return false;
        }
        DMasterQuantPeptide peptide = this.m_quantPeptides.get(rowIndex);
        DPeptideInstance peptideInstance = peptide.getPeptideInstance();
        if (peptideInstance == null) {
            return true;
        }
        Float f = peptideInstance.getElutionTime();
        return f != null;
    }

    public boolean isRowEditable(int rowIndex) {
        if (!this.m_isXICMode) {
            return false;
        }
        DMasterQuantPeptide peptide = this.m_quantPeptides.get(rowIndex);
        DPeptideInstance peptideInstance = peptide.getPeptideInstance();
        if (peptideInstance == null) {
            return true;
        }
        Float f = peptideInstance.getElutionTime();
        return f != null;
    }

    public ArrayList<DMasterQuantPeptide> listToModifyForValidateModifications(ArrayList selectedRows, XicStatusRenderer.SelectLevelEnum cmdSelectLevel) {
        if (selectedRows.isEmpty()) {
            return null;
        }
        ArrayList<DMasterQuantPeptide> listToModify = new ArrayList<DMasterQuantPeptide>();
        for (Integer row : selectedRows) {
            if (!this.isRowEditable(row)) continue;
            DMasterQuantPeptide masterQuantPeptide = this.m_quantPeptides.get(row);
            int thisSelectLevel = masterQuantPeptide.getSelectionLevel();
            switch (cmdSelectLevel) {
                case DESELECTED_MANUAL: {
                    if (thisSelectLevel < 2) break;
                    masterQuantPeptide.setSelectionLevel(cmdSelectLevel.getIntValue());
                    listToModify.add(masterQuantPeptide);
                    break;
                }
                case SELECTED_MANUAL: {
                    if (thisSelectLevel >= 2) break;
                    masterQuantPeptide.setSelectionLevel(cmdSelectLevel.getIntValue());
                    listToModify.add(masterQuantPeptide);
                    break;
                }
                case RESET_AUTO: {
                    if (thisSelectLevel == 0) {
                        masterQuantPeptide.setSelectionLevel(XicStatusRenderer.SelectLevelEnum.DESELECTED_AUTO.getIntValue());
                        listToModify.add(masterQuantPeptide);
                        break;
                    }
                    if (thisSelectLevel != 3) break;
                    masterQuantPeptide.setSelectionLevel(XicStatusRenderer.SelectLevelEnum.SELECTED_AUTO.getIntValue());
                    listToModify.add(masterQuantPeptide);
                }
            }
        }
        if (listToModify.isEmpty()) {
            return null;
        }
        return listToModify;
    }

    public void validateModifications(final XicPeptidePanel panel, ArrayList<DMasterQuantPeptide> listToModify) {
        if (listToModify == null) {
            panel.modifyStatusActionFinished(true, null);
            return;
        }
        final ArrayList masterQuantProteinSetModified = new ArrayList();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (!success) {
                    panel.modifyStatusActionFinished(false, null);
                    return;
                }
                DataBoxViewerManager.loadedDataModified(QuantPeptideTableModel.this.m_projectId, QuantPeptideTableModel.this.m_databox.getRsetId(), QuantPeptideTableModel.this.m_databox.getRsmId(), DMasterQuantProteinSet.class, masterQuantProteinSetModified, 0);
                QuantPeptideTableModel.this.fireTableDataChanged();
                panel.modifyStatusActionFinished(true, null);
            }
        };
        DatabaseModifyPeptideTask task = new DatabaseModifyPeptideTask(callback);
        task.initDisablePeptide(this.m_projectId, listToModify, masterQuantProteinSetModified);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    public XicStatusRenderer.SelectLevel getSelectionLevelFor(DMasterQuantPeptide peptide) {
        Integer value;
        XicStatusRenderer.SelectLevelEnum level = XicStatusRenderer.SelectLevelEnum.UNKNOWN;
        if (this.m_mqProtSetContext != null && !this.m_selectionLevelInContext.isEmpty() && (value = this.m_selectionLevelInContext.get(peptide.getId())) != null) {
            level = XicStatusRenderer.SelectLevelEnum.valueOf(this.m_selectionLevelInContext.get(peptide.getId()));
        }
        if (level == null || level.equals((Object)XicStatusRenderer.SelectLevelEnum.UNKNOWN)) {
            level = XicStatusRenderer.SelectLevelEnum.valueOf(peptide.getSelectionLevel());
        }
        return new XicStatusRenderer.SelectLevel(level, XicStatusRenderer.SelectLevelEnum.valueOf(peptide.getSelectionLevel()));
    }

    public Object getValueAt(final int row, int col) {
        LazyData lazyData;
        DMasterQuantPeptide peptide = this.m_quantPeptides.get(row);
        DPeptideMatch representPepMatch = peptide.getRepresentativePepMatch();
        DPeptideInstance peptideInstance = peptide.getPeptideInstance();
        switch (col) {
            case 0: {
                return peptide.getId() == -1L ? "" : Long.toString(peptide.getId());
            }
            case 1: {
                if (this.m_isXICMode) {
                    XicStatusRenderer.SelectLevel level = this.getSelectionLevelFor(peptide);
                    return level;
                }
                return "";
            }
            case 2: {
                LazyData lazyData2 = this.getLazyData(row, col);
                if (peptideInstance == null) {
                    lazyData2.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else if (representPepMatch != null) {
                    lazyData2.setData((Comparable)representPepMatch);
                } else {
                    lazyData2.setData(null);
                }
                return lazyData2;
            }
            case 3: {
                LazyData lazyData3 = this.getLazyData(row, col);
                if (peptideInstance == null) {
                    lazyData3.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else if (representPepMatch != null) {
                    boolean ptmStringLoaded = peptideInstance.getPeptide().getTransientData().isPeptideReadablePtmStringLoaded();
                    if (!ptmStringLoaded) {
                        return null;
                    }
                    String ptm = "";
                    PeptideReadablePtmString ptmString = peptideInstance.getPeptide().getTransientData().getPeptideReadablePtmString();
                    if (ptmString != null) {
                        ptm = ptmString.getReadablePtmString();
                    }
                    lazyData3.setData((Comparable)((Object)ptm));
                } else {
                    lazyData3.setData((Comparable)((Object)""));
                }
                return lazyData3;
            }
            case 4: {
                LazyData lazyData4 = this.getLazyData(row, col);
                if (peptideInstance == null) {
                    lazyData4.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else if (representPepMatch != null) {
                    Float score = Float.valueOf(representPepMatch.getScore().floatValue());
                    lazyData4.setData((Comparable)score);
                } else {
                    lazyData4.setData(null);
                }
                return lazyData4;
            }
            case 8: {
                LazyData lazyData5 = this.getLazyData(row, col);
                if (peptideInstance == null) {
                    lazyData5.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData5.setData((Comparable)Integer.valueOf(peptideInstance.getValidatedProteinSetCount()));
                }
                return lazyData5;
            }
            case 9: {
                LazyData lazyData6 = this.getLazyData(row, col);
                if (peptideInstance == null) {
                    lazyData6.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    DPeptideMatch peptideMatch = peptideInstance.getBestPeptideMatch();
                    String[] proteinSetNames = peptideMatch.getProteinSetStringArray();
                    if (proteinSetNames == null) {
                        this.givePriorityTo(this.m_taskId, row, col);
                        lazyData6.setData(null);
                    } else {
                        for (int i = 0; i < proteinSetNames.length; ++i) {
                            String name = proteinSetNames[i];
                            if (i < proteinSetNames.length - 1) {
                                this.m_sb.append(name).append(", ");
                                continue;
                            }
                            this.m_sb.append(name);
                        }
                        lazyData6.setData((Comparable)((Object)this.m_sb.toString()));
                        this.m_sb.setLength(0);
                    }
                }
                return lazyData6;
            }
            case 5: {
                LazyData lazyData7 = this.getLazyData(row, col);
                if (representPepMatch == null) {
                    lazyData7.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData7.setData((Comparable)Integer.valueOf(representPepMatch.getCharge()));
                }
                return lazyData7;
            }
            case 6: {
                LazyData lazyData8 = this.getLazyData(row, col);
                if (representPepMatch == null) {
                    lazyData8.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData8.setData((Comparable)Double.valueOf(representPepMatch.getExperimentalMoz()));
                }
                return lazyData8;
            }
            case 7: {
                LazyData lazyData9 = this.getLazyData(row, col);
                if (peptideInstance == null) {
                    lazyData9.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    Float f = peptideInstance.getElutionTime();
                    if (f == null) {
                        f = Float.valueOf(Float.NaN);
                    }
                    lazyData9.setData((Comparable)f);
                }
                return lazyData9;
            }
            case 10: {
                return new CompareValueRenderer.CompareValue(){

                    @Override
                    public int getNumberColumns() {
                        return QuantPeptideTableModel.this.m_quantChannels.length;
                    }

                    @Override
                    public Color getColor(int col) {
                        return CyclicColorPalette.getColor((int)col);
                    }

                    @Override
                    public double getValue(int col) {
                        if (QuantPeptideTableModel.this.m_overviewType == -1) {
                            return 0.0;
                        }
                        int realCol = QuantPeptideTableModel.this.m_isXICMode ? 12 + QuantPeptideTableModel.this.m_overviewType + col * m_columnNamesQC.length : 12 + QuantPeptideTableModel.this.m_overviewType + col * m_columnNamesQC_SC.length;
                        LazyData lazyData = (LazyData)QuantPeptideTableModel.this.getValueAt(row, realCol);
                        if (lazyData != null && lazyData.getData() != null && Number.class.isAssignableFrom(lazyData.getData().getClass())) {
                            return ((Number)lazyData.getData()).floatValue();
                        }
                        return 0.0;
                    }

                    public double getValueNoNaN(int col) {
                        double val = this.getValue(col);
                        if (val != val) {
                            return 0.0;
                        }
                        return val;
                    }

                    @Override
                    public double getMaximumValue() {
                        int nbCols = this.getNumberColumns();
                        double maxValue = 0.0;
                        for (int i = 0; i < nbCols; ++i) {
                            double v = this.getValue(i);
                            if (!(v > maxValue)) continue;
                            maxValue = v;
                        }
                        return maxValue;
                    }

                    @Override
                    public double calculateComparableValue() {
                        int nbColumns = this.getNumberColumns();
                        double mean = 0.0;
                        for (int i = 0; i < nbColumns; ++i) {
                            mean += this.getValueNoNaN(i);
                        }
                        mean /= (double)nbColumns;
                        double maxDiff = 0.0;
                        for (int i = 0; i < nbColumns; ++i) {
                            double diff = this.getValueNoNaN(i) - mean;
                            if (diff < 0.0) {
                                diff = -diff;
                            }
                            if (!(diff > maxDiff)) continue;
                            maxDiff = diff;
                        }
                        return maxDiff / mean;
                    }

                    @Override
                    public int compareTo(CompareValueRenderer.CompareValue o) {
                        return Double.compare(this.calculateComparableValue(), o.calculateComparableValue());
                    }
                };
            }
            case 11: {
                lazyData = this.getLazyData(row, col);
                if (peptideInstance == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                    break;
                }
                DCluster cluster = peptide.getCluster();
                if (cluster == null) {
                    lazyData.setData((Comparable)((Object)""));
                    break;
                }
                lazyData.setData((Comparable)((Object)String.valueOf(cluster.getClusterId())));
            }
        }
        lazyData = this.getLazyData(row, col);
        if (peptideInstance == null) {
            lazyData.setData(null);
            this.givePriorityTo(this.m_taskId, row, col);
        } else {
            int id;
            int nbQc;
            if (this.m_isXICMode) {
                nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
                id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            } else {
                nbQc = (col - m_columnNames.length) / m_columnNamesQC_SC.length;
                id = col - m_columnNames.length - nbQc * m_columnNamesQC_SC.length;
            }
            Map quantPeptideByQchIds = peptide.getQuantPeptideByQchIds();
            if (quantPeptideByQchIds == null) {
                switch (id) {
                    case 0: {
                        lazyData.setData((Comparable)Integer.valueOf(0));
                        break;
                    }
                    case 4: {
                        lazyData.setData((Comparable)Float.valueOf(0.0f));
                        break;
                    }
                    case 3: {
                        lazyData.setData((Comparable)Float.valueOf(0.0f));
                        break;
                    }
                    case 2: {
                        lazyData.setData((Comparable)Integer.valueOf(0));
                        break;
                    }
                    case 1: {
                        lazyData.setData((Comparable)Integer.valueOf(0));
                        break;
                    }
                    case 5: {
                        lazyData.setData((Comparable)Float.valueOf(0.0f));
                    }
                }
            } else {
                DQuantPeptide quantPeptide = (DQuantPeptide)quantPeptideByQchIds.get(this.m_quantChannels[nbQc].getId());
                if (quantPeptide == null) {
                    switch (id) {
                        case 0: {
                            lazyData.setData((Comparable)Integer.valueOf(0));
                            break;
                        }
                        case 4: {
                            lazyData.setData((Comparable)Float.valueOf(0.0f));
                            break;
                        }
                        case 3: {
                            lazyData.setData((Comparable)Float.valueOf(0.0f));
                            break;
                        }
                        case 2: {
                            lazyData.setData((Comparable)Integer.valueOf(0));
                            break;
                        }
                        case 1: {
                            lazyData.setData((Comparable)Integer.valueOf(0));
                            break;
                        }
                        case 5: {
                            lazyData.setData((Comparable)Float.valueOf(0.0f));
                        }
                    }
                } else {
                    switch (id) {
                        case 0: {
                            lazyData.setData((Comparable)quantPeptide.getSelectionLevel());
                            break;
                        }
                        case 4: {
                            lazyData.setData((Comparable)(quantPeptide.getAbundance() == null || quantPeptide.getAbundance().isNaN() ? Float.valueOf(0.0f) : quantPeptide.getAbundance()));
                            break;
                        }
                        case 3: {
                            lazyData.setData((Comparable)(quantPeptide.getRawAbundance() == null || quantPeptide.getRawAbundance().isNaN() ? Float.valueOf(0.0f) : quantPeptide.getRawAbundance()));
                            break;
                        }
                        case 2: {
                            lazyData.setData((Comparable)(quantPeptide.getPeptideMatchesCount() == null ? Integer.valueOf(0) : quantPeptide.getPeptideMatchesCount()));
                            break;
                        }
                        case 1: {
                            lazyData.setData((Comparable)(quantPeptide.getIdentPeptideMatchCount() == null ? Integer.valueOf(0) : quantPeptide.getIdentPeptideMatchCount()));
                            break;
                        }
                        case 5: {
                            lazyData.setData((Comparable)Float.valueOf(quantPeptide.getElutionTime() == null ? Float.valueOf(0.0f).floatValue() : quantPeptide.getElutionTime().floatValue() / 60.0f));
                        }
                    }
                }
            }
        }
        return lazyData;
    }

    public void setData(Long taskId, long projectId, DQuantitationChannel[] quantChannels, List<DMasterQuantPeptide> peptides, DMasterQuantProteinSet masterQuantProtSetContext, boolean isXICMode) {
        Map selectLevelByMqPeps;
        MasterQuantProteinSetProperties prop;
        this.m_taskId = taskId;
        boolean structureChanged = true;
        this.m_isXICMode = isXICMode;
        this.m_overviewType = isXICMode ? 4 : 3;
        this.m_projectId = projectId;
        if (this.m_quantChannels != null && this.m_quantChannels.length == quantChannels.length) {
            for (int i = 0; i < this.m_quantChannels.length; ++i) {
                structureChanged = !this.m_quantChannels[i].equals(quantChannels[i]);
            }
        }
        this.m_quantPeptides = peptides;
        this.m_quantChannels = quantChannels;
        this.m_mqProtSetContext = masterQuantProtSetContext;
        this.m_selectionLevelInContext = new HashMap<Long, Integer>();
        this.m_globalLevel = new HashMap<Long, Integer>();
        if (this.m_mqProtSetContext != null && (prop = this.m_mqProtSetContext.getMasterQuantProtSetProperties()) != null && (selectLevelByMqPeps = prop.getMqPeptideSelLevelById()) != null) {
            for (DMasterQuantPeptide mqPep : this.m_quantPeptides) {
                int globalSelectLevel = mqPep.getSelectionLevel();
                this.m_selectionLevelInContext.put(mqPep.getId(), selectLevelByMqPeps.getOrDefault(mqPep.getId(), XicStatusRenderer.SelectLevelEnum.UNKNOWN.getIntValue()));
                this.m_globalLevel.put(mqPep.getId(), globalSelectLevel);
            }
        }
        this.m_quantChannelNumber = quantChannels.length;
        if (structureChanged) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    public DMasterQuantPeptide getPeptide(int i) {
        return this.m_quantPeptides.get(i);
    }

    public int findRow(long peptideId) {
        int nb = this.m_quantPeptides.size();
        for (int i = 0; i < nb; ++i) {
            if (peptideId != this.m_quantPeptides.get(i).getPeptideInstanceId()) continue;
            return i;
        }
        return -1;
    }

    public void sortAccordingToModel(ArrayList<Long> peptideIds, CompoundTableModel compoundTableModel) {
        if (this.m_quantPeptides == null) {
            return;
        }
        HashSet<Long> peptideIdMap = new HashSet<Long>(peptideIds.size());
        peptideIdMap.addAll(peptideIds);
        int nb = this.m_table.getRowCount();
        int iCur = 0;
        for (int iView = 0; iView < nb; ++iView) {
            DMasterQuantPeptide p;
            int iModel = this.m_table.convertRowIndexToModel(iView);
            if (compoundTableModel != null) {
                iModel = compoundTableModel.convertCompoundRowToBaseModelRow(iModel);
            }
            if (!peptideIdMap.contains((p = this.getPeptide(iModel)).getPeptideInstanceId())) continue;
            peptideIds.set(iCur++, p.getPeptideInstanceId());
        }
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        ConvertValueInterface peptideConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return ((DPeptideMatch)o).getPeptide().getSequence();
            }
        };
        filtersMap.put(2, (Filter)new StringDiffFilter(this.getColumnName(2), peptideConverter, 2));
        filtersMap.put(3, (Filter)new StringDiffFilter(this.getColumnName(3), null, 3));
        filtersMap.put(4, (Filter)new DoubleFilter(this.getColumnName(4), null, 4));
        filtersMap.put(5, (Filter)new IntegerFilter(this.getColumnName(5), null, 5));
        filtersMap.put(6, (Filter)new DoubleFilter(this.getColumnName(6), null, 6));
        filtersMap.put(8, (Filter)new IntegerFilter(this.getColumnName(8), null, 8));
        filtersMap.put(9, (Filter)new StringDiffFilter(this.getColumnName(9), null, 9));
        filtersMap.put(11, (Filter)new StringDiffFilter(this.getColumnName(11), null, 11));
        int nbCol = this.getColumnCount();
        block4: for (int i = 12; i < nbCol; ++i) {
            int id;
            int nbQc;
            if (this.m_isXICMode) {
                nbQc = (i - m_columnNames.length) / m_columnNamesQC.length;
                id = i - m_columnNames.length - nbQc * m_columnNamesQC.length;
            } else {
                nbQc = (i - m_columnNames.length) / m_columnNamesQC_SC.length;
                id = i - m_columnNames.length - nbQc * m_columnNamesQC_SC.length;
            }
            switch (id) {
                case 0: {
                    filtersMap.put(i, (Filter)new IntegerFilter(this.getColumnName(i), null, i));
                    continue block4;
                }
                case 2: {
                    filtersMap.put(i, (Filter)new IntegerFilter(this.getColumnName(i), null, i));
                    continue block4;
                }
                default: {
                    filtersMap.put(i, (Filter)new DoubleFilter(this.getColumnName(i), null, i));
                }
            }
        }
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public boolean isLoaded() {
        return this.m_table.isLoaded();
    }

    public int getByQCCount() {
        if (this.m_isXICMode) {
            return m_columnNamesQC.length;
        }
        return m_columnNamesQC_SC.length;
    }

    public int getQCCount() {
        return this.m_quantChannels.length;
    }

    public int getColumStart(int index) {
        if (this.m_isXICMode) {
            return m_columnNames.length + index * m_columnNamesQC.length;
        }
        return m_columnNames.length + index * m_columnNamesQC_SC.length;
    }

    public int getColumStop(int index) {
        if (this.m_isXICMode) {
            return m_columnNames.length + (1 + index) * m_columnNamesQC.length - 1;
        }
        return m_columnNames.length + (1 + index) * m_columnNamesQC_SC.length - 1;
    }

    public String getQCName(int i) {
        StringBuilder sb = new StringBuilder();
        String rsmHtmlColor = CyclicColorPalette.getHTMLColor((int)i);
        sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
        sb.append(this.m_quantChannels[i].getFullName());
        sb.append("</html>");
        return sb.toString();
    }

    public String getByQCMColumnName(int index) {
        return this.m_isXICMode ? m_columnNamesQC[index] : m_columnNamesQC_SC[index];
    }

    public int getQCNumber(int col) {
        if (this.m_isXICMode) {
            return (col - m_columnNames.length) / m_columnNamesQC.length;
        }
        return (col - m_columnNames.length) / m_columnNamesQC_SC.length;
    }

    public int getTypeNumber(int col) {
        if (this.m_isXICMode) {
            return (col - m_columnNames.length) % m_columnNamesQC.length;
        }
        return (col - m_columnNames.length) % m_columnNamesQC_SC.length;
    }

    public Long getResultSummaryId() {
        if (this.m_quantPeptides == null || this.m_quantPeptides.isEmpty()) {
            return null;
        }
        return this.m_quantPeptides.get(0).getQuantResultSummaryId();
    }

    public void setOverviewType(int overviewType) {
        this.m_overviewType = overviewType;
        this.fireTableDataChanged();
    }

    public int getOverviewType() {
        return this.m_overviewType;
    }

    public List<Integer> getDefaultColumnsToHide() {
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        if (this.m_quantChannels != null) {
            for (int i = this.m_quantChannels.length - 1; i >= 0; --i) {
                if (this.m_isXICMode) {
                    listIds.add(m_columnNames.length + 1 + i * m_columnNamesQC.length);
                    listIds.add(m_columnNames.length + 3 + i * m_columnNamesQC.length);
                    listIds.add(m_columnNames.length + 5 + i * m_columnNamesQC.length);
                } else {
                    listIds.add(m_columnNames.length + 1 + i * m_columnNamesQC_SC.length);
                }
                if (this.m_isXICMode) {
                    listIds.add(m_columnNames.length + 0 + i * m_columnNamesQC.length);
                    continue;
                }
                listIds.add(m_columnNames.length + 0 + i * m_columnNamesQC_SC.length);
            }
        }
        if (!this.m_isXICMode) {
            listIds.add(11);
        }
        return listIds;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        int id;
        int nbQc;
        if (columnIndex <= 11) {
            return m_columnNames[columnIndex];
        }
        if (this.m_isXICMode) {
            nbQc = (columnIndex - m_columnNames.length) / m_columnNamesQC.length;
            id = columnIndex - m_columnNames.length - nbQc * m_columnNamesQC.length;
        } else {
            nbQc = (columnIndex - m_columnNames.length) / m_columnNamesQC_SC.length;
            id = columnIndex - m_columnNames.length - nbQc * m_columnNamesQC_SC.length;
        }
        StringBuilder sb = new StringBuilder();
        if (this.m_isXICMode) {
            sb.append(m_columnNamesQC[id]);
        } else {
            sb.append(m_columnNamesQC_SC[id]);
        }
        sb.append(' ');
        sb.append(this.m_quantChannels[nbQc].getName());
        return sb.toString();
    }

    public Class getDataColumnClass(int columnIndex) {
        int id;
        switch (columnIndex) {
            case 0: {
                return Long.class;
            }
            case 1: {
                if (this.m_isXICMode) {
                    return Integer.class;
                }
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: 
            case 9: {
                return String.class;
            }
            case 5: 
            case 8: {
                return Integer.class;
            }
            case 6: {
                return Double.class;
            }
            case 4: {
                return Float.class;
            }
            case 10: {
                return CompareValueRenderer.CompareValue.class;
            }
            case 11: {
                return String.class;
            }
            case 7: {
                return Float.class;
            }
        }
        if (this.m_isXICMode) {
            int nbQc = (columnIndex - m_columnNames.length) / m_columnNamesQC.length;
            id = columnIndex - m_columnNames.length - nbQc * m_columnNamesQC.length;
        } else {
            int nbQc = (columnIndex - m_columnNames.length) / m_columnNamesQC_SC.length;
            id = columnIndex - m_columnNames.length - nbQc * m_columnNamesQC_SC.length;
        }
        switch (id) {
            case 0: {
                return Integer.class;
            }
            case 3: 
            case 4: 
            case 5: {
                return Float.class;
            }
            case 1: 
            case 2: {
                return Integer.class;
            }
        }
        return null;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        Object data = this.getValueAt(rowIndex, columnIndex);
        if (data instanceof LazyData) {
            data = ((LazyData)data).getData();
        }
        if (data instanceof DPeptideMatch) {
            data = ((DPeptideMatch)data).getPeptide().getSequence();
        }
        DMasterQuantPeptide peptide = this.m_quantPeptides.get(rowIndex);
        if (columnIndex == 0) {
            return peptide.getId();
        }
        if (columnIndex == 1) {
            return ((XicStatusRenderer.SelectLevel)data).getStatus().getIntValue();
        }
        return data;
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{2};
        return keys;
    }

    public int getInfoColumn() {
        return 2;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public PlotType getBestPlotType() {
        return null;
    }

    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        boolean grayed = false;
        if (this.getRowCount() > 0) {
            Boolean peptideSelected = true;
            if (this.m_isXICMode) {
                XicStatusRenderer.SelectLevel status = (XicStatusRenderer.SelectLevel)this.getValueAt(row, 1);
                peptideSelected = status.getStatus().getIntValue() >= 2;
            }
            boolean bl = grayed = peptideSelected == false;
            if (grayed) {
                if (this.m_rendererMapGrayed.containsKey(col)) {
                    return this.m_rendererMapGrayed.get(col);
                }
            } else if (this.m_rendererMap.containsKey(col)) {
                return this.m_rendererMap.get(col);
            }
        }
        Object renderer = null;
        block0 : switch (col) {
            case 2: {
                renderer = new PeptideRenderer();
                break;
            }
            case 1: {
                if (!this.m_isXICMode) break;
                renderer = new XicStatusRenderer(this.m_callback, 1);
                break;
            }
            case 4: {
                renderer = this.m_scoreRenderer;
                break;
            }
            case 5: {
                renderer = new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class));
                break;
            }
            case 6: {
                renderer = new DoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 4);
                break;
            }
            case 7: {
                renderer = new TimeRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)));
                break;
            }
            case 8: {
                renderer = new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class));
                break;
            }
            case 3: 
            case 11: {
                renderer = new DefaultLeftAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class));
                break;
            }
            case 10: {
                renderer = new CompareValueRenderer();
                break;
            }
            default: {
                int id;
                if (this.m_isXICMode) {
                    int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
                    id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
                } else {
                    int nbQc = (col - m_columnNames.length) / m_columnNamesQC_SC.length;
                    id = col - m_columnNames.length - nbQc * m_columnNamesQC_SC.length;
                }
                switch (id) {
                    case 0: 
                    case 1: 
                    case 2: {
                        renderer = new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class));
                        break block0;
                    }
                    case 4: {
                        if (this.m_isXICMode) {
                            renderer = new BigFloatOrDoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 0);
                            break block0;
                        }
                        renderer = new FloatRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 2);
                        break block0;
                    }
                    case 3: {
                        if (this.m_isXICMode) {
                            renderer = new BigFloatOrDoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 0);
                            break block0;
                        }
                        renderer = new FloatRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 0);
                        break block0;
                    }
                    case 5: {
                        renderer = new FloatRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 2);
                    }
                }
            }
        }
        if (grayed) {
            if (renderer == null) {
                return null;
            }
            renderer = new GrayedRenderer((TableCellRenderer)renderer);
            this.m_rendererMapGrayed.put(col, (TableCellRenderer)renderer);
        } else {
            this.m_rendererMap.put(col, (TableCellRenderer)renderer);
        }
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(DMasterQuantPeptide.class, true));
        list.add(new ExtraDataType(ResultSummary.class, false));
        list.add(new ExtraDataType(DDataset.class, false));
        list.add(new ExtraDataType(QuantChannelInfo.class, false));
        list.add(new ExtraDataType(XicMode.class, false));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(DMasterQuantPeptide.class)) {
            return this.m_quantPeptides.get(row);
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        if (c.equals(XicGroup.class)) {
            if (col <= 11) {
                return null;
            }
            int nbQc = this.m_isXICMode ? (col - m_columnNames.length) / m_columnNamesQC.length : (col - m_columnNames.length) / m_columnNamesQC_SC.length;
            return new XicGroup(this.m_quantChannels[nbQc].getBiologicalGroupId(), null);
        }
        if (c.equals(QuantitationType.class)) {
            int id;
            if (col <= 11) {
                return null;
            }
            if (this.m_isXICMode) {
                int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
                id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            } else {
                int nbQc = (col - m_columnNames.length) / m_columnNamesQC_SC.length;
                id = col - m_columnNames.length - nbQc * m_columnNamesQC_SC.length;
            }
            if (this.m_isXICMode) {
                switch (id) {
                    case 4: {
                        return QuantitationType.getQuantitationType((int)0);
                    }
                    case 3: {
                        return QuantitationType.getQuantitationType((int)1);
                    }
                }
            } else {
                switch (id) {
                    case 2: {
                        return QuantitationType.getQuantitationType((int)2);
                    }
                    case 3: {
                        return QuantitationType.getQuantitationType((int)3);
                    }
                    case 4: {
                        return QuantitationType.getQuantitationType((int)4);
                    }
                }
            }
            return null;
        }
        return null;
    }
}

