/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DQuantProteinSet;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.extendedtablemodel.SecondAxisTableModelInterface;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.rsmexplorer.gui.xic.XICComparePeptideTableModel;
import java.awt.Color;
import java.util.Map;

public class XicAbundanceProteinTableModel
extends XICComparePeptideTableModel
implements SecondAxisTableModelInterface {
    private DMasterQuantProteinSet m_proteinSet = null;

    public void setData(DQuantitationChannel[] quantChannels, DMasterQuantProteinSet proteinSet) {
        this.m_quantChannels = quantChannels;
        this.m_proteinSet = proteinSet;
        this.fireTableDataChanged();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.m_quantChannels == null || this.m_proteinSet == null) {
            return null;
        }
        DQuantitationChannel qc = this.m_quantChannels[row];
        Map quantProteinSetByQchIds = this.m_proteinSet.getQuantProteinSetByQchIds();
        DQuantProteinSet quantProteinSet = (DQuantProteinSet)quantProteinSetByQchIds.get(qc.getId());
        switch (col) {
            case 0: {
                return qc.getId();
            }
            case 1: {
                return qc.getName();
            }
            case 2: {
                if (quantProteinSet == null || quantProteinSet.getAbundance() == null) {
                    return null;
                }
                return quantProteinSet.getAbundance().isNaN() ? null : quantProteinSet.getAbundance();
            }
            case 3: {
                if (quantProteinSet == null || quantProteinSet.getRawAbundance() == null) {
                    return null;
                }
                return quantProteinSet.getRawAbundance().isNaN() ? null : quantProteinSet.getRawAbundance();
            }
            case 4: {
                if (quantProteinSet == null || quantProteinSet.getPeptideMatchesCount() == null) {
                    return null;
                }
                return quantProteinSet.getPeptideMatchesCount();
            }
        }
        return null;
    }

    @Override
    public PlotInformation getPlotInformation() {
        PlotInformation plotInformation = new PlotInformation();
        if (this.m_proteinSet != null && this.m_proteinSet.getProteinSet() != null && this.m_proteinSet.getProteinSet().getTypicalProteinMatch() != null) {
            DProteinMatch proteinMatch = this.m_proteinSet.getProteinSet().getTypicalProteinMatch();
            StringBuilder sb = new StringBuilder(proteinMatch.getAccession());
            plotInformation.setPlotTitle(sb.toString());
        }
        if (this.m_proteinSet.getSelectionLevel() < 2) {
            plotInformation.setPlotColor(Color.LIGHT_GRAY);
        } else {
            plotInformation.setPlotColor(Color.ORANGE);
        }
        plotInformation.setDrawPoints(true);
        plotInformation.setDrawGap(true);
        return plotInformation;
    }

    @Override
    public Object getValue(Class c) {
        if (c.equals(DMasterQuantProteinSet.class)) {
            return this.m_proteinSet;
        }
        return this.getSingleValue(c);
    }

    @Override
    public Object getRowValue(Class c, int row) {
        if (c.equals(DQuantitationChannel.class)) {
            return this.m_quantChannels[row];
        }
        return null;
    }

    @Override
    public PlotDataSpec getDataSpecAt(int row) {
        int matcheCount;
        PlotDataSpec result = new PlotDataSpec();
        DQuantitationChannel qc = this.m_quantChannels[row];
        Map quantProteinSetByQchIds = this.m_proteinSet.getQuantProteinSetByQchIds();
        DQuantProteinSet quantProteinSet = (DQuantProteinSet)quantProteinSetByQchIds.get(qc.getId());
        if (quantProteinSet != null && quantProteinSet.getRawAbundance() != null && quantProteinSet.getPeptideMatchesCount() != null && (matcheCount = quantProteinSet.getPeptideMatchesCount().intValue()) == 0) {
            result.setFill(PlotDataSpec.FILL.EMPTY);
        }
        return result;
    }
}

