/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.lcms.Feature;
import fr.proline.core.orm.lcms.dto.DFeature;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.corewrapper.util.PeptideClassesUtils;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.ExtractChromatogramTask;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelInterface;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.mzscope.AddMzScopeButton;
import fr.proline.studio.mzscope.MzScopeInterface;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.MzScopeWindowBoxManager;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.pattern.xic.DataboxChildFeature;
import fr.proline.studio.progress.ProgressBarDialog;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import fr.proline.studio.rsmexplorer.actions.table.DisplayTablePopupMenu;
import fr.proline.studio.rsmexplorer.gui.xic.FeatureTableModel;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.table.AbstractTableAction;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.openide.windows.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XicFeaturePanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private AbstractDataBox m_dataBox;
    private JScrollPane m_featureScrollPane;
    private FeatureTable m_featureTable;
    private MarkerContainerPanel m_markerContainerPanel;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private JButton m_graphicsButton;
    private JButton m_graphicsTypeButton;
    private AddMzScopeButton m_mzscopeButton;
    private ExctractXICAction m_extractSelectedXICAction = null;
    private ExctractXICAction m_extractAlldXICAction = null;
    public static final int VIEW_ALL_GRAPH_PEAKS = 0;
    public static final int VIEW_ALL_ISOTOPES_FOR_FEATURE = 1;
    private int m_viewType = 0;
    private final boolean m_canGraph;
    private JLabel m_titleLabel;
    private static final String TABLE_TITLE = "Features";
    private int m_loadingXICId = 0;

    public XicFeaturePanel(boolean canGraph) {
        this.m_canGraph = canGraph;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel featurePanel = this.createFeaturePanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                featurePanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)featurePanel, JLayeredPane.DEFAULT_LAYER);
    }

    private JPanel createFeaturePanel() {
        JPanel featurePanel = new JPanel();
        featurePanel.setBounds(0, 0, 500, 400);
        featurePanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        JToolBar toolbar = this.initToolbar();
        this.m_titleLabel = new JLabel(TABLE_TITLE);
        featurePanel.add((Component)this.m_titleLabel, "North");
        featurePanel.add((Component)toolbar, "West");
        featurePanel.add((Component)internalPanel, "Center");
        return featurePanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_featureTable.getModel(), (SettingsInterface)this.m_featureTable);
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_featureTable.getModel())){

            protected void filteringDone() {
                XicFeaturePanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                XicFeaturePanel.this.m_dataBox.propagateDataChanged();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_featureTable.getModel()), TABLE_TITLE, (JXTable)this.m_featureTable);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        this.m_graphicsButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CHART));
        this.m_graphicsButton.setToolTipText("Graphics : Linear Plot");
        this.m_graphicsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!((CompoundTableModel)XicFeaturePanel.this.m_featureTable.getModel()).isLoaded()) {
                    ProgressBarDialog dialog = ProgressBarDialog.getDialog((Window)WindowManager.getDefault().getMainWindow(), (ProgressInterface)((CompoundTableModel)XicFeaturePanel.this.m_featureTable.getModel()), (String)"Data loading", (String)"Histogram functionnality is not available while data is loading. Please Wait.");
                    dialog.setLocation(XicFeaturePanel.this.getLocationOnScreen().x + XicFeaturePanel.this.m_graphicsButton.getWidth() + 5, ((XicFeaturePanel)XicFeaturePanel.this).m_graphicsButton.getLocationOnScreen().y + XicFeaturePanel.this.getHeight() + 5);
                    dialog.setVisible(true);
                    if (!dialog.isWaitingFinished()) {
                        return;
                    }
                }
                WindowBox wbox = WindowBoxFactory.getMultiGraphicsWindowBox("Feature Graphic", XicFeaturePanel.this.m_dataBox, false);
                wbox.setEntryData(XicFeaturePanel.this.m_dataBox.getProjectId(), null);
                DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(wbox);
                win.open();
                win.requestActive();
            }
        });
        this.m_graphicsTypeButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CHART_ARROW));
        this.setGraphicTypeToolTip();
        this.m_graphicsTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (XicFeaturePanel.this.m_viewType) {
                    case 0: {
                        XicFeaturePanel.this.m_viewType = 1;
                        break;
                    }
                    case 1: {
                        XicFeaturePanel.this.m_viewType = 0;
                    }
                }
                XicFeaturePanel.this.setGraphicTypeToolTip();
                ((DataboxChildFeature)XicFeaturePanel.this.m_dataBox).propagateModelChangeWithoutModifyingZoom();
            }
        });
        if (this.m_canGraph) {
            toolbar.add(this.m_graphicsButton);
            toolbar.add(this.m_graphicsTypeButton);
        }
        this.m_mzscopeButton = new AddMzScopeButton((ProgressInterface)((CompoundTableModel)this.m_featureTable.getModel()), (FeatureTableModel)((CompoundTableModel)this.m_featureTable.getModel()).getBaseModel()){

            public void actionPerformed(MzScopeInterface mzScopeInterface) {
                if (!((CompoundTableModel)XicFeaturePanel.this.m_featureTable.getModel()).isLoaded()) {
                    ProgressBarDialog dialog = ProgressBarDialog.getDialog((Window)WindowManager.getDefault().getMainWindow(), (ProgressInterface)((CompoundTableModel)XicFeaturePanel.this.m_featureTable.getModel()), (String)"Data loading", (String)"Histogram functionnality is not available while data is loading. Please Wait.");
                    dialog.setLocation(this.getLocationOnScreen().x + XicFeaturePanel.this.m_mzscopeButton.getWidth() + 5, ((XicFeaturePanel)XicFeaturePanel.this).m_mzscopeButton.getLocationOnScreen().y + this.getHeight() + 5);
                    dialog.setVisible(true);
                    if (!dialog.isWaitingFinished()) {
                        return;
                    }
                }
                MzScopeInterface mzscopeInterface = (MzScopeInterface)XicFeaturePanel.this.m_dataBox.getData(MzScopeInterface.class);
                MzScopeWindowBoxManager.addMzdbScope(mzscopeInterface);
            }
        };
        toolbar.add((Component)this.m_mzscopeButton);
        return toolbar;
    }

    private void setGraphicTypeToolTip() {
        String tooltipText = "";
        switch (this.m_viewType) {
            case 0: {
                tooltipText = "Display all isotopes for the selected feature";
                break;
            }
            case 1: {
                tooltipText = "Display peaks for this map";
            }
        }
        this.m_graphicsTypeButton.setToolTipText(tooltipText);
    }

    public int getGraphViewType() {
        return this.m_viewType;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_featureScrollPane = new JScrollPane();
        this.m_featureTable = new FeatureTable();
        this.m_featureTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)new FeatureTableModel(this.m_featureTable), true));
        List<Integer> listIdsToHide = ((FeatureTableModel)((CompoundTableModel)this.m_featureTable.getModel()).getBaseModel()).getDefaultColumnsToHide();
        for (Integer id : listIdsToHide) {
            this.m_featureTable.getColumnExt(this.m_featureTable.convertColumnIndexToView(id)).setVisible(false);
        }
        this.m_featureTable.getColumnExt(this.m_featureTable.convertColumnIndexToView(0)).setVisible(false);
        this.m_featureTable.setSortable(false);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_featureScrollPane, (MarkerComponentInterface)this.m_featureTable);
        this.m_featureScrollPane.setViewportView((Component)((Object)this.m_featureTable));
        this.m_featureTable.setFillsViewportHeight(true);
        this.m_featureTable.setViewport(this.m_featureScrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    public void setData(Long taskId, List<DFeature> features, QuantChannelInfo quantChannelInfo, List<Boolean> featureHasPeak, boolean finished) {
        ((FeatureTableModel)((CompoundTableModel)this.m_featureTable.getModel()).getBaseModel()).setData(taskId, features, quantChannelInfo, featureHasPeak);
        if (features == null) {
            this.m_titleLabel.setText(TABLE_TITLE);
            this.m_markerContainerPanel.setMaxLineNumber(0);
        } else {
            this.m_titleLabel.setText("Features (" + features.size() + ")");
            if (features.size() > 0) {
                this.m_featureTable.getSelectionModel().setSelectionInterval(0, 0);
                this.m_markerContainerPanel.setMaxLineNumber(features.size());
            }
            if (finished) {
                this.m_featureTable.setSortable(true);
            }
        }
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.m_featureTable.dataUpdated(subTask, finished);
        if (finished) {
            this.m_featureTable.setSortable(true);
        }
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_featureTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_featureTable;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public DFeature getSelectedFeature() {
        return this.m_featureTable.getSelectedFeature();
    }

    public List<DFeature> getSelectedFeatures() {
        return this.m_featureTable.getSelectedFeatures();
    }

    public Color getPlotColor() {
        return this.m_featureTable.getPlotColor();
    }

    public String getPlotTitle() {
        return this.m_featureTable.getPlotTitle();
    }

    public MzScopeInterface getMzScopeInterface() {
        return (FeatureTableModel)((CompoundTableModel)this.m_featureTable.getModel()).getBaseModel();
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_featureTable;
    }

    public class ExctractXICAction
    extends AbstractTableAction {
        private Logger m_logger;
        private AbstractDataBox m_box;
        private boolean m_all;

        public ExctractXICAction(boolean all) {
            super(all ? "Extract All XIC" : "Extract Selected XIC");
            this.m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
            this.m_all = all;
        }

        public void setBox(AbstractDataBox box) {
            this.m_box = box;
        }

        public void actionPerformed(int col, int row, int[] selectedRows, JTable table) {
            if (this.m_box == null) {
                return;
            }
            final DataboxChildFeature databoxChildFeature = (DataboxChildFeature)this.m_box;
            QuantChannelInfo quantChannelInfo = (QuantChannelInfo)databoxChildFeature.getData(QuantChannelInfo.class);
            DQuantitationChannel[] qChannels = quantChannelInfo.getQuantChannels();
            double ppm = 5.0;
            try {
                Map configMap = quantChannelInfo.getDataset().getQuantProcessingConfigAsMap();
                DQuantitationChannel[] map = (DQuantitationChannel[])configMap.get("cross_assignment_config");
                map = (LinkedHashMap)map.get("ft_mapping_params");
                String mozTolString = (String)map.get("moz_tol");
                ppm = Double.valueOf(mozTolString);
            }
            catch (Exception e) {
                this.m_logger.error(((Object)((Object)this)).getClass().getSimpleName() + " moz_tol not found ", (Throwable)e);
            }
            HashMap<Long, DQuantitationChannel> qChannelMap = new HashMap<Long, DQuantitationChannel>();
            for (DQuantitationChannel qChannel : qChannels) {
                qChannelMap.put(qChannel.getId(), qChannel);
            }
            List featureList = !this.m_all ? XicFeaturePanel.this.getSelectedFeatures() : (List)databoxChildFeature.getData(DFeature.class, ParameterSubtypeEnum.LIST_DATA);
            HashSet<String> identifierFound = new HashSet<String>();
            int size = featureList.size();
            ArrayList<String> rawFileIdentifierList = new ArrayList<String>(size);
            ArrayList<Double> mozList = new ArrayList<Double>(size);
            final ArrayList<DFeature> featuresSearched = new ArrayList<DFeature>(size);
            DMasterQuantPeptideIon masterQuantPeptideIon = databoxChildFeature.getMasterQuantPeptideIon();
            for (int i = 0; i < size; ++i) {
                String rawFileIdentifier;
                DFeature feature = (DFeature)featureList.get(i);
                if (feature.hasPeaks() || identifierFound.contains(rawFileIdentifier = ((DQuantitationChannel)qChannelMap.get(feature.getQuantChannelId())).getRawFileIdentifier())) continue;
                identifierFound.add(rawFileIdentifier);
                for (int rank = 0; rank <= 2; ++rank) {
                    double moz = PeptideClassesUtils.getIsotopMoz((double)masterQuantPeptideIon.getMoz(), (int)masterQuantPeptideIon.getCharge(), (int)rank);
                    rawFileIdentifierList.add(rawFileIdentifier);
                    mozList.add(moz);
                    featuresSearched.add(feature);
                }
            }
            if (featuresSearched.isEmpty()) {
                return;
            }
            final int loadingId = XicFeaturePanel.this.m_loadingXICId++;
            XicFeaturePanel.this.setLoading(loadingId);
            AbstractJMSCallback callback = new AbstractJMSCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success) {
                    if (success) {
                        HashSet<DFeature> features = new HashSet<DFeature>();
                        for (DFeature f : featuresSearched) {
                            features.add(f);
                        }
                        databoxChildFeature.setRetrievedXic(features);
                    }
                    XicFeaturePanel.this.setLoaded(loadingId);
                }
            };
            ExtractChromatogramTask task = new ExtractChromatogramTask(callback, featuresSearched, rawFileIdentifierList, mozList, ppm);
            AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
        }

        public void updateEnabled(int row, int col, int[] selectedRows, JTable table) {
            this.setEnabled(this.m_all || selectedRows != null && selectedRows.length > 0);
        }
    }

    private class FeatureTable
    extends LazyTable
    implements ExportModelInterface {
        String searchTextBeingDone;
        private boolean selectionWillBeRestored;
        private DisplayTablePopupMenu m_popupMenu;

        public FeatureTable() {
            super(XicFeaturePanel.this.m_featureScrollPane.getVerticalScrollBar());
            this.searchTextBeingDone = null;
            this.selectionWillBeRestored = false;
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.selectionWillBeRestored) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            XicFeaturePanel.this.m_dataBox.addDataChanged(Feature.class);
            if (XicFeaturePanel.this.m_viewType == 1) {
                ((DataboxChildFeature)XicFeaturePanel.this.m_dataBox).propagateModelChangeWithoutModifyingZoom();
            } else {
                ((DataboxChildFeature)XicFeaturePanel.this.m_dataBox).propagateDataChanged();
            }
        }

        public boolean selectFeature(Long featureId, String searchText) {
            FeatureTableModel tableModel = (FeatureTableModel)((CompoundTableModel)this.getModel()).getBaseModel();
            int row = tableModel.findRow(featureId);
            if (row == -1) {
                return false;
            }
            row = ((CompoundTableModel)this.getModel()).convertBaseModelRowToCompoundRow(row);
            if (row == -1) {
                return false;
            }
            this.searchTextBeingDone = searchText;
            row = this.convertRowIndexToView(row);
            this.getSelectionModel().setSelectionInterval(row, row);
            this.scrollRowToVisible(row);
            this.searchTextBeingDone = null;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataUpdated(SubTask subTask, boolean finished) {
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    ((FeatureTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).dataUpdated();
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if ((keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) && subTask.getSubTaskId() == ((CompoundTableModel)this.getModel()).getSubTaskId(this.getSortedColumnIndex())) {
                        this.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            if (finished) {
                this.setSortable(true);
            }
        }

        @Override
        public void sortingChanged(int col) {
        }

        public void selectionWillBeRestored(boolean b) {
            this.selectionWillBeRestored = b;
        }

        public int getLoadingPercentage() {
            return XicFeaturePanel.this.m_dataBox.getLoadingPercentage();
        }

        public boolean isLoaded() {
            return XicFeaturePanel.this.m_dataBox.isLoaded();
        }

        public DFeature getSelectedFeature() {
            int selectedRow = this.getSelectedRow();
            if (selectedRow == -1) {
                return null;
            }
            return this.getFeature(selectedRow);
        }

        private DFeature getFeature(int row) {
            CompoundTableModel compoundTableModel = (CompoundTableModel)this.getModel();
            if (compoundTableModel.getRowCount() == 0) {
                return null;
            }
            row = this.convertRowIndexToModel(row);
            row = compoundTableModel.convertCompoundRowToBaseModelRow(row);
            FeatureTableModel tableModel = (FeatureTableModel)compoundTableModel.getBaseModel();
            return tableModel.getFeature(row);
        }

        public ArrayList<DFeature> getSelectedFeatures() {
            int[] selectedRows = this.getSelectedRows();
            if (selectedRows == null || selectedRows.length == 0) {
                return null;
            }
            ArrayList<DFeature> features = new ArrayList<DFeature>(selectedRows.length);
            for (int row : selectedRows) {
                features.add(this.getFeature(row));
            }
            return features;
        }

        public Color getPlotColor() {
            int selectedRow = this.getSelectedRow();
            if (selectedRow == -1) {
                return null;
            }
            CompoundTableModel compoundTableModel = (CompoundTableModel)this.getModel();
            if (compoundTableModel.getRowCount() == 0) {
                return null;
            }
            selectedRow = this.convertRowIndexToModel(selectedRow);
            selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
            FeatureTableModel tableModel = (FeatureTableModel)compoundTableModel.getBaseModel();
            return tableModel.getPlotColor(selectedRow);
        }

        public String getPlotTitle() {
            int selectedRow = this.getSelectedRow();
            if (selectedRow == -1) {
                return null;
            }
            CompoundTableModel compoundTableModel = (CompoundTableModel)this.getModel();
            if (compoundTableModel.getRowCount() == 0) {
                return null;
            }
            selectedRow = this.convertRowIndexToModel(selectedRow);
            selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
            FeatureTableModel tableModel = (FeatureTableModel)compoundTableModel.getBaseModel();
            return tableModel.getPlotTitle(selectedRow);
        }

        public String getExportColumnName(int col) {
            return ((CompoundTableModel)XicFeaturePanel.this.m_featureTable.getModel()).getExportColumnName(this.convertColumnIndexToModel(col));
        }

        public String getExportRowCell(int row, int col) {
            return ((CompoundTableModel)XicFeaturePanel.this.m_featureTable.getModel()).getExportRowCell(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public ArrayList<ExportFontData> getExportFonts(int row, int col) {
            return ((CompoundTableModel)XicFeaturePanel.this.m_featureTable.getModel()).getExportFonts(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public TablePopupMenu initPopupMenu() {
            this.m_popupMenu = new DisplayTablePopupMenu(XicFeaturePanel.this);
            XicFeaturePanel.this.m_extractSelectedXICAction = new ExctractXICAction(false);
            XicFeaturePanel.this.m_extractAlldXICAction = new ExctractXICAction(true);
            this.m_popupMenu.addAction(null);
            this.m_popupMenu.addAction(XicFeaturePanel.this.m_extractSelectedXICAction);
            this.m_popupMenu.addAction(XicFeaturePanel.this.m_extractAlldXICAction);
            return this.m_popupMenu;
        }

        public void prepostPopupMenu() {
            XicFeaturePanel.this.m_extractSelectedXICAction.setBox(XicFeaturePanel.this.m_dataBox);
            XicFeaturePanel.this.m_extractAlldXICAction.setBox(XicFeaturePanel.this.m_dataBox);
            this.m_popupMenu.prepostPopupMenu();
        }
    }
}

