/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic.alignment;

import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.graphics.PlotScatter;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import fr.proline.studio.rsmexplorer.gui.xic.alignment.IonsRTTableModel;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.Color;
import java.awt.Graphics2D;

public class IonsRTScatterPlot
extends PlotScatter {
    private static final int TRANSPARENCY = 70;
    private Color m_color;
    private Color m_highlightColor = new Color(CyclicColorPalette.GRAY_DARK.getRed(), CyclicColorPalette.GRAY_DARK.getGreen(), CyclicColorPalette.GRAY_DARK.getBlue(), 85);
    private boolean m_showCrossAssignedIons = true;
    private StringBuilder m_sBuilder = new StringBuilder();
    private int m_colY;

    public IonsRTScatterPlot(BasePlotPanel plotPanel, ExtendedTableModelInterface compareDataInterface, CrossSelectionInterface crossSelectionInterface, int colX, int colY) {
        super(plotPanel, compareDataInterface, crossSelectionInterface, colX, colY);
        this.m_color = CyclicColorPalette.getColor((int)2, (int)70);
        this.m_colY = colY;
    }

    public void setColor(Color c) {
        this.m_color = new Color(c.getRed(), c.getGreen(), c.getBlue(), 70);
    }

    public void showCrossAssignedIons(boolean showCrossAssignedIons) {
        this.m_showCrossAssignedIons = showCrossAssignedIons;
    }

    public void setYMin(double m_yMin) {
        this.m_yMin = m_yMin;
    }

    public void setYMax(double m_yMax) {
        this.m_yMax = m_yMax;
    }

    public String getToolTipText(double x, double y) {
        int indexFound = this.findPoint(x, y);
        if (indexFound == -1) {
            return null;
        }
        if (((IonsRTTableModel)this.m_compareDataInterface).isCrossAssigned(indexFound, this.m_colY) && !this.m_showCrossAssignedIons) {
            return null;
        }
        String infoValue = ((IonsRTTableModel)this.m_compareDataInterface).getToolTipInfo(indexFound);
        this.m_sBuilder.append(infoValue);
        this.m_sBuilder.append("<BR>");
        this.m_sBuilder.append(this.m_plotPanel.getXAxis().getTitle());
        this.m_sBuilder.append(" : ");
        this.m_sBuilder.append(this.m_plotPanel.getXAxis().getExternalDecimalFormat().format(this.m_dataX[indexFound]));
        this.m_sBuilder.append(" <BR>");
        this.m_sBuilder.append(this.m_plotPanel.getYAxis().getTitle());
        if (this.m_dataY[indexFound] > 0.0) {
            this.m_sBuilder.append("+");
        }
        this.m_sBuilder.append(this.m_plotPanel.getYAxis().getExternalDecimalFormat().format(this.m_dataY[indexFound]));
        String tooltip = this.m_sBuilder.toString();
        this.m_sBuilder.setLength(0);
        return tooltip;
    }

    public void paint(Graphics2D g, XAxis xAxis, YAxis yAxis) {
        int y;
        int x;
        int i;
        int clipX = xAxis.valueToPixel(xAxis.getMinValue());
        int clipWidth = xAxis.valueToPixel(xAxis.getMaxValue()) - clipX;
        int clipY = yAxis.valueToPixel(yAxis.getMaxValue());
        int clipHeight = yAxis.valueToPixel(yAxis.getMinValue()) - clipY;
        g.setClip(clipX, clipY, clipWidth, clipHeight);
        int size = this.m_dataX != null ? this.m_dataX.length : 0;
        for (i = 0; i < size; ++i) {
            if (this.m_selected[i] || Double.isNaN(this.m_dataY[i])) continue;
            x = xAxis.valueToPixel(this.m_dataX[i]) + (this.m_jitterX != null ? this.m_jitterX[i] : 0);
            y = yAxis.valueToPixel(this.m_dataY[i]) + (this.m_jitterY != null ? this.m_jitterY[i] : 0);
            if (((IonsRTTableModel)this.m_compareDataInterface).isCrossAssigned(i, this.m_colY)) {
                if (!this.m_showCrossAssignedIons) continue;
                g.setColor(this.m_highlightColor);
                g.drawOval(x - 3, y - 3, 6, 6);
                continue;
            }
            g.setColor(this.m_color);
            g.fillOval(x - 3, y - 3, 6, 6);
        }
        for (i = 0; i < size; ++i) {
            if (!this.m_selected[i] || Double.isNaN(this.m_dataY[i])) continue;
            x = xAxis.valueToPixel(this.m_dataX[i]) + (this.m_jitterX != null ? this.m_jitterX[i] : 0);
            y = yAxis.valueToPixel(this.m_dataY[i]) + (this.m_jitterY != null ? this.m_jitterY[i] : 0);
            g.setColor(this.m_color);
            if (!((IonsRTTableModel)this.m_compareDataInterface).isCrossAssigned(i, this.m_colY)) {
                g.fillOval(x - 3, y - 3, 6, 6);
                g.setColor(Color.black);
                g.drawOval(x - 3, y - 3, 6, 6);
                continue;
            }
            if (!this.m_showCrossAssignedIons) continue;
            g.setColor(Color.black);
            g.drawOval(x - 3, y - 3, 6, 6);
        }
    }
}

