/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic.alignment;

import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DQuantPeptideIon;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.graphics.PlotInformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class IonsRTTableModel
implements ExtendedTableModelInterface {
    private String m_modelName;
    private Map<Long, Long> m_idMap;
    private long[] m_rsmIdArray;
    private List<IonRTRow> m_data;
    private Map<Long, String> m_idNameMap;
    private String[] m_columnName;
    private static int PEPTIDE_ID = 0;
    private static int PEPTIDE_SEQUENCE = 1;
    private static int CHARGE = 2;
    private static int ELUTION_TIME_FROM = 3;
    private int m_mapCount;

    public List<IonRTRow> getData() {
        return this.m_data;
    }

    public IonsRTTableModel(List<DMasterQuantPeptideIon> m_masterQuantPeptideIonList, Map<Long, Long> idMap, Map<Long, String> idNameMap, long[] rsmIdArray) {
        this.m_mapCount = rsmIdArray.length;
        this.m_idNameMap = idNameMap;
        this.m_idMap = idMap;
        this.m_rsmIdArray = rsmIdArray;
        this.m_data = new ArrayList<IonRTRow>();
        this.m_columnName = new String[rsmIdArray.length + 3];
        this.m_columnName[IonsRTTableModel.PEPTIDE_ID] = "Peptide Id";
        this.m_columnName[IonsRTTableModel.PEPTIDE_SEQUENCE] = "Peptide Sequence";
        this.m_columnName[IonsRTTableModel.CHARGE] = "Charge";
        this.m_columnName[IonsRTTableModel.ELUTION_TIME_FROM] = "Time in Map " + this.m_idNameMap.get(rsmIdArray[0]) + " (min)";
        for (int i = 4; i < rsmIdArray.length + 3; ++i) {
            this.m_columnName[i] = "Delta time in Map " + this.m_idNameMap.get(rsmIdArray[i - 3]) + " (s)";
        }
        for (DMasterQuantPeptideIon masterPep : m_masterQuantPeptideIonList) {
            float[] rTimeTo = new float[this.m_mapCount - 1];
            int[] matchCountTo = new int[rTimeTo.length];
            DPeptideInstance pi = masterPep.getPeptideInstance();
            if (pi == null) continue;
            long peptideId = pi.getPeptideId();
            String peptideSequence = pi.getPeptide().getSequence();
            int charge = masterPep.getCharge();
            Map nbPepInMap = masterPep.getQuantPeptideIonByQchIds();
            if (nbPepInMap == null || nbPepInMap.isEmpty()) continue;
            Long rsmIdFrom = rsmIdArray[0];
            this.m_modelName = idNameMap.get(rsmIdFrom) + " ElutionTime compare table model";
            DQuantPeptideIon element = (DQuantPeptideIon)nbPepInMap.get(rsmIdFrom);
            if (element == null) continue;
            float rTimeFrom = element.getElutionTime().floatValue();
            int matchCountFrom = element.getPeptideMatchesCount();
            for (int i = 1; i < rsmIdArray.length; ++i) {
                float deltaTime;
                DQuantPeptideIon quantPeptideIon = (DQuantPeptideIon)nbPepInMap.get(rsmIdArray[i]);
                if (quantPeptideIon == null) {
                    rTimeTo[i - 1] = Float.NaN;
                    continue;
                }
                rTimeTo[i - 1] = deltaTime = quantPeptideIon.getElutionTime().floatValue() - rTimeFrom;
                matchCountTo[i - 1] = quantPeptideIon.getPeptideMatchesCount();
            }
            this.m_data.add(new IonRTRow(peptideId, peptideSequence, charge, rTimeFrom, rTimeTo, matchCountFrom, matchCountTo));
        }
    }

    public String getInfo(int rowIndex) {
        return this.m_data.get(rowIndex).toString();
    }

    public PlotDataSpec getDataSpecAt(int i) {
        return null;
    }

    public int getRowCount() {
        return this.m_data.size();
    }

    public int getColumnCount() {
        return this.m_columnName.length;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.m_columnName[columnIndex];
    }

    public Class getDataColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Long.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
        }
        return Float.class;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        IonRTRow row = this.m_data.get(rowIndex);
        if (columnIndex == PEPTIDE_ID) {
            return row._peptideId;
        }
        if (columnIndex == PEPTIDE_SEQUENCE) {
            return row._peptideSequence;
        }
        if (columnIndex == CHARGE) {
            return row._charge;
        }
        if (columnIndex == ELUTION_TIME_FROM) {
            return (double)row._eTimeFrom / 60.0;
        }
        if (columnIndex > 3 && columnIndex < this.m_mapCount + 3) {
            return Float.valueOf(row._eTimeTo[columnIndex - 4]);
        }
        if (columnIndex == 3 + this.m_mapCount) {
            return row._MatchCountTo;
        }
        return row._MatchCountTo[columnIndex - 4 - this.m_mapCount];
    }

    public boolean isCrossAssigned(int rowIndex, int colY) {
        IonRTRow row = this.m_data.get(rowIndex);
        int countFrom = row._MatchCountFrom;
        int countTo = row._MatchCountTo[colY - 4];
        return countFrom == 0 || countTo == 0;
    }

    public int getColumnIndex(Long mapId) {
        long rsmId = this.m_idMap.get(mapId);
        for (int i = 0; i < this.m_rsmIdArray.length; ++i) {
            if (this.m_rsmIdArray[i] != rsmId) continue;
            return i + 3;
        }
        return -1;
    }

    public int[] getKeysColumn() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getInfoColumn() {
        return PEPTIDE_SEQUENCE;
    }

    public String getToolTipInfo(int rowIndex) {
        IonRTRow row = this.m_data.get(rowIndex);
        String infoValue = " Peptide id : " + row._peptideId + "<BR>";
        infoValue = infoValue + "Sequence : " + row._peptideSequence + "<BR>";
        infoValue = infoValue + "charge : " + row._charge + "<BR>";
        return infoValue;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        PlotInformation plotInformation = new PlotInformation();
        plotInformation.setPlotTitle("");
        plotInformation.setDrawPoints(true);
        plotInformation.setDrawGap(true);
        return plotInformation;
    }

    public long row2UniqueId(int rowIndex) {
        return rowIndex;
    }

    public int uniqueId2Row(long id) {
        return (int)id;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    public Object getValue(Class c) {
        return null;
    }

    public Object getRowValue(Class c, int row) {
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public void addSingleValue(Object v) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getSingleValue(Class c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected class IonRTRow {
        long _peptideId;
        String _peptideSequence;
        int _charge;
        float _eTimeFrom;
        float[] _eTimeTo;
        int _MatchCountFrom;
        int[] _MatchCountTo;

        public IonRTRow(long peptideId, String peptideSequence, int charge, float eTimeFrom, float[] eTimeTo, int matchCountFrom, int[] matchCountTo) {
            this._peptideId = peptideId;
            this._peptideSequence = peptideSequence;
            this._charge = charge;
            this._eTimeFrom = eTimeFrom;
            this._eTimeTo = eTimeTo;
            this._MatchCountFrom = matchCountFrom;
            this._MatchCountTo = matchCountTo;
        }

        public String toString() {
            String s = "";
            for (float f : this._eTimeTo) {
                s = s + ";" + f;
            }
            return this._peptideId + ";" + this._peptideSequence + ";" + this._charge + ";" + this._eTimeFrom + s;
        }
    }
}

