/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree;

import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.utils.IconManager;
import fr.proline.studio.utils.PropertiesProviderInterface;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openide.nodes.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNode
extends DefaultMutableTreeNode
implements Cloneable,
PropertiesProviderInterface {
    private static Action[] m_actionInstance = null;
    protected NodeTypes m_type;
    protected boolean m_isChanging = false;
    protected boolean m_isDisabled = false;
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");

    public AbstractNode(NodeTypes type, AbstractData data) {
        super(data);
        this.m_type = type;
    }

    public NodeTypes getType() {
        return this.m_type;
    }

    public AbstractNode getLowestAncestor() {
        AbstractNode ancestor = this;
        while (ancestor.getParent() != null && ancestor.getParent().getParent() != null) {
            ancestor = (AbstractNode)ancestor.getParent();
        }
        return ancestor;
    }

    public AbstractData getData() {
        return (AbstractData)this.getUserObject();
    }

    public abstract ImageIcon getIcon(boolean var1);

    public ImageIcon getIcon(IconManager.IconType iconType) {
        if (this.m_isChanging) {
            return IconManager.getIconWithHourGlass((IconManager.IconType)iconType);
        }
        if (this.m_isDisabled) {
            return IconManager.getGrayedIcon((IconManager.IconType)iconType);
        }
        return IconManager.getIcon((IconManager.IconType)iconType);
    }

    public boolean searchChildNodeOfAType(NodeTypes type) {
        return this.m_type == type;
    }

    @Override
    public String toString() {
        AbstractData data = this.getData();
        if (data == null) {
            return "";
        }
        return data.getName();
    }

    public boolean isInTrash() {
        return false;
    }

    public boolean canBeDeleted() {
        return false;
    }

    public void setIsChanging(boolean isChanging) {
        this.m_isChanging = isChanging;
    }

    public boolean isChanging() {
        return this.m_isChanging;
    }

    public void setIsDisabled(boolean isDisabled) {
        this.m_isDisabled = isDisabled;
    }

    public boolean isDisabled() {
        return this.m_isDisabled;
    }

    public String getToolTipText() {
        return null;
    }

    public abstract Sheet createSheet();

    public abstract AbstractNode copyNode();

    public void copyChildren(AbstractNode copyParent) {
        int nbChildren = this.getChildCount();
        for (int i = 0; i < nbChildren; ++i) {
            AbstractNode childCopy;
            AbstractNode childNode = (AbstractNode)this.getChildAt(i);
            if (childNode.isChanging() || (childCopy = childNode.copyNode()) == null) continue;
            copyParent.add(childCopy);
        }
    }

    public static enum NodeTypes {
        TREE_PARENT,
        PROJECT_IDENTIFICATION,
        PROJECT_QUANTITATION,
        DATA_SET,
        DATA_ALL_IMPORTED,
        HOUR_GLASS,
        BIOLOGICAL_SAMPLE,
        BIOLOGICAL_GROUP,
        BIOLOGICAL_SAMPLE_ANALYSIS,
        RUN,
        DATASET_REFERENCE;

    }
}

