/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree.identification;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.uds.Aggregation;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.rsmexplorer.actions.identification.ImportManager;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.HourGlassNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdProjectIdentificationNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdTransferable;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdTransferHandler
extends TransferHandler {
    private Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof IdentificationTree) {
            IdentificationTree tree = (IdentificationTree)c;
            long commonProjectId = -1L;
            AbstractNode[] selectedNodes = tree.getSelectedNodes();
            int nbSelectedNode = selectedNodes.length;
            for (int i = 0; i < nbSelectedNode; ++i) {
                AbstractNode node = selectedNodes[i];
                if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
                    return null;
                }
                if (node.isChanging()) {
                    return null;
                }
                DataSetNode datasetNode = (DataSetNode)node;
                if (datasetNode.isTrash()) {
                    return null;
                }
                long projectId = datasetNode.getDataset().getProject().getId();
                if (commonProjectId == -1L) {
                    commonProjectId = projectId;
                    continue;
                }
                if (commonProjectId == projectId) continue;
                return null;
            }
            ArrayList<AbstractNode> keptNodes = new ArrayList<AbstractNode>(nbSelectedNode);
            keptNodes.add(selectedNodes[0]);
            block1: for (int i = 1; i < nbSelectedNode; ++i) {
                AbstractNode curKeptNode;
                int j;
                AbstractNode curNode = selectedNodes[i];
                int nbKeptNodes = keptNodes.size();
                for (j = 0; j < nbKeptNodes; ++j) {
                    curKeptNode = (AbstractNode)keptNodes.get(j);
                    if (curNode.isNodeAncestor(curKeptNode)) continue block1;
                }
                for (j = nbKeptNodes - 1; j >= 0; --j) {
                    curKeptNode = keptNodes.get(j);
                    if (!curKeptNode.isNodeAncestor(curNode)) continue;
                    keptNodes.remove(j);
                }
                keptNodes.add(curNode);
            }
            int nbKeptNodes = keptNodes.size();
            for (int i = 0; i < nbKeptNodes; ++i) {
                DataSetNode parentDatasetNode;
                AbstractNode curNode = (AbstractNode)keptNodes.get(i);
                AbstractNode parentNode = (AbstractNode)curNode.getParent();
                if (!(parentNode instanceof DataSetNode) || !(parentDatasetNode = (DataSetNode)parentNode).hasResultSet() && !parentDatasetNode.hasResultSummary() && !parentDatasetNode.isChanging()) continue;
                return null;
            }
            IdTransferable.TransferData data = new IdTransferable.TransferData();
            data.setNodeList(keptNodes);
            Integer transferKey = IdTransferable.register(data);
            return new IdTransferable(transferKey, commonProjectId);
        }
        return null;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        IdTransferable.clearRegisteredData();
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        support.setShowDropLocation(true);
        if (support.isDataFlavorSupported(IdTransferable.RSMNodeList_FLAVOR)) {
            long dropProjectId;
            TreePath dropTreePath = ((JTree.DropLocation)support.getDropLocation()).getPath();
            if (dropTreePath == null) {
                return false;
            }
            Object dropComponent = dropTreePath.getLastPathComponent();
            if (!(dropComponent instanceof AbstractNode)) {
                return false;
            }
            AbstractNode dropRSMNode = (AbstractNode)dropComponent;
            if (dropRSMNode.isChanging()) {
                return false;
            }
            AbstractNode.NodeTypes nodeType = dropRSMNode.getType();
            if (nodeType == AbstractNode.NodeTypes.DATA_SET) {
                DataSetNode dropDatasetNode = (DataSetNode)dropRSMNode;
                if (dropDatasetNode.hasResultSet() || dropDatasetNode.hasResultSummary()) {
                    return false;
                }
                dropProjectId = dropDatasetNode.getDataset().getProject().getId();
            } else if (nodeType == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
                IdProjectIdentificationNode dropProjectNode = (IdProjectIdentificationNode)dropRSMNode;
                dropProjectId = dropProjectNode.getProject().getId();
                if (((JTree.DropLocation)support.getDropLocation()).getChildIndex() == 0) {
                    return false;
                }
            } else {
                return false;
            }
            try {
                IdTransferable nodeListTransferable = (IdTransferable)support.getTransferable().getTransferData(IdTransferable.RSMNodeList_FLAVOR);
                if (nodeListTransferable.getProjectId() != dropProjectId) {
                    return false;
                }
                IdTransferable.TransferData data = IdTransferable.getData(nodeListTransferable.getTransferKey());
                if (data.isNodeList()) {
                    ArrayList nodeList = data.getDataList();
                    int nbNodes = nodeList.size();
                    for (int i = 0; i < nbNodes; ++i) {
                        AbstractNode nodeTransfered = (AbstractNode)nodeList.get(i);
                        if (!dropRSMNode.isNodeAncestor(nodeTransfered)) continue;
                        return false;
                    }
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                this.m_logger.error(this.getClass().getSimpleName() + " DnD error ", (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (this.canImport(support)) {
            try {
                IdTransferable transfer = (IdTransferable)support.getTransferable().getTransferData(IdTransferable.RSMNodeList_FLAVOR);
                IdTransferable.TransferData data = IdTransferable.getData(transfer.getTransferKey());
                if (data.isNodeList()) {
                    return this.importNodes(support, data);
                }
                return this.importResultSets(support, data);
            }
            catch (UnsupportedFlavorException | IOException e) {
                this.m_logger.error(this.getClass().getSimpleName() + " DnD error ", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private boolean importResultSets(TransferHandler.TransferSupport support, IdTransferable.TransferData data) {
        AbstractNode lastChild;
        JTree.DropLocation location = (JTree.DropLocation)support.getDropLocation();
        TreePath dropTreePath = location.getPath();
        int childIndex = location.getChildIndex();
        final AbstractNode dropRSMNode = (AbstractNode)dropTreePath.getLastPathComponent();
        final IdentificationTree tree = IdentificationTree.getCurrentTree();
        final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        if (childIndex == -1 && (childIndex = dropRSMNode.getChildCount()) > 0 && (lastChild = (AbstractNode)dropRSMNode.getChildAt(childIndex - 1)) instanceof DataSetNode && ((DataSetNode)lastChild).isTrash()) {
            --childIndex;
        }
        Project project = null;
        DDataset parentDataset = null;
        DataSetNode parentDatasetNode = null;
        if (dropRSMNode.getType() == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
            IdProjectIdentificationNode projectNode = (IdProjectIdentificationNode)dropRSMNode;
            project = projectNode.getProject();
        } else if (dropRSMNode.getType() == AbstractNode.NodeTypes.DATA_SET) {
            parentDatasetNode = (DataSetNode)dropRSMNode;
            project = parentDatasetNode.getDataset().getProject();
            parentDataset = parentDatasetNode.getDataset();
        }
        ArrayList rsetList = data.getDataList();
        final int nbRset = rsetList.size();
        final AtomicInteger counter = new AtomicInteger(0);
        for (int i = 0; i < nbRset; ++i) {
            ResultSet rset = (ResultSet)rsetList.get(i);
            String datasetName = rset.getMsiSearch().getResultFileName();
            int indexOfDot = datasetName.lastIndexOf(46);
            if (indexOfDot != -1) {
                datasetName = datasetName.substring(0, indexOfDot);
            }
            DataSetData identificationData = DataSetData.createTemporaryIdentification((String)datasetName);
            final DataSetNode identificationNode = new DataSetNode((AbstractData)identificationData);
            identificationNode.setIsChanging(true);
            treeModel.insertNodeInto(identificationNode, dropRSMNode, childIndex);
            ++childIndex;
            final ArrayList createdDatasetList = new ArrayList();
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    identificationNode.setIsChanging(false);
                    counter.getAndIncrement();
                    if (success) {
                        DDataset dataset = (DDataset)createdDatasetList.get(0);
                        identificationNode.setIsChanging(false);
                        ((DataSetData)identificationNode.getData()).setDataset(dataset);
                        treeModel.nodeChanged(identificationNode);
                        ImportManager.importRenaming(dataset, identificationNode, tree);
                    } else {
                        treeModel.removeNodeFromParent(identificationNode);
                    }
                    if (counter.get() == nbRset) {
                        LinkedHashMap databaseObjectsToModify = new LinkedHashMap();
                        int nbChildren = dropRSMNode.getChildCount();
                        ArrayList<DDataset> datasetList = new ArrayList<DDataset>(nbChildren);
                        for (int i = 0; i < nbChildren; ++i) {
                            AbstractNode childNode = (AbstractNode)dropRSMNode.getChildAt(i);
                            if (childNode.getType() != AbstractNode.NodeTypes.DATA_SET) continue;
                            DataSetNode childDatasetNode = (DataSetNode)childNode;
                            DDataset dataset = childDatasetNode.getDataset();
                            datasetList.add(dataset);
                        }
                        Project databaseParentObject = dropRSMNode.getType() == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION ? ((IdProjectIdentificationNode)dropRSMNode).getProject() : ((DataSetNode)dropRSMNode).getDataset();
                        databaseObjectsToModify.put(databaseParentObject, datasetList);
                        DatabaseDataSetTask.updateDatasetAndProjectsTree(databaseObjectsToModify, (boolean)true);
                    }
                }
            };
            DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
            task.initCreateDatasetForIdentification(project, parentDataset, Aggregation.ChildNature.SAMPLE_ANALYSIS, datasetName, Long.valueOf(rset.getId()), null, createdDatasetList, new TaskInfo("Create Dataset " + datasetName, true, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
        }
        return true;
    }

    private boolean importNodes(TransferHandler.TransferSupport support, IdTransferable.TransferData data) {
        AbstractNode lastChild;
        JTree.DropLocation location = (JTree.DropLocation)support.getDropLocation();
        TreePath dropTreePath = location.getPath();
        int childIndex = location.getChildIndex();
        AbstractNode dropRSMNode = (AbstractNode)dropTreePath.getLastPathComponent();
        IdentificationTree tree = IdentificationTree.getCurrentTree();
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        if (childIndex == -1 && (childIndex = dropRSMNode.getChildCount()) > 0 && (lastChild = (AbstractNode)dropRSMNode.getChildAt(childIndex - 1)) instanceof DataSetNode && ((DataSetNode)lastChild).isTrash()) {
            --childIndex;
        }
        LinkedHashSet<AbstractNode> allParentNodeModified = new LinkedHashSet<AbstractNode>();
        ArrayList nodeList = data.getDataList();
        int nbNodes = nodeList.size();
        for (int i = 0; i < nbNodes; ++i) {
            AbstractNode node = (AbstractNode)nodeList.get(i);
            if (dropRSMNode.isNodeChild(node)) {
                int indexChild = dropRSMNode.getIndex(node);
                if (indexChild < childIndex) {
                    --childIndex;
                }
            } else {
                allParentNodeModified.add((AbstractNode)node.getParent());
            }
            treeModel.removeNodeFromParent(node);
            treeModel.insertNodeInto(node, dropRSMNode, childIndex);
            ++childIndex;
        }
        allParentNodeModified.add(dropRSMNode);
        LinkedHashMap databaseObjectsToModify = new LinkedHashMap();
        for (AbstractNode parentNode : allParentNodeModified) {
            DDataset databaseParentObject = null;
            AbstractNode.NodeTypes type = parentNode.getType();
            if (type == AbstractNode.NodeTypes.DATA_SET) {
                DataSetNode datasetNode = (DataSetNode)parentNode;
                databaseParentObject = datasetNode.getDataset();
            } else if (type == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
                IdProjectIdentificationNode projectNode = (IdProjectIdentificationNode)parentNode;
                databaseParentObject = projectNode.getProject();
            }
            int nbChildren = parentNode.getChildCount();
            ArrayList<DDataset> datasetList = new ArrayList<DDataset>(nbChildren);
            for (int i = 0; i < nbChildren; ++i) {
                AbstractNode childNode = (AbstractNode)parentNode.getChildAt(i);
                if (!(childNode instanceof DataSetNode)) {
                    if (!(childNode instanceof HourGlassNode)) continue;
                    datasetList.add(null);
                    continue;
                }
                DataSetNode childDatasetNode = (DataSetNode)childNode;
                DDataset dataset = childDatasetNode.getDataset();
                datasetList.add(dataset);
            }
            databaseObjectsToModify.put(databaseParentObject, datasetList);
        }
        DatabaseDataSetTask.updateDatasetAndProjectsTree(databaseObjectsToModify, (boolean)true);
        return true;
    }
}

