/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree.quantitation;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.data.ProjectQuantitationData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.actions.identification.ChangeTypicalProteinJMSAction;
import fr.proline.studio.rsmexplorer.actions.identification.CreateQuantitationAction;
import fr.proline.studio.rsmexplorer.actions.identification.DeleteAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayRsetAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayRsmAction;
import fr.proline.studio.rsmexplorer.actions.identification.EmptyTrashAction;
import fr.proline.studio.rsmexplorer.actions.identification.ExportAction;
import fr.proline.studio.rsmexplorer.actions.identification.ExportDatasetJMSAction;
import fr.proline.studio.rsmexplorer.actions.identification.GenerateSpectrumMatchesJMSAction;
import fr.proline.studio.rsmexplorer.actions.identification.IdentifyPtmSitesJMSAction;
import fr.proline.studio.rsmexplorer.actions.identification.PropertiesAction;
import fr.proline.studio.rsmexplorer.actions.identification.QuantifyAction;
import fr.proline.studio.rsmexplorer.actions.identification.RenameAction;
import fr.proline.studio.rsmexplorer.actions.identification.RetrieveBioSeqJMSAction;
import fr.proline.studio.rsmexplorer.actions.xic.AddQuantitationFolderAction;
import fr.proline.studio.rsmexplorer.actions.xic.AggregateQuantitationsAction;
import fr.proline.studio.rsmexplorer.actions.xic.ComputeQuantPostProcessingAction;
import fr.proline.studio.rsmexplorer.actions.xic.DisplayExperimentalDesignAction;
import fr.proline.studio.rsmexplorer.actions.xic.DisplayXICAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.ChildFactory;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.HourGlassNode;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantiTransferHandler;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantitationProjectNode;
import fr.proline.studio.rsmexplorer.tree.xic.DatasetReferenceNode;
import fr.proline.studio.rsmexplorer.tree.xic.QuantExperimentalDesignTree;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalGroupNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleAnalysisNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICRunNode;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class QuantitationTree
extends AbstractTree
implements TreeWillExpandListener {
    private final boolean m_isMainTree;
    private static final HashMap<ProjectQuantitationData, QuantitationTree> m_treeMap = new HashMap();
    private static QuantitationTree m_currentTree = null;
    private boolean m_loadingDone = false;
    private JPopupMenu m_rootPopup;
    private ArrayList<AbstractRSMAction> m_rootActions;
    private JPopupMenu m_mainPopup;
    private JPopupMenu m_multiPopup;
    private ArrayList<AbstractRSMAction> m_multiActions;
    private ArrayList<AbstractRSMAction> m_mainActions;
    private JPopupMenu m_trashPopup;
    private ArrayList<AbstractRSMAction> m_trashActions;
    private JPopupMenu m_identPopup;
    private ArrayList<AbstractRSMAction> m_identActions;

    public static QuantitationTree getTree(ProjectQuantitationData projectData) {
        QuantitationTree tree = m_treeMap.get(projectData);
        if (tree == null) {
            tree = new QuantitationTree(projectData);
            m_treeMap.put(projectData, tree);
        }
        m_currentTree = tree;
        return tree;
    }

    private QuantitationTree(ProjectQuantitationData projectData) {
        this.setEditable(true);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        QuantiTransferHandler handler = new QuantiTransferHandler();
        this.setTransferHandler(handler);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.m_isMainTree = true;
        AbstractNode top = ChildFactory.createNode((AbstractData)projectData);
        this.initTree(top);
        this.startLoading(top, false);
    }

    @Override
    protected final void initTree(AbstractNode top) {
        super.initTree(top);
        this.addTreeWillExpandListener(this);
    }

    public static QuantitationTree getCurrentTree() {
        return m_currentTree;
    }

    @Override
    public void rename(AbstractNode rsmNode, String newName) {
        if (rsmNode.getType().equals((Object)AbstractNode.NodeTypes.DATA_SET)) {
            ((DataSetNode)rsmNode).rename(newName, QuantitationTree.getCurrentTree());
        }
    }

    private void triggerPopup(MouseEvent e) {
        DisplayRsmAction displayRsmAction;
        ArrayList<AbstractRSMAction> actions;
        JPopupMenu popup;
        AbstractNode[] selectedNodes = this.getSelectedNodes();
        int nbNodes = selectedNodes.length;
        if (nbNodes == 0) {
            return;
        }
        AbstractNode n = selectedNodes[0];
        boolean isRootPopup = n.isRoot();
        boolean isAggregationDataSet = false;
        AbstractNode parentNode = (AbstractNode)n.getParent();
        if (parentNode != null && parentNode instanceof DatasetReferenceNode) {
            isAggregationDataSet = true;
        }
        boolean trashNodeSelected = false;
        if (n instanceof DataSetNode) {
            DataSetNode datasetNode = (DataSetNode)n;
            if (datasetNode.isTrash()) {
                trashNodeSelected = true;
            } else if (datasetNode.isInTrash()) {
                return;
            }
        }
        boolean xicSampleAnalysisNodeSelected = false;
        for (int i = 0; i < nbNodes; ++i) {
            if (selectedNodes[i].isChanging()) {
                return;
            }
            if (selectedNodes[i] instanceof XICBiologicalGroupNode || selectedNodes[i] instanceof XICBiologicalSampleNode || selectedNodes[i] instanceof XICRunNode) {
                return;
            }
            if (!(selectedNodes[i] instanceof XICBiologicalSampleAnalysisNode)) continue;
            xicSampleAnalysisNodeSelected = true;
        }
        if (nbNodes > 1 && !xicSampleAnalysisNodeSelected) {
            if (this.m_multiPopup == null) {
                this.m_multiActions = new ArrayList(5);
                AggregateQuantitationsAction aggregateAction = new AggregateQuantitationsAction(this);
                this.m_multiActions.add(aggregateAction);
                ComputeQuantPostProcessingAction computePTMAction = new ComputeQuantPostProcessingAction(this);
                this.m_multiActions.add(computePTMAction);
                this.m_multiActions.add(null);
                ExportDatasetJMSAction exportDatasetAction = new ExportDatasetJMSAction(this, true);
                this.m_multiActions.add(exportDatasetAction);
                RetrieveBioSeqJMSAction retrieveBioSeqAction = new RetrieveBioSeqJMSAction(this);
                this.m_multiActions.add(retrieveBioSeqAction);
                this.m_multiActions.add(null);
                PropertiesAction propertiesAction = new PropertiesAction(this);
                this.m_multiActions.add(propertiesAction);
            }
            this.m_multiPopup = new JPopupMenu();
            for (int i = 0; i < this.m_multiActions.size(); ++i) {
                AbstractRSMAction action = this.m_multiActions.get(i);
                if (action == null) {
                    this.m_multiPopup.addSeparator();
                    continue;
                }
                this.m_multiPopup.add(action.getPopupPresenter());
            }
            popup = this.m_multiPopup;
            actions = this.m_multiActions;
        } else if (isRootPopup) {
            if (this.m_rootPopup == null) {
                this.m_rootActions = new ArrayList(1);
                QuantifyAction quantifyAction = new QuantifyAction(this);
                this.m_rootActions.add(quantifyAction);
                AddQuantitationFolderAction addFolderAction = new AddQuantitationFolderAction(this);
                this.m_rootActions.add(addFolderAction);
                this.m_rootPopup = new JPopupMenu();
                for (int i = 0; i < this.m_rootActions.size(); ++i) {
                    AbstractRSMAction action = this.m_rootActions.get(i);
                    if (action == null) {
                        this.m_rootPopup.addSeparator();
                        continue;
                    }
                    this.m_rootPopup.add(action.getPopupPresenter());
                }
            }
            popup = this.m_rootPopup;
            actions = this.m_rootActions;
        } else if (trashNodeSelected) {
            if (this.m_trashPopup == null) {
                this.m_trashActions = new ArrayList(1);
                EmptyTrashAction emtpyTrashAction = new EmptyTrashAction(this);
                this.m_trashActions.add(emtpyTrashAction);
                this.m_trashPopup = new JPopupMenu();
                this.m_trashPopup.add(emtpyTrashAction.getPopupPresenter());
            }
            popup = this.m_trashPopup;
            actions = this.m_trashActions;
        } else if (xicSampleAnalysisNodeSelected) {
            if (this.m_identPopup == null) {
                this.m_identActions = new ArrayList(6);
                DisplayRsetAction displayRsetAction = new DisplayRsetAction(this);
                this.m_identActions.add(displayRsetAction);
                displayRsmAction = new DisplayRsmAction(this);
                this.m_identActions.add(displayRsmAction);
                this.m_identActions.add(null);
                ExportAction exportAction = new ExportAction(this);
                this.m_identActions.add(exportAction);
                this.m_identActions.add(null);
                PropertiesAction propertiesAction = new PropertiesAction(this);
                this.m_identActions.add(propertiesAction);
                this.m_identPopup = new JPopupMenu();
                for (int i = 0; i < this.m_identActions.size(); ++i) {
                    AbstractRSMAction action = this.m_identActions.get(i);
                    if (action == null) {
                        this.m_identPopup.addSeparator();
                        continue;
                    }
                    this.m_identPopup.add(action.getPopupPresenter());
                }
            }
            popup = this.m_identPopup;
            actions = this.m_identActions;
        } else {
            if (nbNodes == 1 && isAggregationDataSet) {
                return;
            }
            if (this.m_mainPopup == null) {
                this.m_mainActions = new ArrayList(20);
                DisplayXICAction displayXICAction = new DisplayXICAction(this);
                this.m_mainActions.add(displayXICAction);
                displayRsmAction = new DisplayRsmAction(this);
                this.m_mainActions.add(displayRsmAction);
                DisplayExperimentalDesignAction expDesignAction = new DisplayExperimentalDesignAction(this);
                this.m_mainActions.add(expDesignAction);
                this.m_mainActions.add(null);
                AddQuantitationFolderAction addFolderAction = new AddQuantitationFolderAction(this);
                this.m_mainActions.add(addFolderAction);
                RenameAction renameQuantitationAction = new RenameAction(this);
                this.m_mainActions.add(renameQuantitationAction);
                DeleteAction deleteAction = new DeleteAction(this);
                this.m_mainActions.add(deleteAction);
                this.m_mainActions.add(null);
                ComputeQuantPostProcessingAction computeQuantPostProcessingAction = new ComputeQuantPostProcessingAction(this);
                this.m_mainActions.add(computeQuantPostProcessingAction);
                CreateQuantitationAction createXICAction = new CreateQuantitationAction((AbstractTree)this, true);
                this.m_mainActions.add(createXICAction);
                this.m_mainActions.add(null);
                ChangeTypicalProteinJMSAction changeTypicalProteinJmsAction = new ChangeTypicalProteinJMSAction(this);
                this.m_mainActions.add(changeTypicalProteinJmsAction);
                IdentifyPtmSitesJMSAction identifyPtmSitesAction = new IdentifyPtmSitesJMSAction(this);
                this.m_mainActions.add(identifyPtmSitesAction);
                GenerateSpectrumMatchesJMSAction generateSpectrumMatchesAction = new GenerateSpectrumMatchesJMSAction(this);
                this.m_mainActions.add(generateSpectrumMatchesAction);
                RetrieveBioSeqJMSAction retrieveBioSeqAction = new RetrieveBioSeqJMSAction(this);
                this.m_mainActions.add(retrieveBioSeqAction);
                this.m_mainActions.add(null);
                ExportAction exportAction = new ExportAction(this);
                this.m_mainActions.add(exportAction);
                this.m_mainActions.add(null);
                PropertiesAction propertiesAction = new PropertiesAction(this);
                this.m_mainActions.add(propertiesAction);
                this.m_mainPopup = new JPopupMenu();
                for (int i = 0; i < this.m_mainActions.size(); ++i) {
                    AbstractRSMAction action = this.m_mainActions.get(i);
                    if (action == null) {
                        this.m_mainPopup.addSeparator();
                        continue;
                    }
                    this.m_mainPopup.add(action.getPopupPresenter());
                }
            }
            popup = this.m_mainPopup;
            actions = this.m_mainActions;
        }
        for (AbstractRSMAction action : actions) {
            if (action == null) continue;
            action.updateEnabled(selectedNodes);
        }
        popup.show((JComponent)e.getSource(), e.getX(), e.getY());
    }

    public static void reinitMainPopup() {
        Iterator<ProjectQuantitationData> it = m_treeMap.keySet().iterator();
        while (it.hasNext()) {
            QuantitationTree tree = m_treeMap.get(it.next());
            tree.m_mainPopup = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.manageSelectionOnRightClick(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.m_isMainTree && SwingUtilities.isRightMouseButton(e)) {
            this.manageSelectionOnRightClick(e);
            this.triggerPopup(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        AbstractNode childNode;
        TreePath path = event.getPath();
        AbstractNode nodeExpanded = (AbstractNode)path.getLastPathComponent();
        if (nodeExpanded.getChildCount() > 0 && (childNode = (AbstractNode)nodeExpanded.getChildAt(0)).getType() == AbstractNode.NodeTypes.HOUR_GLASS) {
            this.startLoading(nodeExpanded, false);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    public void startLoading() {
        if (this.m_loadingDone) {
            return;
        }
        this.m_loadingDone = true;
        AbstractNode root = (AbstractNode)this.m_model.getRoot();
        this.m_model.insertNodeInto(new HourGlassNode(null), root, 0);
        this.expandRow(0);
    }

    public void removeRootChildren() {
        this.m_loadingDone = false;
        AbstractNode root = (AbstractNode)this.m_model.getRoot();
        root.removeAllChildren();
        this.m_model.nodeStructureChanged(root);
    }

    @Override
    public boolean isPathEditable(TreePath path) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            return false;
        }
        if (this.isEditable()) {
            if (path.getPathCount() == 1) {
                return false;
            }
            AbstractNode node = (AbstractNode)path.getLastPathComponent();
            AbstractNode.NodeTypes nodeType = node.getType();
            if (nodeType == AbstractNode.NodeTypes.DATA_SET) {
                DataSetNode dataSetNode = (DataSetNode)node;
                return !dataSetNode.isInTrash() && !dataSetNode.isChanging();
            }
        }
        return false;
    }

    public void moveToTrash(AbstractNode[] selectedNodes) {
        int nbSelectedNode = selectedNodes.length;
        if (nbSelectedNode == 0) {
            return;
        }
        ArrayList<AbstractNode> keptNodes = new ArrayList<AbstractNode>(nbSelectedNode);
        keptNodes.add(selectedNodes[0]);
        block0: for (int i = 1; i < nbSelectedNode; ++i) {
            AbstractNode curKeptNode;
            int j;
            AbstractNode curNode = selectedNodes[i];
            int nbKeptNodes = keptNodes.size();
            for (j = 0; j < nbKeptNodes; ++j) {
                curKeptNode = (AbstractNode)keptNodes.get(j);
                if (curNode.isNodeAncestor(curKeptNode)) continue block0;
            }
            for (j = nbKeptNodes - 1; j >= 0; --j) {
                curKeptNode = (AbstractNode)keptNodes.get(j);
                if (!curKeptNode.isNodeAncestor(curNode)) continue;
                keptNodes.remove(j);
            }
            keptNodes.add(curNode);
        }
        QuantitationProjectNode projectNode = null;
        for (AbstractNode parentNodeCur = (AbstractNode)((AbstractNode)keptNodes.get(0)).getParent(); parentNodeCur != null; parentNodeCur = (AbstractNode)parentNodeCur.getParent()) {
            if (!(parentNodeCur instanceof QuantitationProjectNode)) continue;
            projectNode = (QuantitationProjectNode)parentNodeCur;
            break;
        }
        if (projectNode == null) {
            return;
        }
        DataSetNode trash = null;
        int nbChildren = projectNode.getChildCount();
        for (int i = nbChildren - 1; i >= 0; --i) {
            DataSetNode datasetNode;
            AbstractNode childNode = (AbstractNode)projectNode.getChildAt(i);
            if (!(childNode instanceof DataSetNode) || !(datasetNode = (DataSetNode)childNode).isTrash()) continue;
            trash = datasetNode;
            break;
        }
        if (trash == null) {
            return;
        }
        LinkedHashSet<AbstractNode> allParentNodeModified = new LinkedHashSet<AbstractNode>();
        int nbKeptNodes = keptNodes.size();
        for (int i = 0; i < nbKeptNodes; ++i) {
            AbstractNode nodeCur = (AbstractNode)keptNodes.get(i);
            allParentNodeModified.add((AbstractNode)nodeCur.getParent());
            this.m_model.removeNodeFromParent(nodeCur);
            this.m_model.insertNodeInto(nodeCur, trash, trash.getChildCount());
        }
        allParentNodeModified.add(trash);
        LinkedHashMap databaseObjectsToModify = new LinkedHashMap();
        for (AbstractNode parentNode : allParentNodeModified) {
            DDataset databaseParentObject = null;
            AbstractNode.NodeTypes type = parentNode.getType();
            if (type == AbstractNode.NodeTypes.DATA_SET) {
                DataSetNode datasetNode = (DataSetNode)parentNode;
                databaseParentObject = datasetNode.getDataset();
            } else if (type == AbstractNode.NodeTypes.PROJECT_QUANTITATION) {
                QuantitationProjectNode projectNodeS = (QuantitationProjectNode)parentNode;
                databaseParentObject = projectNodeS.getProject();
            }
            int nb = parentNode.getChildCount();
            ArrayList<DDataset> datasetList = new ArrayList<DDataset>(nb);
            for (int i = 0; i < nb; ++i) {
                AbstractNode childNode = (AbstractNode)parentNode.getChildAt(i);
                if (childNode instanceof DataSetNode) {
                    DDataset dataset = ((DataSetNode)childNode).getDataset();
                    datasetList.add(dataset);
                    continue;
                }
                if (!(childNode instanceof HourGlassNode)) continue;
            }
            databaseObjectsToModify.put(databaseParentObject, datasetList);
        }
        DatabaseDataSetTask.updateDatasetAndProjectsTree(databaseObjectsToModify, (boolean)false);
    }

    private DataSetNode getTrashNode() {
        QuantitationProjectNode projectNode = null;
        TreeNode root = (TreeNode)this.m_model.getRoot();
        if (root instanceof QuantitationProjectNode) {
            projectNode = (QuantitationProjectNode)root;
        }
        if (projectNode == null) {
            return null;
        }
        DataSetNode trash = null;
        int nbChildren = projectNode.getChildCount();
        for (int i = nbChildren - 1; i >= 0; --i) {
            DataSetNode datasetNode;
            AbstractNode childNode = (AbstractNode)projectNode.getChildAt(i);
            if (!(childNode instanceof DataSetNode) || !(datasetNode = (DataSetNode)childNode).isTrash()) continue;
            trash = datasetNode;
            break;
        }
        if (trash == null) {
            return null;
        }
        return trash;
    }

    public void loadTrash() {
        DataSetNode trashNode = this.getTrashNode();
        if (trashNode != null) {
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return false;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                }
            };
            QuantitationTree.getCurrentTree().loadInBackground(trashNode, callback);
        }
    }

    public void loadInBackground(AbstractNode nodeToLoad, final AbstractDatabaseCallback parentCallback) {
        if (nodeToLoad.getChildCount() == 0) {
            parentCallback.run(true, 0L, null, true);
            return;
        }
        AbstractNode childNode = (AbstractNode)nodeToLoad.getChildAt(0);
        if (childNode.getType() != AbstractNode.NodeTypes.HOUR_GLASS) {
            parentCallback.run(true, 0L, null, true);
            return;
        }
        this.m_loadingMap.put(nodeToLoad.getData(), nodeToLoad);
        final ArrayList childrenList = new ArrayList();
        final AbstractData parentData = nodeToLoad.getData();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return false;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        QuantitationTree.this.dataLoaded(parentData, childrenList);
                        parentCallback.run(true, 0L, null, true);
                    }
                });
            }
        };
        parentData.load(callback, childrenList, false);
    }

    public int getQuantitationChildCount() {
        AbstractNode root = (AbstractNode)this.m_model.getRoot();
        int nbC = root.getChildCount();
        int nb = 0;
        for (int i = 0; i < nbC; ++i) {
            DataSetNode dsnode;
            TreeNode tnode = root.getChildAt(i);
            if (!(tnode instanceof DataSetNode) || !(dsnode = (DataSetNode)tnode).isQuantitation()) continue;
            ++nb;
        }
        return nb;
    }

    public AbstractNode getQuantitationNode(int index) {
        AbstractNode root = (AbstractNode)this.m_model.getRoot();
        int nbC = root.getChildCount();
        for (int i = 0; i < nbC; ++i) {
            TreeNode tnode = root.getChildAt(i);
            if (!(tnode instanceof DataSetNode) || index != i) continue;
            return (AbstractNode)tnode;
        }
        return null;
    }

    public void clearQuantiSelection() {
        this.clearSelection();
    }

    public void selectQuantiNodeWithId(List<Long> listIds) {
        AbstractNode root = (AbstractNode)this.m_model.getRoot();
        int nbC = root.getChildCount();
        for (int i = 0; i < nbC; ++i) {
            DataSetNode dsnode;
            DDataset dataset;
            TreeNode tnode = root.getChildAt(i);
            if (!(tnode instanceof DataSetNode) || !listIds.contains((dataset = (dsnode = (DataSetNode)tnode).getDataset()).getId())) continue;
            this.addSelectionRow(i + 1);
        }
        QuantitationTree.getCurrentTree().updateUI();
    }

    public AbstractNode copyCurrentNodeForSelection() {
        AbstractNode[] nodes = this.getSelectedNodes();
        if (nodes != null && nodes.length > 0) {
            return nodes[0].copyNode();
        }
        return null;
    }

    @Override
    protected void dataLoaded(AbstractData data, List<AbstractData> list) {
        AbstractNode parentNode = (AbstractNode)this.m_loadingMap.remove(data);
        parentNode.remove(0);
        int indexToInsert = 0;
        for (AbstractData dataCur : list) {
            parentNode.insert(ChildFactory.createNode(dataCur), indexToInsert);
            ++indexToInsert;
        }
        this.m_model.nodeStructureChanged(parentNode);
        if (parentNode instanceof DataSetNode && ((DataSetNode)parentNode).isQuantXIC()) {
            QuantExperimentalDesignTree.displayExperimentalDesign(((DataSetNode)parentNode).getDataset(), parentNode, this, false, true);
        }
    }

    public DataSetNode createQuantitationNode(String name) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.getModel();
        DataSetData quantitationData = DataSetData.createTemporaryQuantitation((String)name);
        DataSetNode quantitationNode = new DataSetNode((AbstractData)quantitationData);
        quantitationNode.setIsChanging(true);
        AbstractNode rootNode = (AbstractNode)treeModel.getRoot();
        treeModel.insertNodeInto(quantitationNode, rootNode, rootNode.getChildCount() - 1);
        this.expandNodeIfNeeded(rootNode);
        return quantitationNode;
    }

    public void loadDataSet(Long quantiDatasetId, final DataSetNode datasetNode) {
        final ArrayList readDatasetList = new ArrayList(1);
        final QuantitationTree tree = QuantitationTree.getCurrentTree();
        final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        AbstractDatabaseCallback readDatasetCallback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (success) {
                    final DDataset ds = (DDataset)readDatasetList.get(0);
                    AbstractDatabaseCallback loadQCallback = new AbstractDatabaseCallback(){

                        public boolean mustBeCalledInAWT() {
                            return true;
                        }

                        public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                            ((DataSetData)datasetNode.getData()).setDataset(ds);
                            if (datasetNode instanceof DataSetNode && datasetNode.isQuantXIC()) {
                                QuantExperimentalDesignTree.displayExperimentalDesign(datasetNode.getDataset(), datasetNode, tree, false, true);
                            }
                            datasetNode.setIsChanging(false);
                            treeModel.nodeChanged(datasetNode);
                        }
                    };
                    DatabaseDataSetTask loadQTask = new DatabaseDataSetTask(loadQCallback);
                    loadQTask.initLoadQuantitation(ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject(), ds);
                    AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)loadQTask);
                } else {
                    treeModel.removeNodeFromParent(datasetNode);
                }
            }
        };
        DatabaseDataSetTask task = new DatabaseDataSetTask(readDatasetCallback);
        task.initLoadDataset(quantiDatasetId, readDatasetList);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }
}

