/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree.xic;

import fr.proline.core.orm.uds.BiologicalGroup;
import fr.proline.core.orm.uds.BiologicalSample;
import fr.proline.core.orm.uds.QuantitationChannel;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.gui.DefaultFloatingPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.aggregation.DQuantitationChannelMapping;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.xic.QuantExperimentalDesignTree;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalGroupNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleAnalysisNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICSelectionTransferable;
import fr.proline.studio.utils.IconManager;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.openide.util.Exceptions;

public class QuantAggregateExperimentalTreePanel
extends JPanel {
    private AssociatedQuantExperimentalDesignTree m_tree;
    private ChannelPanel m_channelPanel;
    private DefaultFloatingPanel m_floattingButtonsPanel;
    private JTabbedPane m_tabbedPane;
    private ActionListener m_eraseAction;
    private ActionListener m_moveUpAction;
    private ActionListener m_moveDownAction;
    private List<DDataset> m_datasets;
    private Map<XICBiologicalSampleAnalysisNode, DQuantitationChannelMapping> m_parentQCMappings;
    private static final int COLUMN_WIDTH_MIN = 100;
    private static final int COLUMN_WIDTH_MAX = 300;
    private static final int PAD = 14;
    private static final BasicStroke STROKE_1 = new BasicStroke(1.0f);
    private static final BasicStroke STROKE_2 = new BasicStroke(2.0f);
    private static final Color SELECTION_COLOR = UIManager.getColor("Table.selectionBackground");

    public QuantAggregateExperimentalTreePanel(AbstractNode rootNode, List<DDataset> datasets) {
        this.m_datasets = datasets;
        this.m_parentQCMappings = this.inferDefaultMapping(rootNode);
        JComponent treePanel = this.createTreePanel(rootNode);
        this.createTabbedPane();
        JScrollPane leftScrollPane = new JScrollPane();
        leftScrollPane.setViewportView(treePanel);
        JScrollPane rightScrollPane = new JScrollPane();
        rightScrollPane.setViewportView(this.m_tabbedPane);
        this.setLayout(new BorderLayout());
        JSplitPane sp = new JSplitPane();
        sp.setLeftComponent(leftScrollPane);
        sp.setRightComponent(rightScrollPane);
        sp.setDividerLocation(0.7);
        sp.setResizeWeight(0.5);
        this.add((Component)sp, "Center");
    }

    private void createTabbedPane() {
        this.m_tabbedPane = new JTabbedPane();
        this.setMapping(this.m_datasets);
        this.m_tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                QuantAggregateExperimentalTreePanel.this.m_channelPanel.clearSelection();
            }
        });
    }

    private JComponent createTreePanel(AbstractNode rootNode) {
        this.m_tree = new AssociatedQuantExperimentalDesignTree(rootNode);
        this.m_channelPanel = new ChannelPanel();
        this.m_floattingButtonsPanel = this.createButtonsPanel();
        this.m_tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = QuantAggregateExperimentalTreePanel.this.m_tree.getRowForLocation(e.getX(), e.getY());
                if (row == -1) {
                    QuantAggregateExperimentalTreePanel.this.m_tree.clearSelection();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (QuantAggregateExperimentalTreePanel.this.m_tree.getSelectionCount() > 0) {
                    QuantAggregateExperimentalTreePanel.this.m_channelPanel.clearSelection();
                } else {
                    QuantAggregateExperimentalTreePanel.this.m_channelPanel.repaint();
                }
            }
        });
        this.m_tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                QuantAggregateExperimentalTreePanel.this.m_channelPanel.treeChanged(false);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                QuantAggregateExperimentalTreePanel.this.m_channelPanel.treeChanged(false);
            }
        });
        this.m_tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                QuantAggregateExperimentalTreePanel.this.m_channelPanel.treeChanged(false);
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                QuantAggregateExperimentalTreePanel.this.m_channelPanel.treeChanged(true);
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                QuantAggregateExperimentalTreePanel.this.m_channelPanel.treeChanged(true);
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                QuantAggregateExperimentalTreePanel.this.m_channelPanel.treeChanged(true);
            }
        });
        final JPanel treePanel = new JPanel();
        treePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        treePanel.add((Component)this.m_tree, c);
        ++c.gridx;
        c.weightx = 1.0;
        treePanel.add((Component)this.m_channelPanel, c);
        final JLayeredPane layeredPane = new JLayeredPane(){

            @Override
            public Dimension getPreferredSize() {
                return treePanel.getPreferredSize();
            }
        };
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                treePanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
                QuantAggregateExperimentalTreePanel.this.m_floattingButtonsPanel.setLocation(c.getWidth() - ((QuantAggregateExperimentalTreePanel)QuantAggregateExperimentalTreePanel.this).m_floattingButtonsPanel.getPreferredSize().width - 5, 5);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add((Component)layeredPane, "Center");
        layeredPane.add((Component)treePanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_floattingButtonsPanel, JLayeredPane.PALETTE_LAYER);
        return layeredPane;
    }

    public List<Map<String, Object>> getQuantChannelsMatching() {
        LinkedHashSet<XICBiologicalSampleAnalysisNode> bioSampleAnalysisNodes = new LinkedHashSet<XICBiologicalSampleAnalysisNode>();
        this.collectBioSampleAnalysisNodes((AbstractNode)this.m_tree.getModel().getRoot(), bioSampleAnalysisNodes);
        HashSet<XICBiologicalSampleAnalysisNode> nodes = new HashSet<XICBiologicalSampleAnalysisNode>(this.m_parentQCMappings.keySet());
        for (XICBiologicalSampleAnalysisNode xICBiologicalSampleAnalysisNode : nodes) {
            if (bioSampleAnalysisNodes.contains(xICBiologicalSampleAnalysisNode)) continue;
            this.m_parentQCMappings.remove(xICBiologicalSampleAnalysisNode);
        }
        int index = 1;
        for (XICBiologicalSampleAnalysisNode node : bioSampleAnalysisNodes) {
            DQuantitationChannelMapping mapping = this.m_parentQCMappings.get(node);
            mapping.setParentQCNumber(index);
            ++index;
        }
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (DQuantitationChannelMapping entry : this.m_parentQCMappings.values()) {
            HashMap<String, Object> mapping = new HashMap<String, Object>();
            mapping.put("quant_channel_number", entry.getParentQCNumber());
            Map<Long, Long> map = entry.getMappedQuantChannels().entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> ((DMasterQuantitationChannel)((DDataset)e.getKey()).getMasterQuantitationChannels().get(0)).getId(), e -> ((QuantitationChannel)e.getValue()).getId()));
            mapping.put("quant_channels_matching", map);
            arrayList.add(mapping);
        }
        return arrayList;
    }

    private void collectBioSampleAnalysisNodes(AbstractNode node, HashSet<XICBiologicalSampleAnalysisNode> bioSampleAnalysisNodes) {
        int nb = node.getChildCount();
        for (int i = 0; i < nb; ++i) {
            AbstractNode child = (AbstractNode)node.getChildAt(i);
            if (child.getType() == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
                bioSampleAnalysisNodes.add((XICBiologicalSampleAnalysisNode)child);
            }
            this.collectBioSampleAnalysisNodes(child, bioSampleAnalysisNodes);
        }
    }

    public ChannelPanel getChannelPanel() {
        return this.m_channelPanel;
    }

    private DefaultFloatingPanel createButtonsPanel() {
        this.m_eraseAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuantAggregateExperimentalTreePanel.this.m_channelPanel.eraseDropZone();
            }
        };
        this.m_moveUpAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuantAggregateExperimentalTreePanel.this.m_channelPanel.moveDropZone(true);
            }
        };
        this.m_moveDownAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuantAggregateExperimentalTreePanel.this.m_channelPanel.moveDropZone(false);
            }
        };
        String[] actionText = new String[]{"", "", ""};
        ActionListener[] actionListeners = new ActionListener[]{this.m_eraseAction, this.m_moveUpAction, this.m_moveDownAction};
        Icon[] icons = new Icon[]{IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER), IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW_UP), IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW_DOWN)};
        DefaultFloatingPanel floattingPanel = new DefaultFloatingPanel(null, actionText, actionListeners, icons, false){

            public void actionFinished(boolean success, String errorMessage) {
                super.actionFinished(success, errorMessage);
            }
        };
        floattingPanel.setVisible(true);
        return floattingPanel;
    }

    public void setMapping(List<DDataset> datasets) {
        this.m_tabbedPane.removeAll();
        for (DDataset ds : datasets) {
            DataSetData datasetData = DataSetData.createTemporaryQuantitation((String)ds.getName());
            datasetData.setDataset(ds);
            DataSetNode dsNode = new DataSetNode((AbstractData)datasetData);
            QuantExperimentalDesignTree dsDesignTree = new QuantExperimentalDesignTree(dsNode, false, false, true);
            QuantExperimentalDesignTree.displayExperimentalDesign(ds, dsNode, dsDesignTree, false, true);
            JScrollPane sPane = new JScrollPane(dsDesignTree);
            this.m_tabbedPane.add(ds.getName(), sPane);
        }
        this.validate();
        this.repaint();
    }

    public QuantExperimentalDesignTree getTree() {
        return this.m_tree;
    }

    private Map<XICBiologicalSampleAnalysisNode, DQuantitationChannelMapping> inferDefaultMapping(AbstractNode node) {
        HashMap<XICBiologicalSampleAnalysisNode, DQuantitationChannelMapping> mappings = new HashMap<XICBiologicalSampleAnalysisNode, DQuantitationChannelMapping>();
        Stream<Object> groupStream = Collections.list(node.children()).stream().filter(n -> ((AbstractNode)n).getType() == AbstractNode.NodeTypes.BIOLOGICAL_GROUP);
        AtomicInteger index = new AtomicInteger(1);
        List groupNodes = groupStream.map(o -> (XICBiologicalGroupNode)o).collect(Collectors.toList());
        for (XICBiologicalGroupNode groupNode : groupNodes) {
            Stream<Object> sampleStream = Collections.list(groupNode.children()).stream().filter(n -> ((AbstractNode)n).getType() == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE);
            List sampleNodeList = sampleStream.map(s -> (XICBiologicalSampleNode)s).collect(Collectors.toList());
            for (XICBiologicalSampleNode sampleNode : sampleNodeList) {
                Stream<XICBiologicalSampleAnalysisNode> sampleNodeStream = this.parseSample(sampleNode);
                Map<XICBiologicalSampleAnalysisNode, DQuantitationChannelMapping> qcsNodes = sampleNodeStream.collect(Collectors.toMap(x -> x, x -> new DQuantitationChannelMapping(index.getAndIncrement())));
                List sortedMappings = qcsNodes.values().stream().sorted(Comparator.comparing(DQuantitationChannelMapping::getParentQCNumber)).collect(Collectors.toList());
                for (DDataset ds : this.m_datasets) {
                    BiologicalSample sample;
                    BiologicalGroup group = ds.getGroupSetup().getBiologicalGroups().stream().filter(bg -> bg.getName().equals(((DataSetData)groupNode.getData()).getTemporaryName())).findAny().orElse(null);
                    if (group == null || (sample = (BiologicalSample)group.getBiologicalSamples().stream().filter(bs -> bs.getName().equals(this.getCompletSampleName(group, sampleNode))).findAny().orElse(null)) == null) continue;
                    List groupQcs = sample.getQuantitationChannels();
                    for (int k = 0; k < Math.min(groupQcs.size(), sortedMappings.size()); ++k) {
                        ((DQuantitationChannelMapping)sortedMappings.get(k)).put(ds, (QuantitationChannel)groupQcs.get(k));
                    }
                }
                mappings.putAll(qcsNodes);
            }
        }
        return mappings;
    }

    private String getCompletSampleName(BiologicalGroup group, XICBiologicalSampleNode sampleNode) {
        String groupName = group.getName();
        String sampleName = ((DataSetData)sampleNode.getData()).getTemporaryName();
        String sampleCompletName = sampleName.startsWith(groupName) ? sampleName : groupName + sampleName;
        return sampleCompletName;
    }

    private Stream<XICBiologicalSampleAnalysisNode> parseGroup(XICBiologicalGroupNode groupNode) {
        Stream<XICBiologicalSampleAnalysisNode> stream = Collections.list(groupNode.children()).stream().flatMap(sampleNode -> Collections.list(((AbstractNode)sampleNode).children()).stream());
        return stream.map(node -> (XICBiologicalSampleAnalysisNode)node);
    }

    private Stream<XICBiologicalSampleAnalysisNode> parseSample(XICBiologicalSampleNode sampleNode) {
        Stream stream = Collections.list(sampleNode.children()).stream();
        return stream.map(node -> (XICBiologicalSampleAnalysisNode)node);
    }

    public static int paintCenterdString(Graphics g, Rectangle zone, Font f, String s) {
        FontMetrics fm = g.getFontMetrics(f);
        Rectangle2D rect = fm.getStringBounds(s, g);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        String subText = null;
        int countSub = 1;
        while (textWidth >= 300) {
            subText = ".." + s.substring(countSub++);
            rect = fm.getStringBounds(s, g);
            textWidth = (int)rect.getWidth();
        }
        if (subText != null) {
            s = subText;
        }
        int x = zone.x + (zone.width - textWidth) / 2;
        int y = zone.y + (zone.height - textHeight) / 2 + fm.getAscent();
        g.drawString(s, x, y);
        return textWidth;
    }

    public static class DropZoneTransferable
    implements Transferable,
    Serializable {
        public static final DataFlavor DROPZONE_FLAVOR = new DataFlavor(DropZone.class, "Drag and drop DropZone");
        private Integer m_transferKey = null;
        private static HashMap<Integer, TransferData> transferMap = new HashMap();
        private static final DataFlavor[] DATA_FLAVORS = new DataFlavor[]{DROPZONE_FLAVOR};
        private static final long serialVersionUID = 1L;
        private static int m_transferIndex = 0;

        public DropZoneTransferable(Integer transferKey) {
            this.m_transferKey = transferKey;
        }

        public static Integer register(TransferData data) {
            Integer transferKey = m_transferIndex;
            ++m_transferIndex;
            transferMap.put(transferKey, data);
            return transferKey;
        }

        public static TransferData getData(Integer transferKey) {
            return transferMap.get(transferKey);
        }

        public static void clearRegisteredData() {
            transferMap.clear();
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return DATA_FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DATA_FLAVORS[0].equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(flavor)) {
                return this;
            }
            return null;
        }

        public Integer getTransferKey() {
            return this.m_transferKey;
        }

        public static class TransferData {
            private ArrayList<DropZone> m_dropZoneList = null;

            public void setDropZoneList(ArrayList<DropZone> list) {
                this.m_dropZoneList = list;
            }

            public ArrayList<DropZone> getDropZoneList() {
                return this.m_dropZoneList;
            }
        }
    }

    public class DropZone {
        private DDataset m_dataset;
        private AbstractNode m_node;
        private QuantitationChannel m_channel;
        private Rectangle m_rectangle = new Rectangle();
        private boolean m_selected = false;
        private boolean m_error = false;
        private int m_col;
        private int m_row;

        public int getCol() {
            return this.m_col;
        }

        public int getRow() {
            return this.m_row;
        }

        public void setRow(int row) {
            this.m_row = row;
        }

        public Rectangle getBounds() {
            return this.m_rectangle;
        }

        public QuantitationChannel getChannel() {
            return this.m_channel;
        }

        public void setChannel(QuantitationChannel channel) {
            this.m_channel = channel;
        }

        public void setSelected(boolean v) {
            this.m_selected = v;
            if (this.m_selected) {
                QuantAggregateExperimentalTreePanel.this.m_tabbedPane.setSelectedIndex(this.m_col);
            }
        }

        public boolean isSelected() {
            return this.m_selected;
        }

        public void setError(boolean error) {
            this.m_error = error;
        }

        public boolean getError() {
            return this.m_error;
        }

        public int paint(Graphics g, AbstractNode highlightRowNode) {
            g.setColor(this.m_selected ? SELECTION_COLOR : Color.white);
            g.fillRect(this.m_rectangle.x, this.m_rectangle.y, this.m_rectangle.width, this.m_rectangle.height);
            g.setColor(Color.black);
            g.drawRect(this.m_rectangle.x, this.m_rectangle.y, this.m_rectangle.width, this.m_rectangle.height);
            if (this.m_channel != null) {
                g.setColor(this.m_error ? Color.red : (this.m_selected ? Color.white : Color.black));
                return QuantAggregateExperimentalTreePanel.paintCenterdString(g, this.m_rectangle, g.getFont(), this.m_channel.getName());
            }
            return 0;
        }

        public void set(int col, int row, DDataset dataset, QuantitationChannel channel, AbstractNode node) {
            this.m_col = col;
            this.m_row = row;
            this.m_dataset = dataset;
            this.m_channel = channel;
            this.m_node = node;
        }

        public void set(int x, int y, int width, int height) {
            this.m_rectangle.setBounds(x, y, width, height);
        }

        public DDataset getDataset() {
            return this.m_dataset;
        }

        public AbstractNode getNode() {
            return this.m_node;
        }

        public boolean contains(Point p) {
            return this.m_rectangle.contains(p);
        }
    }

    public class QuestionPanel {
        private int m_x;
        private int m_y;
        private boolean m_visible = false;

        public void QuestionPanel() {
        }

        public void setVisible(boolean v) {
            this.m_visible = v;
        }

        public void setLocation(int x, int y) {
            this.m_x = x;
            this.m_y = y;
        }

        public boolean inside(int x, int y) {
            if (!this.m_visible) {
                return false;
            }
            Image img = IconManager.getImage((IconManager.IconType)IconManager.IconType.QUESTION);
            return x >= this.m_x && y >= this.m_y && x <= this.m_x + img.getWidth(null) && y <= this.m_y + img.getHeight(null);
        }

        public void paint(Graphics g) {
            if (this.m_visible) {
                g.drawImage(IconManager.getImage((IconManager.IconType)IconManager.IconType.QUESTION), this.m_x, this.m_y, null);
            }
        }
    }

    public class ChannelPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private Dimension m_minimumDimension = null;
        private int m_columnWidth = 100;
        private DropZone[][] m_dropZones;
        private int m_nbCols;
        private int m_nbRows;
        private QuestionPanel m_question = new QuestionPanel();
        private ArrayList<DropZone> m_selectedDropZoneList = new ArrayList();
        private MouseEvent m_mouseDragBegin;
        private Font m_font = null;
        private TransferHandler m_transferHandler;
        private HashMap<Long, DropZone> m_duplicatesChannel = new HashMap();
        private DropZone m_willSelectDropZone = null;
        private JPopupMenu m_popup = null;

        public ChannelPanel() {
            this.setLayout(null);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.m_transferHandler = new TransferHandler(){

                @Override
                public int getSourceActions(JComponent c) {
                    return 2;
                }

                @Override
                public Transferable createTransferable(JComponent c) {
                    ArrayList<DropZone> draggedList = new ArrayList<DropZone>(ChannelPanel.this.m_selectedDropZoneList);
                    DropZoneTransferable.TransferData data = new DropZoneTransferable.TransferData();
                    data.setDropZoneList(draggedList);
                    Integer transferKey = DropZoneTransferable.register(data);
                    return new DropZoneTransferable(transferKey);
                }

                @Override
                public void exportDone(JComponent c, Transferable t, int action) {
                    for (DropZone dropZone : ChannelPanel.this.m_selectedDropZoneList) {
                        dropZone.setSelected(false);
                    }
                    ChannelPanel.this.m_selectedDropZoneList.clear();
                    ChannelPanel.this.updateFloattingButtons();
                }

                @Override
                public boolean canImport(TransferHandler.TransferSupport support) {
                    if (support.isDataFlavorSupported(XICSelectionTransferable.RSMNodeList_FLAVOR)) {
                        return this.canImportFromXICTree(support);
                    }
                    if (support.isDataFlavorSupported(DropZoneTransferable.DROPZONE_FLAVOR)) {
                        return this.canImportFromDropNode(support);
                    }
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private boolean canImportFromXICTree(TransferHandler.TransferSupport support) {
                    boolean repaint = false;
                    try {
                        if (!support.isDrop()) {
                            if (!ChannelPanel.this.m_selectedDropZoneList.isEmpty()) {
                                for (DropZone dropZone : ChannelPanel.this.m_selectedDropZoneList) {
                                    dropZone.setSelected(false);
                                }
                                ChannelPanel.this.m_selectedDropZoneList.clear();
                                ChannelPanel.this.updateFloattingButtons();
                                repaint = true;
                            }
                            boolean bl = false;
                            return bl;
                        }
                        TransferHandler.DropLocation dropLocation = support.getDropLocation();
                        Point p = dropLocation.getDropPoint();
                        DropZone[][] dropZoneArray = ChannelPanel.this.m_dropZones;
                        int n = dropZoneArray.length;
                        for (int i = 0; i < n; ++i) {
                            DropZone[] dropZoneList;
                            for (DropZone dropZone : dropZoneList = dropZoneArray[i]) {
                                if (!dropZone.contains(p)) continue;
                                boolean typeCompatible = false;
                                try {
                                    ArrayList<AbstractNode> nodesList;
                                    AbstractNode.NodeTypes designNodeType;
                                    XICSelectionTransferable transfer = (XICSelectionTransferable)support.getTransferable().getTransferData(XICSelectionTransferable.RSMNodeList_FLAVOR);
                                    XICSelectionTransferable.TransferData data = XICSelectionTransferable.getData(transfer.getTransferKey());
                                    boolean designData = data.isDesignData();
                                    if (designData && (designNodeType = data.getDesignNodeType()) == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS && (nodesList = data.getDesignList()) != null && !nodesList.isEmpty()) {
                                        AbstractData rootData = ((AbstractNode)nodesList.get(0).getRoot()).getData();
                                        DDataset sourceDS = ((DataSetData)rootData).getDataset();
                                        if (sourceDS == null) {
                                            // empty if block
                                        }
                                        DDataset destDS = dropZone.getDataset();
                                        if (sourceDS.getId() == destDS.getId()) {
                                            typeCompatible = true;
                                        }
                                    }
                                }
                                catch (UnsupportedFlavorException | IOException exception) {
                                    // empty catch block
                                }
                                for (DropZone dropZoneCur : ChannelPanel.this.m_selectedDropZoneList) {
                                    dropZoneCur.setSelected(false);
                                }
                                ChannelPanel.this.m_selectedDropZoneList.clear();
                                if (typeCompatible) {
                                    dropZone.setSelected(true);
                                    ChannelPanel.this.m_selectedDropZoneList.add(dropZone);
                                    repaint = true;
                                    ChannelPanel.this.updateFloattingButtons();
                                    boolean bl = true;
                                    return bl;
                                }
                                ChannelPanel.this.updateFloattingButtons();
                                repaint = true;
                            }
                        }
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        if (repaint) {
                            ChannelPanel.this.repaint();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private boolean canImportFromDropNode(TransferHandler.TransferSupport support) {
                    boolean repaint = false;
                    try {
                        if (!support.isDrop()) {
                            if (!ChannelPanel.this.m_selectedDropZoneList.isEmpty()) {
                                for (DropZone dropZone : ChannelPanel.this.m_selectedDropZoneList) {
                                    dropZone.setSelected(false);
                                }
                                ChannelPanel.this.m_selectedDropZoneList.clear();
                                ChannelPanel.this.updateFloattingButtons();
                                repaint = true;
                            }
                            boolean bl = false;
                            return bl;
                        }
                        TransferHandler.DropLocation dropLocation = support.getDropLocation();
                        Point p = dropLocation.getDropPoint();
                        DropZone[][] dropZoneArray = ChannelPanel.this.m_dropZones;
                        int n = dropZoneArray.length;
                        for (int i = 0; i < n; ++i) {
                            DropZone[] dropZoneList;
                            for (DropZone dropZone : dropZoneList = dropZoneArray[i]) {
                                if (!dropZone.contains(p)) continue;
                                boolean typeCompatible = false;
                                try {
                                    DropZoneTransferable transfer = (DropZoneTransferable)support.getTransferable().getTransferData(DropZoneTransferable.DROPZONE_FLAVOR);
                                    DropZoneTransferable.TransferData data = DropZoneTransferable.getData(transfer.getTransferKey());
                                    ArrayList<DropZone> dropZonesSrc = data.getDropZoneList();
                                    if (dropZonesSrc != null && !dropZonesSrc.isEmpty()) {
                                        DDataset sourceDS = dropZonesSrc.get(0).getDataset();
                                        DDataset destDS = dropZone.getDataset();
                                        if (sourceDS.getId() == destDS.getId()) {
                                            typeCompatible = true;
                                        }
                                    }
                                }
                                catch (UnsupportedFlavorException | IOException exception) {
                                    // empty catch block
                                }
                                for (DropZone dropZoneCur : ChannelPanel.this.m_selectedDropZoneList) {
                                    dropZoneCur.setSelected(false);
                                }
                                ChannelPanel.this.m_selectedDropZoneList.clear();
                                if (typeCompatible) {
                                    dropZone.setSelected(true);
                                    ChannelPanel.this.m_selectedDropZoneList.add(dropZone);
                                    repaint = true;
                                    ChannelPanel.this.updateFloattingButtons();
                                    boolean bl = true;
                                    return bl;
                                }
                                ChannelPanel.this.updateFloattingButtons();
                                repaint = true;
                            }
                        }
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        if (repaint) {
                            ChannelPanel.this.repaint();
                        }
                    }
                }

                @Override
                public boolean importData(TransferHandler.TransferSupport support) {
                    if (support.isDataFlavorSupported(XICSelectionTransferable.RSMNodeList_FLAVOR)) {
                        return this.importDataFromXic(support);
                    }
                    if (support.isDataFlavorSupported(DropZoneTransferable.DROPZONE_FLAVOR)) {
                        return this.importDataFromDropNode(support);
                    }
                    return false;
                }

                private boolean importDataFromXic(TransferHandler.TransferSupport support) {
                    try {
                        XICSelectionTransferable transfer = (XICSelectionTransferable)support.getTransferable().getTransferData(XICSelectionTransferable.RSMNodeList_FLAVOR);
                        XICSelectionTransferable.TransferData transferData = XICSelectionTransferable.getData(transfer.getTransferKey());
                        ArrayList<AbstractNode> transferDsNodesList = transferData.getDesignList();
                        if (transferDsNodesList == null) {
                            return false;
                        }
                        DropZone selectedDropZone = (DropZone)ChannelPanel.this.m_selectedDropZoneList.get(0);
                        selectedDropZone.setSelected(false);
                        int dropRow = selectedDropZone.getRow();
                        int dropCol = selectedDropZone.getCol();
                        for (AbstractNode dsNode : transferDsNodesList) {
                            selectedDropZone = ChannelPanel.this.m_dropZones[dropCol][dropRow];
                            DDataset dropLocationDs = selectedDropZone.getDataset();
                            AbstractNode dropLocationNode = selectedDropZone.getNode();
                            DQuantitationChannelMapping mapping = (DQuantitationChannelMapping)QuantAggregateExperimentalTreePanel.this.m_parentQCMappings.get(dropLocationNode);
                            DataSetData userObject = (DataSetData)dsNode.getData();
                            mapping.put(dropLocationDs, userObject.getChannelNumber());
                            if (++dropRow < ChannelPanel.this.m_nbRows) continue;
                            break;
                        }
                        ChannelPanel.this.m_selectedDropZoneList.clear();
                        ChannelPanel.this.updateFloattingButtons();
                        ChannelPanel.this.repaint();
                        return false;
                    }
                    catch (UnsupportedFlavorException transfer) {
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    for (DropZone dropZone : ChannelPanel.this.m_selectedDropZoneList) {
                        dropZone.setSelected(false);
                    }
                    ChannelPanel.this.m_selectedDropZoneList.clear();
                    ChannelPanel.this.updateFloattingButtons();
                    ChannelPanel.this.repaint();
                    return false;
                }

                private boolean importDataFromDropNode(TransferHandler.TransferSupport support) {
                    try {
                        DQuantitationChannelMapping mapping;
                        DropZoneTransferable transfer = (DropZoneTransferable)support.getTransferable().getTransferData(DropZoneTransferable.DROPZONE_FLAVOR);
                        DropZoneTransferable.TransferData transferData = DropZoneTransferable.getData(transfer.getTransferKey());
                        ArrayList<DropZone> transferDsNodesList = transferData.getDropZoneList();
                        if (transferDsNodesList == null) {
                            return false;
                        }
                        HashSet<DropZone> destinationDropZones = new HashSet<DropZone>();
                        DropZone selectedDropZone = (DropZone)ChannelPanel.this.m_selectedDropZoneList.get(0);
                        selectedDropZone.setSelected(false);
                        int dropRow = selectedDropZone.getRow();
                        int dropCol = selectedDropZone.getCol();
                        for (DropZone dropZoneSource : transferDsNodesList) {
                            selectedDropZone = ChannelPanel.this.m_dropZones[dropCol][dropRow];
                            destinationDropZones.add(selectedDropZone);
                            DDataset dropLocationDs = selectedDropZone.getDataset();
                            AbstractNode dropLocationNode = selectedDropZone.getNode();
                            mapping = (DQuantitationChannelMapping)QuantAggregateExperimentalTreePanel.this.m_parentQCMappings.get(dropLocationNode);
                            mapping.put(dropLocationDs, dropZoneSource.getChannel());
                            if (++dropRow < ChannelPanel.this.m_nbRows) continue;
                            break;
                        }
                        for (DropZone dropZoneSource : transferDsNodesList) {
                            if (destinationDropZones.contains(dropZoneSource)) continue;
                            AbstractNode node = dropZoneSource.getNode();
                            DDataset ds = dropZoneSource.getDataset();
                            mapping = (DQuantitationChannelMapping)QuantAggregateExperimentalTreePanel.this.m_parentQCMappings.get(node);
                            mapping.put(ds, null);
                        }
                        ChannelPanel.this.m_selectedDropZoneList.clear();
                        ChannelPanel.this.updateFloattingButtons();
                        ChannelPanel.this.repaint();
                        return false;
                    }
                    catch (UnsupportedFlavorException transfer) {
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    for (DropZone dropZone : ChannelPanel.this.m_selectedDropZoneList) {
                        dropZone.setSelected(false);
                    }
                    ChannelPanel.this.m_selectedDropZoneList.clear();
                    ChannelPanel.this.updateFloattingButtons();
                    ChannelPanel.this.repaint();
                    return false;
                }
            };
            this.setTransferHandler(this.m_transferHandler);
        }

        public DropZone checkDuplicateDropZone() {
            for (int col = 0; col < this.m_nbCols; ++col) {
                for (int row = 0; row < this.m_nbRows; ++row) {
                    if (!this.m_dropZones[col][row].getError()) continue;
                    return this.m_dropZones[col][row];
                }
            }
            return null;
        }

        public void treeChanged(boolean nbOfChannelsChanged) {
            if (nbOfChannelsChanged) {
                this.m_dropZones = null;
                AbstractNode rootNode = (AbstractNode)QuantAggregateExperimentalTreePanel.this.m_tree.getModel().getRoot();
                LinkedHashSet bioSampleAnalysisNodes = new LinkedHashSet();
                QuantAggregateExperimentalTreePanel.this.collectBioSampleAnalysisNodes(rootNode, bioSampleAnalysisNodes);
                for (XICBiologicalSampleAnalysisNode node : bioSampleAnalysisNodes) {
                    if (QuantAggregateExperimentalTreePanel.this.m_parentQCMappings.containsKey(node)) continue;
                    DQuantitationChannelMapping mapping = new DQuantitationChannelMapping(-1);
                    for (DDataset d : QuantAggregateExperimentalTreePanel.this.m_datasets) {
                        mapping.put(d, null);
                    }
                    QuantAggregateExperimentalTreePanel.this.m_parentQCMappings.put(node, mapping);
                }
            } else {
                for (DropZone dropZone : this.m_selectedDropZoneList) {
                    dropZone.setSelected(false);
                }
            }
            this.m_selectedDropZoneList.clear();
            this.updateFloattingButtons();
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.m_minimumDimension == null) {
                this.m_minimumDimension = new Dimension();
            }
            Dimension d = QuantAggregateExperimentalTreePanel.this.m_tree.getPreferredSize();
            this.m_minimumDimension.width = this.m_columnWidth * QuantAggregateExperimentalTreePanel.this.m_datasets.size() + 28 + 16 + 7;
            this.m_minimumDimension.height = d.height;
            return this.m_minimumDimension;
        }

        @Override
        public void paint(Graphics g) {
            int nbRow;
            Graphics2D g2D = (Graphics2D)g;
            if (this.m_font == null) {
                this.m_font = g.getFont();
            } else {
                g.setFont(this.m_font);
            }
            if (this.m_dropZones != null) {
                nbRow = 0;
                int nbRowInTree = QuantAggregateExperimentalTreePanel.this.m_tree.getRowCount();
                for (int i = 0; i < nbRowInTree; ++i) {
                    TreePath path = QuantAggregateExperimentalTreePanel.this.m_tree.getPathForRow(i);
                    AbstractNode node = (AbstractNode)path.getLastPathComponent();
                    if (node.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) continue;
                    ++nbRow;
                }
                if (nbRow != this.m_nbRows) {
                    this.m_dropZones = null;
                }
            }
            if (this.m_dropZones == null) {
                int i;
                this.m_nbCols = QuantAggregateExperimentalTreePanel.this.m_datasets.size();
                this.m_nbRows = 0;
                int nbRowInTree = QuantAggregateExperimentalTreePanel.this.m_tree.getRowCount();
                for (i = 0; i < nbRowInTree; ++i) {
                    TreePath path = QuantAggregateExperimentalTreePanel.this.m_tree.getPathForRow(i);
                    AbstractNode node = (AbstractNode)path.getLastPathComponent();
                    if (node.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) continue;
                    ++this.m_nbRows;
                }
                this.m_dropZones = new DropZone[this.m_nbCols][this.m_nbRows];
                for (i = 0; i < this.m_nbRows; ++i) {
                    for (int j = 0; j < this.m_nbCols; ++j) {
                        this.m_dropZones[j][i] = new DropZone();
                    }
                }
            }
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.black);
            nbRow = QuantAggregateExperimentalTreePanel.this.m_tree.getRowCount();
            this.m_duplicatesChannel.clear();
            boolean foundFirstSampleAnalysis = false;
            int textWidthNeededMin = 0;
            AbstractNode[] selectedNodes = QuantAggregateExperimentalTreePanel.this.m_tree.getSelectedNodes();
            AbstractNode highlightRowNode = null;
            if (selectedNodes.length == 1) {
                highlightRowNode = selectedNodes[0];
            }
            this.m_question.setVisible(false);
            int upLineY = 0;
            int rowIndex = 0;
            for (int i = 0; i < nbRow; ++i) {
                boolean rowHighlighted;
                Rectangle r = QuantAggregateExperimentalTreePanel.this.m_tree.getRowBounds(i);
                TreePath path = QuantAggregateExperimentalTreePanel.this.m_tree.getPathForRow(i);
                AbstractNode node = (AbstractNode)path.getLastPathComponent();
                if (node.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) continue;
                boolean bl = rowHighlighted = highlightRowNode == node;
                if (rowHighlighted) {
                    g2D.setStroke(STROKE_2);
                }
                g.setColor(rowHighlighted ? SELECTION_COLOR : Color.lightGray);
                g.drawLine(0, r.y + r.height / 2, 14 + this.m_columnWidth * QuantAggregateExperimentalTreePanel.this.m_datasets.size(), r.y + r.height / 2);
                g2D.setStroke(STROKE_1);
                if (rowHighlighted) {
                    this.m_question.setLocation(21 + this.m_columnWidth * QuantAggregateExperimentalTreePanel.this.m_datasets.size(), r.y + r.height / 2 - 8);
                    this.m_question.setVisible(true);
                    this.m_question.paint(g);
                }
                DQuantitationChannelMapping mapping = (DQuantitationChannelMapping)QuantAggregateExperimentalTreePanel.this.m_parentQCMappings.get(node);
                Map<DDataset, QuantitationChannel> map = mapping.getMappedQuantChannels();
                int colIndex = 0;
                int decalX = 0;
                for (DDataset d : QuantAggregateExperimentalTreePanel.this.m_datasets) {
                    int textWidthNeeded;
                    QuantitationChannel channel = map.get(d);
                    DropZone dropZone = this.m_dropZones[colIndex][rowIndex];
                    dropZone.set(colIndex, rowIndex, d, channel, node);
                    dropZone.set(14 + decalX, r.y, this.m_columnWidth - 14, r.height);
                    dropZone.setError(false);
                    if (channel != null) {
                        DropZone dropZoneWithSameChannel = this.m_duplicatesChannel.get(channel.getId());
                        if (dropZoneWithSameChannel != null) {
                            dropZoneWithSameChannel.setError(true);
                            dropZoneWithSameChannel.paint(g, highlightRowNode);
                            dropZone.setError(true);
                        } else {
                            this.m_duplicatesChannel.put(channel.getId(), dropZone);
                        }
                    }
                    if ((textWidthNeeded = dropZone.paint(g, highlightRowNode)) > textWidthNeededMin) {
                        textWidthNeededMin = textWidthNeeded;
                    }
                    if (!foundFirstSampleAnalysis) {
                        g.setColor(Color.black);
                        Rectangle titleRectangle = new Rectangle(14 + decalX, r.y - r.height, this.m_columnWidth - 14, r.height);
                        textWidthNeeded = QuantAggregateExperimentalTreePanel.paintCenterdString(g, titleRectangle, g.getFont(), d.getName());
                        if (textWidthNeeded > textWidthNeededMin) {
                            textWidthNeededMin = textWidthNeeded;
                        }
                        upLineY = titleRectangle.y;
                    }
                    decalX += this.m_columnWidth;
                    ++colIndex;
                }
                ++rowIndex;
                foundFirstSampleAnalysis = true;
            }
            int colInTab = QuantAggregateExperimentalTreePanel.this.m_tabbedPane.getSelectedIndex();
            Rectangle selectedCol = new Rectangle();
            DropZone lastInRowDropZone = this.m_dropZones[colInTab][this.m_nbRows - 1];
            selectedCol.setBounds(lastInRowDropZone.getBounds().x - 7, upLineY - 7, lastInRowDropZone.getBounds().width + 14, lastInRowDropZone.getBounds().height + lastInRowDropZone.getBounds().y - upLineY + 14);
            g2D.setStroke(STROKE_2);
            g2D.setColor(SELECTION_COLOR);
            g.drawRect(selectedCol.x, selectedCol.y, selectedCol.width, selectedCol.height);
            g2D.setStroke(STROKE_1);
            if (textWidthNeededMin > this.m_columnWidth) {
                this.m_columnWidth = Math.min(textWidthNeededMin + 28, 300);
                this.setPreferredSize(this.getPreferredSize());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.m_question.inside(e.getX(), e.getY())) {
                String name;
                AbstractNode[] selectedNodes = QuantAggregateExperimentalTreePanel.this.m_tree.getSelectedNodes();
                AbstractNode highlightRowNode = selectedNodes[0];
                int rowSelected = 0;
                for (int row = 0; row < this.m_nbRows; ++row) {
                    if (this.m_dropZones[0][row].getNode() != highlightRowNode) continue;
                    rowSelected = row;
                    break;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("The abundance of one ion in ");
                sb.append(highlightRowNode.getData().getName());
                sb.append(" will be the sum of its values in ");
                int nb = QuantAggregateExperimentalTreePanel.this.m_datasets.size();
                for (int i = 0; i < nb; ++i) {
                    DDataset d = (DDataset)QuantAggregateExperimentalTreePanel.this.m_datasets.get(i);
                    name = d.getName();
                    sb.append(name);
                    if (i < nb - 2) {
                        sb.append(", ");
                        continue;
                    }
                    if (i >= nb - 1) continue;
                    sb.append(" and ");
                }
                sb.append(".\n\n");
                sb.append("In your Aggregation Quantitation Design, it is the sum of the abundances of this ion in ");
                for (int col = 0; col < this.m_nbCols; ++col) {
                    QuantitationChannel channel = this.m_dropZones[col][rowSelected].getChannel();
                    name = channel != null ? channel.getName() : "<no data>";
                    sb.append(name);
                    if (col < this.m_nbCols - 2) {
                        sb.append(", ");
                        continue;
                    }
                    if (col >= this.m_nbCols - 1) continue;
                    sb.append(" and ");
                }
                sb.append(".");
                JOptionPane.showMessageDialog(this, sb.toString(), "Aggregation Information", 1);
            } else {
                QuantAggregateExperimentalTreePanel.this.m_tree.clearSelection();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            int currentSelectionCol = -1;
            if (!this.m_selectedDropZoneList.isEmpty()) {
                currentSelectionCol = this.m_selectedDropZoneList.get(0).getCol();
            }
            DropZone overDropZone = null;
            DropZone[][] dropZoneArray = this.m_dropZones;
            int n = dropZoneArray.length;
            block0: for (int i = 0; i < n; ++i) {
                DropZone[] list;
                DropZone[] dropZoneArray2 = list = dropZoneArray[i];
                int n2 = dropZoneArray2.length;
                for (int j = 0; j < n2; ++j) {
                    DropZone dropZone = dropZoneArray2[j];
                    if (!dropZone.contains(e.getPoint())) continue;
                    this.m_mouseDragBegin = e;
                    overDropZone = dropZone;
                    break block0;
                }
            }
            if (overDropZone != null && currentSelectionCol != -1 && overDropZone.getCol() != currentSelectionCol) {
                for (DropZone dropZone : this.m_selectedDropZoneList) {
                    dropZone.setSelected(false);
                }
                this.m_selectedDropZoneList.clear();
            }
            int modifier = e.getModifiers();
            if (overDropZone == null) {
                for (DropZone dropZone : this.m_selectedDropZoneList) {
                    dropZone.setSelected(false);
                }
                this.m_selectedDropZoneList.clear();
            } else {
                if (this.m_selectedDropZoneList.isEmpty()) {
                    modifier = 0;
                }
                if ((modifier & 3) == 0) {
                    if (overDropZone.isSelected()) {
                        this.m_willSelectDropZone = overDropZone;
                    } else {
                        for (DropZone dropZone : this.m_selectedDropZoneList) {
                            dropZone.setSelected(false);
                        }
                        this.m_selectedDropZoneList.clear();
                        overDropZone.setSelected(true);
                        this.m_selectedDropZoneList.add(overDropZone);
                    }
                } else if ((modifier & 2) != 0) {
                    if (overDropZone.isSelected()) {
                        overDropZone.setSelected(false);
                        this.m_selectedDropZoneList.remove(overDropZone);
                    } else {
                        overDropZone.setSelected(true);
                        this.m_selectedDropZoneList.add(overDropZone);
                    }
                } else if ((modifier & 1) != 0) {
                    int minRow;
                    int maxRow = minRow = overDropZone.getRow();
                    for (DropZone dropZone : this.m_selectedDropZoneList) {
                        int row = dropZone.getRow();
                        if (minRow > row) {
                            minRow = row;
                        }
                        if (maxRow >= row) continue;
                        maxRow = row;
                    }
                    this.m_selectedDropZoneList.clear();
                    for (DropZone dropZone : this.m_dropZones[currentSelectionCol]) {
                        boolean select = dropZone.getRow() >= minRow && dropZone.getRow() <= maxRow;
                        dropZone.setSelected(select);
                        if (!select) continue;
                        this.m_selectedDropZoneList.add(dropZone);
                    }
                }
            }
            this.updateFloattingButtons();
            this.revalidate();
            this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.m_willSelectDropZone != null) {
                for (DropZone dropZone : this.m_selectedDropZoneList) {
                    dropZone.setSelected(false);
                }
                this.m_selectedDropZoneList.clear();
                this.m_willSelectDropZone.setSelected(true);
                this.m_selectedDropZoneList.add(this.m_willSelectDropZone);
                this.updateFloattingButtons();
                this.m_willSelectDropZone = null;
            }
            if (e.isPopupTrigger() && !this.m_selectedDropZoneList.isEmpty()) {
                this.triggerPopup(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int dy;
            int dx;
            if (this.m_mouseDragBegin != null && !this.m_selectedDropZoneList.isEmpty() && (dx = this.m_mouseDragBegin.getX() - e.getX()) * dx + (dy = this.m_mouseDragBegin.getY() - e.getY()) * dy > 16) {
                this.m_willSelectDropZone = null;
                this.m_transferHandler.exportAsDrag(this, this.m_mouseDragBegin, 2);
                this.m_mouseDragBegin = null;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        private void triggerPopup(MouseEvent e) {
            if (this.m_popup == null) {
                this.m_popup = new JPopupMenu();
                JMenuItem item = new JMenuItem("Clear", IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
                item.addActionListener(QuantAggregateExperimentalTreePanel.this.m_eraseAction);
                this.m_popup.add(item);
                this.m_popup.addSeparator();
                item = new JMenuItem("Move Up", IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW_UP));
                item.addActionListener(QuantAggregateExperimentalTreePanel.this.m_moveUpAction);
                this.m_popup.add(item);
                item = new JMenuItem("Move Down", IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW_DOWN));
                item.addActionListener(QuantAggregateExperimentalTreePanel.this.m_moveDownAction);
                this.m_popup.add(item);
            }
            this.m_popup.show((JComponent)e.getSource(), e.getX(), e.getY());
        }

        private void updateFloattingButtons() {
            boolean enabled = !this.m_selectedDropZoneList.isEmpty();
            QuantAggregateExperimentalTreePanel.this.m_floattingButtonsPanel.enableAllButtons(enabled);
        }

        public void eraseDropZone() {
            for (DropZone dropZone : this.m_selectedDropZoneList) {
                dropZone.setSelected(false);
                dropZone.setChannel(null);
            }
            this.m_selectedDropZoneList.clear();
            this.updateFloattingButtons();
            this.updateTreeFromDropZone();
        }

        public void clearSelection() {
            for (DropZone dropZone : this.m_selectedDropZoneList) {
                dropZone.setSelected(false);
            }
            this.m_selectedDropZoneList.clear();
            this.updateFloattingButtons();
            this.repaint();
        }

        public void moveDropZone(boolean up) {
            int col = this.m_selectedDropZoneList.get(0).getCol();
            DropZone[] dropZoneList = this.m_dropZones[col];
            if (up) {
                for (int row = 1; row < dropZoneList.length; ++row) {
                    DropZone dropZone = dropZoneList[row];
                    DropZone dropZonePrevious = dropZoneList[row - 1];
                    if (!dropZone.isSelected() || dropZonePrevious.isSelected()) continue;
                    this.m_dropZones[col][row - 1] = dropZone;
                    dropZone.setRow(row - 1);
                    this.m_dropZones[col][row] = dropZonePrevious;
                    dropZonePrevious.setRow(row);
                }
            } else {
                for (int row = dropZoneList.length - 2; row >= 0; --row) {
                    DropZone dropZone = dropZoneList[row];
                    DropZone dropZoneNext = dropZoneList[row + 1];
                    if (!dropZone.isSelected() || dropZoneNext.isSelected()) continue;
                    this.m_dropZones[col][row + 1] = dropZone;
                    dropZone.setRow(row + 1);
                    this.m_dropZones[col][row] = dropZoneNext;
                    dropZoneNext.setRow(row);
                }
            }
            this.updateTreeFromDropZone();
        }

        private void updateTreeFromDropZone() {
            int nbRow = QuantAggregateExperimentalTreePanel.this.m_tree.getRowCount();
            int rowIndex = 0;
            for (int i = 0; i < nbRow; ++i) {
                TreePath path = QuantAggregateExperimentalTreePanel.this.m_tree.getPathForRow(i);
                AbstractNode node = (AbstractNode)path.getLastPathComponent();
                if (node.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) continue;
                DQuantitationChannelMapping mapping = (DQuantitationChannelMapping)QuantAggregateExperimentalTreePanel.this.m_parentQCMappings.get(node);
                Map<DDataset, QuantitationChannel> map = mapping.getMappedQuantChannels();
                int colIndex = 0;
                for (DDataset d : QuantAggregateExperimentalTreePanel.this.m_datasets) {
                    DropZone dropZone = this.m_dropZones[colIndex][rowIndex];
                    map.put(d, dropZone.getChannel());
                    ++colIndex;
                }
                ++rowIndex;
            }
            this.repaint();
        }
    }

    private class AssociatedQuantExperimentalDesignTree
    extends QuantExperimentalDesignTree {
        public AssociatedQuantExperimentalDesignTree(AbstractNode rootNode) {
            super(rootNode, true, true, true);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2D = (Graphics2D)g;
            int nbRow = QuantAggregateExperimentalTreePanel.this.m_tree.getRowCount();
            AbstractNode[] selectedNodes = QuantAggregateExperimentalTreePanel.this.m_tree.getSelectedNodes();
            AbstractNode highlightRowNode = null;
            if (selectedNodes.length == 1) {
                highlightRowNode = selectedNodes[0];
            }
            for (int i = 0; i < nbRow; ++i) {
                Rectangle r = QuantAggregateExperimentalTreePanel.this.m_tree.getRowBounds(i);
                TreePath path = QuantAggregateExperimentalTreePanel.this.m_tree.getPathForRow(i);
                AbstractNode node = (AbstractNode)path.getLastPathComponent();
                if (node.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) continue;
                boolean highlight = highlightRowNode == node;
                g.setColor(highlight ? SELECTION_COLOR : Color.lightGray);
                if (highlight) {
                    g2D.setStroke(STROKE_2);
                }
                g.drawLine(r.x + r.width + 14, r.y + r.height / 2, this.getPreferredSize().width, r.y + r.height / 2);
                g2D.setStroke(STROKE_1);
            }
        }
    }
}

