/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.pool;

import com.sun.jndi.ldap.LdapPoolManager;
import com.sun.jndi.ldap.pool.ConnectionDesc;
import com.sun.jndi.ldap.pool.Pool;
import com.sun.jndi.ldap.pool.PoolCallback;
import com.sun.jndi.ldap.pool.PooledConnection;
import com.sun.jndi.ldap.pool.PooledConnectionFactory;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;

final class Connections
implements PoolCallback {
    private static final boolean debug = Pool.debug;
    private static final boolean trace = LdapPoolManager.trace;
    private static final int DEFAULT_SIZE = 10;
    private final int maxSize;
    private final int prefSize;
    private final List<ConnectionDesc> conns;
    private boolean closed = false;
    private Reference<Object> ref;

    Connections(Object object, int n, int n2, int n3, PooledConnectionFactory pooledConnectionFactory) throws NamingException {
        this.maxSize = n3;
        if (n3 > 0) {
            this.prefSize = Math.min(n2, n3);
            n = Math.min(n, n3);
        } else {
            this.prefSize = n2;
        }
        this.conns = new ArrayList<ConnectionDesc>(n3 > 0 ? n3 : 10);
        this.ref = new SoftReference<Object>(object);
        this.d("init size=", n);
        this.d("max size=", n3);
        this.d("preferred size=", n2);
        for (int i = 0; i < n; ++i) {
            PooledConnection pooledConnection = pooledConnectionFactory.createPooledConnection(this);
            this.td("Create ", pooledConnection, pooledConnectionFactory);
            this.conns.add(new ConnectionDesc(pooledConnection));
        }
    }

    synchronized PooledConnection get(long l, PooledConnectionFactory pooledConnectionFactory) throws NamingException {
        PooledConnection pooledConnection;
        long l2 = l > 0L ? System.currentTimeMillis() : 0L;
        long l3 = l;
        this.d("get(): before");
        while ((pooledConnection = this.getOrCreateConnection(pooledConnectionFactory)) == null) {
            if (l > 0L && l3 <= 0L) {
                throw new CommunicationException("Timeout exceeded while waiting for a connection: " + l + "ms");
            }
            try {
                this.d("get(): waiting");
                if (l3 > 0L) {
                    this.wait(l3);
                } else {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedNamingException("Interrupted while waiting for a connection");
            }
            if (l <= 0L) continue;
            long l4 = System.currentTimeMillis();
            l3 = l - (l4 - l2);
        }
        this.d("get(): after");
        return pooledConnection;
    }

    private PooledConnection getOrCreateConnection(PooledConnectionFactory pooledConnectionFactory) throws NamingException {
        int n = this.conns.size();
        PooledConnection pooledConnection = null;
        if (this.prefSize <= 0 || n >= this.prefSize) {
            for (int i = 0; i < n; ++i) {
                ConnectionDesc connectionDesc = this.conns.get(i);
                pooledConnection = connectionDesc.tryUse();
                if (pooledConnection == null) continue;
                this.d("get(): use ", pooledConnection);
                this.td("Use ", pooledConnection);
                return pooledConnection;
            }
        }
        if (this.maxSize > 0 && n >= this.maxSize) {
            return null;
        }
        pooledConnection = pooledConnectionFactory.createPooledConnection(this);
        this.td("Create and use ", pooledConnection, pooledConnectionFactory);
        this.conns.add(new ConnectionDesc(pooledConnection, true));
        return pooledConnection;
    }

    @Override
    public synchronized boolean releasePooledConnection(PooledConnection pooledConnection) {
        ConnectionDesc connectionDesc = new ConnectionDesc(pooledConnection);
        int n = this.conns.indexOf(connectionDesc);
        this.d("release(): ", pooledConnection);
        if (n >= 0) {
            if (this.closed || this.prefSize > 0 && this.conns.size() > this.prefSize) {
                this.d("release(): closing ", pooledConnection);
                this.td("Close ", pooledConnection);
                this.conns.remove(connectionDesc);
                pooledConnection.closeConnection();
            } else {
                this.d("release(): release ", pooledConnection);
                this.td("Release ", pooledConnection);
                connectionDesc = this.conns.get(n);
                connectionDesc.release();
            }
            this.notifyAll();
            this.d("release(): notify");
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removePooledConnection(PooledConnection pooledConnection) {
        if (this.conns.remove(new ConnectionDesc(pooledConnection))) {
            this.d("remove(): ", pooledConnection);
            this.notifyAll();
            this.d("remove(): notify");
            this.td("Remove ", pooledConnection);
            if (this.conns.isEmpty()) {
                this.ref = null;
            }
            return true;
        }
        this.d("remove(): not found ", pooledConnection);
        return false;
    }

    synchronized boolean expire(long l) {
        Iterator<ConnectionDesc> iterator = this.conns.iterator();
        while (iterator.hasNext()) {
            ConnectionDesc connectionDesc = iterator.next();
            if (!connectionDesc.expire(l)) continue;
            this.d("expire(): removing ", connectionDesc);
            this.td("Expired ", connectionDesc);
            iterator.remove();
        }
        return this.conns.isEmpty();
    }

    synchronized void close() {
        this.expire(System.currentTimeMillis());
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getStats() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l = 0L;
        Connections connections = this;
        synchronized (connections) {
            n = this.conns.size();
            block8: for (int i = 0; i < n; ++i) {
                ConnectionDesc connectionDesc = this.conns.get(i);
                l += connectionDesc.getUseCount();
                switch (connectionDesc.getState()) {
                    case 0: {
                        ++n3;
                        continue block8;
                    }
                    case 1: {
                        ++n2;
                        continue block8;
                    }
                    case 2: {
                        ++n4;
                    }
                }
            }
        }
        return "size=" + n + "; use=" + l + "; busy=" + n3 + "; idle=" + n2 + "; expired=" + n4;
    }

    private void d(String string, Object object) {
        if (debug) {
            this.d(string + object);
        }
    }

    private void d(String string, int n) {
        if (debug) {
            this.d(string + n);
        }
    }

    private void d(String string) {
        if (debug) {
            System.err.println(this + "." + string + "; size: " + this.conns.size());
        }
    }

    private void td(String string, Object object, Object object2) {
        if (trace) {
            this.td(string + object + "[" + object2 + "]");
        }
    }

    private void td(String string, Object object) {
        if (trace) {
            this.td(string + object);
        }
    }

    private void td(String string) {
        if (trace) {
            System.err.println(string);
        }
    }
}

