/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.snmp.SnmpCounter64;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpOidTable;
import com.sun.jmx.snmp.SnmpParameters;
import com.sun.jmx.snmp.SnmpPeer;
import com.sun.jmx.snmp.SnmpString;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.SnmpVarBindList;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import sun.management.snmp.jvminstr.JvmClassLoadingImpl;
import sun.management.snmp.jvminstr.JvmCompilationImpl;
import sun.management.snmp.jvminstr.JvmMemPoolTableMetaImpl;
import sun.management.snmp.jvminstr.JvmMemoryImpl;
import sun.management.snmp.jvminstr.JvmMemoryMetaImpl;
import sun.management.snmp.jvminstr.JvmOSImpl;
import sun.management.snmp.jvminstr.JvmRuntimeImpl;
import sun.management.snmp.jvminstr.JvmRuntimeMetaImpl;
import sun.management.snmp.jvminstr.JvmThreadingImpl;
import sun.management.snmp.jvminstr.JvmThreadingMetaImpl;
import sun.management.snmp.jvminstr.NotificationTarget;
import sun.management.snmp.jvmmib.JVM_MANAGEMENT_MIB;
import sun.management.snmp.jvmmib.JVM_MANAGEMENT_MIBOidTable;
import sun.management.snmp.jvmmib.JvmCompilationMeta;
import sun.management.snmp.jvmmib.JvmMemoryMeta;
import sun.management.snmp.jvmmib.JvmRuntimeMeta;
import sun.management.snmp.jvmmib.JvmThreadingMeta;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpTableHandler;

public class JVM_MANAGEMENT_MIB_IMPL
extends JVM_MANAGEMENT_MIB {
    private static final long serialVersionUID = -8104825586888859831L;
    private static final MibLogger log = new MibLogger(JVM_MANAGEMENT_MIB_IMPL.class);
    private static WeakReference<SnmpOidTable> tableRef;
    private ArrayList<NotificationTarget> notificationTargets = new ArrayList();
    private final NotificationEmitter emitter;
    private final NotificationHandler handler = new NotificationHandler();
    private static final int DISPLAY_STRING_MAX_LENGTH = 255;
    private static final int JAVA_OBJECT_NAME_MAX_LENGTH = 1023;
    private static final int PATH_ELEMENT_MAX_LENGTH = 1023;
    private static final int ARG_VALUE_MAX_LENGTH = 1023;
    private static final int DEFAULT_CACHE_VALIDITY_PERIOD = 1000;

    public static SnmpOidTable getOidTable() {
        SnmpOidTable snmpOidTable = null;
        if (tableRef == null) {
            snmpOidTable = new JVM_MANAGEMENT_MIBOidTable();
            tableRef = new WeakReference<JVM_MANAGEMENT_MIBOidTable>((JVM_MANAGEMENT_MIBOidTable)snmpOidTable);
            return snmpOidTable;
        }
        snmpOidTable = (SnmpOidTable)tableRef.get();
        if (snmpOidTable == null) {
            snmpOidTable = new JVM_MANAGEMENT_MIBOidTable();
            tableRef = new WeakReference<JVM_MANAGEMENT_MIBOidTable>((JVM_MANAGEMENT_MIBOidTable)snmpOidTable);
        }
        return snmpOidTable;
    }

    public JVM_MANAGEMENT_MIB_IMPL() {
        this.emitter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
        this.emitter.addNotificationListener(this.handler, null, null);
    }

    private synchronized void sendTrap(SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) {
        Iterator<NotificationTarget> iterator = this.notificationTargets.iterator();
        SnmpAdaptorServer snmpAdaptorServer = (SnmpAdaptorServer)this.getSnmpAdaptor();
        if (snmpAdaptorServer == null) {
            log.error("sendTrap", "Cannot send trap: adaptor is null.");
            return;
        }
        if (!snmpAdaptorServer.isActive()) {
            log.config("sendTrap", "Adaptor is not active: trap not sent.");
            return;
        }
        while (iterator.hasNext()) {
            NotificationTarget notificationTarget = null;
            try {
                notificationTarget = iterator.next();
                SnmpPeer snmpPeer = new SnmpPeer(notificationTarget.getAddress(), notificationTarget.getPort());
                SnmpParameters snmpParameters = new SnmpParameters();
                snmpParameters.setRdCommunity(notificationTarget.getCommunity());
                snmpPeer.setParams(snmpParameters);
                log.debug("handleNotification", "Sending trap to " + notificationTarget.getAddress() + ":" + notificationTarget.getPort());
                snmpAdaptorServer.snmpV2Trap(snmpPeer, snmpOid, snmpVarBindList, null);
            }
            catch (Exception exception) {
                log.error("sendTrap", "Exception occurred while sending trap to [" + notificationTarget + "]. Exception : " + exception);
                log.debug("sendTrap", exception);
            }
        }
    }

    public synchronized void addTarget(NotificationTarget notificationTarget) throws IllegalArgumentException {
        if (notificationTarget == null) {
            throw new IllegalArgumentException("Target is null");
        }
        this.notificationTargets.add(notificationTarget);
    }

    public void terminate() {
        try {
            this.emitter.removeNotificationListener(this.handler);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            log.error("terminate", "Listener Not found : " + listenerNotFoundException);
        }
    }

    public synchronized void addTargets(List<NotificationTarget> list) throws IllegalArgumentException {
        if (list == null) {
            throw new IllegalArgumentException("Target list is null");
        }
        this.notificationTargets.addAll(list);
    }

    @Override
    protected Object createJvmMemoryMBean(String string, String string2, ObjectName objectName, MBeanServer mBeanServer) {
        if (mBeanServer != null) {
            return new JvmMemoryImpl(this, mBeanServer);
        }
        return new JvmMemoryImpl(this);
    }

    @Override
    protected JvmMemoryMeta createJvmMemoryMetaNode(String string, String string2, ObjectName objectName, MBeanServer mBeanServer) {
        return new JvmMemoryMetaImpl(this, this.objectserver);
    }

    @Override
    protected JvmThreadingMeta createJvmThreadingMetaNode(String string, String string2, ObjectName objectName, MBeanServer mBeanServer) {
        return new JvmThreadingMetaImpl(this, this.objectserver);
    }

    @Override
    protected Object createJvmThreadingMBean(String string, String string2, ObjectName objectName, MBeanServer mBeanServer) {
        if (mBeanServer != null) {
            return new JvmThreadingImpl(this, mBeanServer);
        }
        return new JvmThreadingImpl(this);
    }

    @Override
    protected JvmRuntimeMeta createJvmRuntimeMetaNode(String string, String string2, ObjectName objectName, MBeanServer mBeanServer) {
        return new JvmRuntimeMetaImpl(this, this.objectserver);
    }

    @Override
    protected Object createJvmRuntimeMBean(String string, String string2, ObjectName objectName, MBeanServer mBeanServer) {
        if (mBeanServer != null) {
            return new JvmRuntimeImpl(this, mBeanServer);
        }
        return new JvmRuntimeImpl(this);
    }

    @Override
    protected JvmCompilationMeta createJvmCompilationMetaNode(String string, String string2, ObjectName objectName, MBeanServer mBeanServer) {
        if (ManagementFactory.getCompilationMXBean() == null) {
            return null;
        }
        return super.createJvmCompilationMetaNode(string, string2, objectName, mBeanServer);
    }

    @Override
    protected Object createJvmCompilationMBean(String string, String string2, ObjectName objectName, MBeanServer mBeanServer) {
        if (mBeanServer != null) {
            return new JvmCompilationImpl(this, mBeanServer);
        }
        return new JvmCompilationImpl(this);
    }

    @Override
    protected Object createJvmOSMBean(String string, String string2, ObjectName objectName, MBeanServer mBeanServer) {
        if (mBeanServer != null) {
            return new JvmOSImpl(this, mBeanServer);
        }
        return new JvmOSImpl(this);
    }

    @Override
    protected Object createJvmClassLoadingMBean(String string, String string2, ObjectName objectName, MBeanServer mBeanServer) {
        if (mBeanServer != null) {
            return new JvmClassLoadingImpl(this, mBeanServer);
        }
        return new JvmClassLoadingImpl(this);
    }

    static String validDisplayStringTC(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() > 255) {
            return string.substring(0, 255);
        }
        return string;
    }

    static String validJavaObjectNameTC(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() > 1023) {
            return string.substring(0, 1023);
        }
        return string;
    }

    static String validPathElementTC(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() > 1023) {
            return string.substring(0, 1023);
        }
        return string;
    }

    static String validArgValueTC(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() > 1023) {
            return string.substring(0, 1023);
        }
        return string;
    }

    private SnmpTableHandler getJvmMemPoolTableHandler(Object object) {
        SnmpMibTable snmpMibTable = this.getRegisteredTableMeta("JvmMemPoolTable");
        if (!(snmpMibTable instanceof JvmMemPoolTableMetaImpl)) {
            String string = snmpMibTable == null ? "No metadata for JvmMemPoolTable" : "Bad metadata class for JvmMemPoolTable: " + snmpMibTable.getClass().getName();
            log.error("getJvmMemPoolTableHandler", string);
            return null;
        }
        JvmMemPoolTableMetaImpl jvmMemPoolTableMetaImpl = (JvmMemPoolTableMetaImpl)snmpMibTable;
        return jvmMemPoolTableMetaImpl.getHandler(object);
    }

    private int findInCache(SnmpTableHandler snmpTableHandler, String string) {
        if (!(snmpTableHandler instanceof SnmpCachedData)) {
            if (snmpTableHandler != null) {
                String string2 = "Bad class for JvmMemPoolTable datas: " + snmpTableHandler.getClass().getName();
                log.error("getJvmMemPoolEntry", string2);
            }
            return -1;
        }
        SnmpCachedData snmpCachedData = (SnmpCachedData)snmpTableHandler;
        int n = snmpCachedData.datas.length;
        for (int i = 0; i < snmpCachedData.datas.length; ++i) {
            MemoryPoolMXBean memoryPoolMXBean = (MemoryPoolMXBean)snmpCachedData.datas[i];
            if (!string.equals(memoryPoolMXBean.getName())) continue;
            return i;
        }
        return -1;
    }

    private SnmpOid getJvmMemPoolEntryIndex(SnmpTableHandler snmpTableHandler, String string) {
        int n = this.findInCache(snmpTableHandler, string);
        if (n < 0) {
            return null;
        }
        return ((SnmpCachedData)snmpTableHandler).indexes[n];
    }

    private SnmpOid getJvmMemPoolEntryIndex(String string) {
        return this.getJvmMemPoolEntryIndex(this.getJvmMemPoolTableHandler(null), string);
    }

    public long validity() {
        return 1000L;
    }

    private class NotificationHandler
    implements NotificationListener {
        private NotificationHandler() {
        }

        @Override
        public void handleNotification(Notification notification, Object object) {
            log.debug("handleNotification", "Received notification [ " + notification.getType() + "]");
            String string = notification.getType();
            if (string.equals("java.management.memory.threshold.exceeded") || string.equals("java.management.memory.collection.threshold.exceeded")) {
                MemoryNotificationInfo memoryNotificationInfo = MemoryNotificationInfo.from((CompositeData)notification.getUserData());
                SnmpCounter64 snmpCounter64 = new SnmpCounter64(memoryNotificationInfo.getCount());
                SnmpCounter64 snmpCounter642 = new SnmpCounter64(memoryNotificationInfo.getUsage().getUsed());
                SnmpString snmpString = new SnmpString(memoryNotificationInfo.getPoolName());
                SnmpOid snmpOid = JVM_MANAGEMENT_MIB_IMPL.this.getJvmMemPoolEntryIndex(memoryNotificationInfo.getPoolName());
                if (snmpOid == null) {
                    log.error("handleNotification", "Error: Can't find entry index for Memory Pool: " + memoryNotificationInfo.getPoolName() + ": " + "No trap emitted for " + string);
                    return;
                }
                SnmpOid snmpOid2 = null;
                SnmpOidTable snmpOidTable = JVM_MANAGEMENT_MIB_IMPL.getOidTable();
                try {
                    SnmpOid snmpOid3 = null;
                    SnmpOid snmpOid4 = null;
                    if (string.equals("java.management.memory.threshold.exceeded")) {
                        snmpOid2 = new SnmpOid(snmpOidTable.resolveVarName("jvmLowMemoryPoolUsageNotif").getOid());
                        snmpOid3 = new SnmpOid(snmpOidTable.resolveVarName("jvmMemPoolUsed").getOid() + "." + snmpOid);
                        snmpOid4 = new SnmpOid(snmpOidTable.resolveVarName("jvmMemPoolThreshdCount").getOid() + "." + snmpOid);
                    } else if (string.equals("java.management.memory.collection.threshold.exceeded")) {
                        snmpOid2 = new SnmpOid(snmpOidTable.resolveVarName("jvmLowMemoryPoolCollectNotif").getOid());
                        snmpOid3 = new SnmpOid(snmpOidTable.resolveVarName("jvmMemPoolCollectUsed").getOid() + "." + snmpOid);
                        snmpOid4 = new SnmpOid(snmpOidTable.resolveVarName("jvmMemPoolCollectThreshdCount").getOid() + "." + snmpOid);
                    }
                    SnmpVarBindList snmpVarBindList = new SnmpVarBindList();
                    SnmpOid snmpOid5 = new SnmpOid(snmpOidTable.resolveVarName("jvmMemPoolName").getOid() + "." + snmpOid);
                    SnmpVarBind snmpVarBind = new SnmpVarBind(snmpOid4, snmpCounter64);
                    SnmpVarBind snmpVarBind2 = new SnmpVarBind(snmpOid3, snmpCounter642);
                    SnmpVarBind snmpVarBind3 = new SnmpVarBind(snmpOid5, snmpString);
                    snmpVarBindList.add(snmpVarBind3);
                    snmpVarBindList.add(snmpVarBind);
                    snmpVarBindList.add(snmpVarBind2);
                    JVM_MANAGEMENT_MIB_IMPL.this.sendTrap(snmpOid2, snmpVarBindList);
                }
                catch (Exception exception) {
                    log.error("handleNotification", "Exception occurred : " + exception);
                }
            }
        }
    }
}

