/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi;

import com.fasterxml.jackson.core.type.TypeReference;
import fr.proline.core.orm.msi.MasterQuantComponent;
import fr.proline.core.orm.msi.MasterQuantReporterIon;
import fr.proline.core.orm.msi.PeptideInstance;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DQuantPeptideIon;
import fr.proline.core.orm.util.JsonSerializer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="master_quant_peptide_ion")
public class MasterQuantPeptideIon
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DMasterQuantProteinSet.class);
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Column(name="charge")
    private int charge;
    @Column(name="moz")
    private double moz;
    @Column(name="elution_time")
    private float elutionTime;
    @Column(name="scan_number")
    private Integer scanNumber;
    @Column(name="peptide_match_count")
    private int peptideMatchCount;
    @Column(name="serialized_properties")
    private String serializedProperties;
    @Column(name="lcms_master_feature_id")
    private Long lcmsMasterFeatureId;
    @Column(name="master_quant_peptide_id")
    private long masterQuantPeptideId;
    @Column(name="peptide_id")
    private Long peptideId;
    @ManyToOne
    @JoinColumn(name="peptide_instance_id")
    private PeptideInstance peptideInstance;
    @Column(name="best_peptide_match_id")
    private Long bestPeptideMatchId;
    @Column(name="unmodified_peptide_ion_id")
    private Long unmodifiedPeptideIonId;
    @Transient
    private Map<Long, DQuantPeptideIon> quantPeptideIonByQchIds = null;
    @ManyToOne
    @JoinColumn(name="master_quant_component_id")
    private MasterQuantComponent masterQuantComponent;
    @OneToMany(mappedBy="masterQuantPeptideIon")
    private Set<MasterQuantReporterIon> masterQuantReporterIons;
    @ManyToOne
    @JoinColumn(name="result_summary_id")
    private ResultSummary resultSummary;

    public Map<Long, DQuantPeptideIon> getQuantPeptideIonByQchIds() {
        return this.quantPeptideIonByQchIds;
    }

    public void setQuantPeptideIonByQchIds(Map<Long, DQuantPeptideIon> quantPeptideIonByQchIds) {
        this.quantPeptideIonByQchIds = quantPeptideIonByQchIds;
    }

    public Map<Long, DQuantPeptideIon> parseQuantPeptideIonFromProperties(String quantPeptideIonData) {
        try {
            List quantPepIons = (List)JsonSerializer.getMapper().readValue(quantPeptideIonData, (TypeReference)new TypeReference<List<DQuantPeptideIon>>(){});
            this.quantPeptideIonByQchIds = new HashMap<Long, DQuantPeptideIon>();
            if (quantPepIons != null) {
                for (int i = 0; i < quantPepIons.size(); ++i) {
                    DQuantPeptideIon nextQuantPepIon = (DQuantPeptideIon)quantPepIons.get(i);
                    if (nextQuantPepIon == null) continue;
                    this.quantPeptideIonByQchIds.put(nextQuantPepIon.getQuantChannelId(), nextQuantPepIon);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error Parsing DQuantPeptideIon ", (Throwable)e);
            LOG.warn("quantPeptideIonData= " + quantPeptideIonData);
            this.quantPeptideIonByQchIds = null;
        }
        return this.quantPeptideIonByQchIds;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public int getCharge() {
        return this.charge;
    }

    public void setCharge(int charge) {
        this.charge = charge;
    }

    public double getMoz() {
        return this.moz;
    }

    public void setMoz(double pMoz) {
        this.moz = pMoz;
    }

    public float getElutionTime() {
        return this.elutionTime;
    }

    public void setElutionTime(float pElutionTime) {
        this.elutionTime = pElutionTime;
    }

    public Integer getScanNumber() {
        return this.scanNumber;
    }

    public void setScanNumber(Integer scanNumber) {
        this.scanNumber = scanNumber;
    }

    public int getPeptideMatchCount() {
        return this.peptideMatchCount;
    }

    public void setPeptideMatchCount(int pPeptideMatchCount) {
        this.peptideMatchCount = pPeptideMatchCount;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public Long getLcmsMasterFeatureId() {
        return this.lcmsMasterFeatureId;
    }

    public void setLcmsMasterFeatureId(Long pLcmsMasterFeatureId) {
        this.lcmsMasterFeatureId = pLcmsMasterFeatureId;
    }

    public long getMasterQuantPeptideId() {
        return this.masterQuantPeptideId;
    }

    public void setMasterQuantPeptideId(long pMasterQuantPeptideId) {
        this.masterQuantPeptideId = pMasterQuantPeptideId;
    }

    public Long getPeptideId() {
        return this.peptideId;
    }

    public void setPeptideId(Long pPeptideId) {
        this.peptideId = pPeptideId;
    }

    public PeptideInstance getPeptideInstance() {
        return this.peptideInstance;
    }

    public void setPeptideInstance(PeptideInstance pPeptideInstance) {
        this.peptideInstance = pPeptideInstance;
    }

    public Long getBestPeptideMatchId() {
        return this.bestPeptideMatchId;
    }

    public void setBestPeptideMatchId(Long pBestPeptideMatchId) {
        this.bestPeptideMatchId = pBestPeptideMatchId;
    }

    public Long getUnmodifiedPeptideIonId() {
        return this.unmodifiedPeptideIonId;
    }

    public void setUnmodifiedPeptideIonId(Long pUnmodifiedPeptideIonId) {
        this.unmodifiedPeptideIonId = pUnmodifiedPeptideIonId;
    }

    public MasterQuantComponent getMasterQuantComponent() {
        return this.masterQuantComponent;
    }

    public void setMasterQuantComponent(MasterQuantComponent masterQuantComponent) {
        this.masterQuantComponent = masterQuantComponent;
    }

    public ResultSummary getResultSummary() {
        return this.resultSummary;
    }

    public void setResultSummary(ResultSummary resultSummary) {
        this.resultSummary = resultSummary;
    }

    public Set<MasterQuantReporterIon> getMasterQuantReporterIons() {
        return this.masterQuantReporterIons;
    }

    public void setMasterQuantReporterIons(Set<MasterQuantReporterIon> masterQuantReporterIons) {
        this.masterQuantReporterIons = masterQuantReporterIons;
    }
}

