/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi.dto;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.SequenceMatch;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptidePTM;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DPtmSiteProperties;
import fr.proline.core.orm.util.JsonSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class DPeptideMatch
implements Comparable<DPeptideMatch> {
    public static final String ISOTOPE_OFFSET_KEY = "isotope_offset";
    private long m_id;
    private Integer m_rank;
    private int m_charge;
    private Float m_deltaMoz;
    private double m_experimentalMoz;
    private int m_missedCleavage;
    private Float m_score;
    private Peptide m_peptide;
    private long m_resultSetId;
    private DMsQuery m_msQuery;
    private boolean m_msQuerySet;
    private SequenceMatch m_sequenceMatch;
    private DProteinMatch[] m_proteinMatchArray = null;
    private String[] m_proteinSetStringArray = null;
    private Integer m_cdPrettyRank;
    private Integer m_sdPrettyRank;
    private Float m_retentionTime;
    private String m_sourceDatFile = null;
    private Boolean m_isDecoy;
    private Boolean m_isValidated;
    private String m_serializedProperties = null;
    private ArrayList<DPeptidePTM> m_peptidePTMArray = null;
    private DPtmSiteProperties m_ptmSiteProperties = null;
    private Integer m_isotopeOff = 0;

    public DPeptideMatch(long id, Integer rank, int charge, Float deltaMoz, double experimentalMoz, int missedCleavage, Float score, long resultSetId, Integer cdPrettyRank, Integer sdPrettyRank, String serializedProperties) {
        this.m_id = id;
        this.m_rank = rank;
        this.m_charge = charge;
        this.m_deltaMoz = deltaMoz;
        this.m_experimentalMoz = experimentalMoz;
        this.m_missedCleavage = missedCleavage;
        this.m_score = score;
        this.m_resultSetId = resultSetId;
        this.m_peptide = null;
        this.m_msQuery = null;
        this.m_msQuerySet = false;
        this.m_sequenceMatch = null;
        this.m_proteinMatchArray = null;
        this.m_cdPrettyRank = cdPrettyRank;
        this.m_sdPrettyRank = sdPrettyRank;
        this.m_isDecoy = false;
        this.m_isValidated = false;
        this.m_serializedProperties = serializedProperties;
        this.setIsotopeOffFromSerializedProperties();
    }

    public DPeptideMatch(long id, Integer rank, int charge, Float deltaMoz, double experimentalMoz, int missedCleavage, Float score, long resultSetId, Integer cdPrettyRank, Integer sdPrettyRank) {
        this.m_id = id;
        this.m_rank = rank;
        this.m_charge = charge;
        this.m_deltaMoz = deltaMoz;
        this.m_experimentalMoz = experimentalMoz;
        this.m_missedCleavage = missedCleavage;
        this.m_score = score;
        this.m_resultSetId = resultSetId;
        this.m_peptide = null;
        this.m_msQuery = null;
        this.m_msQuerySet = false;
        this.m_sequenceMatch = null;
        this.m_proteinMatchArray = null;
        this.m_cdPrettyRank = cdPrettyRank;
        this.m_sdPrettyRank = sdPrettyRank;
        this.m_isDecoy = false;
        this.m_isValidated = false;
    }

    public DPeptideMatch(long id, Integer rank, int charge, Float deltaMoz, double experimentalMoz, int missedCleavage, Float score, long resultSetId, Integer cdPrettyRank, Integer sdPrettyRank, Boolean isDecoy) {
        this.m_id = id;
        this.m_rank = rank;
        this.m_charge = charge;
        this.m_deltaMoz = deltaMoz;
        this.m_experimentalMoz = experimentalMoz;
        this.m_missedCleavage = missedCleavage;
        this.m_score = score;
        this.m_resultSetId = resultSetId;
        this.m_peptide = null;
        this.m_msQuery = null;
        this.m_msQuerySet = false;
        this.m_sequenceMatch = null;
        this.m_proteinMatchArray = null;
        this.m_cdPrettyRank = cdPrettyRank;
        this.m_sdPrettyRank = sdPrettyRank;
        this.m_isDecoy = isDecoy;
    }

    public DPeptideMatch(long id, Integer rank, int charge, Float deltaMoz, double experimentalMoz, int missedCleavage, Float score, long resultSetId, Integer cdPrettyRank, Integer sdPrettyRank, Boolean isDecoy, String serializedProperties) {
        this.m_id = id;
        this.m_rank = rank;
        this.m_charge = charge;
        this.m_deltaMoz = deltaMoz;
        this.m_experimentalMoz = experimentalMoz;
        this.m_missedCleavage = missedCleavage;
        this.m_score = score;
        this.m_resultSetId = resultSetId;
        this.m_peptide = null;
        this.m_msQuery = null;
        this.m_msQuerySet = false;
        this.m_sequenceMatch = null;
        this.m_proteinMatchArray = null;
        this.m_cdPrettyRank = cdPrettyRank;
        this.m_sdPrettyRank = sdPrettyRank;
        this.m_isDecoy = isDecoy;
        this.m_serializedProperties = serializedProperties;
        this.setIsotopeOffFromSerializedProperties();
    }

    public long getId() {
        return this.m_id;
    }

    public void setPeptide(Peptide p) {
        this.m_peptide = p;
    }

    public Peptide getPeptide() {
        return this.m_peptide;
    }

    public String getSerializedProperties() {
        return this.m_serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.m_serializedProperties = serializedProperties;
        this.setIsotopeOffFromSerializedProperties();
    }

    public void setSequenceMatch(SequenceMatch sequenceMatch) {
        this.m_sequenceMatch = sequenceMatch;
    }

    public SequenceMatch getSequenceMatch() {
        return this.m_sequenceMatch;
    }

    public Float getScore() {
        return this.m_score;
    }

    public Integer getRank() {
        return this.m_rank;
    }

    public Integer getCDPrettyRank() {
        return this.m_cdPrettyRank;
    }

    public Integer getSDPrettyRank() {
        return this.m_sdPrettyRank;
    }

    public int getCharge() {
        return this.m_charge;
    }

    public double getExperimentalMoz() {
        return this.m_experimentalMoz;
    }

    public Float getDeltaMoz() {
        return this.m_deltaMoz;
    }

    public int getMissedCleavage() {
        return this.m_missedCleavage;
    }

    public long getResultSetId() {
        return this.m_resultSetId;
    }

    public void setMsQuery(DMsQuery msQuery) {
        this.m_msQuery = msQuery;
        this.m_msQuerySet = true;
    }

    public DMsQuery getMsQuery() {
        return this.m_msQuery;
    }

    public boolean isMsQuerySet() {
        return this.m_msQuerySet;
    }

    public String[] getProteinSetStringArray() {
        return this.m_proteinSetStringArray;
    }

    public void setProteinSetStringArray(String[] s) {
        this.m_proteinSetStringArray = s;
    }

    public DProteinMatch[] getProteinMatches() {
        return this.m_proteinMatchArray;
    }

    public void setProteinMatches(DProteinMatch[] proteinMatchArray) {
        this.m_proteinMatchArray = proteinMatchArray;
    }

    @Override
    public int compareTo(DPeptideMatch peptideMatch) {
        if (this.m_peptide == null) {
            return 0;
        }
        if (peptideMatch.m_peptide == null) {
            return 0;
        }
        return this.m_peptide.compareTo(peptideMatch.m_peptide);
    }

    public Float getRetentionTime() {
        return this.m_retentionTime;
    }

    public void setRetentionTime(Float retentionTime) {
        this.m_retentionTime = retentionTime;
    }

    public String getSourceDatFile() {
        return this.m_sourceDatFile;
    }

    public void setSourceDatFile(String sourceDatFile) {
        this.m_sourceDatFile = sourceDatFile;
    }

    public Boolean isDecoy() {
        return this.m_isDecoy;
    }

    public void setDecoy(Boolean isDecoy) {
        this.m_isDecoy = isDecoy;
    }

    public Boolean isValidated() {
        return this.m_isValidated;
    }

    public void setValidated(Boolean isValidated) {
        this.m_isValidated = isValidated;
    }

    public ArrayList<DPeptidePTM> getPeptidePTMArray() {
        return this.m_peptidePTMArray;
    }

    public Integer getIsotopeOffset() {
        return this.m_isotopeOff;
    }

    public void setPeptidePTMArray(ArrayList<DPeptidePTM> peptidePTMArray) {
        this.m_peptidePTMArray = peptidePTMArray;
    }

    public DPtmSiteProperties getPtmSiteProperties() {
        return this.m_ptmSiteProperties;
    }

    public void setPtmSiteProperties(DPtmSiteProperties m_ptmSiteProperties) {
        this.m_ptmSiteProperties = m_ptmSiteProperties;
    }

    private void setIsotopeOffFromSerializedProperties() {
        this.m_isotopeOff = 0;
        try {
            Object value;
            Map pmqSerializedMap;
            if (this.m_serializedProperties != null && (pmqSerializedMap = (Map)JsonSerializer.getMapper().readValue(this.m_serializedProperties, Map.class)) != null && (value = pmqSerializedMap.get(ISOTOPE_OFFSET_KEY)) != null) {
                this.m_isotopeOff = Integer.parseInt(value.toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

