/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi.repository;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.msi.Scoring;
import fr.proline.repository.util.JPAUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;

public final class ScoringRepository {
    private static final Map<String, Long> SCORING_IDS_CACHE = new HashMap<String, Long>();
    private static final Map<Long, String> SCORE_TYPES_CACHE = new HashMap<Long, String>();
    private static final Object CACHE_LOCK = new Object();

    private ScoringRepository() {
    }

    public static Scoring findScoringForType(EntityManager msiEm, String scoreType) {
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        if (StringUtils.isEmpty((String)scoreType)) {
            throw new IllegalArgumentException("Invalid scoreType");
        }
        Scoring result = null;
        TypedQuery query = msiEm.createNamedQuery("findScoringForScoreType", Scoring.class);
        query.setParameter("scoreType", (Object)scoreType);
        List scorings = query.getResultList();
        if (scorings != null && !scorings.isEmpty()) {
            if (scorings.size() == 1) {
                result = (Scoring)scorings.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one Scoring for given scoreType");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getScoringIdForType(EntityManager msiEm, String scoreType) {
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        if (StringUtils.isEmpty((String)scoreType)) {
            throw new IllegalArgumentException("Invalid scoreType");
        }
        Long result = null;
        Object object = CACHE_LOCK;
        synchronized (object) {
            Scoring foundScoring;
            result = SCORING_IDS_CACHE.get(scoreType);
            if (result == null && (foundScoring = ScoringRepository.findScoringForType(msiEm, scoreType)) != null && (result = Long.valueOf(foundScoring.getId())) != null) {
                SCORING_IDS_CACHE.put(scoreType, result);
                String searchEngine = foundScoring.getSearchEngine();
                String name = foundScoring.getName();
                if (searchEngine != null && name != null) {
                    SCORE_TYPES_CACHE.put(result, searchEngine + ':' + name);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getScoreTypeForId(EntityManager msiEm, long scoringId) {
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        Long scoringIdKey = scoringId;
        String result = null;
        Object object = CACHE_LOCK;
        synchronized (object) {
            Scoring foundScoring;
            result = SCORE_TYPES_CACHE.get(scoringIdKey);
            if (result == null && (foundScoring = (Scoring)msiEm.find(Scoring.class, (Object)scoringIdKey)) != null) {
                String searchEngine = foundScoring.getSearchEngine();
                String name = foundScoring.getName();
                if (searchEngine != null && name != null) {
                    String scoreType = searchEngine + ':' + name;
                    SCORING_IDS_CACHE.put(scoreType, scoringIdKey);
                    SCORE_TYPES_CACHE.put(scoringIdKey, scoreType);
                    result = scoreType;
                }
            }
        }
        return result;
    }
}

