/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.uds;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.uds.Project;
import fr.proline.repository.ConnectionMode;
import fr.proline.repository.DriverType;
import fr.proline.repository.ProlineDatabaseType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@NamedQueries(value={@NamedQuery(name="findExternalDbByType", query="select ed from fr.proline.core.orm.uds.ExternalDb ed where ed.type = :type"), @NamedQuery(name="findExternalDbByTypeAndProject", query="select ed from fr.proline.core.orm.uds.ExternalDb ed join ed.projects as dBProject where (ed.type = :type) and (dBProject = :project)")})
@Table(name="external_db")
public class ExternalDb
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ExternalDb.class);
    private static final int URL_BUFFER_SIZE = 256;
    private static final int MAX_PORT = 65535;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Transient
    private DriverType driverType;
    @Column(name="name")
    private String dbName;
    @Column(name="version")
    private String dbVersion;
    private String host;
    @Column(name="is_busy")
    private boolean isBusy;
    private Integer port;
    @Column(name="serialized_properties")
    private String serializedProperties;
    @Enumerated(value=EnumType.STRING)
    private ProlineDatabaseType type;
    @Column(name="connection_mode")
    @Enumerated(value=EnumType.STRING)
    private ConnectionMode connectionMode;
    @ManyToMany(mappedBy="externalDatabases")
    private Set<Project> projects;

    public void setId(long pId) {
        this.id = pId;
    }

    public long getId() {
        return this.id;
    }

    public void setDriverType(DriverType dt) {
        this.driverType = dt;
    }

    public DriverType getDriverType() {
        return this.driverType;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public void setDbVersion(String dbVersion) {
        this.dbVersion = dbVersion;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean getIsBusy() {
        return this.isBusy;
    }

    public void setIsBusy(boolean pIsBusy) {
        this.isBusy = pIsBusy;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public ProlineDatabaseType getType() {
        return this.type;
    }

    public void setType(ProlineDatabaseType databaseType) {
        this.type = databaseType;
    }

    public void setProjects(Set<Project> pProjects) {
        this.projects = pProjects;
    }

    public Set<Project> getProjects() {
        return this.projects;
    }

    public void addProject(Project project) {
        if (project != null) {
            Set<Project> localProjects = this.getProjects();
            if (localProjects == null) {
                localProjects = new HashSet<Project>();
                this.setProjects(localProjects);
            }
            localProjects.add(project);
        }
    }

    public void removeProject(Project project) {
        Set<Project> localProjects = this.getProjects();
        if (localProjects != null) {
            localProjects.remove(project);
        }
    }

    public ConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public void setConnectionMode(ConnectionMode connectMode) {
        this.connectionMode = connectMode;
    }

    public Map<Object, Object> toPropertiesMap(String userName, String password) {
        DriverType dt = this.getDriverType();
        if (dt == null) {
            throw new IllegalArgumentException("DriverType is null");
        }
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.put("javax.persistence.jdbc.driver", dt.getJdbcDriver());
        StringBuilder urlBuilder = new StringBuilder(256);
        urlBuilder.append("jdbc").append(':');
        urlBuilder.append(this.driverType.name().toLowerCase()).append(':');
        String databasePathname = this.getDbName();
        switch (this.getConnectionMode()) {
            case MEMORY: {
                if (dt == DriverType.SQLITE) {
                    urlBuilder.append(":memory:");
                    break;
                }
                urlBuilder.append("mem:");
                if (StringUtils.isEmpty((String)databasePathname)) break;
                urlBuilder.append(databasePathname);
                break;
            }
            case FILE: {
                if (dt != DriverType.SQLITE) {
                    urlBuilder.append("file:");
                }
                if (StringUtils.isEmpty((String)databasePathname)) break;
                urlBuilder.append(databasePathname);
                break;
            }
            case HOST: {
                int portValue;
                Integer serverPort;
                if (dt == DriverType.H2) {
                    urlBuilder.append("tcp:");
                }
                urlBuilder.append("//");
                String serverHostName = this.getHost();
                if (!StringUtils.isEmpty((String)serverHostName)) {
                    urlBuilder.append(serverHostName);
                }
                if ((serverPort = this.getPort()) != null && 0 < (portValue = serverPort.intValue()) && portValue <= 65535) {
                    urlBuilder.append(':').append(portValue);
                }
                urlBuilder.append('/');
                if (StringUtils.isEmpty((String)databasePathname)) break;
                urlBuilder.append(databasePathname);
            }
        }
        LOG.debug("Database URL [{}]", (Object)urlBuilder);
        properties.put("javax.persistence.jdbc.url", urlBuilder.toString());
        boolean authent = false;
        if (!StringUtils.isEmpty((String)userName)) {
            authent = true;
            properties.put("javax.persistence.jdbc.user", userName);
        }
        if (StringUtils.isEmpty((String)password)) {
            if (authent) {
                properties.put("javax.persistence.jdbc.password", "");
            }
        } else {
            properties.put("javax.persistence.jdbc.password", password);
        }
        return properties;
    }

    public Map<Object, Object> toPropertiesMap(DriverType dt, String userName, String password) {
        if (dt != null) {
            this.setDriverType(dt);
        }
        return this.toPropertiesMap(userName, password);
    }
}

