/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.uds.repository;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.uds.Enzyme;
import fr.proline.repository.util.JPAUtils;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;

public final class UdsEnzymeRepository {
    private UdsEnzymeRepository() {
    }

    public static Enzyme findEnzymeForName(EntityManager udsEm, String name) {
        JPAUtils.checkEntityManager((EntityManager)udsEm);
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Invalid name");
        }
        Enzyme result = null;
        TypedQuery query = udsEm.createNamedQuery("findUdsEnzymeForName", Enzyme.class);
        query.setParameter("name", (Object)name.toUpperCase());
        List enzymes = query.getResultList();
        if (enzymes != null && !enzymes.isEmpty()) {
            if (enzymes.size() == 1) {
                result = (Enzyme)enzymes.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one Enzyme for given name");
            }
        }
        return result;
    }
}

