/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.inf.sape.hac;

import ch.usi.inf.sape.hac.ClusteringBuilder;
import ch.usi.inf.sape.hac.agglomeration.AgglomerationMethod;
import ch.usi.inf.sape.hac.experiment.DissimilarityMeasure;
import ch.usi.inf.sape.hac.experiment.Experiment;

public final class HierarchicalAgglomerativeClusterer {
    private Experiment experiment;
    private DissimilarityMeasure dissimilarityMeasure;
    private AgglomerationMethod agglomerationMethod;

    public HierarchicalAgglomerativeClusterer(Experiment experiment, DissimilarityMeasure dissimilarityMeasure, AgglomerationMethod agglomerationMethod) {
        this.experiment = experiment;
        this.dissimilarityMeasure = dissimilarityMeasure;
        this.agglomerationMethod = agglomerationMethod;
    }

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public void setDissimilarityMeasure(DissimilarityMeasure dissimilarityMeasure) {
        this.dissimilarityMeasure = dissimilarityMeasure;
    }

    public DissimilarityMeasure getDissimilarityMeasure() {
        return this.dissimilarityMeasure;
    }

    public void setAgglomerationMethod(AgglomerationMethod agglomerationMethod) {
        this.agglomerationMethod = agglomerationMethod;
    }

    public AgglomerationMethod getAgglomerationMethod() {
        return this.agglomerationMethod;
    }

    public void cluster(ClusteringBuilder clusteringBuilder) {
        double[][] dissimilarityMatrix = this.computeDissimilarityMatrix();
        int nObservations = dissimilarityMatrix.length;
        boolean[] indexUsed = new boolean[nObservations];
        int[] clusterCardinalities = new int[nObservations];
        int i = 0;
        while (i < nObservations) {
            indexUsed[i] = true;
            clusterCardinalities[i] = 1;
            ++i;
        }
        int a = 1;
        while (a < nObservations) {
            Pair pair = HierarchicalAgglomerativeClusterer.findMostSimilarClusters(dissimilarityMatrix, indexUsed);
            int i2 = pair.getSmaller();
            int j = pair.getLarger();
            double d = dissimilarityMatrix[i2][j];
            int k = 0;
            while (k < nObservations) {
                if (k != i2 && k != j && indexUsed[k]) {
                    double dissimilarity;
                    dissimilarityMatrix[i2][k] = dissimilarity = this.agglomerationMethod.computeDissimilarity(dissimilarityMatrix[i2][k], dissimilarityMatrix[j][k], dissimilarityMatrix[i2][j], clusterCardinalities[i2], clusterCardinalities[j], clusterCardinalities[k]);
                    dissimilarityMatrix[k][i2] = dissimilarity;
                }
                ++k;
            }
            clusterCardinalities[i2] = clusterCardinalities[i2] + clusterCardinalities[j];
            indexUsed[j] = false;
            k = 0;
            while (k < nObservations) {
                dissimilarityMatrix[j][k] = Double.POSITIVE_INFINITY;
                dissimilarityMatrix[k][j] = Double.POSITIVE_INFINITY;
                ++k;
            }
            clusteringBuilder.merge(i2, j, d);
            ++a;
        }
    }

    private double[][] computeDissimilarityMatrix() {
        double[][] dissimilarityMatrix = new double[this.experiment.getNumberOfObservations()][this.experiment.getNumberOfObservations()];
        int o = 0;
        while (o < dissimilarityMatrix.length) {
            dissimilarityMatrix[o][o] = 0.0;
            ++o;
        }
        int o1 = 0;
        while (o1 < dissimilarityMatrix.length) {
            int o2 = 0;
            while (o2 < o1) {
                double dissimilarity;
                dissimilarityMatrix[o1][o2] = dissimilarity = this.dissimilarityMeasure.computeDissimilarity(this.experiment, o1, o2);
                dissimilarityMatrix[o2][o1] = dissimilarity;
                ++o2;
            }
            ++o1;
        }
        return dissimilarityMatrix;
    }

    private static Pair findMostSimilarClusters(double[][] dissimilarityMatrix, boolean[] indexUsed) {
        Pair mostSimilarPair = new Pair();
        double smallestDissimilarity = Double.POSITIVE_INFINITY;
        int cluster = 0;
        while (cluster < dissimilarityMatrix.length) {
            if (indexUsed[cluster]) {
                int neighbor = 0;
                while (neighbor < dissimilarityMatrix.length) {
                    if (indexUsed[neighbor] && dissimilarityMatrix[cluster][neighbor] < smallestDissimilarity && cluster != neighbor) {
                        smallestDissimilarity = dissimilarityMatrix[cluster][neighbor];
                        mostSimilarPair.set(cluster, neighbor);
                    }
                    ++neighbor;
                }
            }
            ++cluster;
        }
        return mostSimilarPair;
    }

    private static final class Pair {
        private int cluster1;
        private int cluster2;

        private Pair() {
        }

        public final void set(int cluster1, int cluster2) {
            this.cluster1 = cluster1;
            this.cluster2 = cluster2;
        }

        public final int getLarger() {
            return Math.max(this.cluster1, this.cluster2);
        }

        public final int getSmaller() {
            return Math.min(this.cluster1, this.cluster2);
        }
    }
}

