/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam;

import fr.proline.studio.dam.AccessDatabaseWorkerThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;

public class AccessDatabaseWorkerPool {
    private static AccessDatabaseWorkerPool m_workerPool = null;
    private AccessDatabaseWorkerThread m_highThread = null;
    private AccessDatabaseWorkerThread m_normalThread = null;
    private AccessDatabaseWorkerThread m_lowThread = null;

    public static synchronized AccessDatabaseWorkerPool getWorkerPool() {
        if (m_workerPool == null) {
            m_workerPool = new AccessDatabaseWorkerPool();
        }
        return m_workerPool;
    }

    private AccessDatabaseWorkerPool() {
    }

    public Object getMutex() {
        return this;
    }

    public synchronized void threadFinished() {
        this.notifyAll();
    }

    public synchronized AccessDatabaseWorkerThread getWorkerThread(AbstractDatabaseTask.Priority priority) {
        switch (priority) {
            case TOP: 
            case HIGH_3: 
            case HIGH_2: 
            case HIGH_1: {
                return this.getHighThread();
            }
            case NORMAL_3: 
            case NORMAL_2: 
            case NORMAL_1: {
                return this.getNormalThread();
            }
        }
        return this.getLowThread();
    }

    private AccessDatabaseWorkerThread getHighThread() {
        if (this.m_highThread == null) {
            this.m_highThread = new AccessDatabaseWorkerThread(this);
            this.m_highThread.start();
            return this.m_highThread;
        }
        if (this.m_highThread.isAvailable()) {
            return this.m_highThread;
        }
        return this.getNormalThread();
    }

    private AccessDatabaseWorkerThread getNormalThread() {
        if (this.m_normalThread == null) {
            this.m_normalThread = new AccessDatabaseWorkerThread(this);
            this.m_normalThread.start();
            return this.m_normalThread;
        }
        if (this.m_normalThread.isAvailable()) {
            return this.m_normalThread;
        }
        return this.getLowThread();
    }

    private AccessDatabaseWorkerThread getLowThread() {
        if (this.m_lowThread == null) {
            this.m_lowThread = new AccessDatabaseWorkerThread(this);
            this.m_lowThread.start();
            return this.m_lowThread;
        }
        if (this.m_lowThread.isAvailable()) {
            return this.m_lowThread;
        }
        return null;
    }
}

