/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.memory;

import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.memory.MemoryReference;
import fr.proline.studio.dam.memory.TransientMemoryClientInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransientMemoryCacheManager
implements TransientDataAllocationListener {
    protected static final Logger m_logger = LoggerFactory.getLogger("ProlineStudio.TransientMemoryCacheManager");
    private static TransientMemoryCacheManager m_singleton = null;
    public HashMap<TransientDataInterface, HashSet<TransientMemoryClientInterface>> m_cacheToClients = new HashMap();
    public HashMap<TransientMemoryClientInterface, HashSet<TransientDataInterface>> m_clientToCaches = new HashMap();
    public HashMap<TransientDataInterface, HashSet<ClientName>> m_cacheToClientsName = new HashMap();

    public static synchronized TransientMemoryCacheManager getSingleton() {
        if (m_singleton == null) {
            m_singleton = new TransientMemoryCacheManager();
        }
        return m_singleton;
    }

    public synchronized void memoryAllocated(TransientDataInterface cache) {
        m_logger.debug("Cache Allocated " + cache);
        if (this.m_cacheToClients.containsKey(cache)) {
            return;
        }
        this.m_cacheToClients.put(cache, new HashSet());
    }

    public synchronized void linkCache(TransientMemoryClientInterface client, TransientDataInterface cache) {
        if (cache == null) {
            return;
        }
        m_logger.debug("Link Cache " + cache);
        HashSet<TransientMemoryClientInterface> clientSet = this.m_cacheToClients.get(cache);
        if (clientSet == null) {
            clientSet = new HashSet();
            this.m_cacheToClients.put(cache, clientSet);
        }
        clientSet.add(client);
        HashSet<Object> cacheSet = this.m_clientToCaches.get(client);
        if (cacheSet == null) {
            cacheSet = new HashSet();
            this.m_clientToCaches.put(client, cacheSet);
        }
        cacheSet.add(cache);
        HashSet<ClientName> nameSet = this.m_cacheToClientsName.get(cache);
        if (nameSet == null) {
            nameSet = new HashSet();
            this.m_cacheToClientsName.put(cache, nameSet);
        }
        nameSet.add(new ClientName(client.getMemoryClientName(), client.getMemoryDataName()));
    }

    public synchronized void unlinkCache(TransientMemoryClientInterface client) {
        HashSet<TransientDataInterface> cacheSet = this.m_clientToCaches.get(client);
        if (cacheSet == null) {
            return;
        }
        m_logger.debug("Unlink Cache " + client);
        this.m_clientToCaches.remove(client);
        for (TransientDataInterface cache : cacheSet) {
            HashSet<TransientMemoryClientInterface> clientSet = this.m_cacheToClients.get(cache);
            if (clientSet == null) continue;
            clientSet.remove(client);
        }
    }

    public synchronized void freeUnusedCache() {
        m_logger.debug("Free unused Caches");
        HashSet<TransientDataInterface> tmpSet = new HashSet<TransientDataInterface>(this.m_cacheToClients.keySet());
        for (TransientDataInterface cache : tmpSet) {
            if (!this.m_cacheToClients.get(cache).isEmpty()) continue;
            cache.clearMemory();
            this.m_cacheToClients.remove(cache);
            this.m_cacheToClientsName.remove(cache);
        }
    }

    public ArrayList<MemoryReference> getFreeCacheList() {
        return this.getCacheList(true);
    }

    public ArrayList<MemoryReference> getUsedCacheList() {
        return this.getCacheList(false);
    }

    private synchronized ArrayList<MemoryReference> getCacheList(boolean free) {
        ArrayList<MemoryReference> clientNamesSet = new ArrayList<MemoryReference>();
        for (TransientDataInterface cache : this.m_cacheToClients.keySet()) {
            if (free && this.m_cacheToClients.get(cache).isEmpty()) {
                if (this.m_cacheToClientsName.get(cache) == null) continue;
                for (ClientName clientName : this.m_cacheToClientsName.get(cache)) {
                    clientNamesSet.add(new MemoryReference(cache.getMemoryName(clientName.m_dataName), clientName.m_name));
                }
                continue;
            }
            if (free || this.m_cacheToClients.get(cache).isEmpty()) continue;
            for (TransientMemoryClientInterface client : this.m_cacheToClients.get(cache)) {
                clientNamesSet.add(new MemoryReference(cache.getMemoryName(client.getMemoryDataName()), client.getMemoryClientName()));
            }
        }
        Collections.sort(clientNamesSet);
        return clientNamesSet;
    }

    private class ClientName {
        private String m_name;
        private String m_dataName;

        public ClientName(String name, String dataName) {
            this.m_name = name;
            this.m_dataName = dataName;
        }

        public String toString() {
            return this.m_name + ":" + this.m_dataName;
        }

        public boolean equals(Object o) {
            return this.toString().equals(o.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

