/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.taskinfo;

import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfoManager;

public class TaskInfo
implements Comparable<TaskInfo> {
    public static final Integer INFO_IMPORTANCE_LOW = 0;
    public static final Integer INFO_IMPORTANCE_MEDIUM = 1;
    public static final Integer INFO_IMPORTANCE_HIGH = 2;
    public static final String[] IMPORTANCE_VALUES = new String[]{"Low", "Medium", "High"};
    public static final Integer PUBLIC_STATE_WAITING = 0;
    public static final Integer PUBLIC_STATE_RUNNING = 1;
    public static final Integer PUBLIC_STATE_ABORTED = 2;
    public static final Integer PUBLIC_STATE_FINISHED = 3;
    public static final Integer PUBLIC_STATE_FAILED = 4;
    public static final String[] PUBLIC_STATE_VALUES = new String[]{"Waiting", "Running", "Aborted", "Finished", "Failed"};
    public static final int STATE_WAITING = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_FINISHED = 2;
    public static final int STATE_ABORTED = 3;
    private String m_taskDescription = null;
    private String m_idList = null;
    private Integer m_infoImportance;
    private String m_requestContent = null;
    private String m_requestURL = null;
    private boolean m_hidden = false;
    private int m_state;
    private int m_updateState = -1;
    private long m_askTimestamp = -1L;
    private long m_startTimestamp = -1L;
    private long m_endTimestamp = -1L;
    private float m_percentage = 0.0f;
    private long m_duration = -1L;
    private int m_id;
    private String m_jmsMessageID = null;
    private boolean m_askBeforeExitingApp;
    private boolean m_success;
    private TaskError m_taskError = null;
    private static int INC_ID = 0;

    public TaskInfo(String taskDescription, boolean askBeforeExitingApp, String idList, Integer infoImportance) {
        this(taskDescription, askBeforeExitingApp, idList, infoImportance, false);
    }

    public TaskInfo(String taskDescription, boolean askBeforeExitingApp, String idList, Integer infoImportance, boolean hidden) {
        this.m_taskDescription = taskDescription;
        this.m_askBeforeExitingApp = askBeforeExitingApp;
        this.m_idList = idList;
        this.m_infoImportance = infoImportance;
        this.m_hidden = hidden;
        this.m_state = 0;
        this.m_id = INC_ID++;
        this.m_success = true;
        this.m_taskError = null;
        this.m_askTimestamp = System.currentTimeMillis();
    }

    public TaskInfo(TaskInfo src) {
        TaskInfo.copy(src, this);
    }

    public String getJmsMessageID() {
        return this.m_jmsMessageID;
    }

    public void setJmsMessageID(String jmsMsgId) {
        this.m_jmsMessageID = jmsMsgId;
    }

    public void setRunning(boolean saveTimestamp) {
        if (this.m_state == 1 || this.m_updateState == 1 || this.m_updateState == 2 || this.m_updateState == 3) {
            return;
        }
        this.m_updateState = 1;
        if (saveTimestamp) {
            this.m_startTimestamp = System.currentTimeMillis();
        }
        TaskInfoManager.getTaskInfoManager().update(this);
    }

    public void setPercentage(float percentage) {
        this.m_percentage = percentage;
        TaskInfoManager.getTaskInfoManager().update(this, false);
    }

    public float getPercentage() {
        return this.m_percentage;
    }

    public void setRequestContent(String m_requestContent) {
        this.m_requestContent = m_requestContent;
    }

    public void setRequestURL(String m_requestURL) {
        this.m_requestURL = m_requestURL;
    }

    public void setAborted() {
        this.m_updateState = 3;
        this.m_percentage = 0.0f;
        TaskInfoManager.getTaskInfoManager().update(this);
    }

    public void setFinished(boolean success, TaskError taskError, boolean saveTimestamp) {
        if (this.m_updateState == 3) {
            return;
        }
        if (this.m_updateState == 2) {
            saveTimestamp = false;
        }
        this.m_updateState = 2;
        if (saveTimestamp) {
            this.m_endTimestamp = this.m_startTimestamp == -1L ? -1L : System.currentTimeMillis();
        }
        this.m_percentage = 100.0f;
        this.m_success = success;
        this.m_taskError = taskError;
        TaskInfoManager.getTaskInfoManager().update(this);
    }

    public void setDuration(long duration) {
        this.m_duration = duration;
        TaskInfoManager.getTaskInfoManager().update(this, false);
    }

    public void update() {
        if (this.m_updateState != -1) {
            this.m_state = this.m_updateState;
            this.m_updateState = -1;
        }
    }

    public boolean isWaiting() {
        return this.m_state == 0;
    }

    public boolean isRunning() {
        return this.m_state == 1;
    }

    public boolean isFinished() {
        return this.m_state == 2;
    }

    public boolean isAborted() {
        return this.m_state == 3;
    }

    public boolean isSuccess() {
        return this.m_success;
    }

    public TaskError getTaskError() {
        return this.m_taskError;
    }

    public boolean hasTaskError() {
        return this.m_taskError != null;
    }

    public int getId() {
        return this.m_id;
    }

    public String getIdList() {
        return this.m_idList;
    }

    public String getImportanceAsString() {
        return IMPORTANCE_VALUES[this.m_infoImportance];
    }

    public int getImportance() {
        return this.m_infoImportance;
    }

    public int getPublicState() {
        if (this.isWaiting()) {
            return PUBLIC_STATE_WAITING;
        }
        if (this.isRunning()) {
            return PUBLIC_STATE_RUNNING;
        }
        if (this.isFinished()) {
            if (this.isSuccess()) {
                return PUBLIC_STATE_FINISHED;
            }
            return PUBLIC_STATE_FAILED;
        }
        if (this.isAborted()) {
            return PUBLIC_STATE_ABORTED;
        }
        return PUBLIC_STATE_WAITING;
    }

    public String getPublicStateAsString() {
        return PUBLIC_STATE_VALUES[this.getPublicState()];
    }

    public boolean askBeforeExitingApplication() {
        return this.m_askBeforeExitingApp;
    }

    public String getTaskDescription() {
        return this.m_taskDescription;
    }

    public String getRequestContent() {
        return this.m_requestContent;
    }

    public String getRequestURL() {
        return this.m_requestURL;
    }

    public long getAskTimestamp() {
        return this.m_askTimestamp;
    }

    public long getStartTimestamp() {
        return this.m_startTimestamp;
    }

    public long getEndTimestamp() {
        return this.m_endTimestamp;
    }

    public boolean isHidden() {
        return this.m_hidden;
    }

    public long getDuration() {
        if (this.m_duration != -1L) {
            return this.m_duration;
        }
        if (this.m_endTimestamp != -1L && this.m_startTimestamp != -1L) {
            return this.m_endTimestamp - this.m_startTimestamp;
        }
        return -1L;
    }

    public long getDelay() {
        if (this.m_startTimestamp != -1L && this.m_askTimestamp != -1L) {
            return this.m_startTimestamp - this.m_askTimestamp;
        }
        return -1L;
    }

    @Override
    public int compareTo(TaskInfo o) {
        int cmp;
        int o_state;
        int state = this.m_state;
        if (state == 3) {
            state = 2;
        }
        if ((o_state = o.m_state) == 3) {
            o_state = 2;
        }
        if ((cmp = state - o_state) != 0) {
            return cmp;
        }
        return o.m_id - this.m_id;
    }

    public void copyData(TaskInfo dest) {
        TaskInfo.copy(this, dest);
    }

    private static void copy(TaskInfo from, TaskInfo to) {
        to.m_taskDescription = from.m_taskDescription;
        to.m_askBeforeExitingApp = from.m_askBeforeExitingApp;
        to.m_idList = from.m_idList;
        to.m_infoImportance = from.m_infoImportance;
        to.m_hidden = from.m_hidden;
        to.m_state = from.m_state;
        to.m_id = from.m_id;
        to.m_success = from.m_success;
        to.m_taskError = from.m_taskError;
        to.m_askTimestamp = from.m_askTimestamp;
        to.m_startTimestamp = from.m_startTimestamp;
        to.m_endTimestamp = from.m_endTimestamp;
        to.m_duration = from.m_duration;
        to.m_percentage = from.m_percentage;
        to.m_requestContent = from.m_requestContent;
        to.m_requestURL = from.m_requestURL;
        to.m_jmsMessageID = from.m_jmsMessageID;
    }

    public String toString() {
        return "";
    }
}

