/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.dto.DBioSequence;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptideSet;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.module.seq.BioSequenceProvider;
import fr.proline.studio.dam.DatabaseDataManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class DatabaseBioSequenceTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fetchData(List<DProteinMatch> proteinMatchList, Long projectId) {
        Map<Long, DProteinMatch> proteinMatchById = proteinMatchList.stream().collect(Collectors.toMap(pm -> pm.getId(), pm -> pm));
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(projectId.longValue()).createEntityManager();){
            Query query = entityManagerMSI.createQuery("SELECT pm.id, bs.sequence, bs.mass, bs.pi FROM fr.proline.core.orm.msi.ProteinMatch pm, fr.proline.core.orm.msi.BioSequence bs WHERE bs.id = pm.bioSequenceId AND pm.id IN (:proteinMatchIds)");
            query.setParameter("proteinMatchIds", proteinMatchById.keySet());
            for (Object[] resCur : query.getResultList()) {
                Long proteinMatchId = (Long)resCur[0];
                String sequence = (String)resCur[1];
                Integer mass = (Integer)resCur[2];
                Float pI = (Float)resCur[3];
                proteinMatchById.get(proteinMatchId).setDBioSequence(new DBioSequence(sequence, (double)mass.intValue(), (double)pI.floatValue()));
            }
        }
        return true;
    }

    public static boolean fetchData_PreviousImpl(List<DProteinMatch> proteinMatchList, Long rsmId) {
        int nbProteinMatches = proteinMatchList.size();
        if (!DatabaseDataManager.getDatabaseDataManager().isSeqDatabaseExists()) {
            for (int i = 0; i < nbProteinMatches; ++i) {
                DProteinMatch proteinMatch = proteinMatchList.get(i);
                proteinMatch.setDBioSequence(null);
            }
            return true;
        }
        ArrayList<String> values = new ArrayList<String>(nbProteinMatches);
        for (int i = 0; i < nbProteinMatches; ++i) {
            String accession = proteinMatchList.get(i).getAccession();
            values.add(accession);
        }
        Map result = BioSequenceProvider.findSEDbIdentRelatedData(values);
        for (int i = 0; i < nbProteinMatches; ++i) {
            fr.proline.module.seq.dto.DBioSequence biosequenceWrapperSelected;
            DPeptideInstance[] peptideInstances;
            DProteinMatch proteinMatch = proteinMatchList.get(i);
            BioSequenceProvider.RelatedIdentifiers relatedObjects = (BioSequenceProvider.RelatedIdentifiers)result.get(proteinMatch.getAccession());
            if (relatedObjects == null || relatedObjects.getDBioSequences() == null || relatedObjects.getDBioSequences().isEmpty()) {
                proteinMatch.setDBioSequence(null);
                continue;
            }
            List bioSequenceWrapperList = relatedObjects.getDBioSequences();
            DPeptideSet peptideSet = null;
            if (rsmId != null) {
                peptideSet = proteinMatch.getPeptideSet(rsmId);
            }
            DPeptideInstance[] dPeptideInstanceArray = peptideInstances = peptideSet == null ? null : peptideSet.getPeptideInstances();
            if (peptideInstances == null) {
                biosequenceWrapperSelected = null;
                if (bioSequenceWrapperList.size() > 0) {
                    biosequenceWrapperSelected = (fr.proline.module.seq.dto.DBioSequence)bioSequenceWrapperList.get(0);
                }
                if (biosequenceWrapperSelected == null) {
                    proteinMatch.setDBioSequence(null);
                    continue;
                }
                proteinMatch.setDBioSequence(new DBioSequence(biosequenceWrapperSelected.getSequence(), biosequenceWrapperSelected.getMass(), biosequenceWrapperSelected.getPI()));
                continue;
            }
            biosequenceWrapperSelected = null;
            int nb = bioSequenceWrapperList.size();
            for (int j = 0; j < nb; ++j) {
                biosequenceWrapperSelected = (fr.proline.module.seq.dto.DBioSequence)bioSequenceWrapperList.get(j);
                String sequence = biosequenceWrapperSelected.getSequence();
                int nbPeptides = peptideInstances.length;
                for (int k = 0; k < nbPeptides; ++k) {
                    DPeptideMatch peptideMatch = peptideInstances[k].getBestPeptideMatch();
                    String peptideSequence = peptideMatch.getPeptide().getSequence();
                    int start = peptideMatch.getSequenceMatch().getId().getStart();
                    int stop = peptideMatch.getSequenceMatch().getId().getStop();
                    if (stop > sequence.length()) {
                        biosequenceWrapperSelected = null;
                        break;
                    }
                    String subSequence = sequence.substring(start - 1, stop);
                    if (subSequence.compareTo(peptideSequence) == 0) continue;
                    biosequenceWrapperSelected = null;
                    break;
                }
                if (biosequenceWrapperSelected != null) break;
            }
            if (biosequenceWrapperSelected == null) {
                proteinMatch.setDBioSequence(null);
                continue;
            }
            proteinMatch.setDBioSequence(new DBioSequence(biosequenceWrapperSelected.getSequence(), biosequenceWrapperSelected.getMass(), biosequenceWrapperSelected.getPI()));
        }
        return true;
    }
}

