/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import fr.proline.core.orm.msi.ObjectTree;
import fr.proline.core.orm.msi.ObjectTreeSchema;
import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideInstance;
import fr.proline.core.orm.msi.PeptideMatch;
import fr.proline.core.orm.msi.PeptideReadablePtmString;
import fr.proline.core.orm.msi.PtmSpecificity;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DInfoPTM;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptidePTM;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DPtmSiteProperties;
import fr.proline.core.orm.msi.dto.DSpectrum;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.SubTaskManager;
import fr.proline.studio.dam.tasks.data.ptm.JSONPTMSite;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class DatabasePTMSitesTask
extends AbstractDatabaseTask {
    private long m_projectId = -1L;
    private ResultSummary m_rsm = null;
    private List<Long> m_rsmIds = null;
    private PTMSite m_ptmSiteOutput = null;
    private List<PTMSite> m_ptmSitesOutput = null;
    private List<PtmSpecificity> m_ptmsOutput = null;
    private static final int SLICE_SIZE = 1000;
    private int m_action;
    private static final int LOAD_ALL_PTM_SITES_FOR_RSMS = 0;
    private static final int FILL_PTM_SITE_PEPINFO = 1;
    private static final int LOAD_IDENTIFIED_PTM_SPECIFICITIES = 2;
    private static final int FILL_ALL_PTM_SITES_PEPINFO = 3;

    public DatabasePTMSitesTask(AbstractDatabaseCallback callback) {
        super(callback, null);
    }

    private void init(TaskInfo taskInfo) {
        this.m_defaultPriority = AbstractDatabaseTask.Priority.NORMAL_1;
        this.m_taskInfo = taskInfo;
    }

    public void initLoadPTMSites(long projectId, ResultSummary rsm, List<PTMSite> ptmSiteArray) {
        this.init(new TaskInfo("Load All PTM Sites for " + rsm.getId(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_rsm = rsm;
        this.m_ptmSitesOutput = ptmSiteArray;
        this.m_action = 0;
    }

    public void initFillPTMSite(long projectId, ResultSummary rsm, PTMSite ptmSiteToFill) {
        this.init(new TaskInfo("Load peptides of PTM Site " + ptmSiteToFill, false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_ptmSiteOutput = ptmSiteToFill;
        this.m_rsm = rsm;
        this.m_action = 1;
    }

    public void initFillPTMSites(long projectId, ResultSummary rsm, List<PTMSite> ptmSitesToFill) {
        this.init(new TaskInfo("Load peptides of PTM Sites", false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_ptmSitesOutput = ptmSitesToFill;
        this.m_rsm = rsm;
        this.m_action = 3;
    }

    public void initLoadUsedPTMs(Long projectId, Long rsmId, List<PtmSpecificity> ptmsToFill) {
        this.init(new TaskInfo("Load used PTMs from RSM id" + rsmId, false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_rsmIds = new ArrayList<Long>();
        this.m_rsmIds.add(rsmId);
        this.m_ptmsOutput = ptmsToFill;
        this.m_action = 2;
    }

    public void initLoadUsedPTMs(Long projectId, List<Long> rsmIds, List<PtmSpecificity> ptmsToFill) {
        this.init(new TaskInfo("Load used PTMs from RSM ids" + rsmIds, false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_rsmIds = rsmIds;
        this.m_ptmsOutput = ptmsToFill;
        this.m_action = 2;
    }

    @Override
    public boolean needToFetch() {
        switch (this.m_action) {
            case 0: 
            case 2: 
            case 3: {
                return true;
            }
            case 1: {
                return !this.m_ptmSiteOutput.isLoaded();
            }
        }
        return false;
    }

    @Override
    public boolean fetchData() {
        if (this.needToFetch()) {
            switch (this.m_action) {
                case 0: {
                    return this.fetchAllPTMSites();
                }
                case 1: {
                    return this.fetchPTMSitePeptideMatches();
                }
                case 2: {
                    return this.fetchIdentifiedPTMs();
                }
                case 3: {
                    return this.fetchAllPTMSitesPeptideMatches();
                }
            }
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchIdentifiedPTMs() {
        long start = System.currentTimeMillis();
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            long stop = System.currentTimeMillis();
            m_logger.debug("Identified PTM entityManagerMSI.getTransaction().begin {} ms", (Object)(stop - start));
            start = stop;
            TypedQuery query = entityManagerMSI.createQuery("SELECT DISTINCT(pp.specificity) FROM PeptidePtm pp, PeptideInstance pi JOIN FETCH pp.specificity.ptm ptm WHERE pi.resultSummary.id in (:rsmIds) AND pi.peptide.id = pp.peptide.id", PtmSpecificity.class);
            query.setParameter("rsmIds", this.m_rsmIds);
            this.m_ptmsOutput.addAll(query.getResultList());
            stop = System.currentTimeMillis();
            m_logger.debug("Identified PTM fetched in {} ms", (Object)(stop - start));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchPTMSitePeptideMatches() {
        long start = System.currentTimeMillis();
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            ObjectMapper mapper = new ObjectMapper();
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
            this.fetchPTMSiteData(this.m_ptmSiteOutput, entityManagerMSI, mapper);
            long stop = System.currentTimeMillis();
            m_logger.debug("PTM Site {} filled in {} ms", (Object)this.m_ptmSiteOutput, (Object)(stop - start));
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchAllPTMSitesPeptideMatches() {
        long start = System.currentTimeMillis();
        m_logger.debug(" START fetchAllPTMSitesPeptideMatches task ");
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            ObjectMapper mapper = new ObjectMapper();
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
            this.fetchPTMSitesData(this.m_ptmSitesOutput, entityManagerMSI, mapper);
            long stop = System.currentTimeMillis();
            m_logger.debug("??/{} PTM Sites filled in {} ms", (Object)this.m_ptmSitesOutput.size(), (Object)(stop - start));
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    private void fetchPTMSitesData(List<PTMSite> sitesToFill, EntityManager entityManagerMSI, ObjectMapper mapper) throws IOException {
        HashMap<Long, Peptide> allPeptidesMap = new HashMap<Long, Peptide>();
        HashMap<Long, DPeptideInstance> leafPeptideInstancesById = new HashMap<Long, DPeptideInstance>();
        Set pepInstanceIds = sitesToFill.stream().flatMap(s -> Arrays.stream(s.getPeptideInstanceIds())).collect(Collectors.toSet());
        m_logger.debug("fetchPTMSitesData: pepInstanceIds " + pepInstanceIds.size());
        Query peptidesQuery = entityManagerMSI.createQuery("SELECT pm, pi, sp.firstTime, sp.precursorIntensity, sp.title,  msq.id, msq.initialId  FROM fr.proline.core.orm.msi.PeptideInstancePeptideMatchMap pipm, fr.proline.core.orm.msi.PeptideMatch pm, fr.proline.core.orm.msi.PeptideInstance pi,       fr.proline.core.orm.msi.MsQuery msq , fr.proline.core.orm.msi.Spectrum sp  WHERE pipm.id.peptideInstanceId IN ( :peptideInstanceList ) AND pipm.id.peptideInstanceId=pi.id AND pipm.id.peptideMatchId=pm.id  AND pm.msQuery.id = msq.id AND msq.spectrum.id = sp.id ");
        peptidesQuery.setParameter("peptideInstanceList", new ArrayList(pepInstanceIds));
        List l = peptidesQuery.getResultList();
        Iterator itPeptidesQuery = l.iterator();
        m_logger.debug("fetchPTMSitesData: query result size " + l.size());
        while (itPeptidesQuery.hasNext()) {
            Object[] resCur = (Object[])itPeptidesQuery.next();
            PeptideMatch pm = (PeptideMatch)resCur[0];
            PeptideInstance pi2 = (PeptideInstance)resCur[1];
            Float firstTime = (Float)resCur[2];
            Float precursorIntensity = (Float)resCur[3];
            String spectrumTitle = (String)resCur[4];
            Long msQueryId = (Long)resCur[5];
            Integer msQueryInitialId = (Integer)resCur[6];
            DSpectrum spectrum = new DSpectrum();
            spectrum.setFirstTime(firstTime);
            spectrum.setPrecursorIntensity(precursorIntensity);
            spectrum.setTitle(spectrumTitle);
            DPeptideMatch dpm = new DPeptideMatch(pm.getId(), pm.getRank(), pm.getCharge(), pm.getDeltaMoz(), pm.getExperimentalMoz(), pm.getMissedCleavage(), pm.getScore(), pm.getResultSet().getId(), pm.getCDPrettyRank(), pm.getSDPrettyRank());
            dpm.setRetentionTime(spectrum.getFirstTime());
            dpm.setSerializedProperties(pm.getSerializedProperties());
            JsonNode node = mapper.readTree(dpm.getSerializedProperties());
            JsonNode child = node.get("ptm_site_properties");
            DPtmSiteProperties properties = (DPtmSiteProperties)mapper.treeToValue((TreeNode)child, DPtmSiteProperties.class);
            dpm.setPtmSiteProperties(properties);
            Peptide p = pi2.getPeptide();
            p.getTransientData().setPeptideReadablePtmStringLoaded();
            allPeptidesMap.put(p.getId(), p);
            DMsQuery msq = new DMsQuery(pm.getId(), msQueryId.longValue(), msQueryInitialId.intValue(), spectrum.getPrecursorIntensity());
            msq.setDSpectrum(spectrum);
            dpm.setPeptide(p);
            dpm.setMsQuery(msq);
            if (!leafPeptideInstancesById.containsKey(pi2.getId())) {
                DPeptideInstance dpi = new DPeptideInstance(pi2);
                dpi.setResultSummary(pi2.getResultSummary());
                dpi.setPeptide(p);
                dpi.setPeptideMatches(new ArrayList());
                leafPeptideInstancesById.put(dpi.getId(), dpi);
            }
            if (pi2.getBestPeptideMatchId() == dpm.getId()) {
                ((DPeptideInstance)leafPeptideInstancesById.get(pi2.getId())).setBestPeptideMatch(dpm);
            }
            ((DPeptideInstance)leafPeptideInstancesById.get(pi2.getId())).getPeptideMatches().add(dpm);
        }
        m_logger.debug(" created leafPeptideInstancesById. Nbr pepIns " + leafPeptideInstancesById.size());
        Long rsetId = this.m_rsm.getResultSet().getId();
        TypedQuery parentPeptideInstanceQuery = entityManagerMSI.createQuery("SELECT pi FROM fr.proline.core.orm.msi.PeptideInstance pi WHERE pi.peptide.id IN (:listId) AND pi.resultSummary.id=:rsmId", PeptideInstance.class);
        parentPeptideInstanceQuery.setParameter("listId", allPeptidesMap.keySet());
        parentPeptideInstanceQuery.setParameter("rsmId", (Object)this.m_rsm.getId());
        Iterator it = parentPeptideInstanceQuery.getResultList().iterator();
        HashMap<Long, DPeptideInstance> parentPeptideInstancesByPepId = new HashMap<Long, DPeptideInstance>();
        while (it.hasNext()) {
            PeptideInstance pi3 = (PeptideInstance)it.next();
            DPeptideInstance dpi = new DPeptideInstance(pi3);
            dpi.setPeptide(pi3.getPeptide());
            parentPeptideInstancesByPepId.put(dpi.getPeptideId(), dpi);
        }
        m_logger.debug(" parentPeptideInstancesByPepId created ");
        Set allPeptides = allPeptidesMap.keySet();
        Query ptmStingQuery = entityManagerMSI.createQuery("SELECT p.id, ptmString FROM fr.proline.core.orm.msi.Peptide p, fr.proline.core.orm.msi.PeptideReadablePtmString ptmString WHERE p.id IN (:listId) AND ptmString.peptide=p AND ptmString.resultSet.id=:rsetId");
        ptmStingQuery.setParameter("listId", allPeptides);
        ptmStingQuery.setParameter("rsetId", (Object)rsetId);
        List ptmStrings = ptmStingQuery.getResultList();
        for (Object[] res : ptmStrings) {
            Long peptideId = (Long)res[0];
            PeptideReadablePtmString ptmString = (PeptideReadablePtmString)res[1];
            Peptide peptide = (Peptide)allPeptidesMap.get(peptideId);
            peptide.getTransientData().setPeptideReadablePtmString(ptmString);
        }
        m_logger.debug(" PeptideReadablePtmString LOADED");
        this.fetchGenericPTMData(entityManagerMSI);
        HashMap<Long, ArrayList<DPeptidePTM>> ptmMap = this.fetchPTMDataForPeptides(entityManagerMSI, new ArrayList<Long>(allPeptidesMap.keySet()));
        List allpeptideMatches = leafPeptideInstancesById.values().stream().flatMap(pi -> pi.getPeptideMatches().stream()).collect(Collectors.toList());
        m_logger.debug(" allpeptideMatches  " + allpeptideMatches.size());
        for (DPeptideMatch pm : allpeptideMatches) {
            Peptide p = pm.getPeptide();
            Long idPeptide = p.getId();
            ArrayList<DPeptidePTM> ptmList = ptmMap.get(idPeptide);
            pm.setPeptidePTMArray(ptmList);
            HashMap<Integer, DPeptidePTM> mapToPtm = new HashMap<Integer, DPeptidePTM>();
            if (ptmList == null) continue;
            for (DPeptidePTM peptidePTM : ptmList) {
                mapToPtm.put((int)peptidePTM.getSeqPosition(), peptidePTM);
            }
            p.getTransientData().setDPeptidePtmMap(mapToPtm);
        }
        m_logger.info("{} peptides matching to {} peptide matches retrieved", (Object)allPeptides.size(), (Object)allpeptideMatches.size());
        m_logger.info("{} peptide instances retrieved", (Object)parentPeptideInstancesByPepId.size());
        for (PTMSite site : sitesToFill) {
            List<DPeptideInstance> leafPeptideInstances = Arrays.stream(site.getPeptideInstanceIds()).map(id -> (DPeptideInstance)leafPeptideInstancesById.get(id)).collect(Collectors.toList());
            Set parentPeptideInstancesAsSet = leafPeptideInstances.stream().map(pi -> pi.getPeptideId()).map(id -> (DPeptideInstance)parentPeptideInstancesByPepId.get(id)).collect(Collectors.toSet());
            ArrayList<DPeptideInstance> parentPeptideInstances = new ArrayList<DPeptideInstance>();
            parentPeptideInstances.addAll(parentPeptideInstancesAsSet);
            site.setPeptideInstances(parentPeptideInstances, leafPeptideInstances);
        }
    }

    private void fetchPTMSiteData(PTMSite siteToFill, EntityManager entityManagerMSI, ObjectMapper mapper) throws IOException {
        HashMap<Long, Peptide> allPeptidesMap = new HashMap<Long, Peptide>();
        HashMap<Long, DPeptideInstance> leafPeptideInstancesById = new HashMap<Long, DPeptideInstance>();
        ArrayList<Long> peptideInstanceIds = new ArrayList<Long>();
        Long[] pepInst = siteToFill.getPeptideInstanceIds();
        if (pepInst == null) {
            ArrayList<Long> allPepIds = siteToFill.getPeptideIds();
            Query peptidesQuery = entityManagerMSI.createQuery("SELECT pi.id FROM fr.proline.core.orm.msi.PeptideInstance pi   WHERE pi.peptide.id IN (:peptideIdsList) AND pi.resultSummary.id in (:rmsIds)");
            peptidesQuery.setParameter("peptideIdsList", allPepIds);
            List<Long> rsmIds = siteToFill.getPTMdataset().getLeafResultSummaryIds();
            rsmIds.add(siteToFill.getPTMdataset().getDataset().getResultSummaryId());
            peptidesQuery.setParameter("rmsIds", rsmIds);
            peptideInstanceIds.addAll(peptidesQuery.getResultList());
        } else {
            peptideInstanceIds.addAll(Arrays.asList(pepInst));
        }
        Query peptidesQuery = entityManagerMSI.createQuery("SELECT pm, pi, sp.firstTime, sp.precursorIntensity, sp.title  msq.id, msq.initialId  FROM fr.proline.core.orm.msi.PeptideInstancePeptideMatchMap pipm, fr.proline.core.orm.msi.PeptideMatch pm, fr.proline.core.orm.msi.PeptideInstance pi,       fr.proline.core.orm.msi.MsQuery msq , fr.proline.core.orm.msi.Spectrum sp  WHERE pipm.id.peptideInstanceId IN ( :peptideInstanceList ) AND pipm.id.peptideInstanceId=pi.id AND pipm.id.peptideMatchId=pm.id AND pm.msQuery.id = msq.id AND msq.spectrum.id = sp.id ");
        peptidesQuery.setParameter("peptideInstanceList", peptideInstanceIds);
        List l = peptidesQuery.getResultList();
        for (Object[] resCur : l) {
            PeptideMatch pm = (PeptideMatch)resCur[0];
            PeptideInstance pi2 = (PeptideInstance)resCur[1];
            Float firstTime = (Float)resCur[2];
            Float precursorIntensity = (Float)resCur[3];
            String spectrumTitle = (String)resCur[4];
            Long msQueryId = (Long)resCur[5];
            Integer msQueryInitialId = (Integer)resCur[6];
            DSpectrum spectrum = new DSpectrum();
            spectrum.setFirstTime(firstTime);
            spectrum.setPrecursorIntensity(precursorIntensity);
            spectrum.setTitle(spectrumTitle);
            DPeptideMatch dpm = new DPeptideMatch(pm.getId(), pm.getRank(), pm.getCharge(), pm.getDeltaMoz(), pm.getExperimentalMoz(), pm.getMissedCleavage(), pm.getScore(), pm.getResultSet().getId(), pm.getCDPrettyRank(), pm.getSDPrettyRank());
            dpm.setRetentionTime(spectrum.getFirstTime());
            dpm.setSerializedProperties(pm.getSerializedProperties());
            JsonNode node = mapper.readTree(dpm.getSerializedProperties());
            JsonNode child = node.get("ptm_site_properties");
            DPtmSiteProperties properties = (DPtmSiteProperties)mapper.treeToValue((TreeNode)child, DPtmSiteProperties.class);
            dpm.setPtmSiteProperties(properties);
            Peptide p = pi2.getPeptide();
            p.getTransientData().setPeptideReadablePtmStringLoaded();
            allPeptidesMap.put(p.getId(), p);
            DMsQuery msq = new DMsQuery(pm.getId(), msQueryId.longValue(), msQueryInitialId.intValue(), spectrum.getPrecursorIntensity());
            msq.setDSpectrum(spectrum);
            dpm.setPeptide(p);
            dpm.setMsQuery(msq);
            if (!leafPeptideInstancesById.containsKey(pi2.getId())) {
                DPeptideInstance dpi = new DPeptideInstance(pi2);
                dpi.setResultSummary(pi2.getResultSummary());
                dpi.setPeptide(p);
                dpi.setPeptideMatches(new ArrayList());
                leafPeptideInstancesById.put(dpi.getId(), dpi);
            }
            ((DPeptideInstance)leafPeptideInstancesById.get(pi2.getId())).getPeptideMatches().add(dpm);
        }
        Long rsetId = this.m_rsm.getResultSet().getId();
        TypedQuery parentPeptideInstanceQuery = entityManagerMSI.createQuery("SELECT pi FROM fr.proline.core.orm.msi.PeptideInstance pi WHERE pi.peptide.id IN (:listId) AND pi.resultSummary.id=:rsmId", PeptideInstance.class);
        parentPeptideInstanceQuery.setParameter("listId", allPeptidesMap.keySet());
        parentPeptideInstanceQuery.setParameter("rsmId", (Object)this.m_rsm.getId());
        Iterator it = parentPeptideInstanceQuery.getResultList().iterator();
        ArrayList<DPeptideInstance> parentPeptideInstances = new ArrayList<DPeptideInstance>();
        while (it.hasNext()) {
            PeptideInstance pi3 = (PeptideInstance)it.next();
            DPeptideInstance dpi = new DPeptideInstance(pi3);
            dpi.setPeptide(pi3.getPeptide());
            parentPeptideInstances.add(dpi);
        }
        Query ptmStingQuery = entityManagerMSI.createQuery("SELECT p.id, ptmString FROM fr.proline.core.orm.msi.Peptide p, fr.proline.core.orm.msi.PeptideReadablePtmString ptmString WHERE p.id IN (:listId) AND ptmString.peptide=p AND ptmString.resultSet.id=:rsetId");
        ptmStingQuery.setParameter("listId", allPeptidesMap.keySet());
        ptmStingQuery.setParameter("rsetId", (Object)rsetId);
        List ptmStrings = ptmStingQuery.getResultList();
        for (Object[] res : ptmStrings) {
            Long peptideId = (Long)res[0];
            PeptideReadablePtmString ptmString = (PeptideReadablePtmString)res[1];
            Peptide peptide = (Peptide)allPeptidesMap.get(peptideId);
            peptide.getTransientData().setPeptideReadablePtmString(ptmString);
        }
        this.fetchGenericPTMData(entityManagerMSI);
        HashMap<Long, ArrayList<DPeptidePTM>> ptmMap = this.fetchPTMDataForPeptides(entityManagerMSI, new ArrayList<Long>(allPeptidesMap.keySet()));
        List allpeptideMatches = leafPeptideInstancesById.values().stream().flatMap(pi -> pi.getPeptideMatches().stream()).collect(Collectors.toList());
        for (DPeptideMatch pm : allpeptideMatches) {
            Peptide p = pm.getPeptide();
            Long idPeptide = p.getId();
            pm.setPeptidePTMArray(ptmMap.get(idPeptide));
            HashMap<Integer, DPeptidePTM> mapToPtm = new HashMap<Integer, DPeptidePTM>();
            ArrayList<DPeptidePTM> ptmList = ptmMap.get(p.getId());
            if (ptmList == null) continue;
            for (DPeptidePTM peptidePTM : ptmList) {
                mapToPtm.put((int)peptidePTM.getSeqPosition(), peptidePTM);
            }
            p.getTransientData().setDPeptidePtmMap(mapToPtm);
        }
        siteToFill.setPeptideInstances(parentPeptideInstances, leafPeptideInstancesById.values().stream().collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchAllPTMSites() {
        long start = System.currentTimeMillis();
        m_logger.debug(" START fetchAllPTMSites");
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            Long rsmId = this.m_rsm.getId();
            TypedQuery typicalProteinQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DProteinMatch(pm.id, pm.accession, pm.score, pm.peptideCount, pm.resultSet.id, pm.description, pm.geneName, pepset.id, pepset.score, pepset.sequenceCount, pepset.peptideCount, pepset.peptideMatchCount, pepset.resultSummaryId) FROM PeptideSetProteinMatchMap pset_to_pm JOIN pset_to_pm.proteinMatch as pm JOIN pset_to_pm.peptideSet as pepset JOIN pepset.proteinSet as ps WHERE ps.resultSummary.id=:rsmId AND ps.isValidated=true AND ps.representativeProteinMatchId=pm.id  ORDER BY pepset.score DESC", DProteinMatch.class);
            typicalProteinQuery.setParameter("rsmId", (Object)rsmId);
            List typicalProteinMatchesArray = typicalProteinQuery.getResultList();
            ResultSummary rsm = (ResultSummary)entityManagerMSI.find(ResultSummary.class, (Object)rsmId);
            if (rsm.getObjectTreeIdByName().isEmpty() || rsm.getObjectTreeIdByName().get(ObjectTreeSchema.SchemaName.PTM_SITES.toString()) == null) {
                throw new RuntimeException("Identify PTM algorythm should be run first !");
            }
            ObjectTree ot = (ObjectTree)entityManagerMSI.find(ObjectTree.class, rsm.getObjectTreeIdByName().get(ObjectTreeSchema.SchemaName.PTM_SITES.toString()));
            ObjectMapper mapper = new ObjectMapper();
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
            List values = (List)mapper.readValue(ot.getClobData(), (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, JSONPTMSite.class));
            Long[] bestPeptideMatchIdsArray = (Long[])values.stream().map(site -> site.bestPeptideMatchId).distinct().toArray(Long[]::new);
            long stop = System.currentTimeMillis();
            m_logger.debug("{} typical ProtMatches and {} PTMSites loaded in {} ms", typicalProteinMatchesArray.size(), values.size(), stop - start);
            start = stop;
            HashMap<Long, Peptide> allPeptidesMap = new HashMap<Long, Peptide>();
            ArrayList<DPeptideMatch> peptideMatchArray = new ArrayList<DPeptideMatch>();
            HashMap<Long, DPeptideMatch> peptideMatchById = new HashMap<Long, DPeptideMatch>();
            SubTaskManager subTaskManager = new SubTaskManager(1);
            SubTask subTask = subTaskManager.sliceATaskAndGetFirst(0, bestPeptideMatchIdsArray.length, 1000);
            while (subTask != null) {
                Query peptidesQuery = entityManagerMSI.createQuery("SELECT pm.id, pm.rank, pm.charge, pm.deltaMoz, pm.experimentalMoz, pm.missedCleavage, pm.score, pm.resultSet.id, pm.cdPrettyRank, pm.sdPrettyRank, pm.serializedProperties, sp.firstTime, sp.precursorIntensity, sp.title, p, ms.id, ms.initialId\n              FROM fr.proline.core.orm.msi.PeptideInstancePeptideMatchMap pipm, fr.proline.core.orm.msi.PeptideMatch pm, fr.proline.core.orm.msi.PeptideInstance pi, fr.proline.core.orm.msi.Peptide p, fr.proline.core.orm.msi.MsQuery ms, fr.proline.core.orm.msi.Spectrum sp  \n              WHERE pipm.id.peptideMatchId IN (:peptideMatchList) AND pipm.id.peptideInstanceId=pi.id AND pipm.id.peptideMatchId=pm.id AND pm.peptideId=p.id AND pm.msQuery=ms AND ms.spectrum=sp");
                List subList = subTask.getSubList(Arrays.asList(bestPeptideMatchIdsArray));
                peptidesQuery.setParameter("peptideMatchList", (Object)subList);
                List l = peptidesQuery.getResultList();
                for (Object[] resCur : l) {
                    Long pmId = (Long)resCur[0];
                    Integer pmRank = (Integer)resCur[1];
                    Integer pmCharge = (Integer)resCur[2];
                    Float pmDeltaMoz = (Float)resCur[3];
                    Double pmExperimentalMoz = (Double)resCur[4];
                    Integer pmMissedCleavage = (Integer)resCur[5];
                    Float pmScore = (Float)resCur[6];
                    Long pmResultSetId = (Long)resCur[7];
                    Integer pmCdPrettyRank = (Integer)resCur[8];
                    Integer pmSdPrettyRank = (Integer)resCur[9];
                    String serializedProperties = (String)resCur[10];
                    Float firstTime = (Float)resCur[11];
                    Float precursorIntensity = (Float)resCur[12];
                    String title = (String)resCur[13];
                    DSpectrum spectrum = new DSpectrum();
                    spectrum.setFirstTime(firstTime);
                    spectrum.setPrecursorIntensity(precursorIntensity);
                    spectrum.setTitle(title);
                    DPeptideMatch pm = new DPeptideMatch(pmId.longValue(), pmRank, pmCharge.intValue(), pmDeltaMoz, pmExperimentalMoz.doubleValue(), pmMissedCleavage.intValue(), pmScore, pmResultSetId.longValue(), pmCdPrettyRank, pmSdPrettyRank);
                    pm.setRetentionTime(firstTime);
                    pm.setSerializedProperties(serializedProperties);
                    JsonNode node = mapper.readTree(serializedProperties);
                    JsonNode child = node.get("ptm_site_properties");
                    DPtmSiteProperties properties = (DPtmSiteProperties)mapper.treeToValue((TreeNode)child, DPtmSiteProperties.class);
                    pm.setPtmSiteProperties(properties);
                    if (!peptideMatchById.containsKey(pmId)) {
                        peptideMatchById.put(pmId, pm);
                    }
                    peptideMatchArray.add(pm);
                    Peptide p = (Peptide)resCur[14];
                    p.getTransientData().setPeptideReadablePtmStringLoaded();
                    allPeptidesMap.put(p.getId(), p);
                    Long msqId = (Long)resCur[15];
                    Integer msqInitialId = (Integer)resCur[16];
                    DMsQuery msq = new DMsQuery(pmId.longValue(), msqId.longValue(), msqInitialId.intValue(), precursorIntensity);
                    msq.setDSpectrum(spectrum);
                    pm.setPeptide(p);
                    pm.setMsQuery(msq);
                }
                subTask = subTaskManager.getNextSubTask();
            }
            stop = System.currentTimeMillis();
            m_logger.debug("Best PSM + Peptide + Spectrum + Query from PepInstances created in {} ms", (Object)(stop - start));
            start = stop;
            Long rsetId = this.m_rsm.getResultSet().getId();
            Query ptmStingQuery = entityManagerMSI.createQuery("SELECT p.id, ptmString FROM fr.proline.core.orm.msi.Peptide p, fr.proline.core.orm.msi.PeptideReadablePtmString ptmString WHERE p.id IN (:listId) AND ptmString.peptide=p AND ptmString.resultSet.id=:rsetId");
            ptmStingQuery.setParameter("listId", allPeptidesMap.keySet());
            ptmStingQuery.setParameter("rsetId", (Object)rsetId);
            List ptmStrings = ptmStingQuery.getResultList();
            for (Object[] res : ptmStrings) {
                Long peptideId = (Long)res[0];
                PeptideReadablePtmString ptmString = (PeptideReadablePtmString)res[1];
                Peptide peptide = (Peptide)allPeptidesMap.get(peptideId);
                peptide.getTransientData().setPeptideReadablePtmString(ptmString);
            }
            stop = System.currentTimeMillis();
            m_logger.debug("PeptideReadablePtmString loaded in {} ms", (Object)(stop - start));
            start = stop;
            this.fetchGenericPTMData(entityManagerMSI);
            stop = System.currentTimeMillis();
            m_logger.debug("Generic PTM data loaded in {} ms", (Object)(stop - start));
            start = stop;
            HashMap<Long, ArrayList<DPeptidePTM>> ptmMap = this.fetchPTMDataForPeptides(entityManagerMSI, new ArrayList<Long>(allPeptidesMap.keySet()));
            for (DPeptideMatch pm : peptideMatchArray) {
                Peptide p = pm.getPeptide();
                Long idPeptide = p.getId();
                pm.setPeptidePTMArray(ptmMap.get(idPeptide));
                HashMap<Integer, DPeptidePTM> mapToPtm = new HashMap<Integer, DPeptidePTM>();
                ArrayList<DPeptidePTM> ptmList = ptmMap.get(idPeptide);
                if (ptmList == null) continue;
                for (DPeptidePTM peptidePTM : ptmList) {
                    mapToPtm.put((int)peptidePTM.getSeqPosition(), peptidePTM);
                }
                p.getTransientData().setDPeptidePtmMap(mapToPtm);
            }
            stop = System.currentTimeMillis();
            m_logger.debug("PTM data for peptides loaded in {} ms", (Object)(stop - start));
            start = stop;
            Map<Long, DProteinMatch> proteinMatchMap = typicalProteinMatchesArray.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            for (JSONPTMSite jsonSite : values) {
                PTMSite site2 = new PTMSite(jsonSite, proteinMatchMap.get(jsonSite.proteinMatchId));
                site2.setBestProbabilityPepMatch((DPeptideMatch)peptideMatchById.get(jsonSite.bestPeptideMatchId));
                site2.setPTMSpecificity((DInfoPTM)DInfoPTM.getInfoPTMMap().get(jsonSite.ptmDefinitionId));
                if (site2.getProteinMatch() == null) continue;
                this.m_ptmSitesOutput.add(site2);
            }
            stop = System.currentTimeMillis();
            m_logger.debug("{} PTM Sites built in {} ms", (Object)this.m_ptmSitesOutput.size(), (Object)(stop - start));
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    private boolean fetchGenericPTMData(EntityManager entityManagerMSI) {
        HashMap infoPTMMAp = DInfoPTM.getInfoPTMMap();
        if (!infoPTMMAp.isEmpty()) {
            return true;
        }
        TypedQuery ptmInfoQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DInfoPTM(spec.id, spec.residue, spec.location, ptm.shortName, evidence.composition, evidence.monoMass) \nFROM fr.proline.core.orm.msi.PtmSpecificity as spec, fr.proline.core.orm.msi.Ptm as ptm, fr.proline.core.orm.msi.PtmEvidence as evidence \nWHERE spec.ptm=ptm AND ptm=evidence.ptm AND evidence.type='Precursor' ", DInfoPTM.class);
        List ptmInfoList = ptmInfoQuery.getResultList();
        for (DInfoPTM infoPTM : ptmInfoList) {
            DInfoPTM.addInfoPTM((DInfoPTM)infoPTM);
        }
        return true;
    }

    private HashMap<Long, ArrayList<DPeptidePTM>> fetchPTMDataForPeptides(EntityManager entityManagerMSI, ArrayList<Long> allPeptidesIds) {
        HashMap<Long, ArrayList<DPeptidePTM>> ptmMap = new HashMap<Long, ArrayList<DPeptidePTM>>();
        SubTaskManager subTaskManager = new SubTaskManager(1);
        SubTask subTask = subTaskManager.sliceATaskAndGetFirst(0, allPeptidesIds.size(), 1000);
        while (subTask != null) {
            TypedQuery ptmQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DPeptidePTM(pptm.peptide.id, pptm.specificity.id, pptm.seqPosition) \nFROM PeptidePtm as pptm  \nWHERE pptm.peptide.id IN (:peptideList) ", DPeptidePTM.class);
            ptmQuery.setParameter("peptideList", (Object)subTask.getSubList(allPeptidesIds));
            List ptmList = ptmQuery.getResultList();
            for (DPeptidePTM ptm : ptmList) {
                Long peptideId = ptm.getIdPeptide();
                ArrayList<Object> list = ptmMap.get(peptideId);
                if (list == null) {
                    list = new ArrayList();
                    ptmMap.put(peptideId, list);
                }
                list.add(ptm);
            }
            subTask = subTaskManager.getNextSubTask();
        }
        return ptmMap;
    }

    public static void fetchReadablePTMData(EntityManager entityManagerMSI, Long rsetId, HashMap<Long, Peptide> peptideMap, List<Long> sliceOfPeptideMatchIds) {
        if (peptideMap == null || peptideMap.isEmpty()) {
            return;
        }
        if (sliceOfPeptideMatchIds == null) {
            sliceOfPeptideMatchIds = new ArrayList<Long>(peptideMap.keySet());
        }
        Query ptmStingQuery = entityManagerMSI.createQuery("SELECT p.id, ptmString FROM fr.proline.core.orm.msi.Peptide p, fr.proline.core.orm.msi.PeptideReadablePtmString ptmString WHERE p.id IN (:listId) AND ptmString.peptide=p AND ptmString.resultSet.id=:rsetId");
        ptmStingQuery.setParameter("listId", sliceOfPeptideMatchIds);
        ptmStingQuery.setParameter("rsetId", (Object)rsetId);
        List ptmStrings = ptmStingQuery.getResultList();
        for (Object[] res : ptmStrings) {
            Long peptideId = (Long)res[0];
            PeptideReadablePtmString ptmString = (PeptideReadablePtmString)res[1];
            Peptide peptide = peptideMap.get(peptideId);
            peptide.getTransientData().setPeptideReadablePtmString(ptmString);
        }
    }

    public static void fetchPTMDataForPeptides(EntityManager entityManagerMSI, HashMap<Long, Peptide> peptideMap, List<Long> sliceOfPeptideMatchIds) {
        if (!peptideMap.isEmpty()) {
            if (sliceOfPeptideMatchIds == null) {
                sliceOfPeptideMatchIds = new ArrayList<Long>(peptideMap.keySet());
            }
            TypedQuery ptmQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DPeptidePTM(pptm.peptide.id, pptm.specificity.id, pptm.seqPosition) FROM fr.proline.core.orm.msi.PeptidePtm pptm WHERE pptm.peptide.id IN (:peptideIds)", DPeptidePTM.class);
            ptmQuery.setParameter("peptideIds", sliceOfPeptideMatchIds);
            List ptmList = ptmQuery.getResultList();
            for (DPeptidePTM ptm : ptmList) {
                Peptide p = peptideMap.get(ptm.getIdPeptide());
                HashMap<Integer, DPeptidePTM> map = p.getTransientData().getDPeptidePtmMap();
                if (map == null) {
                    map = new HashMap<Integer, DPeptidePTM>();
                    p.getTransientData().setDPeptidePtmMap(map);
                }
                map.put((int)ptm.getSeqPosition(), ptm);
            }
        }
    }
}

