/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.studio.dam.memory.TransientMemoryCacheManager;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseBioSequenceTask;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public class DatabaseProteinMatchesTask
extends AbstractDatabaseTask {
    private long m_projectId = -1L;
    private DPeptideMatch m_peptideMatch = null;
    private ResultSet m_rset = null;
    private final int m_action;
    private static final int LOAD_PROTEINS_FROM_PEPTIDE_MATCH = 0;
    private static final int LOAD_ALL_PROTEINS_OF_RSET = 1;

    public DatabaseProteinMatchesTask(AbstractDatabaseCallback callback, long projectId, DPeptideMatch peptideMatch) {
        super(callback, new TaskInfo("Load Proteins for a Peptide Match " + DatabaseProteinMatchesTask.getPeptideName(peptideMatch), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_projectId = projectId;
        this.m_peptideMatch = peptideMatch;
        this.m_action = 0;
    }

    public DatabaseProteinMatchesTask(AbstractDatabaseCallback callback, long projectId, ResultSet rset) {
        super(callback, new TaskInfo("Load Proteins of Search Result " + rset.getId(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_rset = rset;
        this.m_action = 1;
    }

    private static String getPeptideName(DPeptideMatch peptideMatch) {
        Peptide peptide = peptideMatch.getPeptide();
        String name = peptide != null ? peptide.getSequence() : String.valueOf(peptideMatch.getId());
        return name;
    }

    @Override
    public void abortTask() {
        super.abortTask();
        switch (this.m_action) {
            case 1: {
                this.m_rset.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setProteinMatches(null);
                break;
            }
            case 0: {
                this.m_peptideMatch.setProteinMatches(null);
            }
        }
    }

    @Override
    public boolean needToFetch() {
        switch (this.m_action) {
            case 1: {
                return this.m_rset.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getProteinMatches() == null;
            }
            case 0: {
                return this.m_peptideMatch.getProteinMatches() == null;
            }
        }
        return false;
    }

    @Override
    public boolean fetchData() {
        switch (this.m_action) {
            case 1: {
                if (this.needToFetch()) {
                    return this.fechDataForRset();
                }
            }
            case 0: {
                if (!this.needToFetch()) break;
                return this.fetchDataForPeptideMatch();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fechDataForRset() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            TypedQuery proteinMatchQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DProteinMatch(protm.id, protm.accession, protm.score, protm.peptideCount, protm.resultSet.id, protm.description, protm.geneName, protm.serializedProperties)  FROM ProteinMatch protm WHERE protm.resultSet.id=:resultSetId ORDER BY protm.score DESC", DProteinMatch.class);
            proteinMatchQuery.setParameter("resultSetId", (Object)this.m_rset.getId());
            List proteinMatchList = proteinMatchQuery.getResultList();
            int nbProteins = proteinMatchList.size();
            DProteinMatch[] proteins = proteinMatchList.toArray(new DProteinMatch[nbProteins]);
            this.m_rset.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setProteinMatches(proteins);
            DatabaseBioSequenceTask.fetchData(proteinMatchList, this.m_projectId);
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataForPeptideMatch() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            TypedQuery proteinMatchQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DProteinMatch(protm.id, protm.accession, protm.score, protm.peptideCount, protm.resultSet.id, protm.description, protm.geneName, protm.serializedProperties) FROM ProteinMatch protm, SequenceMatch sm, PeptideMatch pepm, fr.proline.core.orm.msi.Peptide p WHERE pepm.id=:peptideMatchId AND  pepm.peptideId=p.id AND p.id=sm.id.peptideId AND sm.resultSetId=pepm.resultSet.id AND sm.id.proteinMatchId=protm.id ORDER BY protm.score DESC", DProteinMatch.class);
            proteinMatchQuery.setParameter("peptideMatchId", (Object)this.m_peptideMatch.getId());
            List proteinMatchList = proteinMatchQuery.getResultList();
            int nbProteins = proteinMatchList.size();
            DProteinMatch[] proteins = proteinMatchList.toArray(new DProteinMatch[nbProteins]);
            this.m_peptideMatch.setProteinMatches(proteins);
            DatabaseBioSequenceTask.fetchData(proteinMatchList, this.m_projectId);
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }
}

