/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.uds.IdentificationDataset;
import fr.proline.core.orm.uds.RawFile;
import fr.proline.core.orm.uds.Run;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public class DatabaseRunsTask
extends AbstractDatabaseTask {
    private long m_projectId = -1L;
    private List<Long> m_rsmIds = null;
    private Long m_datasetId = null;
    private RawFile m_rawfile = null;
    private Run m_run = null;
    private Map<Long, Long> m_runIdsByRsmIds = null;
    private String m_searchString = null;
    private HashMap<String, RawFile> m_rawfileFounds = null;
    private Run[] m_runOut;
    private int m_action;
    private static final int LOAD_RUNS_FOR_RSMS = 0;
    private static final int SEARCH_RAWFILE = 1;
    private static final int LOAD_RAWFILE = 2;
    private static final int REGISTER_IDENTIFICATION_DATASET_RUN = 3;

    public DatabaseRunsTask(AbstractDatabaseCallback callback) {
        super(callback, null);
    }

    public void initLoadRunIdsForRsms(long projectId, ArrayList<Long> rsmIds, HashMap<Long, Long> runIds) {
        this.setTaskInfo(new TaskInfo(" Load RunId for Identification Summary with ids " + rsmIds, false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_projectId = projectId;
        this.m_rsmIds = rsmIds;
        this.m_runIdsByRsmIds = runIds;
        this.m_action = 0;
    }

    public void initSearchRawFile(String searchString, HashMap<String, RawFile> rawfileFounds) {
        this.setTaskInfo(new TaskInfo(" Search Raw File " + searchString, false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW, true));
        this.m_searchString = searchString;
        this.m_rawfileFounds = rawfileFounds;
        this.m_action = 1;
    }

    public void initLoadRawFile(Long identificationDatasetId, HashMap<String, RawFile> rawfileFounds, Run[] runOut) {
        this.setTaskInfo(new TaskInfo(" Load Raw File for Dataset " + identificationDatasetId, false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW, true));
        this.m_datasetId = identificationDatasetId;
        this.m_rawfileFounds = rawfileFounds;
        this.m_runOut = runOut;
        this.m_action = 2;
    }

    public void initRegisterIdentificationDatasetRun(long datasetId, RawFile rawfile, Run run) {
        this.setTaskInfo(new TaskInfo(" Register Run for Dataset with id " + datasetId, false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_datasetId = datasetId;
        if (rawfile == null) {
            rawfile = run.getRawFile();
        }
        this.m_rawfile = rawfile;
        this.m_run = run;
        this.m_action = 3;
    }

    @Override
    public boolean fetchData() {
        switch (this.m_action) {
            case 0: {
                return this.fetchRunsForRsms();
            }
            case 1: {
                return this.searchRawFile();
            }
            case 2: {
                return this.loadRawFile();
            }
            case 3: {
                return this.registerIdentificationDatasetRun();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetchRunsForRsms() {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            TypedQuery runIdQuery = entityManagerUDS.createQuery("SELECT idfDS FROM IdentificationDataset idfDS WHERE idfDS.project.id = :pjId and idfDS.resultSummaryId IN (:rsmIds)  ", IdentificationDataset.class);
            runIdQuery.setParameter("pjId", (Object)this.m_projectId);
            runIdQuery.setParameter("rsmIds", this.m_rsmIds);
            List idfDs = runIdQuery.getResultList();
            if (idfDs != null) {
                for (IdentificationDataset identDS : idfDs) {
                    if (identDS.getRun() != null) {
                        this.m_runIdsByRsmIds.put(identDS.getResultSummaryId(), identDS.getRun().getId());
                        continue;
                    }
                    this.m_runIdsByRsmIds.put(identDS.getResultSummaryId(), -1L);
                }
            }
            entityManagerUDS.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean searchRawFile() {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            TypedQuery searchQuery = entityManagerUDS.createQuery("SELECT searchRawfile  FROM RawFile searchRawfile WHERE searchRawfile.identifier LIKE :search ORDER BY searchRawfile.identifier ASC", RawFile.class);
            String searchStringSql = this.m_searchString.replaceAll("\\*", "%").replaceAll("\\?", "_");
            searchQuery.setParameter("search", (Object)searchStringSql);
            this.m_rawfileFounds.clear();
            List rawFileList = searchQuery.getResultList();
            for (RawFile r : rawFileList) {
                r.getRuns().size();
                this.m_rawfileFounds.put(r.getRawFileName(), r);
            }
            entityManagerUDS.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadRawFile() {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            RawFile rawFile;
            entityManagerUDS.getTransaction().begin();
            IdentificationDataset identificationDataset = (IdentificationDataset)entityManagerUDS.find(IdentificationDataset.class, (Object)this.m_datasetId);
            if (identificationDataset != null && (rawFile = identificationDataset.getRawFile()) != null) {
                this.m_rawfileFounds.put(rawFile.getRawFileName(), rawFile);
                this.m_runOut[0] = identificationDataset.getRun();
            }
            entityManagerUDS.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerIdentificationDatasetRun() {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            IdentificationDataset idf = (IdentificationDataset)entityManagerUDS.find(IdentificationDataset.class, (Object)this.m_datasetId);
            RawFile mergedRaw = (RawFile)entityManagerUDS.find(RawFile.class, (Object)this.m_rawfile.getIdentifier());
            Run mergedRun = (Run)entityManagerUDS.find(Run.class, (Object)this.m_run.getId());
            idf.setRawFile(mergedRaw);
            idf.setRun(mergedRun);
            entityManagerUDS.merge((Object)idf);
            entityManagerUDS.getTransaction().commit();
        }
        return true;
    }

    @Override
    public boolean needToFetch() {
        return true;
    }
}

