/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.aaproperties.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.biojava.nbio.aaproperties.xml.Element;
import org.biojava.nbio.aaproperties.xml.Isotope;

@XmlRootElement(name="elements", namespace="http://biojava.org")
public class ElementTable {
    private List<Element> element;
    private Map<String, Element> elementName2Element;
    private Map<String, Isotope> isotopeName2Isotope;

    public ElementTable() {
    }

    public ElementTable(List<Element> eList) {
        this.setElement(eList);
    }

    public void setElement(List<Element> eList) {
        this.element = eList;
        this.populateMaps();
    }

    public void populateMaps() {
        this.elementName2Element = new HashMap<String, Element>();
        this.isotopeName2Isotope = new HashMap<String, Isotope>();
        if (this.element != null) {
            for (Element e : this.element) {
                this.elementName2Element.put(e.getName(), e);
                if (e.getIsotopes() == null) continue;
                for (Isotope i : e.getIsotopes()) {
                    this.isotopeName2Isotope.put(i.getName(), i);
                }
            }
        }
    }

    public List<Element> getElement() {
        return this.element;
    }

    public Element getElement(String name) {
        return this.elementName2Element.get(name);
    }

    public Isotope getIsotope(String name) {
        return this.isotopeName2Isotope.get(name);
    }
}

