/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.ForeignKeyNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.ForeignKey;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class ForeignKeyNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle<Table> tableHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private ForeignKeyNodeProvider(Lookup lookup) {
        super(lookup, new ForeignKeyComparator());
    }

    @Override
    protected synchronized void initialize() {
        final ArrayList<Node> newList = new ArrayList<Node>();
        boolean connected = !this.connection.getConnector().isDisconnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Table table = (Table)ForeignKeyNodeProvider.this.tableHandle.resolve(metaData);
                        if (table != null) {
                            Collection keys = table.getForeignKeys();
                            for (ForeignKey key : keys) {
                                MetadataElementHandle h = MetadataElementHandle.create((MetadataElement)key);
                                Collection matches = ForeignKeyNodeProvider.this.getNodes(h);
                                if (matches.size() > 0) {
                                    newList.addAll(matches);
                                    continue;
                                }
                                NodeDataLookup lookup = new NodeDataLookup();
                                lookup.add(ForeignKeyNodeProvider.this.connection);
                                lookup.add(h);
                                newList.add(ForeignKeyNode.create(lookup, ForeignKeyNodeProvider.this));
                            }
                        }
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
            }
        }
        this.setNodes(newList);
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public ForeignKeyNodeProvider createInstance(Lookup lookup) {
                ForeignKeyNodeProvider provider = new ForeignKeyNodeProvider(lookup);
                return provider;
            }
        };

        private FactoryHolder() {
        }
    }

    static class ForeignKeyComparator
    implements Comparator<Node> {
        ForeignKeyComparator() {
        }

        @Override
        public int compare(Node model1, Node model2) {
            return model1.getDisplayName().compareTo(model2.getDisplayName());
        }
    }
}

