/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.Bundle;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.SchemaNode;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public class SchemaNodeProvider
extends NodeProvider
implements PropertyChangeListener {
    private final List<Node> nodes = new ArrayList<Node>();
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle<Catalog> catalogHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private SchemaNodeProvider(Lookup lookup) {
        super(lookup, new SchemaComparator());
    }

    @Override
    protected synchronized void initialize() {
        final ArrayList<Node> newList = new ArrayList<Node>();
        final ArrayList otherList = new ArrayList();
        boolean connected = !this.connection.getConnector().isDisconnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        this.nodes.clear();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Catalog cat = (Catalog)SchemaNodeProvider.this.catalogHandle.resolve(metaData);
                        if (cat != null) {
                            Schema syntheticSchema = cat.getSyntheticSchema();
                            if (syntheticSchema != null) {
                                SchemaNodeProvider.this.updateNode(newList, syntheticSchema);
                            } else {
                                Collection schemas = cat.getSchemas();
                                for (Schema schema : schemas) {
                                    if (SchemaNodeProvider.this.isDefaultSchema(schema, SchemaNodeProvider.this.connection)) {
                                        SchemaNodeProvider.this.updateNode(newList, schema);
                                        continue;
                                    }
                                    SchemaNodeProvider.this.updateNode(otherList, schema);
                                }
                                SchemaNodeProvider.this.nodes.addAll(newList);
                                SchemaNodeProvider.this.nodes.addAll(otherList);
                                if (!otherList.isEmpty()) {
                                    newList.add(new OtherSchemasNode(otherList));
                                }
                            }
                            if (syntheticSchema != null) {
                                SchemaNodeProvider.this.setProxyNodes(newList);
                            } else {
                                SchemaNodeProvider.this.setNodes(newList);
                            }
                        }
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
            }
        } else {
            this.setNodes(newList);
        }
        this.connection.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.connection));
    }

    private boolean isDefaultSchema(Schema schema, DatabaseConnection connection) {
        String def = connection.getDefaultSchema();
        return def == null && schema.isDefault() || def != null && def.equals(schema.getName()) || connection.isImportantSchema(schema.getName());
    }

    private void updateNode(List<Node> newList, Schema schema) {
        MetadataElementHandle schemaHandle = MetadataElementHandle.create((MetadataElement)schema);
        Collection<Node> matches = this.getNodes(schemaHandle);
        if (matches != null && matches.size() > 0) {
            newList.addAll(matches);
        } else {
            NodeDataLookup lookup = new NodeDataLookup();
            lookup.add(this.connection);
            lookup.add(schemaHandle);
            newList.add((Node)SchemaNode.create(lookup, this));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (this.initialized && "importantSchemas".equals(pce.getPropertyName())) {
            ArrayList<Node> mainList = new ArrayList<Node>();
            ArrayList<Node> otherList = new ArrayList<Node>();
            for (Node node : new ArrayList<Node>(this.nodes)) {
                if (this.connection.isImportantSchema(node.getName())) {
                    mainList.add(node.cloneNode());
                    continue;
                }
                otherList.add(node.cloneNode());
            }
            if (!otherList.isEmpty()) {
                mainList.add((Node)new OtherSchemasNode(otherList));
            }
            this.setNodes(mainList);
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public SchemaNodeProvider createInstance(Lookup lookup) {
                SchemaNodeProvider provider = new SchemaNodeProvider(lookup);
                return provider;
            }
        };

        private FactoryHolder() {
        }
    }

    private static class OtherSchemasNode
    extends AbstractNode {
        private static final String ICON_BASE = "org/netbeans/modules/db/resources/schema.png";

        public OtherSchemasNode(List<Node> otherList) {
            super(OtherSchemasNode.createChildren(otherList));
            this.setDisplayName(Bundle.LBL_OtherSchemas());
            this.setIconBaseWithExtension(ICON_BASE);
        }

        private static Children createChildren(final List<Node> otherList) {
            Children c = Children.create((ChildFactory)new ChildFactory<Node>(){

                protected boolean createKeys(List<Node> toPopulate) {
                    toPopulate.addAll(otherList);
                    return true;
                }

                protected Node createNodeForKey(Node key) {
                    return key;
                }
            }, (boolean)false);
            return c;
        }
    }

    static class SchemaComparator
    implements Comparator<Node> {
        SchemaComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            assert (node1.getDisplayName() != null) : node1 + " has display name.";
            assert (node2.getDisplayName() != null) : node2 + " has display name.";
            if (node1 instanceof OtherSchemasNode) {
                return 1;
            }
            if (node2 instanceof OtherSchemasNode) {
                return -1;
            }
            return node1.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
        }
    }
}

