/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rserver.dialog;

import fr.proline.studio.export.ExportButton;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.openide.windows.TopComponent;

public class ImageViewerTopComponent
extends TopComponent {
    public ImageViewerTopComponent(String name, Image img) {
        this.setName(name);
        this.setToolTipText(name);
        this.setLayout(new GridLayout());
        ImagePanel imagePanel = new ImagePanel();
        imagePanel.setImage(img);
        this.add((Component)((Object)imagePanel));
    }

    public Image getIcon() {
        return IconManager.getImage((IconManager.IconType)IconManager.IconType.WAVE);
    }

    public class ImagePanel
    extends HourglassPanel {
        private Dimension m_dimension = null;
        private Image m_img = null;
        private ImageDisplayPanel m_displayPanel;

        public ImagePanel() {
            this.setLayout(new BorderLayout());
            this.m_dimension = new Dimension(0, 0);
            this.m_img = null;
            this.m_displayPanel = new ImageDisplayPanel();
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setBackground(Color.white);
            scrollPane.setViewportView(this.m_displayPanel);
            this.add(scrollPane, "Center");
            JToolBar toolbar = this.initToolbar();
            this.add(toolbar, "West");
        }

        public final JToolBar initToolbar() {
            JToolBar toolbar = new JToolBar(1);
            toolbar.setFloatable(false);
            ExportButton exportImageButton = new ExportButton("Graphic", (JPanel)this.m_displayPanel);
            toolbar.add((Component)exportImageButton);
            return toolbar;
        }

        public void setImage(Image img) {
            this.m_img = img;
            this.m_dimension.width = img.getWidth(null);
            this.m_dimension.height = img.getHeight(null);
            this.revalidate();
            this.repaint();
        }

        private class ImageDisplayPanel
        extends JPanel {
            private ImageDisplayPanel() {
            }

            @Override
            public Dimension getPreferredSize() {
                return ImagePanel.this.m_dimension;
            }

            @Override
            public void paint(Graphics g) {
                g.setColor(Color.white);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (ImagePanel.this.m_img == null) {
                    return;
                }
                g.drawImage(ImagePanel.this.m_img, 0, 0, this);
            }
        }
    }
}

