/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.table;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.db.model.MzDbHeader;
import fr.profi.mzdb.db.model.params.ParamTree;
import fr.profi.mzdb.db.table.MzdbTable;
import fr.profi.mzdb.io.reader.table.AbstractTableModelReader;
import fr.profi.mzdb.io.reader.table.ParamTreeParser;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordExtraction;
import fr.profi.mzdb.util.sqlite.SQLiteQuery;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;

public class MzDbHeaderReader
extends AbstractTableModelReader<MzDbHeader> {
    public MzDbHeaderReader(SQLiteConnection connection) {
        super(connection);
    }

    @Override
    protected ISQLiteRecordExtraction<MzDbHeader> buildRecordExtractor() {
        return new ISQLiteRecordExtraction<MzDbHeader>(){

            @Override
            public MzDbHeader extract(SQLiteRecord r) throws SQLiteException {
                String version = r.columnString(MzdbTable.VERSION);
                int creationTimestamp = r.columnInt(MzdbTable.CREATION_TIMESTAMP);
                String paramTreeAsStr = r.columnString(MzdbTable.PARAM_TREE);
                ParamTree paramTree = ParamTreeParser.parseParamTree(paramTreeAsStr);
                return new MzDbHeader(version, creationTimestamp, paramTree);
            }
        };
    }

    public MzDbHeader getMzDbHeader() throws SQLiteException {
        return (MzDbHeader)new SQLiteQuery(this.connection, "SELECT * FROM " + MzdbTable.tableName).extractRecord(this.recordExtractor);
    }
}

